/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.ODBCOTHERType;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.IProperty;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class NEOVIEWType
extends ODBCOTHERType {
    private static final String AUTOCOMMIT_OPTION = "AUTOCOMMIT";

    public NEOVIEWType() {
        this.setTruncateSupport(false);
        this.setConstraintSupport(false);
        this.setUnquotedTableNameAction("U");
    }

    @Override
    public int getDBMSTypeID() {
        return 16;
    }

    @Override
    public String getDBMSTypeName() {
        return "NeoView";
    }

    @Override
    public String getIndexNamePrefix(IPhysicalTable oTable) {
        return oTable.getSASTableName();
    }

    @Override
    public String getAdditionalConnectionOptions(ILibrary iLib, String dbmsOptions) throws MdException, RemoteException {
        String retString = "";
        if (dbmsOptions != null && dbmsOptions.toUpperCase().indexOf(AUTOCOMMIT_OPTION) > -1) {
            return retString;
        }
        IProperty[] lProps = iLib.getOptions();
        for (int i = 0; i < lProps.length; ++i) {
            if (!lProps[i].getPropertyName().equals(AUTOCOMMIT_OPTION)) continue;
            String option = lProps[i].getPropertyName();
            String optValue = lProps[i].getDefaultValue();
            if (!"NO".equalsIgnoreCase(optValue)) break;
            retString = " " + option + lProps[i].getDelimiter() + optValue;
            break;
        }
        return retString;
    }

    @Override
    public ICodeSegment dropSingleIndex(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        boolean quoting = codeSegment.isQuoting();
        String schemaName = this.getSchemaName(codeSegment.getCurrentServer(), table, quoting);
        if (quoting) {
            codeSegment.addSourceCode("drop index ").addSourceCode(schemaName != null ? schemaName : "").addSourceCode(".\"%trim(%bquote(&etls_indexName))\" \n");
        } else {
            codeSegment.addSourceCode("drop index ").addSourceCode(schemaName != null ? schemaName : "").addSourceCode(".&etls_indexName \n");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment queryIndexes(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName;
        String dsName = tableName = table.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), codeSegment.isQuoting(), true, false, "");
        String user = "";
        if (tableName != null && tableName.indexOf(46) > 0) {
            user = "\"" + tableName.substring(0, tableName.indexOf(46)) + "\"";
            dsName = tableName.substring(tableName.indexOf(46) + 1);
        }
        codeSegment.indent().addSourceCode("from \n").addSourceCode("( \n").indent().addSourceCode("select distinct index_name as idxname, \n").addSourceCode("      \"" + tableName + "\" as tabname \n").indent().addSourceCode("from connection to " + this.getNickName(codeSegment, table) + "\n").indent().addSourceCode("(NEOVIEW::SQLStatistics( \"\", " + user + ", \"" + dsName + "\")) \n").addSourceCode("where type ne 0 \n").unIndent().unIndent().unIndent().addSourceCode("); \n").unIndent();
        return codeSegment;
    }

    @Override
    protected PhysicalTablePromptModel createODBCTableOptionModel(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(optionModel.createPromptGroup(this.getClass().getResource("res/Options_HPNeoViewTable_Template.xml")));
        optionModel.setUsePropertySet(false);
        optionModel.setSetRole("");
        return optionModel;
    }

    @Override
    protected void addODBCModel(PhysicalTablePromptModelCollection collection, IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        collection.addModel(this.createODBCTableOptionModel(model, table), "table_options_neo", RB.getStringResource("NEOVIEWType.Options.title.txt"));
    }
}

