/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.HADOOPType;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.impl.BasePhysicalTable;

public class DBMSNamesUtil {
    private DBMSNamesUtil() {
    }

    public static String getQuotedString(String value, ITable table, boolean passthru) {
        if (table.isQuoted()) {
            IDBMSType DBMSType = null;
            if (table instanceof BasePhysicalTable) {
                DBMSType = ((BasePhysicalTable)table).getDBMSType();
            }
            return DBMSNamesUtil.getQuotedString(value, passthru, DBMSType);
        }
        return value;
    }

    public static String getQuotedColumnName(IColumn column, boolean quoted, boolean passthru) {
        return DBMSNamesUtil.getQuotedColumnName(column, column.getTable(), quoted, passthru);
    }

    public static String getQuotedColumnName(IColumn column, ITable table, boolean quoted, boolean passthru) {
        return DBMSNamesUtil.getQuotedName(column.getName(), table, quoted, passthru);
    }

    public static String getQuotedTableName(IPhysicalTable table, boolean quoted, boolean passthru) {
        return DBMSNamesUtil.getQuotedName(table.getSASTableName(), table, quoted, passthru);
    }

    public static String getQuotedIndexName(IIndex index, boolean quoted, boolean passthru) {
        return DBMSNamesUtil.getQuotedName(index.getName(), index.getTable(), quoted, passthru);
    }

    public static String getQuotedName(String name, ITable table, boolean quoted, boolean passthru) {
        String text = name;
        if (passthru && quoted) {
            text = DBMSNamesUtil.getQuotedString(text, table, passthru);
        } else if (quoted) {
            IDBMSType DBMSType = null;
            if (table instanceof BasePhysicalTable) {
                DBMSType = ((BasePhysicalTable)table).getDBMSType();
            }
            text = DBMSNamesUtil.getQuotedString(text, passthru, DBMSType);
        }
        return text;
    }

    public static String getQuotedName(String name, boolean tableQuoted, boolean quoted, boolean passthru) {
        String text = name;
        if (passthru && tableQuoted && quoted) {
            text = DBMSNamesUtil.getQuotedString(text, passthru);
        } else if (!passthru && quoted) {
            text = DBMSNamesUtil.getQuotedString(text, passthru);
        }
        return text;
    }

    public static String getQuotedString(String value, ITable table) {
        return DBMSNamesUtil.getQuotedString(value, table, false);
    }

    public static String getQuotedString(String value) {
        if (value == null || value.length() <= 0) {
            return "";
        }
        String quote = "\"";
        if (value.indexOf("\"") > -1 || value.substring(value.length() - 1).equals("%")) {
            if (value.indexOf("'") == -1) {
                quote = "'";
            } else {
                value = value.replaceAll("\"", "\"\"");
            }
        }
        value = quote + value.trim() + quote;
        return value;
    }

    public static String getQuotedString(String value, boolean passthru, IDBMSType DBMSType) {
        if (value == null || value.length() <= 0) {
            return "";
        }
        if (!passthru) {
            value = DBMSNamesUtil.getQuotedString(value) + "n";
        } else {
            String quote = "\"";
            if (DBMSType != null && DBMSType instanceof HADOOPType) {
                quote = "`";
            }
            value = quote + value.trim() + quote;
        }
        return value;
    }

    public static String getQuotedString(String value, boolean passthru) {
        return DBMSNamesUtil.getQuotedString(value, passthru, null);
    }

    public static String getTableNamePart(String librefTable) {
        int index = librefTable.indexOf(46);
        if (index < 0) {
            return librefTable;
        }
        return librefTable.substring(index + 1);
    }

    public static String getLibrefPart(String librefTable) {
        int index = librefTable.indexOf(46);
        if (index < 0) {
            return "";
        }
        return librefTable.substring(0, index);
    }
}

