/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.dbmstypes;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDatabaseSchema;
import com.sas.etl.models.data.IForeignKey;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.dbmstypes.RB;
import com.sas.etl.models.data.impl.PhysicalTablePromptModel;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.JobTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.ICondition;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.rio.MVAResultSet;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class BaseDBMSType
implements IDBMSType {
    private static final String DBCREATE_TABLE_OPTS = "DBCREATE_TABLE_OPTS";
    protected String m_ClusWord_0;
    protected String m_indexNameLength = "200";
    protected boolean m_truncateSupport = true;
    protected boolean m_simulateTruncateSupport = false;
    protected boolean m_DBMSTempSupport = false;
    protected boolean m_indexSupport = true;
    protected boolean m_constraintSupport = true;
    protected boolean m_deleteAllRowsSupport = true;
    protected boolean m_passthru = true;
    protected boolean m_randomAccessSupport = true;
    protected boolean m_upsertSupport = false;
    protected boolean m_notNullIsConstraint = false;
    protected String m_constraintTypesDroppable = "";
    protected String m_SQLInsertOptions = "";
    protected String m_addKeyDelimiter = "";
    protected boolean m_repeatAddKeyCommand = true;
    protected boolean m_addOneKeyPerExecute = false;
    protected boolean m_excludeCOwnFromIndexCreate = true;
    protected String m_unquotedTableNameAction = "N";
    protected String m_tableAliasKeyword = " as ";
    protected boolean m_bDeleteTableSupport = true;
    protected boolean m_bTablespaceSupport = false;
    protected boolean m_bMatchingSimpleIndexNameRequired = false;
    protected boolean m_bRereadExposureRequired = true;
    protected boolean m_bPassthruUsedForDropIndexes = true;
    protected String m_sQuoteTypeForPassthru = "DOUBLE";
    protected boolean m_bCreateTempIndexAndConstraintAfterLoad = true;
    private boolean bulkloadSupported;
    private PhysicalTablePromptModelCollection m_tableOptionCollection = null;
    private static final String IC_CREATE_COMMAND = "add";
    static final String DOUBLE_QUOTE = "DOUBLE";
    static final String BACK_QUOTE = "BACK";
    public static final String DEFAULT_TABLE_ALIAS_KEYWORD = " as ";

    public BaseDBMSType() {
        this.setClusterWord("CLUSTER");
        this.setBulkloadSupported(true);
    }

    @Override
    public int getDBMSTypeID() {
        return 14;
    }

    @Override
    public String getDBMSTypeName() {
        return "Other";
    }

    @Override
    public String getConnectionType() {
        return null;
    }

    public List getUniqueKeysToCreate(IPhysicalTable table) throws CodegenException {
        return new ArrayList(table.getKeysList());
    }

    @Override
    public boolean isBulkloadSupported() {
        return this.bulkloadSupported;
    }

    public void setBulkloadSupported(boolean value) {
        this.bulkloadSupported = value;
    }

    @Override
    public void updateTransformTableOptions(ITransformTableOptions options, boolean isSource) {
    }

    @Override
    public ICodeSegment createConstraints(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (table.isView()) {
            return codeSegment;
        }
        List foreignKeys = table.getForeignKeysList();
        List uniqueKeys = this.getUniqueKeysToCreate(table);
        if (!foreignKeys.isEmpty() || !uniqueKeys.isEmpty()) {
            IPersistableObject key;
            int i;
            String tableName = table.getFullNameQuotedAsNeeded(codeSegment, this.m_passthru);
            if (BACK_QUOTE.equals(this.getQuoteTypeForPassthru())) {
                tableName = this.wrapInBackQuotes(tableName);
            }
            tableName = this.getTableNameCustomizedForDBMS(codeSegment, table, tableName);
            codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.CreateConstraint.msg.notrans"));
            codeSegment.genPercentPutStatement(RB.getStringResource("BaseDBMSType.CreateConstraint.note.sasmacro.notrans"));
            codeSegment.addSourceCode("proc sql;\n");
            codeSegment.indent();
            this.genConnect(codeSegment, table);
            codeSegment.addSourceCode("reset noprint; \n\n");
            String delimiter = "";
            String addCommand = IC_CREATE_COMMAND;
            int foreignKeysSize = foreignKeys.size();
            for (int i2 = 0; i2 < foreignKeysSize; ++i2) {
                IForeignKey key2 = (IForeignKey)foreignKeys.get(i2);
                if (key2 == null) {
                    throw new CodegenException(RB.getStringResource("BaseDBMSType.NoFKeyReference.msg.txt"), (IObject)table);
                }
                try {
                    IKey partnerKey = key2.loadPartnerKeyFromOMR();
                    if (partnerKey == null) {
                        throw new CodegenException(RB.getStringResource("BaseDBMSType.NoPartnerKeyReference.msg.txt"), (IObject)table);
                    }
                    IPhysicalTable primKeyTable = partnerKey.getTable();
                    if (primKeyTable == null) {
                        throw new CodegenException(RB.getStringResource("BaseDBMSType.NoPartnerKeyReference.msg.txt"), (IObject)table);
                    }
                    ILibrary library = primKeyTable.getCodeGenLibrary(codeSegment.getCurrentServer());
                    library.genAccessPath(codeSegment, true);
                    continue;
                }
                catch (MdException ex) {
                    throw new CodegenException((Exception)((Object)ex), (IObject)table);
                }
                catch (RemoteException ex) {
                    throw new CodegenException(ex, (IObject)table);
                }
                catch (BadServerDefinitionException ex) {
                    throw new CodegenException(ex, (IObject)table);
                }
            }
            boolean firstKey = true;
            StringBuffer executeAlterCode = new StringBuffer();
            executeAlterCode.append(this.getExecuteBegin("").toString()).append("   ").append("alter table " + tableName);
            int uniqueSize = uniqueKeys.size();
            for (i = 0; i < uniqueSize; ++i) {
                if (this.m_addOneKeyPerExecute || firstKey) {
                    codeSegment.addSourceCode(executeAlterCode);
                    codeSegment.indent(2);
                }
                key = (IKey)uniqueKeys.get(i);
                String sColumns = this.makeColumnListInDBMSTypeFormat(codeSegment, key.getColumnsList());
                codeSegment.addSourceCode(delimiter + "\n").addSourceCode(addCommand + " ");
                if (!key.isPrimary()) {
                    codeSegment.addSourceCode("unique ");
                } else {
                    codeSegment.addSourceCode("primary key ");
                }
                codeSegment.addSourceCode("(").addSourceCode(sColumns).addSourceCode(")");
                if (this.m_addOneKeyPerExecute) {
                    codeSegment.addSourceCode("\n").unIndent();
                    this.genExecuteEnd(codeSegment, table, "");
                    this.genExecuteCommit(codeSegment, table, "");
                }
                delimiter = this.m_addKeyDelimiter;
                addCommand = this.m_repeatAddKeyCommand ? IC_CREATE_COMMAND : "   ";
                firstKey = false;
            }
            for (i = 0; i < foreignKeysSize; ++i) {
                if (this.m_addOneKeyPerExecute || firstKey) {
                    codeSegment.addSourceCode(executeAlterCode);
                    codeSegment.indent(2);
                }
                key = (IForeignKey)foreignKeys.get(i);
                codeSegment.addSourceCode(delimiter + "\n");
                codeSegment.addSourceCode(this.createSingleFKey(codeSegment, (IForeignKey)key, addCommand));
                if (this.m_addOneKeyPerExecute) {
                    codeSegment.addSourceCode("\n").unIndent();
                    this.genExecuteEnd(codeSegment, table, "");
                    this.genExecuteCommit(codeSegment, table, "");
                }
                delimiter = this.m_addKeyDelimiter;
                addCommand = this.m_repeatAddKeyCommand ? IC_CREATE_COMMAND : "   ";
                firstKey = false;
            }
            if (!this.m_addOneKeyPerExecute) {
                codeSegment.addSourceCode("\n").unIndent();
                this.genExecuteEnd(codeSegment, table, "");
                this.genExecuteCommit(codeSegment, table, "");
            }
            this.genDisconnect(codeSegment, table);
            codeSegment.unIndent();
            codeSegment.addSourceCode("quit;\n\n");
            codeSegment.genRCSetCall("&sqlrc");
        }
        return codeSegment;
    }

    public String createSingleFKey(ICodeSegment codeSegment, IForeignKey key, String addCommand) throws CodegenException, BadLibraryDefinitionException {
        StringBuffer code = new StringBuffer("");
        try {
            IKey partnerKey = key.loadPartnerKeyFromOMR();
            if (partnerKey == null) {
                throw new CodegenException(RB.getStringResource("BaseDBMSType.NoPartnerKeyReference.msg.txt"), (IObject)key.getTable());
            }
            IPhysicalTable primKeyTable = partnerKey.getTable();
            if (primKeyTable == null) {
                throw new CodegenException(RB.getStringResource("BaseDBMSType.NoPartnerKeyReference.msg.txt"), (IObject)key.getTable());
            }
            String primKeyTableName = primKeyTable.getFullNameQuotedAsNeeded(codeSegment, this.m_passthru);
            if (BACK_QUOTE.equals(this.getQuoteTypeForPassthru())) {
                primKeyTableName = this.wrapInBackQuotes(primKeyTableName);
            }
            primKeyTableName = this.getTableNameCustomizedForDBMS(codeSegment, primKeyTable, primKeyTableName);
            String sColumns = this.makeColumnListInDBMSTypeFormat(codeSegment, key.getColumnsList());
            code.append(addCommand + " ").append("foreign key (").append(sColumns).append(") references ").append(primKeyTableName);
            this.createFKeyOptions(codeSegment, code, partnerKey);
        }
        catch (MdException ex) {
            throw new CodegenException((Exception)((Object)ex), (IObject)key.getTable());
        }
        catch (RemoteException ex) {
            throw new CodegenException(ex, (IObject)key.getTable());
        }
        return code.toString();
    }

    public StringBuffer createFKeyOptions(ICodeSegment codeSegment, StringBuffer code, IKey partnerKey) throws CodegenException, BadLibraryDefinitionException {
        return code;
    }

    @Override
    public ICodeSegment drop(ICodeSegment codeSegment, IPhysicalTable table, boolean setExistMacro) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.DropTable.msg.notrans")).genPercentPutStatement(RB.getStringResource("BaseDBMSType.DropTable.note.sasmacro.notrans"));
        codeSegment.genTableDelete(table);
        codeSegment.genRCSetCall("&syserr");
        if (setExistMacro) {
            codeSegment.addSourceCode("%let etls_tableExist = 0;\n\n");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genMatchingRowsPrelim(ICodeSegment codeSegment) {
        return codeSegment;
    }

    @Override
    public ICodeSegment genLibname(ICodeSegment codeSegment, IPhysicalTable table, boolean resetLibname) throws CodegenException, BadLibraryDefinitionException, BadServerDefinitionException {
        ILibrary lib = table.getCodeGenLibrary(codeSegment.getCurrentServer());
        if (resetLibname) {
            StringBuffer codeBuffer = new StringBuffer();
            try {
                codeBuffer = lib.getAccessPath(codeSegment.getCodeGenerationEnvironment(), false);
            }
            catch (MdException e) {
                throw new CodegenException((Exception)((Object)e), (IObject)lib);
            }
            catch (RemoteException e) {
                throw new CodegenException(e, (IObject)lib);
            }
            codeSegment.addSourceCode(codeBuffer.toString() + "\n");
        } else {
            try {
                lib.genAccessPath(codeSegment, false);
            }
            catch (MdException e) {
                throw new CodegenException((Exception)((Object)e), (IObject)lib);
            }
            catch (RemoteException e) {
                throw new CodegenException(e, (IObject)lib);
            }
        }
        return codeSegment;
    }

    @Override
    public boolean genRereadExposure(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        if (!this.isRereadExposureRequired()) {
            return false;
        }
        ILibrary lib = table.getCodeGenLibrary(codeSegment.getCurrentServer());
        StringBuffer codeBuffer = new StringBuffer();
        try {
            codeBuffer = lib.getAccessPath(codeSegment.getCodeGenerationEnvironment(), false);
        }
        catch (MdException e) {
            throw new CodegenException((Exception)((Object)e), (IObject)lib);
        }
        catch (BadLibraryDefinitionException e) {
            throw new CodegenException(e, (IObject)lib);
        }
        catch (BadServerDefinitionException e) {
            throw new CodegenException(e, (IObject)lib);
        }
        catch (RemoteException e) {
            throw new CodegenException(e, (IObject)lib);
        }
        String code = codeBuffer.toString();
        if (!lib.isPreAssigned() && code.toUpperCase().replaceAll(" ", "").indexOf("REREAD_EXPOSURE=YES") < 0) {
            codeSegment.addSourceCode("\n").addCommentLine(RB.getStringResource("BaseDBMSType.UpdateModifyWarning.msg.notrans"));
            StringBuffer libCodeBuffer = new StringBuffer();
            libCodeBuffer.append(code);
            int val = libCodeBuffer.lastIndexOf(";");
            libCodeBuffer.insert(val, " REREAD_EXPOSURE=YES");
            codeSegment.addSourceCode(libCodeBuffer.toString()).addSourceCode("\n\n");
            return true;
        }
        if (lib.isPreAssigned()) {
            return false;
        }
        return false;
    }

    @Override
    public ICodeSegment genKeyedLookupStatement(ICodeSegment codeSegment, IPhysicalTable table, IIndex modifyIndex, boolean unique, String allTableOptions) throws CodegenException, BadLibraryDefinitionException {
        List indexColumns = modifyIndex.getColumnsList();
        codeSegment.addSourceCode("(");
        codeSegment.addSourceCode(allTableOptions);
        codeSegment.addSourceCode("\n").indent().addSourceCode("cntllev = rec \n").addSourceCode("dbkey = ");
        if (indexColumns.size() > 1) {
            codeSegment.addSourceCode("(");
        }
        codeSegment.addSourceCode(codeSegment.makeColumnList(indexColumns, false, "   ", false, " ", "", codeSegment.isQuoting(), "", false));
        if (indexColumns.size() > 1) {
            codeSegment.addSourceCode(")");
        }
        codeSegment.addSourceCode("\n").unIndent().addSourceCode(") key = dbkey");
        if (unique) {
            codeSegment.addSourceCode(" / unique");
        }
        codeSegment.addSourceCode(";\n\n");
        return codeSegment;
    }

    @Override
    public ICodeSegment genConnectPreserveComments(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        boolean bUseConnectUsing = table.getUseConnectUsing();
        StringBuffer code = null;
        try {
            code = this.getConnect(codeSegment, table);
        }
        catch (RemoteException ex) {
            throw new CodegenException(ex, (IObject)table);
        }
        catch (MdException ex) {
            throw new CodegenException((Exception)((Object)ex), (IObject)table);
        }
        catch (BadLibraryDefinitionException ex) {
            throw new CodegenException(ex, (IObject)table);
        }
        if (bUseConnectUsing) {
            codeSegment.addSourceCode("connect using " + table.getLibrary().getLibref() + DEFAULT_TABLE_ALIAS_KEYWORD + this.getNickName(codeSegment, table) + ";\n");
        } else if (code != null) {
            codeSegment.addSourceCode("connect to " + this.getNickName(codeSegment, table) + "\n").addSourceCode("( \n").indent();
            String connectOptions = code.toString();
            connectOptions = connectOptions.replaceAll("\\n", "");
            codeSegment.addSourceCode(connectOptions).addSourceCode("PRESERVE_COMMENTS").newLine().unIndent().addSourceCode(");").newLine();
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genConnect(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        boolean bUseConnectUsing = table.getUseConnectUsing();
        StringBuffer code = null;
        try {
            code = this.getConnect(codeSegment, table);
        }
        catch (RemoteException ex) {
            throw new CodegenException(ex, (IObject)table);
        }
        catch (MdException ex) {
            throw new CodegenException((Exception)((Object)ex), (IObject)table);
        }
        catch (BadLibraryDefinitionException ex) {
            throw new CodegenException(ex, (IObject)table);
        }
        if (bUseConnectUsing) {
            codeSegment.addSourceCode("connect using " + table.getLibrary().getLibref() + DEFAULT_TABLE_ALIAS_KEYWORD + this.getNickName(codeSegment, table) + ";\n");
        } else if (code != null) {
            codeSegment.addSourceCode("connect to " + this.getNickName(codeSegment, table) + "\n").addSourceCode("( \n").indent();
            codeSegment.addSourceCode(code);
            codeSegment.unIndent().addSourceCode("); \n");
        }
        return codeSegment;
    }

    @Override
    public StringBuffer getConnectUnformatted(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        boolean bUseConnectUsing = table.getUseConnectUsing();
        StringBuffer code = null;
        StringBuffer fullConnectString = new StringBuffer();
        try {
            code = this.getConnect(codeSegment, table);
        }
        catch (RemoteException ex) {
            throw new CodegenException(ex, (IObject)table);
        }
        catch (MdException ex) {
            throw new CodegenException((Exception)((Object)ex), (IObject)table);
        }
        catch (BadLibraryDefinitionException ex) {
            throw new CodegenException(ex, (IObject)table);
        }
        if (bUseConnectUsing) {
            fullConnectString.append("connect using " + table.getLibrary().getLibref() + DEFAULT_TABLE_ALIAS_KEYWORD + this.getNickName(codeSegment, table) + ";\n");
        } else if (code != null) {
            fullConnectString.append("connect to " + this.getNickName(codeSegment, table)).append(" ( ");
            fullConnectString.append(code).append(");");
        }
        return fullConnectString;
    }

    public ICodeSegment genDeleteAll(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (table == null || codeSegment == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment, true);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        if (BACK_QUOTE.equals(this.getQuoteTypeForPassthru())) {
            tableName = this.wrapInBackQuotes(tableName);
        }
        codeSegment.addSourceCode("delete from " + tableName + "\n");
        return codeSegment;
    }

    public ICodeSegment genDeleteAll2(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return this.genDeleteAll(codeSegment, table);
    }

    @Override
    public ICodeSegment genBeginSelectAllFromConnect(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        String nickName = this.getNickName(codeSegment, table);
        if (nickName == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoLibraryEngine.msg.txt"), (IObject)table);
        }
        if (nickName.length() > 0) {
            codeSegment.addSourceCode("select * from connection to ").addSourceCode(nickName).addSourceCode("\n(\n").indent();
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genBeginSelectAllFromConnect(ICodeSegment codeSegment, IPhysicalTable table, StringBuffer columnCode) throws CodegenException {
        String nickName = this.getNickName(codeSegment, table);
        if (nickName == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoLibraryEngine.msg.txt"), (IObject)table);
        }
        if (nickName.length() > 0) {
            codeSegment.addSourceCode("select\n").indent().addSourceCode(columnCode).unIndent().addSourceCode("\nfrom connection to ").addSourceCode(nickName).addSourceCode("\n(\n").indent();
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genEndSelectAllFromConnect(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        String nickName = this.getNickName(codeSegment, table);
        if (nickName == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoLibraryEngine.msg.txt"), (IObject)table);
        }
        if (nickName.length() > 0) {
            codeSegment.addSourceCode("\n);\n").unIndent().addSourceCode("\n").genRCSetCall("&sqlrc");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genDisconnect(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        String nickName = this.getNickName(codeSegment, table);
        if (nickName == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoLibraryEngine.msg.txt"), (IObject)table);
        }
        if (nickName.length() > 0) {
            codeSegment.addSourceCode("disconnect from " + nickName + "; \n");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genExecuteBegin(ICodeSegment codeSegment, IPhysicalTable table, String prefix) {
        codeSegment.addSourceCode(this.getExecuteBegin(prefix).toString()).indent();
        return codeSegment;
    }

    @Override
    public ICodeSegment genExecuteCommit(ICodeSegment codeSegment, IPhysicalTable table, String prefix) throws CodegenException {
        codeSegment.addSourceCode(prefix);
        return codeSegment;
    }

    @Override
    public ICodeSegment genExecuteEnd(ICodeSegment codeSegment, IPhysicalTable table, String prefix) throws CodegenException {
        if (this.getNickName(codeSegment, table) == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoLibraryEngine.msg.txt"), (IObject)table);
        }
        codeSegment.unIndent().addSourceCode(prefix + ") by " + this.getNickName(codeSegment, table) + "; \n\n");
        codeSegment.genRCSetCall("&sqlrc");
        return codeSegment;
    }

    @Override
    public ICodeSegment genTruncate(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment, true);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        if (BACK_QUOTE.equals(this.getQuoteTypeForPassthru())) {
            tableName = this.wrapInBackQuotes(tableName);
        }
        tableName = this.getTableNameCustomizedForDBMS(codeSegment, table, tableName);
        codeSegment.addSourceCode("truncate table " + tableName + "\n");
        return codeSegment;
    }

    public String getTableNameCustomizedForDBMS(ICodeSegment codeSegment, IPhysicalTable table, String tableName) throws CodegenException, BadLibraryDefinitionException {
        return tableName;
    }

    @Override
    public String getDBMSTableName(ILibrary library, String tableName, boolean passthru) {
        return this.getDBMSTableName(library, tableName, passthru, null);
    }

    @Override
    public String getDBMSTableName(ILibrary library, String tableName, boolean passthru, String schemaName) {
        return tableName;
    }

    @Override
    public ICodeSegment genReplaceEntireTable(ICodeSegment codeSegment, IPhysicalTable target, boolean isConstraintEnabled, boolean createConstraints, boolean createIndexes, String dataTableOptions, boolean simulatingTruncate, ITransform callingTransform) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (this.isTablespaceSupported() && createConstraints) {
            this.genIndexTablespaceOptionMacroVariables(codeSegment, target, "");
        }
        this.drop(codeSegment, target, true);
        this.genCodeConditionCheck(codeSegment, "DIS_CTABLEDROPPED", callingTransform, target);
        this.create(codeSegment, target, false, createConstraints, createIndexes, true, dataTableOptions, callingTransform);
        return codeSegment;
    }

    @Override
    public final StringBuffer getConnect(ICodeSegment codeSegment, IPhysicalTable table) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException {
        return this.getConnect(codeSegment, table.getCodeGenLibrary(codeSegment.getCurrentServer()));
    }

    @Override
    public final StringBuffer getConnect(ICodeSegment codeSegment, ILibrary library) throws MdException, RemoteException, CodegenException {
        if (!this.getPassThroughSupport()) {
            return null;
        }
        StringBuffer sasCode = new StringBuffer();
        String dbmsOptions = "";
        String dbmsOptionsExtra = "";
        if (library == null) {
            return sasCode;
        }
        dbmsOptions = library.getConnectionOptions();
        dbmsOptionsExtra = this.getAdditionalConnectionOptions(library, dbmsOptions);
        if (library.getLibref() == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoLibraryEngine.msg.txt"), (IObject)library);
        }
        if (dbmsOptions.length() > 0) {
            sasCode.append(dbmsOptions + "\n");
        }
        if (dbmsOptionsExtra.length() > 0) {
            sasCode.append(dbmsOptionsExtra + "\n");
        }
        return sasCode;
    }

    public StringBuffer getExecuteBegin(String prefix) {
        StringBuffer code = new StringBuffer();
        code.append(prefix + "execute \n").append(prefix + "( \n");
        return code;
    }

    @Override
    public ICodeSegment genExecuteBeginPreserveComments(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        if (this.getNickName(codeSegment, table) == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoLibraryEngine.msg.txt"), (IObject)table);
        }
        codeSegment.addSourceCode("execute by ").addSourceCode(this.getNickName(codeSegment, table)).newLine().addSourceCode("(").newLine().indent();
        return codeSegment;
    }

    @Override
    public ICodeSegment genExecuteEndPreserveComments(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        codeSegment.unIndent().addSourceCode(");").newLine(2);
        codeSegment.genRCSetCall("&sqlrc");
        return codeSegment;
    }

    public String getIndexColumnName(ICodeSegment codeSegment, IColumn column) throws CodegenException {
        String colName = column.getColumnName(codeSegment, true);
        if (colName == null || colName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoColumnName.msg.txt"), (IObject)column);
        }
        return colName;
    }

    @Override
    public IColumn[] getNotNullCols(IPhysicalTable dataTable) {
        ArrayList<IColumn> notNullColumns = new ArrayList<IColumn>();
        IColumn[] cols = dataTable.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i].isNullable()) continue;
            notNullColumns.add(cols[i]);
        }
        return notNullColumns.toArray(new IColumn[notNullColumns.size()]);
    }

    @Override
    public String getPreferredReplaceType() {
        if (this.isDeleteAllRowsSupported()) {
            if (this.isTruncateSupported()) {
                return "Truncate";
            }
            return "Delete";
        }
        return "EntireTable";
    }

    public ICodeSegment dropSingleConstraint(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        return codeSegment;
    }

    public ICodeSegment genSingleIndex(ICodeSegment codeSegment, IPhysicalTable table, IIndex index) throws CodegenException, BadLibraryDefinitionException {
        String preOpts = this.getPreIndexOptions(index);
        String tableOpts = this.getIndexTableOptions(codeSegment, index);
        String idxname = this.getIndexName(codeSegment, index, true);
        if (idxname == null || idxname.trim().length() <= 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.IndexNameUndefined.msg.txt"), (IObject)index);
        }
        if (index.getTable() == null) {
            throw new CodegenException(RB.getStringResource("IndexCG.MissingIndexTable.msg.txt"), (IObject)index);
        }
        codeSegment.addSourceCode("create ");
        if (preOpts.length() > 0) {
            codeSegment.addSourceCode(preOpts.trim() + " ");
        }
        String tableName = table.getFullNameQuotedAsNeeded(codeSegment, this.m_passthru);
        if (BACK_QUOTE.equals(this.getQuoteTypeForPassthru())) {
            idxname = this.wrapInBackQuotes(idxname);
            tableName = this.wrapInBackQuotes(tableName);
        }
        tableName = this.getTableNameCustomizedForDBMS(codeSegment, table, tableName);
        codeSegment.addSourceCode("index " + idxname + "\n").indent().addSourceCode("on " + tableName + "\n").indent().addSourceCode("  (");
        if (tableOpts.length() > 0) {
            codeSegment.addSourceCode(tableOpts + "\n   ");
        }
        List lColumns = null;
        lColumns = index.getColumnsList();
        if (lColumns.isEmpty()) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoColumnsOnIndex.msg.txt"), (IObject)index);
        }
        String columns = this.makeColumnListInDBMSTypeFormat(codeSegment, lColumns);
        codeSegment.addSourceCode(columns).addSourceCode(") \n").unIndent().unIndent();
        return codeSegment;
    }

    public String makeColumnListInDBMSTypeFormat(ICodeSegment codeSegment, List lColumns) throws CodegenException {
        return codeSegment.makeColumnList(lColumns, true, codeSegment.getIndentString() + "   ", this.m_passthru, ",", "", codeSegment.isQuoting(), codeSegment.getIndentString(), false);
    }

    public ICodeSegment genTablespaceName(ICodeSegment codeSegment, IIndex index) {
        return codeSegment;
    }

    @Override
    public boolean isNativeFunctionSetsSupported() {
        return false;
    }

    @Override
    public boolean isModelManagerFunctionSetsSupported() {
        return false;
    }

    @Override
    public StringBuffer getNativeFunctionSetsQuery(ILibrary library, boolean quotes) {
        return null;
    }

    @Override
    public List createNativeFunctionsFromQueryResults(MVAResultSet rsltSet) throws SQLException {
        return null;
    }

    @Override
    public StringBuffer getModelManagerFunctionSetsQuery(ILibrary library, boolean quotes, List types) {
        return null;
    }

    @Override
    public StringBuffer getModelManagerProjectsQuery(ILibrary library, boolean quotes) {
        return new StringBuffer();
    }

    public String getIndexTableOptions(ICodeSegment codeSegment, IIndex i_index) {
        return "";
    }

    public String getNickName(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        ILibrary library;
        try {
            library = table.getCodeGenLibrary(codeSegment.getCodeGenerationEnvironment().getCurrentServer());
        }
        catch (BadLibraryDefinitionException e) {
            throw new CodegenException(e, (IObject)table);
        }
        if (library == null) {
            throw new CodegenException(new String(RB.getStringResource("BaseDBMSType.NoLibrary.msg.txt") + table.getName()), (IObject)table);
        }
        return library.getEngine();
    }

    public String getPreIndexOptions(IIndex i_index) {
        boolean unique = false;
        unique = i_index.isUnique();
        boolean clustered = false;
        clustered = i_index.isClustered();
        StringBuffer preopts = new StringBuffer("");
        if (unique) {
            preopts.append("UNIQUE ");
        }
        if (clustered) {
            preopts.append(this.m_ClusWord_0);
        }
        return preopts.toString();
    }

    public String getPostIndexOptions(IIndex i_index) {
        StringBuffer opts = new StringBuffer("");
        List optlist = i_index.getPropertyList();
        if (optlist != null) {
            for (int j = 0; j < optlist.size(); ++j) {
                IProperty option = (IProperty)optlist.get(j);
                if (j > 0) {
                    opts.append(" ");
                }
                opts.append(option.getName() + " = \"" + option.getDefaultValue() + "\"");
            }
        }
        return opts.toString();
    }

    @Override
    public String getSchemaName(IServer currentServer, IPhysicalTable table, boolean quotes) throws BadLibraryDefinitionException {
        String schemaName = "";
        IDatabaseSchema schema = table.getDatabaseSchema();
        if (!(schema == null || (schemaName = schema.getSchemaName().trim()).length() <= 0 || !quotes || !table.isQuoted() || schemaName.startsWith("'") && schemaName.endsWith("'") || schemaName.startsWith("\"") && schemaName.endsWith("\""))) {
            schemaName = "\"" + schemaName + "\"";
        }
        return schemaName;
    }

    @Override
    public String getIndexNamePrefix(IPhysicalTable oTable) {
        return "Index";
    }

    public String getIndexName(ICodeSegment codeSegment, IIndex index, boolean passthru) throws CodegenException {
        String name = index.getName();
        if (name == null || name.trim().length() <= 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.MissingIndexName.msg.txt"), (IObject)index);
        }
        IPhysicalTable table = index.getTable();
        if (table == null) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.MissingIndexTable.msg.txt"), (IObject)index);
        }
        name = DBMSNamesUtil.getQuotedIndexName(index, codeSegment.isQuoting(), passthru);
        return name;
    }

    @Override
    public ICodeSegment loadWithUpsert(ICodeSegment codeSegment, IPhysicalTable table, List matchColumnList, boolean unmappedEqMissingInUpdate, List unmappedColumnList, String additionalTableOptions, IDataTransform transform) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return codeSegment;
    }

    public ICodeSegment queryIndexes(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = table.getSASTableName();
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        String schema = this.getSchemaName(codeSegment.getCurrentServer(), table, codeSegment.isQuoting());
        codeSegment.indent().addSourceCode("from \n").indent().addSourceCode("( \n").addSourceCode(" select distinct index_name as idxname, \n").addSourceCode("        table_name as tabname \n").indent().addSourceCode(" from connection to ").addSourceCode(this.getNickName(codeSegment, table)).addSourceCode("\n").indent().addSourceCode(" (DBMS::Indexes (\"\", " + schema + ", " + tableName + ")) \n").unIndent().unIndent().addSourceCode(");\n").unIndent().unIndent();
        return codeSegment;
    }

    protected void setClusterWord(String word) {
        this.m_ClusWord_0 = word;
    }

    public ICodeSegment queryConstraints(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        String tableName = DBMSNamesUtil.getTableNamePart(table.getFullNameQuotedAsNeeded(codeSegment, true));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoTableReference.msg.txt"), (IObject)table);
        }
        String schema = this.getSchemaName(codeSegment.getCurrentServer(), table, true);
        codeSegment.indent().addSourceCode("from \n").indent().addSourceCode("( \n").addSourceCode(" select 'P' as constType, 'NA' as constName \n").indent().addSourceCode(" from connection to ").addSourceCode(this.getNickName(codeSegment, table)).addSourceCode("\n").indent().addSourceCode(" (DBMS::PrimaryKeys (\"\", " + schema + ", " + tableName + ")) \n").unIndent().unIndent().addSourceCode(");\n").unIndent().unIndent();
        return codeSegment;
    }

    @Override
    public ICodeSegment dropConstraints(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.DropConstraint.msg.notrans")).genPercentPutStatement(RB.getStringResource("BaseDBMSType.DropConstraint.note.sasmacro.notrans"));
        String tableName = "etls_CIList";
        codeSegment.genTableDelete(tableName);
        codeSegment.addSourceCode("proc sql; \n\n").indent();
        this.genConnect(codeSegment, table);
        codeSegment.addSourceCode("reset noprint; \n\n");
        codeSegment.addSourceCode("create table etls_CIList as \n").indent().addSourceCode("select consttype length=20, \n").addSourceCode("       constname length=" + this.m_indexNameLength + " \n").unIndent();
        this.queryConstraints(codeSegment, table);
        codeSegment.addSourceCode("%let etls_numConst = &sqlObs; \n");
        codeSegment.addSourceCode("\n%let etls_deleteList= etls_CIList; \n");
        codeSegment.addSourceCode("\n").genPercentPutStatement(RB.getStringResource("BaseDBMSType.NumberConstraints.msg.sasmacro.notrans")).addSourceCode("\n").addSourceCode("%do etls_ConstCount = 1 %to &etls_numConst; \n\n").indent().addSourceCode("select constname, consttype into :etls_constName , :etls_constType \n").indent().addSourceCode("from &etls_deleteList \n").addSourceCode("        (firstobs = &etls_ConstCount \n").addSourceCode("         obs = &etls_ConstCount); \n\n").unIndent().genPercentPutStatement(RB.getStringResource("BaseDBMSType.DropSingleConstraint.msg.sasmacro.notrans"), "NOTE:", false).addSourceCode("\n");
        this.dropSingleConstraint(codeSegment, table);
        this.genExecuteCommit(codeSegment, table, "");
        codeSegment.addSourceCode("\n").unIndent().addSourceCode("%end;  ").addCommentLine(RB.getStringResource("BaseDBMSType.ConstraintDoLoop.msg.notrans"));
        this.genDisconnect(codeSegment, table);
        codeSegment.addSourceCode("\n").unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc");
        codeSegment.genTableDelete("etls_CIList etls_CIList2");
        return codeSegment;
    }

    @Override
    public ICodeSegment createIndexAndConstraintsConditionally(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (this.hasIndexes(table) || this.hasConstraints(table)) {
            codeSegment.addSourceCode("%if (&etls_tableExist eq 0) %then\n").addSourceCode("%do;\n").indent();
            this.createIndexes2(codeSegment, table, null, "");
            this.createConstraints(codeSegment, table);
            codeSegment.unIndent().addSourceCode("%end;\n");
        }
        return codeSegment;
    }

    @Override
    public List getIndexesToCreate(IPhysicalTable table) {
        if (!this.isConstraintSupported()) {
            return new ArrayList(table.getIndexesList());
        }
        if (this.m_excludeCOwnFromIndexCreate) {
            return table.getIndexesNotInUniqKeys();
        }
        return table.getIndexesNotInPrimaryKey();
    }

    @Override
    public ICodeSegment createIndexes2(ICodeSegment codeSegment, IPhysicalTable table, List indexList, String altTableName) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (table.isView()) {
            return codeSegment;
        }
        if (indexList == null) {
            indexList = this.getIndexesToCreate(table);
        }
        if (indexList.size() > 0) {
            codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.CreateIndex.msg.notrans"));
            codeSegment.genPercentPutStatement(RB.getStringResource("BaseDBMSType.CreateIndex.note.sasmacro.notrans")).addSourceCode("%macro etls_createIndexes;\n").indent().addSourceCode("proc sql; \n").indent();
            this.genConnect(codeSegment, table);
            codeSegment.addSourceCode("reset noprint; \n");
            for (int i = 0; i < indexList.size(); ++i) {
                this.genExecuteBegin(codeSegment, table, "");
                IIndex i_index = (IIndex)indexList.get(i);
                this.genSingleIndex(codeSegment, table, i_index);
                String opts = this.getPostIndexOptions(i_index);
                if (opts.length() > 0) {
                    codeSegment.indent().addSourceCode(opts + "\n").unIndent();
                }
                this.genIndexTablespaceOption(codeSegment, i_index);
                this.genExecuteEnd(codeSegment, table, "");
                this.genExecuteCommit(codeSegment, table, "");
            }
            this.genDisconnect(codeSegment, table);
            codeSegment.unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc");
            codeSegment.unIndent().addSourceCode("%mend etls_createIndexes;\n").addSourceCode("%etls_createIndexes;\n\n");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment dropIndexes(ICodeSegment codeSegment, IPhysicalTable table, IIndex keepIndex) throws CodegenException, BadLibraryDefinitionException {
        String keepIndexName = "";
        if (keepIndex != null) {
            keepIndexName = keepIndex.getName();
        }
        codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.DropIndex.msg.notrans")).genPercentPutStatement(RB.getStringResource("BaseDBMSType.DropIndex.note.sasmacro.notrans"));
        codeSegment.genTableDelete("etls_CIList");
        codeSegment.addSourceCode("proc sql; \n\n").indent();
        boolean bDropWithPassthru = this.isPassthruUsedForDropIndexes();
        this.genQueryIndexesSQL(codeSegment, table, "etls_CIList", bDropWithPassthru, false);
        codeSegment.addSourceCode("\n%let etls_deleteList= etls_CIList; \n");
        if (keepIndexName != "") {
            codeSegment.addSourceCode("select '1' into: etls_hasUpdateIndex \n").indent().addSourceCode("from &etls_deleteList \n").indent().addSourceCode("where upcase(idxname) = \"" + keepIndexName.toUpperCase() + "\"; \n\n").unIndent().unIndent();
            codeSegment.addSourceCode("/* Exclude from delete list the index needed in upcoming step */ \n").addSourceCode("%if &etls_hasUpdateIndex %then \n").addSourceCode("%do; \n").indent().addSourceCode("create table &etls_deleteList.2 as \n").indent().addSourceCode("select * \n").indent().addSourceCode("from &etls_deleteList \n").addSourceCode("where upcase(idxname) ne \"" + keepIndexName.toUpperCase() + "\"; \n").unIndent().unIndent().addSourceCode("%let etls_numIndex = &sqlObs; \n").addSourceCode("%let etls_deleteList= &etls_deleteList.2; \n");
            codeSegment.unIndent().addSourceCode("%end; \n");
        }
        codeSegment.addSourceCode("\n").genPercentPutStatement(RB.getStringResource("BaseDBMSType.NumberIndexes.msg.sasmacro.notrans")).addSourceCode("\n").addSourceCode("%do etls_indexCount = 1 %to &etls_numIndex; \n\n").indent().addSourceCode("select idxname, tabname into :etls_indexName , :etls_indexTable \n").indent().addSourceCode("from &etls_deleteList \n").addSourceCode("        (firstobs = &etls_indexCount \n").addSourceCode("         obs = &etls_indexCount); \n\n").unIndent().genPercentPutStatement(RB.getStringResource("BaseDBMSType.DropSingleIndex.msg.sasmacro.notrans"), "NOTE:", false).addSourceCode("\n");
        if (bDropWithPassthru) {
            this.genExecuteBegin(codeSegment, table, "");
        }
        this.dropSingleIndex(codeSegment, table);
        if (bDropWithPassthru) {
            this.genExecuteEnd(codeSegment, table, "");
            this.genExecuteCommit(codeSegment, table, "");
        } else {
            codeSegment.addSourceCode(";");
        }
        codeSegment.addSourceCode("\n").unIndent().addSourceCode("%end;  ").addCommentLine(RB.getStringResource("BaseDBMSType.IndexDoLoop.msg.notrans"));
        if (bDropWithPassthru) {
            this.genDisconnect(codeSegment, table);
        }
        codeSegment.addSourceCode("\n").unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc");
        this.genIndexTablespaceOptionMacroVariables(codeSegment, table, "etls_CIList");
        codeSegment.genTableDelete("etls_CIList etls_CIList2");
        return codeSegment;
    }

    @Override
    public ICodeSegment genQueryIndexesSQL(ICodeSegment codeSegment, IPhysicalTable table, String outputTableName, boolean bAddConnect, boolean bAddDisconnect) throws CodegenException, BadLibraryDefinitionException {
        if (bAddConnect) {
            this.genConnect(codeSegment, table);
        }
        codeSegment.addSourceCode("reset noprint; \n\n");
        codeSegment.addSourceCode("create table " + outputTableName + " as \n").indent().addSourceCode("select tabname length=100, \n").addSourceCode("       idxname length=" + this.m_indexNameLength + " \n").unIndent();
        this.queryIndexes(codeSegment, table);
        codeSegment.addSourceCode("%let etls_numIndex = &sqlObs; \n");
        if (bAddDisconnect) {
            this.genDisconnect(codeSegment, table);
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment dropSingleIndex(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        boolean quoting = codeSegment.isQuoting();
        if (quoting) {
            codeSegment.addSourceCode("drop index \"%trim(%bquote(&etls_indexName))\" \n");
        } else {
            codeSegment.addSourceCode("drop index &etls_indexName \n");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment dropCI(ICodeSegment codeSegment, IPhysicalTable table, boolean dropC, boolean dropI, IIndex indexToKeep) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (dropC) {
            this.dropConstraints(codeSegment, table);
        }
        if (dropI) {
            this.dropIndexes(codeSegment, table, indexToKeep);
        }
        return codeSegment;
    }

    @Override
    public boolean syncCISetup(ICodeSegment codeSegment, IPhysicalTable table, IIndex indexToKeep, String ciSelected) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return true;
    }

    @Override
    public ICodeSegment syncCIPreLoad(ICodeSegment codeSegment, IPhysicalTable table, boolean cOFFBefore, boolean cONBefore, boolean iOFFBefore, boolean iONBefore) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        this.dropCI(codeSegment, table, cONBefore || cOFFBefore, iONBefore || iOFFBefore, null);
        if (iONBefore) {
            this.createIndexes2(codeSegment, table, null, "");
        }
        if (cONBefore) {
            this.createConstraints(codeSegment, table);
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment syncCIPostLoad(ICodeSegment codeSegment, IPhysicalTable table, IIndex indexToKeep, boolean cOFFBefore, boolean cONAfter, boolean cOFFAfter, boolean iOFFBefore, boolean iONAfter, boolean iOFFAfter) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        this.dropCI(codeSegment, table, cONAfter && !cOFFBefore || cOFFAfter, iONAfter && !iOFFBefore || iOFFAfter, null);
        if (iONAfter) {
            this.createIndexes2(codeSegment, table, null, "");
        }
        if (cONAfter) {
            this.createConstraints(codeSegment, table);
        }
        return codeSegment;
    }

    public ICodeSegment dropSingleIndex2(ICodeSegment codeSegment, IIndex index) throws CodegenException {
        String indexName = this.getIndexName(codeSegment, index, true);
        if (BACK_QUOTE.equals(this.getQuoteTypeForPassthru())) {
            indexName = this.wrapInBackQuotes(indexName);
        }
        codeSegment.addSourceCode("drop index ").addSourceCode(indexName).addSourceCode(" \n");
        return codeSegment;
    }

    @Override
    public boolean hasConstraints(IPhysicalTable table) {
        boolean hasConstraints = false;
        if (table != null) {
            IColumn[] notNullColumns = this.getNotNullCols(table);
            hasConstraints = this.isConstraintSupported() && this.isNotNullIsConstraint() && notNullColumns.length > 0 || table.getForeignKeysList().size() > 0 || table.getKeysList().size() > 0;
        }
        return hasConstraints;
    }

    @Override
    public boolean hasSingleConstraint(IPhysicalTable table) {
        int singleConstraintCount = 0;
        if (table != null) {
            IColumn[] notNullColumns = this.getNotNullCols(table);
            singleConstraintCount = (this.isConstraintSupported() && this.isNotNullIsConstraint() && notNullColumns.length == 1 ? 1 : 0) + (table.getForeignKeysList().size() == 1 ? 1 : 0) + (table.getKeysList().size() == 1 ? 1 : 0);
        }
        return singleConstraintCount == 1;
    }

    @Override
    public boolean hasIndexes(IPhysicalTable table) {
        boolean hasIndexes = false;
        if (table != null) {
            hasIndexes = this.isIndexSupported() && table.getIndexesList().size() > 0;
        }
        return hasIndexes;
    }

    @Override
    public boolean isIndexSupported() {
        return this.getIndexSupport();
    }

    public boolean getIndexSupport() {
        return this.m_indexSupport;
    }

    protected void setIndexSupport(boolean support) {
        this.m_indexSupport = support;
    }

    @Override
    public boolean isConstraintSupported() {
        return this.getConstraintSupport();
    }

    public boolean getConstraintSupport() {
        return this.m_constraintSupport;
    }

    protected void setConstraintSupport(boolean support) {
        this.m_constraintSupport = support;
    }

    @Override
    public boolean isPassThroughSupported() {
        return this.getPassThroughSupport();
    }

    public boolean getPassThroughSupport() {
        return this.m_passthru;
    }

    protected void setPassThroughSupport(boolean support) {
        this.m_passthru = support;
    }

    @Override
    public boolean isRandomAccessSupported() {
        return this.getRandomAccessSupport();
    }

    public boolean getRandomAccessSupport() {
        return this.m_randomAccessSupport;
    }

    protected void setRandomAccessSupport(boolean support) {
        this.m_randomAccessSupport = support;
    }

    public boolean getExcludeCOwnFromIndexCreate() {
        return this.m_excludeCOwnFromIndexCreate;
    }

    protected void setExcludeCOwnFromIndexCreate(boolean flag) {
        this.m_excludeCOwnFromIndexCreate = flag;
    }

    @Override
    public boolean isDeleteAllRowsSupported() {
        return this.getDeleteAllRowsSupport();
    }

    public boolean getDeleteAllRowsSupport() {
        return this.m_deleteAllRowsSupport;
    }

    protected void setDeleteAllRowsSupport(boolean support) {
        this.m_deleteAllRowsSupport = support;
    }

    public String getClusterWord() {
        return this.m_ClusWord_0;
    }

    @Override
    public boolean isTruncateSupported() {
        return this.getTruncateSupport();
    }

    public boolean getTruncateSupport() {
        return this.m_truncateSupport;
    }

    @Override
    public String getUnquotedTableNameAction() {
        return this.m_unquotedTableNameAction;
    }

    public void setTableAliasKeyword(String keyword) {
        this.m_tableAliasKeyword = keyword;
    }

    @Override
    public String getTableAliasKeyword(boolean passthru) {
        if (passthru) {
            return this.m_tableAliasKeyword;
        }
        return DEFAULT_TABLE_ALIAS_KEYWORD;
    }

    protected void setTruncateSupport(boolean support) {
        this.m_truncateSupport = support;
    }

    @Override
    public boolean isSimulateTruncateSupported() {
        return this.m_simulateTruncateSupport;
    }

    protected void setSimulateTruncateSupport(boolean support) {
        this.m_simulateTruncateSupport = support;
    }

    protected void setDBMSTempSupport(boolean support) {
        this.m_DBMSTempSupport = support;
    }

    @Override
    public boolean isDBMSTempSupported() {
        return this.m_DBMSTempSupport;
    }

    protected void setCreateTempIndexAndConstraintAfterLoad(boolean support) {
        this.m_bCreateTempIndexAndConstraintAfterLoad = support;
    }

    @Override
    public boolean isCreateTempIndexAndConstraintAfterLoad() {
        return this.m_bCreateTempIndexAndConstraintAfterLoad;
    }

    public void setUnquotedTableNameAction(String action) {
        this.m_unquotedTableNameAction = action;
    }

    @Override
    public boolean isUpsertSupported() {
        return this.getUpsertSupport();
    }

    public boolean getUpsertSupport() {
        return this.m_upsertSupport;
    }

    protected void setUpsertSupport(boolean support) {
        this.m_upsertSupport = support;
    }

    protected void setDeleteTableSupport(boolean support) {
        this.m_bDeleteTableSupport = support;
    }

    @Override
    public boolean isDeleteTableSupported() {
        return this.m_bDeleteTableSupport;
    }

    @Override
    public ICodeSegment genTableDelete(ICodeSegment codeSegment, boolean isView, String tableName, String passwordOptions) throws BadLibraryDefinitionException, CodegenException, RemoteException, ServerException, MdException, BadServerDefinitionException {
        if (this.isDeleteTableSupported()) {
            codeSegment.genTableDelete(tableName, passwordOptions);
        }
        return codeSegment;
    }

    protected ICodeSegment genTableProcDelete(ICodeSegment codeSegment, boolean isView, String tableName, String passwordOptions) throws BadLibraryDefinitionException, CodegenException, RemoteException, ServerException, MdException, BadServerDefinitionException {
        if (!isView) {
            codeSegment.genTableProcDelete(tableName, passwordOptions);
        } else {
            codeSegment.genTableDelete(tableName, passwordOptions);
        }
        return codeSegment;
    }

    protected void setTablespaceSupport(boolean support) {
        this.m_bTablespaceSupport = support;
    }

    @Override
    public boolean isMatchingSimpleIndexNameRequired() {
        return this.m_bMatchingSimpleIndexNameRequired;
    }

    protected void setMatchingSimpleIndexNameRequired(boolean required) {
        this.m_bMatchingSimpleIndexNameRequired = required;
    }

    @Override
    public boolean isRereadExposureRequired() {
        return this.m_bRereadExposureRequired;
    }

    protected void setRereadExposureRequired(boolean required) {
        this.m_bRereadExposureRequired = required;
    }

    @Override
    public boolean isPassthruUsedForDropIndexes() {
        return this.isPassThroughSupported() && this.m_bPassthruUsedForDropIndexes;
    }

    protected void setPassthruUsedForDropIndexes(boolean bUse) {
        this.m_bPassthruUsedForDropIndexes = bUse;
    }

    @Override
    public String getQuoteTypeForPassthru() {
        return this.m_sQuoteTypeForPassthru;
    }

    protected void setQuoteTypeForPassthru(String sQuoteType) {
        this.m_sQuoteTypeForPassthru = sQuoteType;
    }

    @Override
    public boolean isTablespaceSupported() {
        return this.m_bTablespaceSupport;
    }

    @Override
    public boolean isNotNullIsConstraint() {
        return this.m_notNullIsConstraint;
    }

    public boolean getNotNullIsConstraint() {
        return this.m_notNullIsConstraint;
    }

    protected void setNotNullIsConstraint(boolean flag) {
        this.m_notNullIsConstraint = flag;
    }

    @Override
    public String getConstraintTypesDroppable() {
        return this.m_constraintTypesDroppable;
    }

    protected void setConstraintTypesDroppable(String punr) {
        this.m_constraintTypesDroppable = punr;
    }

    @Override
    public String getSQLInsertOptions() {
        return this.m_SQLInsertOptions;
    }

    protected void setSQLInsertOptions(String options) {
        this.m_SQLInsertOptions = options;
    }

    public String getAddKeyDelimiter() {
        return this.m_addKeyDelimiter;
    }

    protected void setAddKeyDelimiter(String delim) {
        this.m_addKeyDelimiter = delim;
    }

    public boolean getRepeatAddKeyCommand() {
        return this.m_repeatAddKeyCommand;
    }

    protected void setRepeatAddKeyCommand(boolean repeat) {
        this.m_repeatAddKeyCommand = repeat;
    }

    public boolean getAddOneKeyPerExecute() {
        return this.m_addOneKeyPerExecute;
    }

    protected void setAddOneKeyPerExecute(boolean onePerExecute) {
        this.m_addOneKeyPerExecute = onePerExecute;
    }

    protected void setIndexNameLength(String idxLength) {
        this.m_indexNameLength = idxLength;
    }

    public String getIndexNameLength() {
        return this.m_indexNameLength;
    }

    @Override
    public String getAdditionalConnectionOptions(ILibrary iLib, String dbmsOptions) throws MdException, RemoteException {
        return "";
    }

    @Override
    public ICodeSegment create(ICodeSegment codeSegment, IPhysicalTable table, boolean useMacroLogic, boolean createColumnConstraints, boolean createIndexes, boolean doTableCreateCodeCondition, String additionalTableOptions, ITransform transformModel) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return this.create(codeSegment, table, useMacroLogic, createColumnConstraints, createIndexes, doTableCreateCodeCondition, additionalTableOptions, transformModel, "etls_tableExist");
    }

    @Override
    public ICodeSegment create(ICodeSegment codeSegment, IPhysicalTable table, boolean useMacroLogic, boolean createColumnConstraints, boolean createIndexes, boolean doTableCreateCodeCondition, String additionalTableOptions, ITransform transformModel, String sExistMacroName) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        return this.create(codeSegment, table, useMacroLogic, createColumnConstraints, createIndexes, doTableCreateCodeCondition, additionalTableOptions, transformModel, sExistMacroName, "", "", "", "");
    }

    @Override
    public ICodeSegment create(ICodeSegment codeSegment, IPhysicalTable table, boolean useMacroLogic, boolean createColumnConstraints, boolean createIndexes, boolean doTableCreateCodeCondition, String additionalTableOptions, ITransform transformModel, String sExistMacroName, String preStmtOpts, String preTableOpts, String postTableOpts, String postStmtOpts) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.Create.msg.notrans"));
        if (useMacroLogic) {
            codeSegment.addSourceCode("%if (&").addSourceCode(sExistMacroName).addSourceCode(" eq 0) %then \n").addSourceCode("%do;  ").addCommentLine(RB.getStringResource("BaseDBMSType.TableDoesNotExist.msg.notrans")).addSourceCode("\n").indent().genPercentPutStatement(RB.getStringResource("BaseDBMSType.Create.note.sasmacro.notrans")).addSourceCode("\n");
        }
        StringBuffer gen_opts = new StringBuffer();
        String label = this.getDataTableLabel(table);
        if (label.length() > 0) {
            gen_opts.append(CodeSegment.getLabelStatement(label)).append("\n         ");
        }
        gen_opts.append(table.getWriteTableOptions(false, additionalTableOptions));
        String dbnullOptions = this.getDBNULL(codeSegment, table);
        if (dbnullOptions.length() > 1) {
            if (gen_opts.length() > 0) {
                gen_opts.append("\n         ");
            }
            gen_opts.append(dbnullOptions);
        }
        if (this.getDBMSTypeID() == 7 || this.getDBMSTypeID() == 12) {
            if (preStmtOpts.length() > 0) {
                if (gen_opts.length() > 0) {
                    gen_opts.append("\n");
                }
                gen_opts.append("         ").append("pre_stmt_opts=\"" + preStmtOpts + "\"");
            }
            if (preTableOpts.length() > 0) {
                if (gen_opts.length() > 0) {
                    gen_opts.append("\n");
                }
                gen_opts.append("         ").append("pre_table_opts=\"" + preTableOpts + "\"");
            }
            if (postTableOpts.length() > 0) {
                if (gen_opts.length() > 0) {
                    gen_opts.append("\n");
                }
                gen_opts.append("         ").append("post_table_opts=\"" + postTableOpts + "\"");
            }
            if (postStmtOpts.length() > 0) {
                if (gen_opts.length() > 0) {
                    gen_opts.append("\n");
                }
                gen_opts.append("         ").append("post_stmt_opts=\"" + postStmtOpts + "\"");
            }
        }
        String optString = "";
        if (gen_opts.length() > 0) {
            optString = "\n        (" + gen_opts.toString().trim() + ")";
        }
        codeSegment.addSourceCode("data ").addSourceCode(table.getFullNameQuotedAsNeeded(codeSegment)).addSourceCode(optString).addSourceCode(";\n").indent();
        this.genscols(codeSegment, table, transformModel);
        if (table.getColumnCount() > 0) {
            codeSegment.addSourceCode("call missing(of _all_);\n");
        }
        codeSegment.addSourceCode("stop;\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
        if (createIndexes) {
            this.createIndexes2(codeSegment, table, null, "");
        }
        if (createColumnConstraints) {
            this.createConstraints(codeSegment, table);
        }
        if (doTableCreateCodeCondition) {
            this.genCodeConditionCheck(codeSegment, "DIS_CTABLECREATED", transformModel, table);
        }
        if (useMacroLogic) {
            codeSegment.unIndent().addSourceCode("%end;  ").addCommentLine(RB.getStringResource("BaseDBMSType.TableDoesNotExist.msg.notrans")).addSourceCode("\n");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment getSQLCreateCode(IPhysicalTable table, boolean passThru, ICodeSegment cs) {
        if (passThru) {
            String createTableTxt = null;
            createTableTxt = "CREATE TABLE " + table.getDBMSTableName(true) + "\n";
            cs.addSourceCode(createTableTxt);
            cs.indent().addSourceCode("(\n").indent();
            IColumn[] columns = table.getColumns();
            int size = columns.length;
            String[] colList = new String[size];
            String type = null;
            int j = 0;
            for (int i = 0; i < size; ++i) {
                ++j;
                String columnLength = String.valueOf(columns[i].getLength());
                String colName = columns[i].getName();
                int colType = columns[i].getType();
                boolean nullValuesYes = columns[i].isNullable();
                type = colType == 0 ? "CHAR" : "FLOAT";
                String notNull = nullValuesYes ? "" : "NOT NULL";
                if (j < size) {
                    cs.addSourceCode(colName + " ").addSourceCode(type).addSourceCode("(").addSourceCode(columnLength).addSourceCode(") ").addSourceCode(notNull).addSourceCode(",\n");
                    continue;
                }
                if (j != size) continue;
                cs.addSourceCode(colName + " ").addSourceCode(type).addSourceCode("(").addSourceCode(columnLength).addSourceCode(") ").addSourceCode(notNull).addSourceCode("\n)\n");
            }
        } else {
            try {
                this.getSQLCreateNoPassThru(table, false, cs);
            }
            catch (BadLibraryDefinitionException e) {
                e.printStackTrace();
            }
        }
        return cs;
    }

    public ICodeSegment getSQLCreateNoPassThru(IPhysicalTable table, boolean passThru, ICodeSegment cs) throws BadLibraryDefinitionException {
        String createTableTxt = "CREATE TABLE " + table.getFullNameQuotedAsNeeded(cs, false) + "\n";
        cs.addSourceCode(createTableTxt);
        cs.indent().addSourceCode("(\n").indent();
        IColumn[] columns = table.getColumns();
        int size = columns.length;
        String type = null;
        int j = 0;
        for (int i = 0; i < size; ++i) {
            ++j;
            String columnLength = String.valueOf(columns[i].getLength());
            String colName = columns[i].getName();
            int colType = columns[i].getType();
            boolean nullValuesYes = columns[i].isNullable();
            type = colType == 0 ? "CHAR" : "NUM";
            String notNull = nullValuesYes ? "" : "NOT NULL";
            if (j < size) {
                cs.addSourceCode(colName + " ").addSourceCode(type).addSourceCode("(").addSourceCode(columnLength).addSourceCode(") ").addSourceCode(notNull).addSourceCode(",\n");
                continue;
            }
            if (j != size) continue;
            cs.addSourceCode(colName + " ").addSourceCode(type).addSourceCode("(").addSourceCode(columnLength).addSourceCode(") ").addSourceCode(notNull).addSourceCode("\n);\n");
        }
        return cs;
    }

    @Override
    public String getDBCreateStatements(IPhysicalTable table) {
        return "";
    }

    public String getDataTableLabel(IPhysicalTable table) {
        return "";
    }

    public String getDBNULL(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        StringBuffer sOpts = new StringBuffer();
        List<IColumn> columnList = Arrays.asList(table.getColumns());
        if (columnList.size() > 0) {
            sOpts.append("dbnull = (");
        }
        for (int i = 0; i < columnList.size(); ++i) {
            IColumn col = columnList.get(i);
            String columnName = DBMSNamesUtil.getQuotedColumnName(col, codeSegment.isQuoting(), false);
            sOpts.append("\n                   ");
            if (col.isNullable()) {
                sOpts.append(columnName + " = YES");
                continue;
            }
            sOpts.append(columnName + " = NO");
        }
        if (sOpts.length() > 0) {
            sOpts.append(")");
        }
        return sOpts.toString();
    }

    @Override
    public ICodeSegment genscols(ICodeSegment codeSegment, IPhysicalTable table) throws CodegenException {
        return this.genscols(codeSegment, table, null);
    }

    public ICodeSegment genscols(ICodeSegment codeSegment, IPhysicalTable table, ITransform transformModel) throws CodegenException {
        List<IColumn> columnlist = Arrays.asList(table.getColumns());
        boolean bFormats = true;
        if (transformModel != null && transformModel instanceof AbstractDataTransform && !((AbstractDataTransform)transformModel).isFormatGenerationEnabled()) {
            bFormats = false;
        }
        if (columnlist.size() > 0) {
            for (int i = 0; i < columnlist.size(); ++i) {
                IColumn column = columnlist.get(i);
                String attrib = column.getAttribStatement(codeSegment.isQuoting(), true, bFormats, true);
                codeSegment.addSourceCode(attrib);
            }
        } else {
            throw new CodegenException(RB.getStringResource("BaseDBMSType.NoColumnsDefined.msg.txt"), (IObject)table);
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genCodeConditionCheck(ICodeSegment codeSegment, String sType, ITransform transformModel, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        List sets = transformModel.getConditionActionSetsList();
        for (int i = 0; i < sets.size(); ++i) {
            IConditionActionSet set = (IConditionActionSet)sets.get(i);
            ICondition condition = set.getCondition();
            if (!condition.getUniqueIdentifier().equalsIgnoreCase(sType)) continue;
            if (sType.equals("DIS_CDATAMODIFIED")) {
                codeSegment.addCommentLine(RB.getStringResource("BaseDBMSType.CodeConditionCheck.msg.notrans"));
                this.genGetNumRows(codeSegment, "&etls_lastTable", table.getReadTableOptions(false), "send");
            }
            codeSegment.addCommentLine(RB.getStringResource("BaseDBMSType.CodeConditionLoader.msg.notrans"));
            codeSegment.addSourceCode("%macro etls_loaderCheck; \n").indent();
            String sMacroVar = "trans_rc";
            if (transformModel instanceof JobTransformModel) {
                sMacroVar = "job_rc";
            }
            codeSegment.addSourceCode(condition.getConditionMacroCall(sMacroVar));
            codeSegment.addSourceCode("\n");
            codeSegment.addSourceCode("%do; \n").indent();
            codeSegment.genActionCodeConditionCheck(transformModel.getJob().isUsingNLSDateFormat(), codeSegment, set, table, table.getCodeGenLibrary(codeSegment.getCurrentServer()));
            codeSegment.addSourceCode("\n").unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%mend etls_loaderCheck; \n").addSourceCode("%etls_loaderCheck; \n\n");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genGetNumRows(ICodeSegment codeSegment, String tableName, String tableOptions, String macroVariable) {
        codeSegment.addSourceCode("%let ").addSourceCode(macroVariable).addSourceCode(" = 0;\n");
        codeSegment.addSourceCode("%macro etls_recordCheck; \n").indent();
        codeSegment.genTableExist(tableName, null, "etls_recCheckExist", false);
        codeSegment.addSourceCode("%if (&etls_recCheckExist) %then\n").addSourceCode("%do;\n").indent();
        codeSegment.addSourceCode("proc sql noprint;\n");
        codeSegment.indent();
        codeSegment.addSourceCode("select count(*) into :").addSourceCode(macroVariable).addSourceCode(" from ").addSourceCode(tableName).addSourceCode(";\n");
        codeSegment.unIndent();
        codeSegment.addSourceCode("quit;\n");
        codeSegment.unIndent().addSourceCode("%end;\n").unIndent().addSourceCode("%mend etls_recordCheck;\n").addSourceCode("%etls_recordCheck;\n\n");
        return codeSegment;
    }

    @Override
    public ICodeSegment deleteAllRows(ICodeSegment codeSegment, IPhysicalTable table, boolean useTruncate) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        if (!useTruncate || !this.isTruncateSupported()) {
            codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.DeleteAllRows.msg.notrans")).genPercentPutStatement(RB.getStringResource("BaseDBMSType.DeleteAllRows.note.sasmacro.notrans"));
        } else {
            codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.Truncate.msg.notrans")).genPercentPutStatement(RB.getStringResource("BaseDBMSType.Truncate.note.sasmacro.notrans"));
        }
        codeSegment.addSourceCode("proc sql;\n").indent();
        this.genConnect(codeSegment, table);
        codeSegment.addSourceCode("reset noprint; \n\n");
        this.genExecuteBegin(codeSegment, table, "");
        if (!useTruncate || !this.getTruncateSupport()) {
            this.genDeleteAll2(codeSegment, table);
        } else {
            this.genTruncate(codeSegment, table);
        }
        this.genExecuteEnd(codeSegment, table, "");
        this.genExecuteCommit(codeSegment, table, "");
        this.genDisconnect(codeSegment, table);
        codeSegment.unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc");
        return codeSegment;
    }

    @Override
    public ICodeSegment truncate(ICodeSegment codeSegment, IPhysicalTable table) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        codeSegment.addSectionComment(RB.getStringResource("BaseDBMSType.Truncate.msg.notrans")).genPercentPutStatement(RB.getStringResource("BaseDBMSType.Truncate.note.sasmacro.notrans")).addSourceCode("\n");
        codeSegment.addSourceCode("proc sql;\n").indent();
        this.genConnect(codeSegment, table);
        codeSegment.addSourceCode("reset noprint; \n\n");
        this.genExecuteBegin(codeSegment, table, "");
        this.genDeleteAll(codeSegment, table);
        this.genExecuteEnd(codeSegment, table, "");
        this.genExecuteCommit(codeSegment, table, "");
        this.genDisconnect(codeSegment, table);
        codeSegment.addSourceCode("\n").unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc");
        return codeSegment;
    }

    @Override
    public String wrapInBackQuotes(String nameToQuote) {
        nameToQuote = "`" + nameToQuote.replaceAll("\"", "") + "`";
        return nameToQuote.replaceAll("'", "%str(%')");
    }

    @Override
    public ICodeSegment genIndexTablespaceOptionMacroVariables(ICodeSegment codeSegment, IPhysicalTable table, String tempTablespaceTable) throws CodegenException, BadLibraryDefinitionException {
        IIndex i_index;
        int i;
        if (!table.getDBMSType().isTablespaceSupported()) {
            return codeSegment;
        }
        List indexList = table.getDBMSType().getIndexesToCreate(table);
        if (indexList == null || indexList.size() == 0) {
            return codeSegment;
        }
        if (tempTablespaceTable.equals("")) {
            tempTablespaceTable = "etls_indexTablespace";
            codeSegment.addCommentLine("Initialize temp table to store pre-existing index tablespace assignments").addSourceCode("data " + tempTablespaceTable + ";\n").indent().addSourceCode("length tabname $100;\n").addSourceCode("tabname='';\n").addSourceCode("stop;\n").unIndent().addSourceCode("run;\n\n");
            codeSegment.addSourceCode("%if (&etls_tableExist) %then \n%do;\n").indent().addSourceCode("proc sql; \n").indent();
            table.getDBMSType().genQueryIndexesSQL(codeSegment, table, tempTablespaceTable, true, true);
            codeSegment.unIndent().addSourceCode("quit; \n\n").genRCSetCall("&sqlrc").unIndent().addSourceCode("%end;\n\n");
        }
        String quotedTableName = "'" + DBMSNamesUtil.getTableNamePart(table.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), codeSegment.isQuoting(), true, false, "")).replaceAll("'", "''") + "'";
        codeSegment.addSourceCode("/* Assign TableSpace macro variables (etls_TS_<uniqid>) for each index - based on any previous tablespace assignements */ \n").addSourceCode("%let etls_TSdefault=; \n\n").addSourceCode("%if %sysfunc(exist(" + tempTablespaceTable + ")) %then \n").addSourceCode("%do; \n").indent().addSourceCode("data _null_; \n").indent().addSourceCode("length tablespacename $100; \n").addSourceCode("tablespacename=''; \n").addSourceCode("set " + tempTablespaceTable + "(where=(tabname=" + quotedTableName + ") obs=1); \n").addSourceCode("call symput('etls_TSdefault','TABLESPACE '||trim(tablespacename)); \n").addSourceCode("put 'Note: >>> Default tablespace name will be: ' tablespacename; \n").unIndent().addSourceCode("run; \n\n").unIndent().addSourceCode("%end; \n");
        for (i = 0; i < indexList.size(); ++i) {
            i_index = (IIndex)indexList.get(i);
            codeSegment.addSourceCode("%let etls_TS" + codeSegment.formatObjectIDForMacroVar(i_index) + "=&" + "etls_TS" + "default; \n");
        }
        codeSegment.addSourceCode("%if %sysfunc(exist(" + tempTablespaceTable + ")) %then \n").addSourceCode("%do; \n").indent().addSourceCode("\ndata _null_; \n").indent().addSourceCode("length idxname $" + this.getIndexNameLength() + " tablespacename $100; \n").addSourceCode("tablespacename=''; \n").addSourceCode("idxname=''; \n").addSourceCode("set " + tempTablespaceTable + "(where=(tabname=" + quotedTableName + ")); \n").addSourceCode("select(idxname); \n").indent();
        for (i = 0; i < indexList.size(); ++i) {
            i_index = (IIndex)indexList.get(i);
            String quotedIndexName = "'" + i_index.getName().replaceAll("'", "''") + "'";
            codeSegment.addSourceCode("when(" + quotedIndexName + ") call symput('" + "etls_TS" + codeSegment.formatObjectIDForMacroVar(i_index) + "','TABLESPACE '||tablespacename); \n");
        }
        codeSegment.addSourceCode("otherwise; \n").unIndent().addSourceCode("end; \n").unIndent().addSourceCode("run; \n\n").unIndent().addSourceCode("%end; \n");
        if (tempTablespaceTable.equals("etls_indexTablespace")) {
            codeSegment.genTableDelete("etls_indexTablespace");
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment genIndexTablespaceOption(ICodeSegment codeSegment, IIndex index) {
        String sUniqIdForMacvar;
        if (this.isTablespaceSupported() && !(sUniqIdForMacvar = codeSegment.formatObjectIDForMacroVar(index)).equals("")) {
            String macvarName = "etls_TS" + sUniqIdForMacvar;
            codeSegment.indent().indent().addSourceCode("%if %symexist(" + macvarName + ") %then &" + macvarName + ";\n").unIndent().unIndent();
        }
        return codeSegment;
    }

    protected final PromptGroupInterface getPromptGroupGeneral() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
        return PromptUtils.getPromptGroupFromFile(this.getClass().getResource("res/Options_AbstractDBMSTable_Template.xml"));
    }

    private PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
        return PromptUtils.combinePromptGroups(this.getPromptGroupGeneral(), PromptUtils.getPromptGroupFromFile(this.getClass().getResource("res/Options_DBMSTable_Template.xml")));
    }

    protected PhysicalTablePromptModel createTableOptionModel(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = new PhysicalTablePromptModel(model, table);
        optionModel.setPromptGroup(this.getPromptGroup());
        optionModel.setUsePropertySet(false);
        optionModel.setSetRole("");
        return optionModel;
    }

    @Override
    public PhysicalTablePromptModelCollection getTableOptionCollectionInstance(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        if (this.m_tableOptionCollection == null) {
            this.m_tableOptionCollection = this.getTableOptionCollection(null, null);
        }
        PhysicalTablePromptModelCollection cp = (PhysicalTablePromptModelCollection)this.m_tableOptionCollection.copy(table);
        cp.setOwner(table);
        cp.setModel(model);
        return cp;
    }

    public PhysicalTablePromptModelCollection getTableOptionCollection(IModel model, IObject table) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        PhysicalTablePromptModel optionModel = this.createTableOptionModel(model, table);
        PhysicalTablePromptModelCollection collection = new PhysicalTablePromptModelCollection();
        collection.addModel(optionModel, "table_options_gen", RB.getStringResource("BaseDBMSType.Options.title.txt"));
        collection.setSaveValuesAsStrings(true);
        return collection;
    }
}

