/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.data.businessrule.impl;

import com.sas.etl.models.DISUsageVersion;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlow;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowTable;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowVersion;
import com.sas.etl.models.data.businessrule.impl.BaseBusinessRuleFlowColumn;
import com.sas.etl.models.data.businessrule.impl.BaseBusinessRuleFlowTable;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.metadata.businessruleflow.BusinessRuleFlowInterface;
import com.sas.services.information.metadata.businessruleflow.DataSetInterface;
import com.sas.services.information.metadata.businessruleflow.TermInterface;
import com.sas.workspace.Workspace;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class BaseBusinessRuleFlowVersion
implements IBusinessRuleFlowVersion {
    private IBusinessRuleFlow _rule;
    private DISUsageVersion _version;
    private String _xml;
    private String _brCode;
    private Map<String, IBusinessRuleFlowTable> _inputs;
    private Map<String, IBusinessRuleFlowTable> _outputs;
    public boolean m_isLoaded;

    public BaseBusinessRuleFlowVersion(IBusinessRuleFlow rule) {
        this._rule = rule;
        this._inputs = new HashMap<String, IBusinessRuleFlowTable>();
        this._outputs = new HashMap<String, IBusinessRuleFlowTable>();
        this.m_isLoaded = false;
    }

    private boolean isLoaded() {
        return this.m_isLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromOMR() throws RemoteException, ServiceException {
        if (this.isLoaded()) {
            return;
        }
        ChildServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer().newChild(true);
        try {
            IBusinessRuleFlowTable brTable;
            String key = this._rule.getID() + "/" + "Transformation";
            BusinessRuleFlowInterface ruleFlow = (BusinessRuleFlowInterface)server.fetch(key, false);
            String version = this.getVersionAsString();
            String brCode = ruleFlow.getCode(version);
            this.setBRCode(brCode);
            this.clearInputs();
            for (DataSetInterface input : ruleFlow.getInputsForVersion(version)) {
                brTable = this.getBRTable(input, "INPUT");
                this.addInput(brTable);
            }
            this.clearOutputs();
            for (DataSetInterface input : ruleFlow.getOutputsForVersion(version)) {
                brTable = this.getBRTable(input, "OUTPUT");
                this.addOutput(brTable);
            }
            for (DataSetInterface input : ruleFlow.getRulesFiredOutput(version)) {
                brTable = this.getBRTable(input, "RULES_FIRED");
                this.addOutput(brTable);
            }
            this.m_isLoaded = true;
        }
        finally {
            if (server != null) {
                server.destroy();
            }
        }
    }

    @Override
    public boolean isRulesFiredPort(ITransformPort<?> port) {
        if (port == null) {
            return false;
        }
        IBusinessRuleFlowTable table = this.getOutput(port.getPartnerName());
        return table != null && !port.isInputTemplate() && "OUTPUT".equals(table.getID());
    }

    @Override
    public IBusinessRuleFlowTable findOutputTable(String id) {
        for (IBusinessRuleFlowTable output : this.getOutputs()) {
            if (!ObjectComparator.isEqual(output.getID(), id)) continue;
            return output;
        }
        return null;
    }

    @Override
    public DISUsageVersion getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(DISUsageVersion version) {
        this._version = version;
    }

    private String getVersionAsString() {
        return this._version != null ? this._version.toString() : null;
    }

    @Override
    public String getBRCode() {
        return this._brCode;
    }

    @Override
    public void setBRCode(String brCode) {
        this._brCode = brCode;
    }

    @Override
    public String getXML() {
        return this._xml;
    }

    @Override
    public void setXML(String xml) {
        this._xml = xml;
    }

    @Override
    public IBusinessRuleFlowTable[] getInputs() {
        return this._inputs.values().toArray(new IBusinessRuleFlowTable[this._inputs.size()]);
    }

    public void clearInputs() {
        this._inputs.clear();
    }

    @Override
    public void addInput(IBusinessRuleFlowTable table) {
        if (this._inputs.containsKey(table.getID())) {
            return;
        }
        this._inputs.put(table.getID(), table);
    }

    @Override
    public void removeInput(IBusinessRuleFlowTable table) {
        if (!this._inputs.containsKey(table.getID())) {
            return;
        }
        this._inputs.remove(table.getID());
    }

    public void clearOutputs() {
        this._outputs.clear();
    }

    @Override
    public IBusinessRuleFlowTable[] getOutputs() {
        return this._outputs.values().toArray(new IBusinessRuleFlowTable[this._outputs.size()]);
    }

    public IBusinessRuleFlowTable getOutput(String id) {
        return this._outputs.get(id);
    }

    @Override
    public void addOutput(IBusinessRuleFlowTable table) {
        if (this._outputs.containsKey(table.getID())) {
            return;
        }
        this._outputs.put(table.getID(), table);
    }

    @Override
    public void removeOutput(IBusinessRuleFlowTable table) {
        if (!this._outputs.containsKey(table.getID())) {
            return;
        }
        this._outputs.remove(table.getID());
    }

    @Override
    public IBusinessRuleFlow getRule() {
        return this._rule;
    }

    @Override
    public int compareTo(IBusinessRuleFlowVersion o) {
        return this.getVersion().compareTo(o.getVersion());
    }

    public String toString() {
        return this.getVersion().toString();
    }

    public void serialize(Document doc, OutputStream out) throws TransformerConfigurationException, TransformerException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer();
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource xmlSource = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(out);
        serializer.transform(xmlSource, outputTarget);
    }

    private IBusinessRuleFlowTable getBRTable(DataSetInterface ds, String type) {
        BaseBusinessRuleFlowTable brTable = new BaseBusinessRuleFlowTable(this, ds.getId());
        brTable.setName(ds.getName());
        brTable.setType(type);
        brTable.setDescription("");
        for (TermInterface term : ds.getTerms()) {
            BaseBusinessRuleFlowColumn column = new BaseBusinessRuleFlowColumn(brTable, term.getId());
            column.setName(term.getName());
            column.setDescription(term.getDescription());
            column.setDataType(term.getDataType());
            column.setDisplayableDataType(term.getDisplayableDataType());
            brTable.addColumn(column);
        }
        return brTable;
    }
}

