/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.cache.impl.mapcache;

import com.sas.services.cache.CacheEntry;
import com.sas.services.cache.CacheException;
import com.sas.services.cache.CacheStatistics;
import com.sas.services.cache.impl.BaseCache;
import com.sas.services.cache.impl.BaseCacheEntry;
import com.sas.services.cache.impl.BaseCacheStatistics;
import com.sas.services.cache.impl.CacheEntryLastUsedComparator;
import com.sas.services.cache.impl.mapcache.RB;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class MapCache
extends BaseCache {
    public static final String MAXNODES_KEY = "MaxNodes";
    public static final String REDUCTIONLEVEL_KEY = "ReductionLevel";
    public static final String TTL_KEY = "TimeToLiveSeconds";
    public static final String MAXNODES_DEFAULT = "-1";
    public static final String TTL_DEFAULT = "-1";
    private static final int CACHEMAP_INIT = 256;
    private static final int REDUCTION_DEFAULT = 20;
    private static final int MILLISECOND_CONVERSION = 1000;
    protected Map tree;
    protected int max_nodes = -1;
    protected int reduction = 20;
    protected long timeToLive = -1L;
    protected final Comparator comparator = new CacheEntryLastUsedComparator();
    protected BaseCacheStatistics stats = new BaseCacheStatistics();

    public MapCache(Map env) {
        super(env);
        this._logger = LogManager.getLogger((String)this.getClass().getName());
        try {
            this.tree = new ConcurrentHashMap(256);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            throw new RuntimeException(ex);
        }
        this.configure(env);
        if (this.isLogEnabled(Level.DEBUG)) {
            this.logMessage(Level.DEBUG, Message.format((ResourceBundle)RB.getResources(), (String)"MapCache.parms.fmt.txt", (Object)new Integer(this.max_nodes), (Object)new Integer(this.reduction), (Object)new Long(this.timeToLive)));
        }
    }

    public void configure(Map env) {
        block3: {
            try {
                Properties prop = (Properties)env;
                String maxNodesString = prop.getProperty(MAXNODES_KEY, "-1");
                this.max_nodes = Integer.parseInt(maxNodesString);
                String reductionString = prop.getProperty(REDUCTIONLEVEL_KEY);
                this.reduction = reductionString == null ? (this.max_nodes > 0 ? this.max_nodes / 10 : 0) : Integer.parseInt(reductionString);
                String timeString = prop.getProperty(TTL_KEY, "-1");
                this.timeToLive = Long.parseLong(timeString);
                if (this.timeToLive > 0L) {
                    this.timeToLive *= 1000L;
                }
            }
            catch (ClassCastException ex) {
                String maxNodesString = (String)env.get(MAXNODES_KEY);
                this.max_nodes = maxNodesString != null ? Integer.parseInt(maxNodesString) : -1;
                String reductionString = (String)env.get(REDUCTIONLEVEL_KEY);
                this.reduction = reductionString != null ? Integer.parseInt(reductionString) : 20;
                String timeString = (String)env.get(TTL_KEY);
                this.timeToLive = timeString != null ? Long.parseLong(timeString) : -1L;
                if (this.timeToLive <= 0L) break block3;
                this.timeToLive *= 1000L;
            }
        }
        this.parmSanityCheck();
    }

    private void parmSanityCheck() {
        if (this.max_nodes > 0 && this.max_nodes < 10) {
            this.logMessage(Level.WARN, Message.format((ResourceBundle)RB.getResources(), (String)"MapCache.lowmax.fmt.txt", (Object)new Integer(this.max_nodes)));
            this.max_nodes = 10;
        }
        if (this.max_nodes > 0 && this.reduction >= this.max_nodes) {
            this.logMessage(Level.WARN, Message.format((ResourceBundle)RB.getResources(), (String)"MapCache.badreduct.fmt.txt", (Object)new Integer(this.reduction)));
            this.reduction = this.max_nodes / 10;
        }
        if (this.timeToLive > 0L && this.timeToLive < 10000L) {
            this.logMessage(Level.WARN, Message.format((ResourceBundle)RB.getResources(), (String)"MapCache.lowttl.fmt.txt", (Object)new Long(this.timeToLive)));
            this.timeToLive = 10000L;
        }
    }

    @Override
    public void clear() {
        if (this.isLogEnabled(Level.DEBUG)) {
            this.logMessage(Level.DEBUG, RB.getStringResource("MapCache.clear.msg.txt"));
        }
        this.tree.clear();
        if (this._loader != null) {
            try {
                this._loader.clear();
            }
            catch (CacheException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        this.notifyListenersClear();
        this.stats.clearStatistics();
    }

    public Object put(Object key, Object value) {
        BaseCacheEntry ce = new BaseCacheEntry(key, value, this.timeToLive);
        return this.put(ce);
    }

    protected Object put(CacheEntry ce) {
        CacheEntry oldValue = null;
        try {
            this.trimBySize();
            oldValue = this.tree.put(ce.getKey(), ce);
            if (this._loader != null) {
                this._loader.put(ce.getKey(), ce.getValue());
            }
            this.stats.incrementObjectCount();
        }
        catch (Exception rex) {
            throw new RuntimeException(rex);
        }
        this.notifyListenersPut(ce.getKey());
        return oldValue;
    }

    private void trimBySize() {
        if (this.max_nodes > 0 && this.tree.size() >= this.max_nodes) {
            ArrayList list = new ArrayList(this.tree.values());
            Collections.sort(list, this.comparator);
            for (int i = 0; i < this.reduction; ++i) {
                CacheEntry oldce = (CacheEntry)list.get(i);
                this.evictEntry(oldce);
            }
            this.stats.setObjectCount(this.tree.size());
        }
    }

    @Override
    public Object get(Object key) {
        CacheEntry ce = null;
        ce = (CacheEntry)this.tree.get(key);
        if (ce == null) {
            if (this._loader != null) {
                try {
                    Object o = this._loader.get(key);
                    if (o != null) {
                        ce = new BaseCacheEntry(key, o, this.timeToLive);
                        this.trimBySize();
                        this.tree.put(ce.getKey(), ce);
                        return o;
                    }
                }
                catch (CacheException ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            this.stats.incrementMisses();
            return null;
        }
        long expiry = ce.getExpirationTime();
        if (expiry > 0L && System.currentTimeMillis() > expiry) {
            this.evict();
            return null;
        }
        Object value = ce.getValue();
        this.stats.incrementHits();
        return value;
    }

    public Object remove(Object key) {
        CacheEntry ce = null;
        ce = (CacheEntry)this.tree.get(key);
        if (ce == null) {
            return null;
        }
        Object mi = ce.getValue();
        this.tree.remove(key);
        if (this._loader != null) {
            try {
                this._loader.remove(key);
            }
            catch (CacheException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        this.notifyListenersRemove(key);
        return mi;
    }

    @Override
    public boolean containsKey(Object key) {
        Object o = this.tree.get(key);
        return o != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (CacheEntry nextEntry : this.tree.values()) {
            Object nextValue = nextEntry.getValue();
            if (!value.equals(nextValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set entrySet() {
        HashSet result = new HashSet(this.tree.values());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict() {
        if (this.timeToLive > 0L) {
            long now = System.currentTimeMillis();
            CacheEntry ce2 = null;
            try {
                ArrayList list = new ArrayList(this.tree.values());
                Collections.sort(list, this.comparator);
                for (CacheEntry ce2 : list) {
                    long expiry = ce2.getExpirationTime();
                    if (expiry <= -1L) continue;
                    if (now < expiry) {
                        break;
                    }
                    this.evictEntry(ce2);
                }
            }
            finally {
                this.stats.setObjectCount(this.tree.size());
            }
        }
    }

    private void evictEntry(CacheEntry ce) {
        Object key = ce.getKey();
        this.tree.remove(key);
        this.notifyListenersEvict(ce);
    }

    @Override
    public Map getAll(Collection keys) throws CacheException {
        if (keys == null) {
            return null;
        }
        HashMap result = new HashMap(keys.size());
        for (Object o : keys) {
            CacheEntry ce = (CacheEntry)this.tree.get(o);
            result.put(o, ce.getValue());
        }
        return result;
    }

    @Override
    public CacheEntry getCacheEntry(Object key) {
        return (CacheEntry)this.tree.get(key);
    }

    @Override
    public final CacheStatistics getCacheStatistics() {
        return this.stats;
    }

    @Override
    public void load(Object key) throws CacheException {
    }

    @Override
    public void loadAll(Collection keys) throws CacheException {
    }

    @Override
    public Object peek(Object key) {
        CacheEntry ce = null;
        ce = (CacheEntry)this.tree.get(key);
        if (ce == null) {
            return null;
        }
        return ce.getValue();
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public Collection values() {
        ArrayList result = new ArrayList(this.tree.size());
        ArrayList valueList = new ArrayList(this.tree.values());
        for (CacheEntry ce : valueList) {
            Object mi = ce.getValue();
            if (mi == null) continue;
            result.add(mi);
        }
        return result;
    }

    public void putAll(Map t) {
        this.tree.putAll(t);
    }

    public Set keySet() {
        return this.tree.keySet();
    }
}

