/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.cache.impl.firebirdcacheloader;

import com.sas.services.cache.Cache;
import com.sas.services.cache.CacheException;
import com.sas.services.cache.impl.BaseCache;
import com.sas.services.cache.impl.BaseCacheLoaderInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.dgc.VMID;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FirebirdCacheLoader
implements BaseCacheLoaderInterface {
    private static final String FIREBIRD_DRIVER_CLASS = "org.firebirdsql.jdbc.FBDriver";
    private static final int MAX_TABLE_ID_LENGTH = 30;
    private static final int TABLE_LIST_INIT = 16;
    public static final String DB_URL = "firebirdurl";
    public static final String USERID_KEY = "firebirduser";
    public static final String PASSWORD_KEY = "firebirdpass";
    private Logger log = LogManager.getLogger(this.getClass());
    private String path = null;
    private String tableid = null;
    private Object syncToken = new Object();
    private String configStr = null;
    private String userid = null;
    private String password = null;
    private Connection _connection = null;
    private Cache _cache = null;

    public FirebirdCacheLoader(Map env, Cache cache) {
        this._cache = cache;
        this.path = ((BaseCache)this._cache).getNodename();
        this.configure(env);
    }

    public void configure(Map env) {
        try {
            Properties prop = (Properties)env;
            this.userid = prop.getProperty(USERID_KEY);
            this.password = prop.getProperty(PASSWORD_KEY);
            this.configStr = prop.getProperty(DB_URL);
        }
        catch (ClassCastException ex) {
            this.userid = (String)env.get(USERID_KEY);
            this.password = (String)env.get(PASSWORD_KEY);
            this.configStr = (String)env.get(DB_URL);
        }
    }

    @Override
    public synchronized void start() throws CacheException {
        try {
            Class.forName(FIREBIRD_DRIVER_CLASS);
        }
        catch (ClassNotFoundException e) {
            this.log.error("Firebird JCA-JDBC driver not found in class path");
            this.log.error(e.getMessage());
            return;
        }
        this.checkNotOpen();
        if (this._cache == null) {
            throw new IllegalStateException("A non-null Cache property (TreeCache object) is required");
        }
        if (this.configStr == null) {
            throw new IllegalStateException("A non-null Config property (configuration string) is required");
        }
        try {
            this.makeDBConnection();
        }
        catch (SQLException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
    }

    private void checkState() throws CacheException {
        if (this._connection == null) {
            this.start();
        }
    }

    private void checkNotOpen() {
        if (this._connection != null) {
            throw new IllegalStateException("Operation not allowed after calling create()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeDBConnection() throws SQLException {
        this._connection = DriverManager.getConnection(this.configStr, this.userid, this.password);
        this.log.debug("connection established.");
        try {
            DatabaseMetaData dbm = this._connection.getMetaData();
            String[] typeArray = new String[]{"TABLE"};
            try (ResultSet results = dbm.getTables(null, null, "%", typeArray);){
                while (results.next()) {
                    String tableName = results.getString(3);
                    if (!"maptable".equalsIgnoreCase(tableName)) continue;
                    return;
                }
            }
            this.createMapTable();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    @Override
    public synchronized void stop() {
        try (Statement statement = this._connection.createStatement();){
            statement.execute("drop table " + this.tableid);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this._connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._connection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private Object getObjectFromTable(String tableid, String key) throws CacheException {
        this.checkState();
        try {
            Object result = null;
            String selectString = "Select data from " + tableid + " where name='" + key + '\'';
            try (Statement getObjectStatement = this._connection.createStatement();){
                Object object;
                ResultSet results;
                block16: {
                    ObjectInputStream ois;
                    block14: {
                        Object var8_11;
                        block15: {
                            results = getObjectStatement.executeQuery(selectString);
                            ois = null;
                            try {
                                if (results.getFetchSize() != 0) break block14;
                                var8_11 = null;
                                if (ois == null) break block15;
                            }
                            catch (Throwable throwable) {
                                if (ois != null) {
                                    ois.close();
                                }
                                results.close();
                                throw throwable;
                            }
                            ois.close();
                        }
                        results.close();
                        return var8_11;
                    }
                    if (results.next()) {
                        Blob blob = results.getBlob(1);
                        ois = new ObjectInputStream(blob.getBinaryStream());
                        result = ois.readObject();
                        ois.close();
                    }
                    object = result;
                    if (ois == null) break block16;
                    ois.close();
                }
                results.close();
                return object;
            }
        }
        catch (ClassNotFoundException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
        catch (SQLException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object storeObjectToTable(String key, Object o) throws CacheException {
        this.checkState();
        if (this.tableid == null) {
            this.tableid = this.createDataTable(this.path);
        }
        try {
            block11: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(o);
                byte[] blobArray = baos.toByteArray();
                oos.reset();
                ByteArrayInputStream bis = new ByteArrayInputStream(blobArray);
                String insertString = "Insert into " + this.tableid + " (name, data) Values (?, ?)";
                try (PreparedStatement insertObjectStatement = this._connection.prepareStatement(insertString);){
                    insertObjectStatement.setString(1, key);
                    insertObjectStatement.setBinaryStream(2, (InputStream)bis, blobArray.length);
                    int results = insertObjectStatement.executeUpdate();
                    if (results != 0) break block11;
                    this.log.warn("No results were inserted into the cache database for " + this.path);
                    String updateString = "Update " + this.tableid + " SET data = ? where name='" + key + '\'';
                    try (PreparedStatement updateObjectStatement = this._connection.prepareStatement(updateString);){
                        bis = new ByteArrayInputStream(blobArray);
                        updateObjectStatement.setBinaryStream(1, (InputStream)bis, blobArray.length);
                        results = updateObjectStatement.executeUpdate();
                        if (results == 0) {
                            this.log.warn("No results were updated in the cache database for " + this.path);
                        }
                    }
                }
            }
            return null;
        }
        catch (SQLException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getTables() throws Exception {
        ArrayList<String> tables = new ArrayList<String>(16);
        try (Statement statement = this._connection.createStatement();){
            ArrayList<String> arrayList;
            statement.execute("SELECT path from maptable");
            ResultSet results = statement.getResultSet();
            try {
                while (results.next()) {
                    String table = results.getString(1);
                    tables.add(table);
                }
                results.close();
                statement.close();
                arrayList = tables;
            }
            catch (Throwable throwable) {
                results.close();
                throw throwable;
            }
            results.close();
            return arrayList;
        }
    }

    private String getUniqueId() {
        String uniqueId = new VMID().toString();
        return uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMapTable() throws Exception {
        Object object = this.syncToken;
        synchronized (object) {
            try (Statement statement = this._connection.createStatement();){
                statement.execute("Create table maptable ( uniqueid VARCHAR(255) not null,path VARCHAR(1024) not null)");
            }
        }
    }

    private String createDataTable(String path) throws CacheException {
        this.tableid = this.getUniqueId();
        this.tableid = this.tableid.replace(':', '_');
        this.tableid = this.tableid.replace('-', '_');
        this.tableid = this.tableid.replaceAll("_", "");
        if (this.tableid.length() > 30) {
            int length = this.tableid.length();
            this.tableid = this.tableid.substring(length - 30);
        }
        if (this.tableid.charAt(0) < 'A') {
            this.tableid = 'D' + this.tableid.substring(1);
        }
        String insertString = "insert into maptable (uniqueid, path) values (?,?)";
        try {
            try (PreparedStatement statement = this._connection.prepareStatement(insertString);){
                statement.setString(1, this.tableid);
                statement.setString(2, path);
                statement.execute();
                statement.execute("Create table " + this.tableid + " (name VARCHAR(1024) not null,data BLOB" + ')');
            }
            return this.tableid;
        }
        catch (SQLException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) throws CacheException {
        Object object = this.syncToken;
        synchronized (object) {
            return this.getObjectFromTable(this.tableid, key.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) throws CacheException {
        Object object = this.syncToken;
        synchronized (object) {
            return this.storeObjectToTable(key.toString(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) throws CacheException {
        this.checkState();
        try {
            Object object = this.syncToken;
            synchronized (object) {
                if (this.tableid == null) {
                    return null;
                }
                Object o = this.getObjectFromTable(this.tableid, key.toString());
                if (o == null) {
                    return null;
                }
                String deleteString = "Delete from " + this.tableid + " where name='" + key + '\'';
                try (Statement statement = this._connection.createStatement();){
                    statement.execute(deleteString);
                }
                return o;
            }
        }
        catch (SQLException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws CacheException {
        this.checkState();
        String deleteString = "Delete from " + this.tableid;
        try {
            Object object = this.syncToken;
            synchronized (object) {
                try (Statement statement = this._connection.createStatement();){
                    statement.execute(deleteString);
                }
                this.stop();
            }
        }
        catch (SQLException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
    }

    @Override
    public Object load(Object key) throws CacheException {
        this._cache.put(key, null);
        return null;
    }

    @Override
    public Map loadAll(Collection keys) throws CacheException {
        return null;
    }
}

