/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.cache.impl.filecacheloader;

import com.sas.services.cache.Cache;
import com.sas.services.cache.CacheException;
import com.sas.services.cache.impl.BaseCache;
import com.sas.services.cache.impl.BaseCacheLoaderInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class FileCacheLoader
implements BaseCacheLoaderInterface {
    private static final String PATH_KEY = "basepath";
    private String path = null;
    private File _file = null;
    private Cache _cache = null;

    public FileCacheLoader(Map env, Cache cache) {
        this._cache = cache;
        this.configure(env);
    }

    public void configure(Map env) {
        try {
            Properties prop = (Properties)env;
            this.path = prop.getProperty(PATH_KEY);
        }
        catch (ClassCastException ex) {
            this.path = (String)env.get(PATH_KEY);
        }
    }

    @Override
    public void start() throws CacheException {
        File pathFile = new File(this.path);
        if (!pathFile.exists()) {
            throw new CacheException("Hey! The path doesn't exist.");
        }
        String myDirName = pathFile.getAbsolutePath() + File.separator + ((BaseCache)this._cache).getNodename();
        this._file = new File(myDirName);
        this._file.mkdir();
    }

    @Override
    public void stop() throws CacheException {
    }

    @Override
    public Object put(Object key, Object value) throws CacheException {
        String fileName = this._file.getAbsolutePath() + File.separator + key.toString();
        File newFile = new File(fileName);
        try {
            if (!newFile.exists()) {
                newFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(newFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(value);
            fos.flush();
            fos.close();
        }
        catch (IOException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
        return null;
    }

    @Override
    public Object get(Object key) throws CacheException {
        String fileName = this._file.getAbsolutePath() + File.separator + key.toString();
        File newFile = new File(fileName);
        try {
            if (!newFile.exists()) {
                return null;
            }
            FileInputStream fos = new FileInputStream(newFile);
            ObjectInputStream oos = new ObjectInputStream(fos);
            Object value = oos.readObject();
            fos.close();
            return value;
        }
        catch (ClassNotFoundException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
    }

    @Override
    public Object remove(Object key) throws CacheException {
        String fileName = this._file.getAbsolutePath() + File.separator + key.toString();
        File newFile = new File(fileName);
        try {
            if (!newFile.exists()) {
                return null;
            }
            FileInputStream fos = new FileInputStream(newFile);
            ObjectInputStream oos = new ObjectInputStream(fos);
            Object value = oos.readObject();
            fos.close();
            newFile.delete();
            return value;
        }
        catch (ClassNotFoundException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new CacheException(ex.getMessage(), ex);
        }
    }

    @Override
    public void clear() throws CacheException {
        File[] files = this._file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File nextFile = files[i];
            nextFile.delete();
        }
    }

    @Override
    public Object load(Object key) throws CacheException {
        return null;
    }

    @Override
    public Map loadAll(Collection keys) throws CacheException {
        return null;
    }
}

