/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.cache.impl;

import com.sas.services.cache.CacheEntry;
import java.io.Serializable;

public class BaseCacheEntry
implements CacheEntry,
Serializable {
    private static final long serialVersionUID = 376077317648893350L;
    public static final long UPDATE_TIME_NOW = -1L;
    private long _createTime;
    private long _expireTime = -1L;
    private int _hits;
    private long _lastAccess;
    private long _lastUpdate;
    private Object _key;
    private Object _value;

    public BaseCacheEntry(Object key, Object value, long ttl) {
        this._key = key;
        this._value = value;
        this._createTime = System.currentTimeMillis();
        if (ttl > 0L) {
            this._expireTime = this._createTime + ttl;
        }
        this._lastAccess = System.currentTimeMillis();
        this._lastUpdate = System.currentTimeMillis();
        this._hits = 1;
    }

    @Override
    public long getCost() {
        return 0L;
    }

    @Override
    public final long getCreationTime() {
        return this._createTime;
    }

    @Override
    public final long getExpirationTime() {
        return this._expireTime;
    }

    public final void updateExpirationTime(long expirationTime) {
        if (expirationTime == -1L) {
            expirationTime = System.currentTimeMillis();
        }
        this._expireTime = expirationTime;
    }

    @Override
    public final int getHits() {
        return this._hits;
    }

    @Override
    public final long getLastAccessTime() {
        return this._lastAccess;
    }

    public final void updateLastAccessTime(long lastAccess) {
        if (lastAccess == -1L) {
            lastAccess = System.currentTimeMillis();
        }
        this._lastAccess = lastAccess;
    }

    @Override
    public final long getLastUpdateTime() {
        return this._lastUpdate;
    }

    @Override
    public long getVersion() {
        return 0L;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public final Object getKey() {
        return this._key;
    }

    public Object getValue() {
        this._lastAccess = System.currentTimeMillis();
        return this._value;
    }

    public Object setValue(Object value) {
        this._lastUpdate = System.currentTimeMillis();
        Object oldValue = this._value;
        this._value = value;
        return oldValue;
    }
}

