/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.cache.impl;

import com.sas.services.cache.Cache;
import com.sas.services.cache.CacheException;
import com.sas.services.cache.CacheFactory;
import com.sas.services.cache.CacheListener;
import com.sas.services.cache.impl.BaseCacheLoaderInterface;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public abstract class BaseCache
implements Cache {
    public static final String NODENAME_KEY = "NodeName";
    private static final String COLON_SPACER = " : ";
    protected String _nodeName;
    protected Logger _logger = null;
    protected BaseCacheLoaderInterface _loader = null;
    protected List _listenerList = new CopyOnWriteArrayList();

    public BaseCache(Map env) {
        this._nodeName = (String)env.get(NODENAME_KEY);
        String loaderclass = (String)env.get("CacheLoaderClass");
        if (loaderclass != null) {
            try {
                ClassLoader cl = null;
                Object o = env.get("ClassLoader");
                if (o != null && o instanceof ClassLoader) {
                    cl = (ClassLoader)o;
                }
                if (cl == null) {
                    cl = CacheFactory.class.getClassLoader();
                }
                Class<?> loaderClass = null;
                loaderClass = cl.loadClass(loaderclass);
                Class[] ctorArgs = new Class[]{Map.class, Cache.class};
                Object[] ctorParms = new Object[]{env, this};
                Constructor<?> ctor = null;
                ctor = loaderClass.getConstructor(ctorArgs);
                this._loader = (BaseCacheLoaderInterface)ctor.newInstance(ctorParms);
                this._loader.start();
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe.getMessage(), cnfe);
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException(nsme.getMessage(), nsme);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae.getMessage(), iae);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getCause();
                t.printStackTrace(System.err);
                throw new RuntimeException(t.getMessage(), t);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(ie.getMessage(), ie);
            }
            catch (CacheException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    public final String getNodename() {
        return this._nodeName;
    }

    @Override
    public void addListener(CacheListener listener) {
        this._listenerList.add(listener);
    }

    @Override
    public void removeListener(CacheListener listener) {
        this._listenerList.remove(listener);
    }

    protected void notifyListenersClear() {
        Iterator it = this._listenerList.iterator();
        CacheListener listener = null;
        while (it.hasNext()) {
            listener = (CacheListener)it.next();
            listener.onClear();
        }
    }

    protected void notifyListenersEvict(Object key) {
        Iterator it = this._listenerList.iterator();
        CacheListener listener = null;
        while (it.hasNext()) {
            listener = (CacheListener)it.next();
            listener.onEvict(key);
        }
    }

    protected void notifyListenersLoad(Object key) {
        Iterator it = this._listenerList.iterator();
        CacheListener listener = null;
        while (it.hasNext()) {
            listener = (CacheListener)it.next();
            listener.onLoad(key);
        }
    }

    protected void notifyListenersPut(Object key) {
        Iterator it = this._listenerList.iterator();
        CacheListener listener = null;
        while (it.hasNext()) {
            listener = (CacheListener)it.next();
            listener.onPut(key);
        }
    }

    protected void notifyListenersRemove(Object key) {
        Iterator it = this._listenerList.iterator();
        CacheListener listener = null;
        while (it.hasNext()) {
            listener = (CacheListener)it.next();
            listener.onRemove(key);
        }
    }

    protected void logMessage(Level level, String message) {
        if (this._logger != null && this._logger.isEnabled(level)) {
            this._logger.log(level, this._nodeName + COLON_SPACER + message);
        }
    }

    protected boolean isLogEnabled(Level level) {
        boolean result = false;
        result = this._logger != null && this._logger.isEnabled(level);
        return result;
    }
}

