/*
 * Decompiled with CFR 0.152.
 */
package com.sas.nls.collator;

import com.ibm.icu.text.CollationElementIterator;
import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RawCollationKey;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UCharacterIterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import com.sas.nls.collator.SASCollator;
import java.text.CharacterIterator;
import java.util.Locale;

class SASRuleCollator
implements SASCollator {
    private final RuleBasedCollator collator;

    SASRuleCollator() {
        this.collator = (RuleBasedCollator)Collator.getInstance();
    }

    SASRuleCollator(Locale locale) {
        this.collator = (RuleBasedCollator)Collator.getInstance((Locale)locale);
    }

    SASRuleCollator(String rules) throws Exception {
        this.collator = new RuleBasedCollator(rules);
    }

    SASRuleCollator(Locale locale, String rules) throws Exception {
        RuleBasedCollator temp = (RuleBasedCollator)Collator.getInstance((Locale)locale);
        this.collator = new RuleBasedCollator(temp.getRules() + rules);
    }

    @Override
    public void setStrength(int newStrength) {
        this.collator.setStrength(newStrength);
    }

    @Override
    public void setStrengthDefault() {
        this.collator.setStrengthDefault();
    }

    @Override
    public void setDecomposition(int decomposition) {
        this.collator.setDecomposition(decomposition);
    }

    @Override
    public int getStrength() {
        return this.collator.getStrength();
    }

    @Override
    public String getStrengthAsText() {
        String result = "Unknown";
        switch (this.getStrength()) {
            case 0: {
                result = "PRIMARY";
                break;
            }
            case 1: {
                result = "SECONDARY";
                break;
            }
            case 2: {
                result = "TERTIARY";
                break;
            }
            case 3: {
                result = "QUATERNARY";
                break;
            }
            case 15: {
                result = "IDENTICAL";
            }
        }
        return result;
    }

    @Override
    public int getDecomposition() {
        return this.collator.getDecomposition();
    }

    @Override
    public int compare(Object source, Object target) {
        return this.collator.compare(source, target);
    }

    @Override
    public boolean equals(String source, String target) {
        return this.collator.compare(source, target) == 0;
    }

    @Override
    public UnicodeSet getTailoredSet() {
        return this.collator.getTailoredSet();
    }

    @Override
    public int compare(String source, String target) {
        return this.collator.compare(source, target);
    }

    @Override
    public CollationKey getCollationKey(String source) {
        return this.collator.getCollationKey(source);
    }

    @Override
    public RawCollationKey getRawCollationKey(String source, RawCollationKey key) {
        return this.collator.getRawCollationKey(source, key);
    }

    @Override
    public VersionInfo getUCAVersion() {
        return this.collator.getUCAVersion();
    }

    @Override
    public int getVariableTop() {
        return this.collator.getVariableTop();
    }

    @Override
    public VersionInfo getVersion() {
        return this.collator.getVersion();
    }

    @Override
    public int setVariableTop(String varTop) {
        return this.collator.setVariableTop(varTop);
    }

    @Override
    public void setVariableTop(int varTop) {
        this.collator.setVariableTop(varTop);
    }

    @Override
    public CollationElementIterator getCollationElementIterator(String source) {
        return this.collator.getCollationElementIterator(source);
    }

    @Override
    public CollationElementIterator getCollationElementIterator(CharacterIterator source) {
        return this.collator.getCollationElementIterator(source);
    }

    @Override
    public CollationElementIterator getCollationElementIterator(UCharacterIterator source) {
        return this.collator.getCollationElementIterator(source);
    }

    @Override
    public void setHiraganaQuaternary(boolean flag) {
        this.collator.setHiraganaQuaternary(flag);
    }

    @Override
    public void setHiraganaQuaternaryDefault() {
        this.collator.setHiraganaQuaternaryDefault();
    }

    @Override
    public void setUpperCaseFirst(boolean upperfirst) {
        this.collator.setUpperCaseFirst(upperfirst);
    }

    @Override
    public void setLowerCaseFirst(boolean lowerfirst) {
        this.collator.setLowerCaseFirst(lowerfirst);
    }

    @Override
    public final void setCaseFirstDefault() {
        this.collator.setCaseFirstDefault();
    }

    @Override
    public void setAlternateHandlingDefault() {
        this.collator.setAlternateHandlingDefault();
    }

    @Override
    public void setCaseLevelDefault() {
        this.collator.setCaseLevelDefault();
    }

    @Override
    public void setDecompositionDefault() {
        this.collator.setDecompositionDefault();
    }

    @Override
    public void setFrenchCollationDefault() {
        this.collator.setFrenchCollationDefault();
    }

    @Override
    public void setNumericCollationDefault() {
        this.collator.setNumericCollationDefault();
    }

    @Override
    public void setFrenchCollation(boolean flag) {
        this.collator.setFrenchCollation(flag);
    }

    @Override
    public void setAlternateHandlingShifted(boolean shifted) {
        this.collator.setAlternateHandlingShifted(shifted);
    }

    @Override
    public void setCaseLevel(boolean flag) {
        this.collator.setCaseLevel(flag);
    }

    @Override
    public void setNumericCollation(boolean flag) {
        this.collator.setNumericCollation(flag);
    }

    @Override
    public String getRules() {
        return this.collator.getRules();
    }

    @Override
    public String getRules(boolean fullrules) {
        return this.collator.getRules(fullrules);
    }

    @Override
    public ULocale getLocale(ULocale.Type type) {
        return this.collator.getLocale(type);
    }

    @Override
    public void getContractionsAndExpansions(UnicodeSet contractions, UnicodeSet expansions, boolean addPrefixes) throws Exception {
        this.collator.getContractionsAndExpansions(contractions, expansions, addPrefixes);
    }

    @Override
    public boolean isUpperCaseFirst() {
        return this.collator.isUpperCaseFirst();
    }

    @Override
    public boolean isLowerCaseFirst() {
        return this.collator.isLowerCaseFirst();
    }

    @Override
    public boolean isAlternateHandlingShifted() {
        return this.collator.isAlternateHandlingShifted();
    }

    @Override
    public boolean isCaseLevel() {
        return this.collator.isCaseLevel();
    }

    @Override
    public boolean isFrenchCollation() {
        return this.collator.isFrenchCollation();
    }

    @Override
    public boolean isHiraganaQuaternary() {
        return this.collator.isHiraganaQuaternary();
    }

    @Override
    public boolean getNumericCollation() {
        return this.collator.getNumericCollation();
    }

    @Override
    public boolean equals(Object obj) {
        return this.collator.equals(obj);
    }

    public int hashCode() {
        return this.collator.hashCode();
    }
}

