/*
 * Decompiled with CFR 0.152.
 */
package com.sas.nls.collator;

import com.sas.nls.collator.CaseInsensitiveComparator;
import com.sas.nls.collator.CaseSensitiveComparator;
import com.sas.nls.collator.JapaneseComparator;
import com.sas.nls.collator.JapaneseComparatorNullHi;
import com.sas.nls.collator.JapaneseComparatorNullLo;
import com.sas.nls.collator.SASCollator;
import com.sas.nls.collator.SASRuleCollator;
import com.sas.nls.collator.SASRuleCollatorNullHi;
import com.sas.nls.collator.SASRuleCollatorNullLo;
import com.sas.nls.collator.SASStringComparator;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;

public class SASCollatorFactory {
    public static final int ICU = 0;
    public static final int BEST = 1;
    public static final int NullAsLowest = 4096;
    public static final int NullAsHighest = 8192;
    private static final int COLTYPE_MASK = 1;

    private SASCollatorFactory() {
    }

    public static SASStringComparator createComparator() {
        return new CaseSensitiveComparator();
    }

    public static SASStringComparator createComparatorIgnoreCase() {
        return new CaseInsensitiveComparator();
    }

    public static SASStringComparator createCollator() {
        return SASCollatorFactory.createCollator(1);
    }

    public static SASStringComparator createCollator(Locale locale) {
        return SASCollatorFactory.createCollator(locale, 1);
    }

    public static SASStringComparator createCollator(int type) {
        if ((type & 1) == 1) {
            if (SASCollatorFactory.isJapanese(Locale.getDefault())) {
                try {
                    if ((type & 0x1000) != 0) {
                        return new JapaneseComparatorNullLo();
                    }
                    if ((type & 0x2000) != 0) {
                        return new JapaneseComparatorNullHi();
                    }
                    return new JapaneseComparator();
                }
                catch (UnsupportedCharsetException ex) {
                    System.err.println("ms932 Charset not supported.");
                }
            }
        } else if ((type & 1) != 0) {
            throw new IllegalArgumentException("'Type' not ICU or BEST");
        }
        if ((type & 0x1000) != 0) {
            return new SASRuleCollatorNullLo();
        }
        if ((type & 0x2000) != 0) {
            return new SASRuleCollatorNullHi();
        }
        return new SASRuleCollator();
    }

    public static SASStringComparator createCollator(Locale locale, int type) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale is null");
        }
        Locale loc = locale;
        if (loc.getLanguage().equals("no")) {
            loc = new Locale("nn", loc.getCountry(), loc.getVariant());
        }
        if ((type & 1) == 1) {
            if (SASCollatorFactory.isJapanese(loc)) {
                try {
                    if ((type & 0x1000) != 0) {
                        return new JapaneseComparatorNullLo();
                    }
                    if ((type & 0x2000) != 0) {
                        return new JapaneseComparatorNullHi();
                    }
                    return new JapaneseComparator();
                }
                catch (UnsupportedCharsetException ex) {
                    System.err.println("ms932 Charset not supported.");
                }
            }
        } else if ((type & 1) != 0) {
            throw new IllegalArgumentException("'Type' not ICU or BEST");
        }
        if ((type & 0x1000) != 0) {
            return new SASRuleCollatorNullLo(loc);
        }
        if ((type & 0x2000) != 0) {
            return new SASRuleCollatorNullHi(loc);
        }
        return new SASRuleCollator(loc);
    }

    public static SASCollator createCollator(String rules) throws Exception {
        if (rules == null) {
            throw new IllegalArgumentException();
        }
        return new SASRuleCollator(rules);
    }

    public static SASCollator createCollatorAppendRules(String rules, Locale locale) throws Exception {
        if (locale == null || rules == null) {
            throw new IllegalArgumentException();
        }
        Locale loc = locale;
        if (loc.getLanguage().equals("no")) {
            loc = new Locale("nn", loc.getCountry(), loc.getVariant());
        }
        return new SASRuleCollator(loc, rules);
    }

    public static SASCollator createCollatorAppendRules(String rules) throws Exception {
        if (rules == null) {
            throw new IllegalArgumentException();
        }
        return new SASRuleCollator(Locale.getDefault(), rules);
    }

    private static boolean isJapanese(Locale locale) {
        String lang = locale.getLanguage();
        if (lang.length() > 2) {
            lang = lang.substring(0, 2);
        }
        return lang.equalsIgnoreCase("ja");
    }
}

