/*
 * Decompiled with CFR 0.152.
 */
package com.sas.nls.collator;

import com.ibm.icu.text.CollationKey;
import com.sas.nls.collator.SASStringComparator;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;

class JapaneseComparator
implements SASStringComparator {
    static final String CHARSET = "ms932";
    private static final Charset cs = Charset.forName("ms932");
    private final CharsetEncoder ce;

    JapaneseComparator() {
        if (cs == null) {
            throw new UnsupportedCharsetException(CHARSET);
        }
        this.ce = cs.newEncoder();
        this.ce.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    @Override
    public int compare(Object source, Object target) {
        if (source == null) {
            if (target == null) {
                return 0;
            }
            if (!(target instanceof String)) {
                throw new IllegalArgumentException();
            }
            return -1;
        }
        if (target == null) {
            if (!(source instanceof String)) {
                throw new IllegalArgumentException();
            }
            return 1;
        }
        if (!(source instanceof String) || !(target instanceof String)) {
            throw new IllegalArgumentException();
        }
        return this.compareImpl((String)source, (String)target);
    }

    @Override
    public int compare(String source, String target) {
        if (source == null) {
            if (target == null) {
                return 0;
            }
            return -1;
        }
        if (target == null) {
            return 1;
        }
        return this.compareImpl(source, target);
    }

    @Override
    public boolean equals(String source, String target) {
        if (source == null) {
            return target == null;
        }
        if (target == null) {
            return false;
        }
        return Arrays.equals(this.convert(source), this.convert(target));
    }

    private int compareImpl(String source, String target) {
        int length;
        byte[] arg0 = this.convert(source);
        byte[] arg1 = this.convert(target);
        if (arg1.length < (length = arg0.length)) {
            length = arg1.length;
        }
        for (int i = 0; i < length; ++i) {
            int value1;
            if (arg0[i] == arg1[i]) continue;
            int value0 = arg0[i];
            if (value0 < 0) {
                value0 = 255 + value0 + 1;
            }
            if ((value1 = arg1[i]) < 0) {
                value1 = 255 + value1 + 1;
            }
            if (value0 < value1) {
                return -1;
            }
            return 1;
        }
        if (arg0.length < arg1.length) {
            return -1;
        }
        if (arg0.length > arg1.length) {
            return 1;
        }
        return 0;
    }

    private byte[] convert(String source) {
        if (source == null || source.length() == 0) {
            byte[] result = new byte[]{0};
            return result;
        }
        try {
            ByteBuffer bb = this.ce.encode(CharBuffer.wrap(source));
            this.ce.flush(bb);
            return bb.array();
        }
        catch (Exception exception) {
            return source.getBytes();
        }
    }

    @Override
    public CollationKey getCollationKey(String source) {
        return new CollationKey(source, this.convert(source));
    }
}

