/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt.tools;

import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.logical.batch.BatchDriverOptions;
import com.sas.metadata.mgmt.Backup;
import com.sas.metadata.mgmt.BackupHistory;
import com.sas.metadata.mgmt.BackupRecovery;
import com.sas.metadata.mgmt.MetadataManager;
import com.sas.metadata.mgmt.MetadataManagerFactory;
import com.sas.metadata.mgmt.MetadataOperation;
import com.sas.metadata.mgmt.tools.RB;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;

public class BackupUtility
extends BatchDriver2 {
    public static final String OPTION_LIST = "list";
    public static final String OPTION_BACKUP = "backup";
    public static final String OPTION_RECOVER = "recover";
    public static final String OPTION_RECOVER_ALTERNATE = "recoverAlternate";
    public static final String OPTION_STATE = "state";
    public static final String OPTION_COMMENT = "comment";
    private boolean _list = false;
    private boolean _backup = false;
    private boolean _recover = false;
    private boolean _recoverAlternate = false;
    private String _recoveryName = null;
    private String _recoveryPath = null;
    private boolean _state = false;
    private String _stateName = null;
    private boolean _comment = false;
    private String _commentText = null;

    public BackupUtility() {
        this._logFilePrefix = "BackupUtility";
        this._logContextName = "com.sas.metadata.admin";
        this._logTimestamps = true;
        this._logFileDisabled = true;
    }

    public BackupUtility(String host, String port, String user, String password) {
        this();
        this.setConnection(host, port);
        this.setCredential(user, password);
    }

    public BackupUtility(SessionContextInterface session) throws ServiceException, RemoteException {
        this();
        this.setConnection(session);
    }

    public int execute() throws Exception {
        MetadataManager manager = null;
        try {
            this.setInitializeLogicalTypes(false);
            this.initialize();
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.Start.fmt.log", (Object)new Date()));
            this.logConnectionInfo();
            manager = MetadataManagerFactory.getMetadataManager(this._session);
            MetadataManager.ServerState currentState = manager.getServerState();
            if (currentState != MetadataManager.ServerState.ONLINE) {
                String pauseComment = manager.getServerStateMessage();
                if (pauseComment != null && pauseComment.length() > 0) {
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.StateAndComment.fmt.log", (Object)currentState.name(), (Object)pauseComment));
                } else {
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.State.fmt.log", (Object)currentState.name()));
                }
            }
            this._rc = this._list ? this.listBackups(manager) : (this._recover || this._recoverAlternate ? this.recoverBackup(manager) : (this._state ? this.setState(manager) : this.backup(manager)));
        }
        catch (Exception e) {
            this._rc |= 8;
            throw e;
        }
        finally {
            if (manager != null) {
                manager.dispose();
            }
            this.terminate();
        }
        return this._rc;
    }

    private int backup(MetadataManager manager) throws Exception {
        try {
            Backup backup = manager.newBackup();
            MetadataOperation.Status status = backup.execute();
            this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.BackupDone.fmt.log", (Object)backup.getName(), (Object)status.description()));
            if (backup.getStatus() == MetadataOperation.Status.SUCCESSFUL) {
                this._rc = 0;
            } else {
                this._rc = 8;
                String errors = backup.getErrorLog();
                if (errors != null) {
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.OperationErrors.fmt.log", (Object)errors));
                }
            }
        }
        catch (ServiceException e) {
            this._rc |= 8;
            this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.ServiceException.backup.fmt.log", (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            this._rc |= 8;
            throw e;
        }
        return this._rc;
    }

    private int listBackups(MetadataManager manager) throws Exception {
        try {
            BackupHistory backupHistory = manager.getBackupHistory();
            List<Backup> backups = backupHistory.getBackups();
            if (backups == null || backups.size() == 0) {
                this._logger.info(RB.getStringResource("BackupUtility.NoBackupsFound.log"));
            } else {
                for (Backup backup : backups) {
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.BackupInfo.fmt.log", (Object)backup.getName(), (Object)backup.getStartDateTime(), (Object)backup.getStatus().description()));
                }
            }
            this._rc = 0;
        }
        catch (Exception e) {
            this._rc |= 8;
            throw e;
        }
        return this._rc;
    }

    private int recoverBackup(MetadataManager manager) throws Exception {
        try {
            BackupHistory backupHistory = manager.getBackupHistory();
            List<Backup> backups = backupHistory.getBackups();
            Backup backup = null;
            if (this._recover) {
                for (Backup aBackup : backups) {
                    if (!this._recoveryName.equals(aBackup.getName())) continue;
                    backup = aBackup;
                    break;
                }
            } else {
                backup = manager.newBackup();
                backup.setPath(this._recoveryPath);
                if (!backup.isValid()) {
                    String backupMessage = backup.getErrorLog();
                    String backupFullMessage = backup.getFullReport();
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.InvalidBackup.fmt.log", (Object)this._recoveryPath, (Object)backupMessage));
                    if (backupFullMessage != null && backupFullMessage.length() > 0) {
                        this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.InvalidBackupFull.fmt.log", (Object)backupFullMessage));
                    }
                    backup = null;
                }
            }
            if (backup != null) {
                MetadataOperation.Status status;
                BackupRecovery recovery = backup.getRecovery();
                if (this._recoverAlternate) {
                    recovery.setVerify(false);
                }
                if ((status = recovery.execute()) == MetadataOperation.Status.SUCCESSFUL) {
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.BackupRecovered.fmt.log", (Object)this._recoveryName));
                    this._rc = 0;
                } else {
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.BackupRecoveryFailed.fmt.log", (Object)this._recoveryName));
                    String errors = recovery.getErrorLog();
                    if (errors != null) {
                        this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.OperationErrors.fmt.log", (Object)errors));
                    }
                }
            } else {
                if (this._recoveryName != null) {
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.BackupNotFound.fmt.log", (Object)this._recoveryName));
                }
                this._rc = 8;
            }
        }
        catch (ServiceException e) {
            this._rc |= 8;
            this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.ServiceException.recovery.fmt.log", (Object)this._recoveryName, (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            this._rc |= 8;
            throw e;
        }
        return this._rc;
    }

    private int setState(MetadataManager manager) throws Exception {
        MetadataManager.ServerState[] allStates = MetadataManager.ServerState.values();
        try {
            MetadataManager.ServerState currentState = manager.getServerState();
            MetadataManager.ServerState newState = null;
            for (MetadataManager.ServerState aState : allStates) {
                if (!this._stateName.equalsIgnoreCase(aState.name())) continue;
                newState = aState;
                break;
            }
            if (newState != null) {
                if (this._comment) {
                    manager.setServerStateMessage(this._commentText);
                }
                manager.setServerState(newState);
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.StateDone.fmt.log", (Object)currentState.name(), (Object)newState.name()));
                String pauseComment = manager.getServerStateMessage();
                if (pauseComment != null && pauseComment.length() > 0) {
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.PauseComment.fmt.log", (Object)pauseComment));
                }
            } else {
                this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.StateNotFound.fmt.log", (Object)this._stateName));
                StringBuffer stateNames = new StringBuffer();
                for (MetadataManager.ServerState aState : allStates) {
                    if (stateNames.length() > 0) {
                        stateNames.append(',');
                    }
                    stateNames.append(aState.name());
                }
                this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.ValidStateNames.fmt.log", (Object)stateNames.toString()));
                this._rc = 8;
            }
        }
        catch (ServiceException e) {
            this._rc |= 8;
            this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.ServiceException.state.fmt.log", (Object)this._stateName, (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            this._rc |= 8;
            throw e;
        }
        return this._rc;
    }

    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new Options();
        super.parse(args);
        if (this._help) {
            return;
        }
        this._list = this._commandLine.hasOption(OPTION_LIST);
        this._backup = this._commandLine.hasOption(OPTION_BACKUP);
        this._recover = this._commandLine.hasOption(OPTION_RECOVER);
        if (this._recover) {
            this._recoveryName = this._commandLine.getOptionValue(OPTION_RECOVER);
        }
        this._recoverAlternate = this._commandLine.hasOption(OPTION_RECOVER_ALTERNATE);
        if (this._recoverAlternate) {
            this._recoveryPath = this._commandLine.getOptionValue(OPTION_RECOVER_ALTERNATE);
        }
        this._state = this._commandLine.hasOption(OPTION_STATE);
        if (this._state) {
            this._stateName = this._commandLine.getOptionValue(OPTION_STATE);
        }
        this._comment = this._commandLine.hasOption(OPTION_COMMENT);
        if (this._comment) {
            this._commentText = this._commandLine.getOptionValue(OPTION_COMMENT);
        }
        if (this._list && this._recover) {
            throw new ParseException(RB.getStringResource("BackupUtility.ConflictingListRecover.log"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BackupUtility backupUtility = new BackupUtility();
        int rc = 0;
        try {
            backupUtility.parse(args);
            if (backupUtility._help) {
                HelpFormatter help = new HelpFormatter();
                org.apache.commons.cli.Options helpOptions = BackupUtility.getHelpOptions((org.apache.commons.cli.Options)backupUtility._options, null);
                help.printHelp(80, BackupUtility.getUsage(help), RB.getStringResource("BackupUtility.Options.txt"), helpOptions, null);
                return;
            }
            rc = backupUtility.execute();
            System.out.println(RB.getStringResource("BackupUtility.Complete.txt"));
        }
        catch (ParseException e) {
            System.err.println(RB.getStringResource("BackupUtility.InvalidOptions.log"));
            System.err.println(e.getLocalizedMessage());
            rc = 8;
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.Failed.fmt.txt", (Object)e.getLocalizedMessage());
            System.err.println(msg);
            rc = 8;
        }
        finally {
            if (backupUtility != null) {
                rc |= backupUtility.getReturnCode();
                String logFileName = backupUtility.getLogFileName();
                if (logFileName != null) {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.ViewLog.fmt.txt", (Object)logFileName));
                }
            }
        }
        System.exit(rc);
    }

    private static String getUsage(HelpFormatter help) {
        StringBuffer usage = new StringBuffer();
        usage.append(RB.getStringResource("BackupUtility.HelpUsage.txt"));
        return usage.toString();
    }

    protected class Options
    extends BatchDriverOptions {
        public Options() {
            Option option = new Option(BackupUtility.OPTION_LIST, RB.getStringResource("BackupUtility.List.Desc.txt"));
            this.addOption(option);
            option = new Option(BackupUtility.OPTION_BACKUP, RB.getStringResource("BackupUtility.Backup.Desc.txt"));
            this.addOption(option);
            option = new Option(BackupUtility.OPTION_RECOVER, true, RB.getStringResource("BackupUtility.Recover.Desc.txt"));
            option.setArgName(RB.getStringResource("BackupUtility.Recover.ArgName.txt"));
            this.addOption(option);
            option = new Option(BackupUtility.OPTION_RECOVER_ALTERNATE, true, RB.getStringResource("BackupUtility.RecoverAlternate.Desc.txt"));
            option.setArgName(RB.getStringResource("BackupUtility.RecoverAlternate.ArgName.txt"));
            this.addOption(option);
            option = new Option(BackupUtility.OPTION_STATE, true, RB.getStringResource("BackupUtility.State.Desc.txt"));
            option.setArgName(RB.getStringResource("BackupUtility.State.ArgName.txt"));
            this.addOption(option);
            option = new Option(BackupUtility.OPTION_COMMENT, true, RB.getStringResource("BackupUtility.Comment.Desc.txt"));
            option.setArgName(RB.getStringResource("BackupUtility.Comment.ArgName.txt"));
            this.addOption(option);
        }
    }
}

