/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt.impl;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.mgmt.MetadataOperation;
import com.sas.metadata.mgmt.impl.RB;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.text.Message;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class ImplFromXMLElement {
    protected static final String ELEMENT_NAME_METADATA_MANAGER = "MetadataManager";
    protected static final String ELEMENT_NAME_BACKUP_HISTORY = "BackupHistory";
    protected static final String ELEMENT_NAME_BACKUPS = "Backups";
    protected static final String ELEMENT_NAME_BACKUP = "Backup";
    protected static final String ELEMENT_NAME_RECOVERY = "Recovery";
    protected static final String ELEMENT_NAME_REPOSITORIES = "Repositories";
    protected static final String ELEMENT_NAME_REPOSITORY = "Repository";
    protected static final String ELEMENT_NAME_METADATA_SERVER = "MetadataServer";
    protected static final String ELEMENT_NAME_FILE = "File";
    protected static final String ELEMENT_NAME_CONFIGURATION_FILES = "ConfigurationFiles";
    protected static final String ELEMENT_NAME_BACKUP_CONFIGURATION = "BackupConfiguration";
    protected static final String ELEMENT_NAME_BACKUP_SCHEDULE = "BackupSchedule";
    protected static final String ELEMENT_NAME_METADATA = "Metadata";
    protected static final String ELEMENT_NAME_OPTIONS = "Options";
    protected static final String ELEMENT_NAME_JOURNALS = "Journals";
    protected static final String ELEMENT_NAME_JOURNAL = "Journal";
    protected static final String ATTRIBUTE_NAME_NAME = "Name";
    protected static final String ATTRIBUTE_NAME_STATUS = "Status";
    protected static final String ATTRIBUTE_NAME_STARTING_USER_ID = "StartingUserID";
    protected static final String ATTRIBUTE_NAME_START_DATE_TIME = "StartDateTime";
    protected static final String ATTRIBUTE_NAME_DIRECTORY = "Directory";
    protected static final String ATTRIBUTE_NAME_BACKUP_PATH = "BackupPath";
    protected static final String ATTRIBUTE_NAME_PATH = "Path";
    protected static final String ATTRIBUTE_NAME_FILE_SIZE = "FileSize";
    protected static final String ATTRIBUTE_NAME_SIZE = "Size";
    protected static final String ATTRIBUTE_NAME_CREATED = "Created";
    protected static final String ATTRIBUTE_NAME_MODIFIED = "Modified";
    protected static final String ATTRIBUTE_NAME_COPY = "Copy";
    protected static final String ATTRIBUTE_NAME_INCLUDE_ALL_CONFIG_FILES = "IncludeAllConfigFiles";
    protected static final String ATTRIBUTE_NAME_PAUSE_COMMENT = "PauseComment";
    protected static final String ATTRIBUTE_NAME_ROLL_FORWARD = "RollForward";
    protected static final String ATTRIBUTE_NAME_BACKUP_LOCATION = "BackupLocation";
    protected static final String ATTRIBUTE_NAME_COMMENT = "Comment";
    protected static final String ATTRIBUTE_NAME_REORG = "Reorg";
    protected static final String ATTRIBUTE_NAME_RUN_SCHEDULED_BACKUPS = "RunScheduledBackups";
    protected static final String ATTRIBUTE_NAME_DAYS_TO_RETAIN_BACKUPS = "DaysToRetainBackups";
    protected static final String ATTRIBUTE_NAME_VERIFY = "Verify";
    protected static final String ATTRIBUTE_NAME_VERIFY_EXIST = "VerifyExist";
    protected static final String ATTRIBUTE_NAME_VERIFY_SIZE = "VerifySize";
    protected static final String ATTRIBUTE_NAME_VERIFY_MOD_DATE_TIME = "VerifyModDT";
    protected static final String ATTRIBUTE_NAME_LAST_VERIFY_DATE_TIME = "LastVerifyDateTime";
    protected static final String ATTRIBUTE_NAME_LAST_VERIFY_STATUS = "LastVerifyStatus";
    protected static final String ATTRIBUTE_NAME_EXPIRED = "Expired";
    protected static final String ATTRIBUTE_NAME_GUID = "GUID";
    protected static final String ATTRIBUTE_VALUE_SUCCESSFUL = MetadataOperation.Status.SUCCESSFUL.description();
    protected static final String ATTRIBUTE_VALUE_FAILED = MetadataOperation.Status.FAILED.description();
    protected static final String ATTRIBUTE_VALUE_CANCELLED = MetadataOperation.Status.CANCELLED.description();
    protected static final String ATTRIBUTE_VALUE_EXTRA = "Extra";
    protected static final String ATTRIBUTE_VALUE_OFFLINE = "Offline";
    protected Element domElement;
    protected Node descriptionTextNode = null;
    protected ImplFromXMLElement root = null;
    protected ImplFromXMLElement parent = null;
    protected NodeList childrenNodes;
    protected boolean haveDetails = false;
    protected SessionContextInterface _session = null;
    public MdFactory _factory = null;
    protected Logger _logger = null;
    protected String name = null;
    protected String objectType = "BackupRelatedObject";
    protected StringBuffer serverException = null;
    protected Exception lastServerException = null;
    protected Vector<ImplFromXMLElement> children = new Vector();
    private static SimpleDateFormat iso8601format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public ImplFromXMLElement() {
        this.objectType = this.getStaticObjectType();
    }

    public ImplFromXMLElement(ImplFromXMLElement container) {
        this.objectType = this.getStaticObjectType();
        this.parent = container;
        this.root = this.parent.root;
        if (this.root != null) {
            this._session = this.root._session;
            this._factory = this.root._factory;
            this._logger = this.root._logger;
        }
    }

    public ImplFromXMLElement(Element realElement, ImplFromXMLElement container) {
        this.objectType = this.getStaticObjectType();
        this.parent = container;
        this.root = this.parent.root;
        if (this.root != null) {
            this._session = this.root._session;
            this._factory = this.root._factory;
            this._logger = this.root._logger;
        }
        if (realElement != null) {
            this.setup(realElement, container);
        }
    }

    protected void setup(Element realElement, ImplFromXMLElement container) {
        if (realElement != null && this.domElement == null) {
            this.domElement = realElement;
        }
        if (this.domElement != null) {
            this.mapAttributes();
            this.childrenNodes = this.domElement.getChildNodes();
            int maxIndex = this.childrenNodes.getLength();
            for (int index = 0; index < maxIndex; ++index) {
                Node aNode = this.childrenNodes.item(index);
                String nodeValue = aNode.getNodeValue();
                if (nodeValue == null) continue;
                nodeValue = new String(nodeValue);
            }
        }
    }

    protected void getDetails(Element realElement) throws ServiceException {
        this.setup(realElement, this.parent);
        if (realElement != null) {
            this.haveDetails = true;
        }
    }

    public Document doRequest(String request) {
        Date beforeDate;
        Document doc;
        block4: {
            doc = null;
            this.lastServerException = null;
            beforeDate = new Date();
            try {
                doc = this._factory.getOMIUtil().DoRequest(request);
            }
            catch (MdException e) {
                this.logError("MdException: " + e.getMessage());
                this.addServerException((Exception)((Object)e));
                if (this._logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
            }
            catch (RemoteException e) {
                this.logError("RemoteException: " + e.getMessage());
                this.addServerException(e);
                if (!this._logger.isDebugEnabled()) break block4;
                e.printStackTrace();
            }
        }
        Date afterDate = new Date();
        this.logDebug("DoRequest took " + (double)(afterDate.getTime() - beforeDate.getTime()) / 1000.0 + " seconds.");
        return doc;
    }

    protected Document doRefresh(String request) {
        Document doc;
        block6: {
            IServer iServer = null;
            this.lastServerException = null;
            doc = null;
            try {
                Date beforeDate = new Date();
                this.logDebug("MetadataServerRefresh with options: " + request);
                iServer = this._factory.getConnection().MakeIServerConnection();
                iServer.Refresh(request);
                Date afterDate = new Date();
                this.logDebug("Refresh took " + (double)(afterDate.getTime() - beforeDate.getTime()) / 1000.0 + " seconds.");
            }
            catch (MdException e) {
                this.logError("MdException: " + e.getMessage());
                this.addServerException((Exception)((Object)e));
                if (this._logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
            }
            catch (RemoteException e) {
                this.logError("RemoteException: " + e.getMessage());
                this.addServerException(e);
                if (this._logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
            }
            catch (GenericError e) {
                this.logError("Generic Error: " + e.getMessage());
                this.addServerException((Exception)((Object)e));
                if (!this._logger.isDebugEnabled()) break block6;
                e.printStackTrace();
            }
        }
        return doc;
    }

    protected Document doStatus(String request) {
        return this.doStatusWithWrapper(request, null, false);
    }

    protected Document doStatus(String request, String options) {
        return this.doStatusWithWrapper(request, options, false);
    }

    protected Document doStatusWithWrapper(String request, String options, boolean withWrapper) {
        Document doc;
        block9: {
            IServer iServer = null;
            this.lastServerException = null;
            if (options == null) {
                options = "";
            }
            doc = null;
            try {
                Date beforeDate = new Date();
                this.logDebug("MetadataServerStatus with options: " + request);
                iServer = this._factory.getConnection().MakeIServerConnection();
                StringHolder outStatus = new StringHolder();
                iServer.Status(request, outStatus, options);
                Date afterDate = new Date();
                this.logDebug("Status took " + (double)(afterDate.getTime() - beforeDate.getTime()) / 1000.0 + " seconds.");
                String output = outStatus.value;
                this.logDebug("MetadataServerStatus response: " + output);
                if (withWrapper) {
                    output = "<wrapper>" + output + "</wrapper>";
                }
                if (output.length() > 0) {
                    doc = this.parseXMLString(output);
                }
            }
            catch (MdException e) {
                this.logError("MdException: " + e.getMessage());
                this.addServerException((Exception)((Object)e));
                if (this._logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
            }
            catch (RemoteException e) {
                this.logError("RemoteException: " + e.getMessage());
                this.addServerException(e);
                if (this._logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
            }
            catch (GenericError e) {
                this.logError("Generic Error: " + e.getMessage());
                this.addServerException((Exception)((Object)e));
                if (!this._logger.isDebugEnabled()) break block9;
                e.printStackTrace();
            }
        }
        return doc;
    }

    public String getName() throws ServiceException {
        if (this.name == null) {
            this.getDetails(null);
        }
        return this.name;
    }

    public String getStaticObjectType() {
        return "BackupRelatedObject";
    }

    public String getObjectType() throws ServiceException {
        if (this.objectType == null) {
            this.getDetails(null);
        }
        return this.objectType;
    }

    public StringBuffer getServerException() {
        return this.serverException;
    }

    protected void addServerException(Exception e) {
        String eString = e.toString();
        if (eString.indexOf(RB.getStringResource("mgmt_impl.exceptions.ElementNamed.txt")) <= 0 || eString.indexOf(RB.getStringResource("mgmt_impl.exceptions.IsMissingFromTheBackupManifest.txt")) <= 0) {
            this.lastServerException = e;
            if (this.serverException == null) {
                this.serverException = new StringBuffer();
            }
            this.serverException.append(e.toString());
        }
    }

    protected void addServerException(String e) {
        if (this.serverException == null) {
            this.serverException = new StringBuffer();
        }
        this.serverException.append(e);
    }

    protected void mapAttributes() {
        this.name = this.getAttribute(ATTRIBUTE_NAME_NAME);
    }

    protected String getAttribute(String attributeName) {
        return this.getAttribute(attributeName, this.domElement);
    }

    protected String getAttribute(String attributeName, Element someElement) {
        String valueString = null;
        Attr theAttr = someElement.getAttributeNode(attributeName);
        if (theAttr != null) {
            valueString = theAttr.getValue();
        }
        if (valueString != null) {
            return new String(valueString);
        }
        return null;
    }

    public void debugDump(String details) throws ServiceException {
        this.logDebug(this.objectType + ": " + (this.name != null ? this.name : "") + " " + details);
    }

    public void debugDump() throws ServiceException {
        this.debugDump(null);
    }

    public void logInfo(String details) {
        if (this._logger == null || this._logger.isInfoEnabled()) {
            this.log(Level.INFO, details);
        }
    }

    public void logDebug(String details) {
        if (this._logger == null || this._logger.isDebugEnabled()) {
            this.log(Level.DEBUG, details);
        }
    }

    public void logWarn(String details) {
        this.log(Level.WARN, details);
    }

    public void logError(String details) {
        this.log(Level.ERROR, details);
    }

    public void logFatal(String details) {
        this.log(Level.FATAL, details);
    }

    public void log(Level level, String details) {
        if (this._logger != null) {
            this._logger.log(level, details);
        } else {
            Date now = new Date();
            if (details == null) {
                details = "";
            }
            System.out.println("" + now.toString() + " " + details);
        }
    }

    public Document parseXMLString(String documentText) {
        Document document;
        block10: {
            document = null;
            DocumentBuilder m_docBuilder = null;
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                m_docBuilder = dbf.newDocumentBuilder();
                StringReader inputStream = new StringReader(documentText);
                InputSource inputSource = new InputSource(inputStream);
                document = m_docBuilder.parse(inputSource);
            }
            catch (SAXParseException dbf) {
            }
            catch (SAXNotRecognizedException dbf) {
            }
            catch (SAXNotSupportedException dbf) {
            }
            catch (SAXException se) {
                if (this._logger.isDebugEnabled()) {
                    if (se.getException() != null) {
                        se.getException().printStackTrace(System.err);
                    } else {
                        se.printStackTrace(System.err);
                    }
                }
            }
            catch (Exception e) {
                if (!this._logger.isDebugEnabled()) break block10;
                e.printStackTrace(System.err);
            }
        }
        if (document == null) {
            this.logWarn(RB.getStringResource("mgmt_impl.xmlparse.error.general.txt") + " [" + documentText + "]");
            return null;
        }
        return document;
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public Date parseISO8601DateTime(String iso8601, String attributeName) {
        Date date;
        block4: {
            date = null;
            if (iso8601 != null) {
                try {
                    StringBuffer sb;
                    int len = iso8601.length();
                    if (len > 22 && (sb = new StringBuffer(iso8601)).charAt(len - 3) == ':') {
                        sb.deleteCharAt(len - 3);
                        iso8601 = sb.toString();
                    }
                    date = iso8601format.parse(iso8601);
                }
                catch (ParseException e) {
                    ParseException pe;
                    int offset;
                    this.logWarn(new Message(RB.getResources(), "mgmt_impl.parse.error.forAttributeValueTypeName.fmt", (Object)attributeName, (Object)iso8601, (Object)this.objectType, (Object)this.name).toString());
                    this.logWarn(new Message(RB.getResources(), "mgmt_impl.parse.error.reason.fmt", (Object)e.getMessage()).toString());
                    if (!(e instanceof ParseException) || (offset = (pe = e).getErrorOffset()) <= 0 || iso8601.length() <= offset) break block4;
                    String underscore = "                                  ";
                    underscore = underscore.substring(0, offset) + "^";
                    this.logWarn(new Message(RB.getResources(), "mgmt_impl.parse.error.inputText.fmt", (Object)iso8601).toString());
                    this.logWarn(new Message(RB.getResources(), "mgmt_impl.parse.error.UpPointer.fmt", (Object)underscore).toString());
                }
            }
        }
        return date;
    }

    public double getISO8601DateTimeTimezoneOffset(String iso8601, String attributeName) {
        Double offsetMinutes = null;
        String offsetString = null;
        if (iso8601 != null) {
            StringBuffer sb;
            int len = iso8601.length();
            if (len > 22 && (sb = new StringBuffer(iso8601)).charAt(len - 3) == ':') {
                sb.deleteCharAt(len - 3);
                iso8601 = sb.toString();
            }
            offsetString = iso8601.substring(iso8601.length() - 5);
            String hoursString = offsetString.substring(1, 3);
            double hours = Integer.parseInt(hoursString);
            String minutesString = offsetString.substring(3);
            double minutes = Integer.parseInt(minutesString);
            offsetMinutes = hours * 60.0 + minutes;
            if (offsetString.charAt(0) == '-') {
                offsetMinutes = offsetMinutes * -1.0;
            }
        }
        return offsetMinutes * 60.0 * 1000.0;
    }

    public String getISO8601DateTimeTimezoneName(String iso8601, String attributeName) {
        String offsetString = null;
        String timezoneName = "GMT";
        if (iso8601 != null) {
            StringBuffer sb;
            int len = iso8601.length();
            if (len > 22 && (sb = new StringBuffer(iso8601)).charAt(len - 3) == ':') {
                sb.deleteCharAt(len - 3);
                iso8601 = sb.toString();
            }
            offsetString = iso8601.substring(iso8601.length() - 5);
            timezoneName = timezoneName + offsetString.substring(0, 3) + ":" + offsetString.substring(3);
        }
        return timezoneName;
    }

    public Document doRequestWithExclusiveServerLock(String request) throws ServiceException {
        return this.doRequest("<EXCLUSIVE_LOCK>" + request + "</EXCLUSIVE_LOCK>");
    }
}

