/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt.impl;

import com.sas.metadata.mgmt.MetadataOperation;
import com.sas.metadata.mgmt.impl.BackupFileSizeFormatter;
import com.sas.metadata.mgmt.impl.ImplFromXMLElement;
import com.sas.metadata.mgmt.impl.RB;
import com.sas.services.ServiceException;
import com.sas.text.Message;
import java.text.DateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.w3c.dom.Element;

public class FileImpl
extends ImplFromXMLElement {
    private String copy;
    private String path;
    private double fileSize;
    private Date modifiedDateTime;
    private double modifiedDateTimeTimeZoneOffset;
    private Date createdDateTime;
    private double createdDateTimeTimeZoneOffset;
    private MetadataOperation.Status status;
    private boolean isWrongSize;
    private boolean isMissing;
    private boolean isWrongDate;
    private boolean isBadModifiedDate;
    private boolean isBadCreatedDate;
    private boolean isExtra;
    boolean haveDetails = false;

    @Override
    public String getStaticObjectType() {
        return "File";
    }

    public FileImpl(Element domElement, ImplFromXMLElement container) {
        super(domElement, container);
    }

    @Override
    protected void mapAttributes() {
        String temp;
        this.isWrongSize = false;
        this.isMissing = false;
        this.isWrongDate = false;
        this.isExtra = false;
        this.path = this.getAttribute("Path");
        if (this.name == null) {
            this.name = this.getAttribute("Name");
        }
        if (this.name == null && this.path != null && this.path.length() > 0) {
            int sepIx = this.path.lastIndexOf("/");
            if (sepIx < 0) {
                sepIx = this.path.lastIndexOf("\\");
            }
            this.name = sepIx > 0 ? this.path.substring(sepIx + 1) : this.path;
        }
        this.copy = this.getAttribute("Copy");
        if (this.copy != null) {
            this.setStatusString(this.copy);
        }
        this.fileSize = (temp = this.getAttribute("FileSize")) != null && temp.length() > 0 ? Double.parseDouble(temp) : 0.0;
        temp = this.getAttribute("Created");
        if (temp != null) {
            this.createdDateTime = this.parseISO8601DateTime(temp, "Created");
            this.createdDateTimeTimeZoneOffset = this.getISO8601DateTimeTimezoneOffset(temp, "Created");
        }
        this.isBadCreatedDate = this.createdDateTime == null;
        temp = this.getAttribute("Modified");
        if (temp != null) {
            this.modifiedDateTime = this.parseISO8601DateTime(temp, "Modified");
            this.modifiedDateTimeTimeZoneOffset = this.getISO8601DateTimeTimezoneOffset(temp, "Modified");
        }
        this.isBadModifiedDate = this.modifiedDateTime == null;
        temp = this.getAttribute("VerifyExist");
        if (temp != null && temp.equals("Extra")) {
            this.isExtra = true;
        } else if (temp != null && !temp.equals(ATTRIBUTE_VALUE_SUCCESSFUL)) {
            this.isMissing = true;
        }
        temp = this.getAttribute("VerifySize");
        if (temp != null && !temp.equals(ATTRIBUTE_VALUE_SUCCESSFUL)) {
            this.isWrongSize = true;
        }
        if ((temp = this.getAttribute("VerifyModDT")) != null && !temp.equals(ATTRIBUTE_VALUE_SUCCESSFUL)) {
            this.isWrongDate = true;
        }
    }

    protected void setStatusString(String description) {
        this.status = MetadataOperation.Status.getStatus(description);
    }

    protected void setStatus(MetadataOperation.Status status) {
        this.status = status;
    }

    public MetadataOperation.Status getStatus() {
        return this.status;
    }

    public double getFileSize() {
        return this.fileSize;
    }

    public String getVerifyErrors() {
        StringBuffer errors = new StringBuffer();
        if (this.isExtra) {
            errors.append(RB.getStringResource("mgmt_impl.file.fileIsExtra.txt"));
        }
        if (this.isMissing) {
            errors.append(RB.getStringResource("mgmt_impl.file.fileIsMissing.txt"));
        }
        if (this.isWrongDate && this.isWrongSize) {
            errors.append(RB.getStringResource("mgmt_impl.file.fileIsWrongSizeAndDate.txt"));
        } else if (this.isWrongDate) {
            errors.append(RB.getStringResource("mgmt_impl.file.fileIsWrongDate.txt"));
        } else if (this.isWrongSize) {
            errors.append(RB.getStringResource("mgmt_impl.file.fileIsWrongSize.txt"));
        }
        if (errors.length() > 0) {
            return errors.toString();
        }
        return null;
    }

    public String getFullVerifyErrors() {
        StringBuffer errors = new StringBuffer();
        double fileSize = this.getFileSize();
        if (this.isExtra) {
            errors.append(RB.getStringResource("mgmt_impl.file.fileIsExtra.txt"));
        }
        if (this.isMissing) {
            errors.append(RB.getStringResource("mgmt_impl.file.fileIsMissing.txt"));
        }
        if (this.isWrongDate && this.isWrongSize) {
            DateFormat df = DateFormat.getDateTimeInstance(2, 2);
            SimpleTimeZone tz = new SimpleTimeZone((int)this.modifiedDateTimeTimeZoneOffset, "");
            df.setTimeZone(tz);
            String temp = this.getAttribute("Modified");
            errors.append(new Message(RB.getResources(), fileSize <= 1024.0 ? (this.isBadModifiedDate ? "mgmt_impl.file.fileIsWrongSizeAndSuspiciousDate.small.full.fmt" : "mgmt_impl.file.fileIsWrongSizeAndDate.small.full.fmt") : (this.isBadModifiedDate ? "mgmt_impl.file.fileIsWrongSizeAndSuspiciousDate.full.fmt" : "mgmt_impl.file.fileIsWrongSizeAndDate.full.fmt"), (Object)(this.isBadModifiedDate ? (temp == null ? "" : temp) : df.format(this.modifiedDateTime)), (Object)("" + fileSize), (Object)BackupFileSizeFormatter.formatFileSize(this.getFileSize())).toString());
        } else if (this.isWrongDate) {
            DateFormat df = DateFormat.getDateTimeInstance(2, 2);
            SimpleTimeZone tz = new SimpleTimeZone((int)this.modifiedDateTimeTimeZoneOffset, "");
            df.setTimeZone(tz);
            String temp = this.getAttribute("Modified");
            errors.append(new Message(RB.getResources(), this.isBadModifiedDate ? "mgmt_impl.file.fileIsSuspiciousDate.full.fmt" : "mgmt_impl.file.fileIsWrongDate.full.fmt", (Object)(this.isBadModifiedDate ? (temp == null ? "" : temp) : df.format(this.modifiedDateTime))).toString());
        } else if (this.isWrongSize) {
            errors.append(new Message(RB.getResources(), fileSize <= 1024.0 ? "mgmt_impl.file.fileIsWrongSize.small.full.fmt" : "mgmt_impl.file.fileIsWrongSize.full.fmt", (Object)("" + fileSize), (Object)BackupFileSizeFormatter.formatFileSize(this.getFileSize())).toString());
        }
        if (errors.length() > 0) {
            return errors.toString();
        }
        return null;
    }

    @Override
    public void debugDump() throws ServiceException {
        this.debugDump(" Status=" + (Object)((Object)this.status) + " fileSize=" + this.fileSize + " Created=" + this.createdDateTime + " Modified=" + this.modifiedDateTime);
        this.debugDump(" Path=" + this.path);
    }
}

