/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt.impl;

import com.sas.metadata.mgmt.BackupRepository;
import com.sas.metadata.mgmt.MetadataOperation;
import com.sas.metadata.mgmt.Repository;
import com.sas.metadata.mgmt.impl.FileImpl;
import com.sas.metadata.mgmt.impl.ImplFromXMLElement;
import com.sas.metadata.mgmt.impl.RB;
import com.sas.services.ServiceException;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BackupRepositoryImpl
extends ImplFromXMLElement
implements BackupRepository {
    protected static final String ATTRIBUTE_NAME_REPOSITORY_NAME = "RepositoryName";
    protected static final String ATTRIBUTE_NAME_REPOSITORY_DESC = "RepositoryDesc";
    protected static final String ATTRIBUTE_NAME_REPOSITORY_TYPE = "RepositoryType";
    protected static final String ATTRIBUTE_NAME_REPOSITORY_PATH = "RepositoryPath";
    protected static final String ATTRIBUTE_NAME_REPOSITORY_FORMAT = "RepositoryFormat";
    protected static final String ATTRIBUTE_NAME_REPOSITORY_ACCESS = "RepositoryAccess";
    private Element backupRepositoryElement = null;
    private Element restoreRepositoryElement = null;
    private MetadataOperation.Status status = null;
    private List<FileImpl> fileList = null;
    private boolean haveDetails = false;
    private String verifyErrors = null;
    private String verifyErrorsFull = null;
    private String backupErrors = null;
    private String backupErrorsFull = null;
    private String backupPath = null;
    private Repository.Access access = null;
    private String description = null;
    private String format = null;
    private String id = null;
    private String path = null;
    private Repository.Type type = null;
    double fileSize = 0.0;
    long fileCount = 0L;
    double recordedFileSize = 0.0;

    public BackupRepositoryImpl(Element realElement, ImplFromXMLElement container) {
        super(realElement, container);
        this.objectType = "Repository";
        this.setup(realElement, container);
        try {
            this.getDetails();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getStaticObjectType() {
        return "Repository";
    }

    public BackupRepositoryImpl(Element realElement, Element backupRepositoryElement, Element restoreRepositoryElement, ImplFromXMLElement container) {
        super(realElement, container);
        this.backupRepositoryElement = backupRepositoryElement;
        this.restoreRepositoryElement = restoreRepositoryElement;
        this.setup(realElement, container);
        try {
            this.getDetails();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void mapAttributes() {
        this.name = this.getAttribute(ATTRIBUTE_NAME_REPOSITORY_NAME);
        this.id = this.getAttribute("Name");
        this.description = this.getAttribute(ATTRIBUTE_NAME_REPOSITORY_DESC);
        String temp = this.getAttribute(ATTRIBUTE_NAME_REPOSITORY_TYPE);
        this.type = Repository.Type.getType(temp);
        this.format = this.getAttribute(ATTRIBUTE_NAME_REPOSITORY_FORMAT);
        temp = this.getAttribute(ATTRIBUTE_NAME_REPOSITORY_ACCESS);
        int iTemp = Integer.parseInt(temp);
        this.access = Repository.Access.getAccess(iTemp);
        this.path = this.getAttribute(ATTRIBUTE_NAME_REPOSITORY_PATH);
        String sizeString = this.getAttribute("Size");
        if (sizeString != null && sizeString.length() > 0) {
            this.recordedFileSize = Long.parseLong(sizeString);
        }
        if (this.backupRepositoryElement != null) {
            this.backupPath = this.getAttribute("Path", this.backupRepositoryElement);
        }
    }

    protected void setStatusString(String description) {
        this.status = MetadataOperation.Status.getStatus(description);
    }

    protected void setStatus(MetadataOperation.Status status) {
        this.status = status;
    }

    @Override
    public MetadataOperation.Status getStatus() {
        return this.status;
    }

    public String getVerifyErrors() {
        return this.verifyErrors;
    }

    public String getVerifyErrorsFull() {
        return this.verifyErrorsFull;
    }

    public void getDetails() throws ServiceException {
        if (this.haveDetails) {
            return;
        }
        StringBuffer backupErrorLog = new StringBuffer();
        StringBuffer verifyErrorLog = new StringBuffer();
        StringBuffer backupErrorFullLog = new StringBuffer();
        StringBuffer verifyErrorFullLog = new StringBuffer();
        int backupFailedCount = 0;
        int verifyFailedCount = 0;
        this.status = MetadataOperation.Status.SUCCESSFUL;
        if (this.backupRepositoryElement == null) {
            if (this.serverException == null) {
                this.serverException = new StringBuffer();
            }
            this.serverException.append("Not backed up.");
        }
        if (this.restoreRepositoryElement != null || this.backupRepositoryElement != null) {
            NodeList fileElementList = (this.restoreRepositoryElement != null ? this.restoreRepositoryElement : this.backupRepositoryElement).getElementsByTagName("File");
            int maxIndex = fileElementList.getLength();
            for (int fileIndex = 0; fileIndex < maxIndex; ++fileIndex) {
                Element fileElement = (Element)fileElementList.item(fileIndex);
                FileImpl file = new FileImpl(fileElement, this);
                if (this.fileList == null) {
                    this.fileList = new ArrayList<FileImpl>();
                }
                this.fileList.add(file);
                String fileName = file.getName();
                MetadataOperation.Status fileStatus = file.getStatus();
                String fileVerifyErrors = file.getFullVerifyErrors();
                ++this.fileCount;
                this.fileSize += file.getFileSize();
                if (fileStatus != null && !fileStatus.equals((Object)MetadataOperation.Status.SUCCESSFUL)) {
                    this.status = fileStatus;
                    if (backupFailedCount > 0) {
                        backupErrorLog.append(", ");
                    }
                    backupErrorLog.append("\"" + fileName + "\"");
                    backupErrorFullLog.append("\n          \"" + fileName + "\" " + RB.getStringResource("mgmt_impl.backup.filesWasNotCopied.txt"));
                    ++backupFailedCount;
                }
                if (fileVerifyErrors == null) continue;
                if (verifyFailedCount > 0) {
                    verifyErrorLog.append(", ");
                }
                verifyErrorLog.append("\"" + fileName + "\" ");
                verifyErrorLog.append(fileVerifyErrors);
                verifyErrorFullLog.append("\n          \"" + fileName + "\" ");
                verifyErrorFullLog.append(fileVerifyErrors);
                ++verifyFailedCount;
            }
            if (this.recordedFileSize > 0.0 && this.fileSize != this.recordedFileSize) {
                this.logDebug("Repository " + this.name + " has recorded file size of " + (long)this.recordedFileSize + " which is different than the computed size of " + (long)this.fileSize);
            }
        }
        if (backupFailedCount > 0) {
            this.backupErrors = new Message(RB.getResources(), "mgmt_impl.backup.filesWithCopyErrorsCount.fmt", (Object)new Integer(backupFailedCount).toString()).toString();
            this.backupErrorsFull = "     " + new Message(RB.getResources(), "mgmt_impl.backup.filesWithCopyErrorsFull.fmt", (Object)new Integer(backupFailedCount).toString(), (Object)backupErrorFullLog.toString()).toString();
        }
        if (verifyFailedCount > 0) {
            this.verifyErrors = new Message(RB.getResources(), "mgmt_impl.backup.filesWithVerifyErrorsCount.fmt", (Object)new Integer(verifyFailedCount).toString()).toString();
            this.verifyErrorsFull = "     " + new Message(RB.getResources(), "mgmt_impl.backup.filesWithVerifyErrorsFull.fmt", (Object)new Integer(verifyFailedCount).toString(), (Object)verifyErrorFullLog.toString()).toString();
        }
        this.haveDetails = true;
    }

    @Override
    public String getBackupPath() {
        return this.backupPath;
    }

    @Override
    public Repository.Access getAccess() {
        return this.access;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Repository.Type getType() {
        return this.type;
    }

    @Override
    public String getErrorLog() throws ServiceException {
        String result = (this.serverException != null && this.serverException.length() > 0 ? this.serverException + "  " : "") + (this.backupErrors != null && this.backupErrors.length() > 0 ? this.backupErrors + "  " : "") + (this.verifyErrors != null && this.verifyErrors.length() > 0 ? this.verifyErrors + "  " : "");
        if ((result = result.trim()).length() > 0) {
            return result;
        }
        return null;
    }

    public String getFullReport() throws ServiceException {
        String result = (this.serverException != null && this.serverException.length() > 0 ? this.serverException + "  " : "") + (this.backupErrorsFull != null && this.backupErrorsFull.length() > 0 ? this.backupErrorsFull + "\n" : "") + (this.verifyErrorsFull != null && this.verifyErrorsFull.length() > 0 ? this.verifyErrorsFull + "\n" : "");
        if (result.length() > 0) {
            return result;
        }
        return null;
    }

    @Override
    public void debugDump() throws ServiceException {
        this.debugDump(" ID=" + this.getID() + " Name=" + this.getName() + " Description=" + this.getDescription());
        this.debugDump(" Access=" + (Object)((Object)this.getAccess()) + " Format=" + this.getFormat() + " Type=" + (Object)((Object)this.getType()));
        this.debugDump(" Path=" + this.getPath());
        this.debugDump(" BackupPath=" + this.getBackupPath());
        this.debugDump(" fileCount=" + this.getFileCount() + " fileSize=" + this.getSize());
        if (this.fileList != null) {
            for (FileImpl file : this.fileList) {
                file.debugDump();
            }
        }
    }

    @Override
    public double getSize() throws ServiceException {
        return this.fileSize;
    }

    public long getFileCount() throws ServiceException {
        return this.fileCount;
    }
}

