/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt.impl;

import com.sas.metadata.mgmt.Backup;
import com.sas.metadata.mgmt.BackupRecovery;
import com.sas.metadata.mgmt.BackupRepository;
import com.sas.metadata.mgmt.MetadataManager;
import com.sas.metadata.mgmt.MetadataManagerException;
import com.sas.metadata.mgmt.MetadataOperation;
import com.sas.metadata.mgmt.impl.BackupHistoryImpl;
import com.sas.metadata.mgmt.impl.BackupImpl;
import com.sas.metadata.mgmt.impl.BackupRepositoryImpl;
import com.sas.metadata.mgmt.impl.ImplFromXMLElement;
import com.sas.metadata.mgmt.impl.JournalImpl;
import com.sas.metadata.mgmt.impl.MetadataManagerImpl;
import com.sas.metadata.mgmt.impl.RB;
import com.sas.services.ServiceException;
import com.sas.text.Message;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BackupRecoveryImpl
extends ImplFromXMLElement
implements BackupRecovery,
MetadataOperation.Listener {
    private String directory;
    private MetadataOperation.Status status;
    private Date startDateTime;
    private Date journalStartDateTime;
    private Date journalEndDateTime;
    private long journalStartEntryNumber;
    private long journalEndEntryNumber;
    private String startingUserID;
    private BackupImpl backup;
    private BackupImpl followupBackup = null;
    private String backupName;
    private boolean isLatestRecovery = false;
    JournalImpl backupJournal = null;
    private boolean includeAllConfigFiles = false;
    private String rollForward = null;
    private Date rollForwardDate = null;
    private long rollForwardLong = 0L;
    private String pauseComment = null;
    String comment = null;
    public String serverState = null;
    boolean isRunning = false;
    double percentCompletion = 0.0;
    long bytesToBackup = 0L;
    long bytesBackedUp = 0L;
    String lastBackupNameBefore = null;
    private static String getLastBackup = "       <MetadataServerBackupHistory XPath=\"MetadataServerBackupManifest/Backups/Backup[POSITION()=LAST()]\"/>\n";
    private static String getLastRecovery = "       <MetadataServerBackupHistory XPath=\"MetadataServerBackupManifest/Backups/Recovery[POSITION()=LAST()]\"/>\n";
    protected boolean isAsynchronous = false;
    private List<MetadataOperation.Listener> listeners = null;
    List<BackupRepository> allRepositories = null;
    private boolean haveSummarizedErrors = false;
    boolean reorg = false;
    private String journalStats = "\t  <OMA JOURNALPATH=\"\" \r\n\t\t  JOURNALSTATE=\"\"\r\n\t\t  JOURNALQUEUELENGTH=\"\"\r\n\t\t  JOURNALDATAAVAILABLE=\"\"\r\n\t\t  JOURNALMAXDATAAVAILABLE=\"\"\r\n\t\t  JOURNALHISTORICALDATA=\"\"\r\n\t\t  JOURNALSPACEAVAILABLE=\"\"\r\n\t\t  JOURNALENTRYCOUNTER=\"\"\r\n\t\t  SERVERSTARTPATH=\"\"/>\r\n\r\n";
    private Date firstJournalCheck = null;
    double recordedFileSize = 0.0;
    double computedFileSize = 0.0;
    long fileCount = 0L;
    boolean doVerify = true;
    private String GUID = null;
    double timezoneOffset = 0.0;
    String timezoneName = null;

    @Override
    public String getStaticObjectType() {
        return "Recovery";
    }

    public BackupRecoveryImpl(Element realElement, ImplFromXMLElement container) {
        super(realElement, container);
        if (realElement != null) {
            this.setup(realElement, container);
        }
    }

    protected void setStatusString(String description) {
        this.status = MetadataOperation.Status.getStatus(description);
    }

    protected void setStatus(MetadataOperation.Status status) {
        this.status = status;
    }

    @Override
    protected void mapAttributes() {
        String sizeString;
        if (this.name == null) {
            this.name = this.getAttribute("Name");
        }
        this.directory = this.getAttribute("BackupPath");
        this.setStatusString(this.getAttribute("Status"));
        String startDateTimeString = this.getAttribute("StartDateTime");
        if (startDateTimeString != null) {
            this.startDateTime = this.parseISO8601DateTime(startDateTimeString, "StartDateTime");
            this.timezoneOffset = this.getISO8601DateTimeTimezoneOffset(startDateTimeString, "StartDateTime");
            this.timezoneName = this.getISO8601DateTimeTimezoneName(startDateTimeString, "StartDateTime");
        }
        if ((sizeString = this.getAttribute("Size")) != null) {
            try {
                this.recordedFileSize = Double.parseDouble(sizeString);
            }
            catch (Exception e) {
                this.logDebug("Recovery named " + this.name + " has a suspicious Size: " + sizeString);
            }
        }
        this.startingUserID = this.getAttribute("StartingUserID");
        String test = this.getAttribute("IncludeAllConfigFiles");
        this.includeAllConfigFiles = test != null && test.length() > 0 ? test.substring(0, 1).equalsIgnoreCase("Y") : false;
        this.rollForward = this.getAttribute("RollForward");
        this.comment = this.getAttribute("Comment");
        this.pauseComment = this.getAttribute("PauseComment");
        if (this.name == null && startDateTimeString != null) {
            this.name = startDateTimeString.replace(':', '_');
        }
        this.reorg = (test = this.getAttribute("Reorg")) != null && test.length() > 0 ? test.substring(0, 1).equalsIgnoreCase("Y") : false;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isSuccessful() {
        return this.status == MetadataOperation.Status.SUCCESSFUL;
    }

    @Override
    public Backup getBackup() throws ServiceException {
        if (this.backup == null && !this.haveDetails) {
            this.getDetails(null);
        }
        if (this.backup == null && this.backupName != null) {
            List<Backup> allBackups = ((BackupHistoryImpl)((MetadataManagerImpl)this.root).getBackupHistory()).getBackups();
            for (Backup aBackup : allBackups) {
                if (!aBackup.getName().equals(this.backupName)) continue;
                this.backup = (BackupImpl)aBackup;
                break;
            }
        }
        return this.backup;
    }

    public void setBackup(BackupImpl backup) {
        this.backup = backup;
        try {
            this.backupName = backup.getName();
            if (this.directory == null) {
                this.directory = backup.getPath();
            }
            this.getBackupJournal();
        }
        catch (ServiceException e) {
            this.backupName = null;
        }
    }

    private void getBackupJournal() throws ServiceException {
        Element manifestElement;
        NodeList journalElementsList;
        int nJournals;
        String journalPath = this.backup.getPath() + "/MetadataServerJournal.dat";
        String journalPathTail = this.backup.getName() + "/MetadataServerJournal.dat";
        String GET_JOURNAL = "      <MetadataServerBackupManifest \n       XPath=\"MetadataServerBackupManifest/MetadataServer/Journals/Journal[@Pathname='" + journalPath + "']\"/>\n";
        String GET_JOURNAL_FROM_BACKUP_DETAILS = "      <MetadataServerBackupManifest             BackupPath=\"" + this.directory + "\"            XPath=\"MetadataServerBackupManifest/MetadataServer/Journals/Journal[@Pathname='" + journalPath + "']\"/>\n";
        String GET_ALL_JOURNALS_FROM_BACKUP_DETAILS = "      <MetadataServerBackupManifest             BackupPath=\"" + this.directory + "\"            XPath=\"MetadataServerBackupManifest/MetadataServer/Journals\"/>\n";
        StringBuffer saveSE = this.serverException;
        Exception saveE = this.lastServerException;
        Document doc = null;
        try {
            doc = this.doStatus(GET_JOURNAL);
        }
        catch (Exception e) {
            this.logError(new Message(RB.getResources(), "mgmt_impl.recovery.exceptionGettingJournal.fmt", (Object)e).toString());
        }
        if (doc == null) {
            try {
                doc = this.doStatus(GET_JOURNAL_FROM_BACKUP_DETAILS);
            }
            catch (Exception e) {
                this.logError(new Message(RB.getResources(), "mgmt_impl.recovery.exceptionGettingJournal.fmt", (Object)e).toString());
            }
        }
        if (doc == null) {
            try {
                doc = this.doStatus(GET_ALL_JOURNALS_FROM_BACKUP_DETAILS);
            }
            catch (Exception e) {
                this.logError(new Message(RB.getResources(), "mgmt_impl.recovery.exceptionGettingJournal.fmt", (Object)e).toString());
            }
        }
        this.serverException = saveSE;
        this.lastServerException = saveE;
        if (doc != null && (nJournals = (journalElementsList = (manifestElement = doc.getDocumentElement()).getElementsByTagName("Journal")).getLength()) > 0) {
            Element journalElement = null;
            for (int ix = 0; ix < nJournals; ++ix) {
                Element testElement = (Element)journalElementsList.item(ix);
                String testPath = this.getAttribute("Pathname", testElement);
                if (!testPath.endsWith(journalPathTail)) continue;
                journalElement = testElement;
            }
            if (journalElement != null) {
                this.backupJournal = new JournalImpl(journalElement, this);
                if (this.backupJournal != null && (this.backupJournal.getHistoricalDataSize() > 0L || this.backupJournal.getHistoricalOverflow() > 0L)) {
                    this.journalStartDateTime = this.backup.getStartDateTime();
                    this.journalEndDateTime = this.backupJournal.getModifiedDateTime();
                    this.journalStartEntryNumber = this.backupJournal.getFirstEntryNumber();
                    this.journalEndEntryNumber = this.backupJournal.getLastEntryNumber();
                }
            }
        }
        this.checkJournal();
    }

    @Override
    public String getPath() throws ServiceException {
        if (!this.haveDetails) {
            this.getDetails(null);
        }
        return this.directory;
    }

    @Override
    public boolean getIncludeAllConfigFiles() throws ServiceException {
        if (!this.haveDetails) {
            this.getDetails(null);
        }
        return this.includeAllConfigFiles;
    }

    @Override
    public void setIncludeAllConfigFiles(boolean value) {
        this.includeAllConfigFiles = value;
    }

    @Override
    public String getRollForwardString() throws ServiceException {
        if (!this.haveDetails) {
            this.getDetails(null);
        }
        return this.rollForward;
    }

    public Object getRollForward() throws ServiceException {
        if (!this.haveDetails) {
            this.getDetails(null);
        }
        if (this.rollForward == null || this.rollForward.length() == 0) {
            return new Boolean(false);
        }
        if (this.rollForward.equals("_ALL_")) {
            return new Boolean(true);
        }
        if (this.rollForwardLong > 0L || this.rollForward.length() < 10) {
            return new Long(Long.parseLong(this.rollForward));
        }
        return this.rollForwardDate;
    }

    @Override
    public void setRollForward(String value) throws ServiceException {
        if (this.status != null && this.status != MetadataOperation.Status.NOT_STARTED) {
            throw new MetadataManagerException(RB.getStringResource("mgmt_impl.operation.error.onlyBeforeExecute.txt"));
        }
        this.rollForward = value;
    }

    @Override
    public void setRollForwardAll() throws ServiceException {
        this.setRollForward("_ALL_");
    }

    @Override
    public void setRollForwardDateTime(Date value) throws ServiceException {
        this.rollForwardDate = value;
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss");
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        sdf.setTimeZone(gmt);
        this.setRollForward(sdf.format(this.rollForwardDate));
    }

    @Override
    public String getPauseComment() throws ServiceException {
        if (!this.haveDetails) {
            this.getDetails(null);
        }
        return this.pauseComment;
    }

    @Override
    public void setPauseComment(String value) throws ServiceException {
        if (this.status != null && this.status != MetadataOperation.Status.NOT_STARTED) {
            throw new MetadataManagerException(RB.getStringResource("mgmt_impl.operation.error.onlyBeforeExecute.txt"));
        }
        this.pauseComment = value;
    }

    @Override
    public String getComment() throws ServiceException {
        return this.comment;
    }

    @Override
    public void setComment(String comment) throws ServiceException {
        if (this.status != null && this.status != MetadataOperation.Status.NOT_STARTED) {
            throw new MetadataManagerException(RB.getStringResource("mgmt_impl.operation.error.onlyBeforeExecute.txt"));
        }
        this.comment = comment;
    }

    @Override
    public Double getPercentCompletion() {
        double reporting;
        Document doc = null;
        double previous = this.percentCompletion;
        if (this.followupBackup != null) {
            double bpc = this.followupBackup.getPercentCompletion();
            reporting = 50.0 + bpc / 2.0;
            this.logDebug("The backup is " + bpc + "% complete, so the recovery is " + reporting + "% complete");
        } else {
            String newLastBackupName;
            doc = this.doStatus(getLastBackup);
            if (doc != null) {
                Element anElement = doc.getDocumentElement();
                Element backupElement = null;
                NodeList backupElementsList = anElement.getElementsByTagName("Backup");
                if (backupElementsList.getLength() > 0) {
                    backupElement = (Element)backupElementsList.item(0);
                }
                newLastBackupName = backupElement != null ? this.getAttribute("Name", backupElement) : "UNKNOWN";
            } else {
                newLastBackupName = "UNKNOWN";
            }
            if (!newLastBackupName.equals(this.lastBackupNameBefore)) {
                this.logDebug("last Backup name has changed, which means that the new backup has started.");
            }
            String queryProgress = "<ServerState/><Backup BytesToBackup=\"\" BytesBackedUp=\"\" IsRunning=\"\"/>\n";
            doc = this.doStatusWithWrapper(queryProgress, null, true);
            Element statusElement = null;
            if (doc != null) {
                statusElement = doc.getDocumentElement();
            }
            if (statusElement != null) {
                NodeList serverStateElementsList = statusElement.getElementsByTagName("ServerState");
                Element serverStateElement = (Element)serverStateElementsList.item(0);
                NodeList nl = serverStateElement.getChildNodes();
                Node stateNode = nl.item(0);
                this.serverState = ((Text)stateNode).getNodeValue();
                if (this.serverState != null && this.serverState.equals("RECOVERY")) {
                    NodeList backupElementsList = statusElement.getElementsByTagName("Backup");
                    Element backupElement = (Element)backupElementsList.item(0);
                    String done = this.getAttribute("BytesBackedUp", backupElement);
                    String toDo = this.getAttribute("BytesToBackup", backupElement);
                    String isRunningString = this.getAttribute("IsRunning", backupElement);
                    if (isRunningString != null && isRunningString.length() > 0) {
                        this.isRunning = isRunningString.toLowerCase().charAt(0) == 'y';
                    }
                    long newBytesToBackup = 0L;
                    long newBytesBackedUp = 0L;
                    if (done != null && done.length() > 0) {
                        newBytesBackedUp = Math.max(this.bytesBackedUp, Double.valueOf(done).longValue());
                    }
                    if (toDo != null && toDo.length() > 0) {
                        newBytesToBackup = Math.max(this.bytesToBackup, Double.valueOf(toDo).longValue());
                    }
                    if (newBytesBackedUp < this.bytesBackedUp || newBytesToBackup < this.bytesToBackup) {
                        this.logInfo(RB.getStringResource("mgmt_impl.recovery.surpriseTransitionToBackup.txt"));
                    } else {
                        this.bytesBackedUp = newBytesBackedUp;
                        this.bytesToBackup = newBytesToBackup;
                    }
                    this.percentCompletion = this.bytesToBackup > 0L ? (double)this.bytesBackedUp * 100.0 / (double)this.bytesToBackup : 0.0;
                } else if (this.serverState != null && this.serverState.equals("ONLINE")) {
                    this.percentCompletion = 100.0;
                }
            }
            reporting = this.percentCompletion / 2.0;
            this.logDebug("The recovery itself is " + this.percentCompletion + "% complete, so return value is " + reporting);
        }
        if (reporting < previous) {
            this.logDebug("It's curious that the previous value was " + previous + " and we now report " + reporting);
        }
        this.percentCompletion = reporting;
        return new Double(reporting);
    }

    @Override
    public List<BackupRepository> getRepositories() {
        if (!(this.allRepositories != null && this.allRepositories.size() != 0 || this.isLatestRecovery)) {
            return null;
        }
        if (this.allRepositories != null) {
            return Collections.unmodifiableList(this.allRepositories);
        }
        return new ArrayList<BackupRepository>();
    }

    @Override
    public Date getStartDateTime() throws ServiceException {
        if (!this.haveDetails) {
            this.getDetails(null);
        }
        return this.startDateTime;
    }

    @Override
    public String getStartingUserID() throws ServiceException {
        if (!this.haveDetails) {
            this.getDetails(null);
        }
        return this.startingUserID;
    }

    @Override
    public MetadataOperation.Status getStatus() {
        return this.status;
    }

    @Override
    public MetadataOperation.Status execute() throws ServiceException {
        String testName;
        BackupImpl lastBackupBefore;
        Element anElement = null;
        NodeList recoveryElementsList = null;
        Element recoveryElement = null;
        if (this.name == null) {
            this.name = "UNKNOWN";
        }
        String lastRecoveryName = "UNKNOWN";
        Document doc = this.doStatusWithWrapper(getLastRecovery, null, true);
        if (doc != null) {
            anElement = doc.getDocumentElement();
            recoveryElementsList = anElement.getElementsByTagName("Recovery");
            if (recoveryElementsList.getLength() > 0 && (recoveryElement = (Element)recoveryElementsList.item(0)) != null) {
                lastRecoveryName = this.getAttribute("Name", recoveryElement);
                this.logInfo(new Message(RB.getResources(), "mgmt_impl.recovery.mostRecentRecoveryNamed.fmt", (Object)lastRecoveryName).toString());
            }
        } else {
            lastRecoveryName = "UNKNOWN";
        }
        if ((lastBackupBefore = (BackupImpl)((BackupHistoryImpl)this.parent).getLastBackup()) != null) {
            this.lastBackupNameBefore = lastBackupBefore.getName();
        }
        String reorgAttributeString = "";
        if (this.reorg) {
            reorgAttributeString = " Reorg=\"Yes\"";
        }
        String startRecovery = "<Recover BackupPath=\"" + this.backup.getPath() + "\" IncludeAllConfigFiles=\"" + (this.includeAllConfigFiles ? "Y" : "N") + "\"" + (this.rollForward == null ? "" : " RollForward=\"" + this.rollForward.replace('\"', '\'') + "\"") + (this.pauseComment == null ? "" : " PauseComment=\"" + this.pauseComment.replace('\"', '\'') + "\"") + (this.comment == null ? "" : " Comment=\"" + this.comment.replace('\"', '\'') + "\"") + reorgAttributeString + "  IgnoreVerify=\"" + (this.doVerify ? "N" : "Y") + "\" />";
        this.doRefresh(startRecovery);
        this.logInfo(new Message(RB.getResources(), "mgmt_impl.recovery.recoveryRequested.fmt", (Object)this.backup.getPath()).toString());
        this.waitForRunning();
        this.startDateTime = new Date();
        this.setStatus(MetadataOperation.Status.STARTED);
        this.setLatestRecovery(true);
        doc = this.doStatusWithWrapper(getLastRecovery, null, true);
        if (doc != null && (recoveryElementsList = (anElement = doc.getDocumentElement()).getElementsByTagName("Recovery")).getLength() > 0 && (recoveryElement = (Element)recoveryElementsList.item(0)) != null && (testName = this.getAttribute("Name", recoveryElement)) != null && !testName.equals(lastRecoveryName)) {
            this.name = testName;
            this.logInfo(new Message(RB.getResources(), "mgmt_impl.recovery.newRecoveryIsNamed.fmt", (Object)this.name).toString());
        }
        this.followupBackup = null;
        if (!this.isAsynchronous) {
            String lastBackupName;
            this.waitForCompletion();
            doc = this.doStatusWithWrapper(getLastBackup, null, true);
            if (doc != null) {
                Element backupElement;
                anElement = doc.getDocumentElement();
                NodeList backupElementsList = anElement.getElementsByTagName("Backup");
                if (backupElementsList.getLength() > 0 && (backupElement = (Element)backupElementsList.item(0)) != null) {
                    lastBackupName = this.getAttribute("Name", backupElement);
                    if (this.lastBackupNameBefore == null || !lastBackupName.equals(this.lastBackupNameBefore)) {
                        this.logInfo(new Message(RB.getResources(), "mgmt_impl.recovery.newBackupIsNamed.fmt", (Object)lastBackupName).toString());
                        this.followupBackup = (BackupImpl)((BackupHistoryImpl)this.parent).newBackup(backupElement);
                        this.followupBackup.addListener(this);
                        this.followupBackup.waitForCompletion();
                        this.followupBackup.removeListener(this);
                    }
                }
            } else {
                lastBackupName = "UNKNOWN";
            }
        } else {
            Runnable waiter = new Runnable(){

                @Override
                public void run() {
                    BackupRecoveryImpl.this.logInfo(RB.getStringResource("mgmt_impl.recovery.waitingForRecoveryToComplete.txt"));
                    while (BackupRecoveryImpl.this.isRunning) {
                        try {
                            Thread.sleep(500L);
                            BackupRecoveryImpl.this.waitForCompletion();
                        }
                        catch (ServiceException e) {
                            e.printStackTrace();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            };
            waiter.run();
        }
        return this.status;
    }

    protected MetadataOperation.Status waitForCompletion() throws ServiceException {
        String serverStateRecovery;
        this.getPercentCompletion();
        String serverState = serverStateRecovery = "RECOVERY";
        while (this.status == MetadataOperation.Status.STARTED && this.isRunning && serverState.equals(serverStateRecovery)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.getPercentCompletion();
            Document doc = this.doStatus("<ServerState/>");
            if (doc != null) {
                Element stateElement = doc.getDocumentElement();
                NodeList children = stateElement.getChildNodes();
                int numChildren = children.getLength();
                for (int ix = 0; ix < numChildren; ++ix) {
                    Node childNode = children.item(ix);
                    short nodeType = childNode.getNodeType();
                    if (nodeType != 3) continue;
                    serverState = ((Text)childNode).getNodeValue();
                }
            } else {
                serverState = serverStateRecovery;
            }
            this.notifyListeners();
            this.logDebug(new Message(RB.getResources(), "mgmt_impl.recovery.isRunning.fmt", (Object)new Boolean(this.isRunning).toString(), (Object)new Double(this.percentCompletion).toString(), (Object)serverState).toString());
        }
        this.status = MetadataOperation.Status.UNCERTAIN;
        this.getDetails(null);
        this.logInfo(RB.getStringResource("mgmt_impl.recovery.isComplete.txt"));
        this.getErrorLog();
        if (this.serverException != null) {
            this.logError(new Message(RB.getResources(), "mgmt_impl.recovery.encounteredExceptions.fmt", (Object)this.serverException).toString());
        }
        this.notifyListeners();
        return this.status;
    }

    protected MetadataOperation.Status waitForRunning() throws ServiceException {
        this.logInfo(RB.getStringResource("mgmt_impl.recovery.waitingForRecoveryToStart.txt"));
        this.isRunning = false;
        this.getPercentCompletion();
        while (!this.isRunning) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.getPercentCompletion();
            this.notifyListeners();
            this.logDebug("Recovery isRunning=" + this.isRunning + " and is " + this.percentCompletion + " percent complete.");
        }
        return this.status;
    }

    @Override
    public void getDetails(Element realElement) throws ServiceException {
        Element thisRecoveryElement = null;
        Element thisBackupElement = null;
        Element manifestElement = null;
        boolean bIsFullDetails = false;
        if (this.isRunning) {
            this.getPercentCompletion();
        }
        if (this.haveDetails || this.status == MetadataOperation.Status.NOT_STARTED || this.status == MetadataOperation.Status.STARTED) {
            return;
        }
        if (realElement != null) {
            thisRecoveryElement = realElement;
        } else if (this.isLatestRecovery() && this.status != MetadataOperation.Status.NOT_STARTED && this.status != MetadataOperation.Status.STARTED) {
            String GET_DETAILS = "      <MetadataServerRecoveryManifest/>\n";
            bIsFullDetails = true;
            Document doc = this.doStatus(GET_DETAILS);
            if (doc == null) {
                return;
            }
            manifestElement = doc.getDocumentElement();
            NodeList backupsElementsList = manifestElement.getElementsByTagName("Backups");
            Element backupsElement = (Element)backupsElementsList.item(0);
            NodeList backupElementList = backupsElement.getChildNodes();
            int maxIndex = backupElementList.getLength();
            for (int index = 0; index < maxIndex; ++index) {
                Node aNode = backupElementList.item(index);
                short nodeType = aNode.getNodeType();
                String nodeName = new String(aNode.getNodeName());
                if (nodeType != 1) continue;
                if (nodeName.equals("Recovery")) {
                    thisRecoveryElement = (Element)aNode;
                    continue;
                }
                if (!nodeName.equals("Backup")) continue;
                thisBackupElement = (Element)aNode;
            }
        }
        if (thisRecoveryElement != null) {
            if (!bIsFullDetails && this.name != null && !thisRecoveryElement.getAttribute("Name").equals(this.name)) {
                this.haveDetails = true;
                return;
            }
            this.domElement = thisRecoveryElement;
            this.mapAttributes();
        } else if (this.domElement == null) {
            MetadataManagerException e = new MetadataManagerException(RB.getStringResource("mgmt_impl.recovery.error.missingManifestDetail.txt"));
            throw e;
        }
        if (thisBackupElement != null) {
            String thisBackupName = thisBackupElement.getAttribute("Name");
            String requestedName = null;
            if (this.backup != null) {
                requestedName = this.backup.getName();
            }
            if (requestedName != null && !requestedName.equals(thisBackupName)) {
                this.logError(new Message(RB.getResources(), "mgmt_impl.recovery.manifestSaysWrongBackup.fmt", (Object)requestedName, (Object)thisBackupName).toString());
            }
            if (this.backupName == null) {
                this.backupName = thisBackupName;
            }
        }
        if (manifestElement != null) {
            Element serverElement;
            NodeList serverElementsList = manifestElement.getElementsByTagName("MetadataServer");
            Element element = serverElement = serverElementsList.getLength() <= 0 ? null : (Element)serverElementsList.item(0);
            if (serverElement != null && (this.GUID == null || this.GUID.length() == 0)) {
                this.GUID = this.getAttribute("GUID", serverElement);
                this.checkGUID();
            }
            NodeList serverRepositoryElementList = serverElement == null ? null : serverElement.getElementsByTagName("Repository");
            NodeList backupRepositoryElementList = thisBackupElement == null ? null : thisBackupElement.getElementsByTagName("Repository");
            NodeList restoreRepositoryElementList = thisRecoveryElement == null ? null : thisRecoveryElement.getElementsByTagName("Repository");
            this.allRepositories = new ArrayList<BackupRepository>();
            int maxIndexInServer = serverRepositoryElementList == null ? 0 : serverRepositoryElementList.getLength();
            int maxIndexInRestore = restoreRepositoryElementList == null ? 0 : restoreRepositoryElementList.getLength();
            int maxIndexInBackup = backupRepositoryElementList == null ? 0 : backupRepositoryElementList.getLength();
            int maxIndex = Math.max(Math.max(maxIndexInServer, maxIndexInRestore), maxIndexInBackup);
            for (int serverIndex = 0; serverIndex < maxIndexInServer; ++serverIndex) {
                int reposIndex;
                boolean bHaveMatch = false;
                BackupRepositoryImpl newRepository = null;
                Element serverRepository = null;
                Element restoreRepository = null;
                Element backupRepository = null;
                Element testRepository = null;
                serverRepository = (Element)serverRepositoryElementList.item(serverIndex);
                String serverRepositoryName = this.getAttribute("Name", serverRepository);
                for (reposIndex = 0; reposIndex < maxIndexInRestore; ++reposIndex) {
                    testRepository = (Element)restoreRepositoryElementList.item(reposIndex);
                    if (testRepository == null || !this.getAttribute("Name", testRepository).equals(serverRepositoryName)) continue;
                    bHaveMatch = true;
                    restoreRepository = testRepository;
                    break;
                }
                for (reposIndex = 0; reposIndex < maxIndexInBackup; ++reposIndex) {
                    testRepository = (Element)backupRepositoryElementList.item(reposIndex);
                    if (testRepository == null || !this.getAttribute("Name", testRepository).equals(serverRepositoryName)) continue;
                    bHaveMatch = true;
                    backupRepository = testRepository;
                    break;
                }
                newRepository = new BackupRepositoryImpl(serverRepository, backupRepository, restoreRepository, this);
                this.allRepositories.add(newRepository);
                this.fileCount += newRepository.getFileCount();
                this.computedFileSize += newRepository.getSize();
            }
        }
        if (this.name != null && this.name.length() > 0) {
            this.haveDetails = true;
        }
    }

    public void refreshDetails() throws ServiceException {
        this.haveDetails = false;
        this.getDetails(null);
    }

    @Override
    public void cancel() throws ServiceException {
        String cancelBackup = "<Cancel Backup=\"\"/>";
        this.doRefresh(cancelBackup);
        this.waitForCompletion();
        this.status = MetadataOperation.Status.CANCELLED;
    }

    @Override
    public boolean isAsynchronous() throws ServiceException {
        return this.isAsynchronous;
    }

    @Override
    public void setAsynchronous(boolean asynchronous) throws ServiceException {
        if (this.status != null && this.status != MetadataOperation.Status.NOT_STARTED) {
            throw new MetadataManagerException(RB.getStringResource("mgmt_impl.operation.error.onlyBeforeExecute.txt"));
        }
        this.isAsynchronous = asynchronous;
    }

    public void addListener(MetadataOperation.Listener listener, Object parm) throws ServiceException {
        this.logDebug("add new listener: " + listener + " parm=" + parm);
        if (this.listeners == null) {
            this.listeners = new ArrayList<MetadataOperation.Listener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void addListener(MetadataOperation.Listener listener) throws ServiceException {
        this.addListener(listener, null);
    }

    @Override
    public void removeListener(MetadataOperation.Listener listener) throws ServiceException {
        this.logDebug("remove listener: " + listener);
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        if (this.listeners != null) {
            for (MetadataOperation.Listener l : this.listeners) {
                this.logDebug("notify listener: " + l);
                l.operationCallback(this);
            }
        }
    }

    @Override
    public void debugDump() throws ServiceException {
        this.debugDump(" status=" + (Object)((Object)this.status) + " directory=" + this.getPath() + " started=" + this.getStartDateTime() + " user=" + this.getStartingUserID() + " isSuccessful=" + this.isSuccessful());
        if (this.haveDetails) {
            this.debugDump(" includeAllConfigFiles=" + this.getIncludeAllConfigFiles() + " comment=\"" + this.getComment() + "\" reorg=" + this.isReorganizeRepositories() + " verify=" + this.getVerify());
            this.debugDump(" isAsynchronous=" + this.isAsynchronous() + " rollForward=" + this.getRollForward() + " pauseComment=\"" + this.getPauseComment() + "\"");
            this.debugDump(" fileCount=" + this.getFileCount() + " fileSize=" + this.getSize());
            this.debugDump("Error Log=\"" + this.getErrorLog() + "\"");
            if (this.backupJournal != null) {
                this.debugDump(" startRollForward=" + this.journalStartDateTime + " endRollForward=" + this.journalEndDateTime + " startEntryNumber=" + this.journalStartEntryNumber + " endEntryNumber=" + this.journalEndEntryNumber);
                this.backupJournal.debugDump();
            }
            if (this.allRepositories != null) {
                for (BackupRepositoryImpl backupRepositoryImpl : this.allRepositories) {
                    backupRepositoryImpl.debugDump();
                }
            }
        }
    }

    @Override
    public String getErrorLog() throws ServiceException {
        int failedCount = 0;
        StringBuffer logText = this.getServerException();
        if (this.allRepositories != null && !this.haveSummarizedErrors) {
            for (BackupRepositoryImpl backupRepositoryImpl : this.allRepositories) {
                if (backupRepositoryImpl.getStatus().equals((Object)MetadataOperation.Status.SUCCESSFUL)) continue;
                ++failedCount;
                String reposErrors = null;
                if (backupRepositoryImpl.serverException != null) {
                    reposErrors = backupRepositoryImpl.serverException.toString();
                }
                if (logText == null) {
                    logText = this.serverException = new StringBuffer();
                }
                logText.append("\n   " + new Message(RB.getResources(), "mgmt_impl.recovery.repositoryFailed.fmt", (Object)backupRepositoryImpl.getName()).toString());
                if (reposErrors == null) continue;
                logText.append(reposErrors);
            }
            this.haveSummarizedErrors = true;
        }
        if (logText != null) {
            return logText.toString();
        }
        return null;
    }

    @Override
    public String getFullReport() throws ServiceException {
        return null;
    }

    public void setLatestRecovery(boolean isLatestRecovery) throws ServiceException {
        this.isLatestRecovery = isLatestRecovery;
        if (isLatestRecovery && this.status != null && !this.status.equals((Object)MetadataOperation.Status.NOT_STARTED)) {
            this.haveDetails = false;
            this.getDetails(null);
        }
    }

    public boolean isLatestRecovery() {
        return this.isLatestRecovery;
    }

    @Override
    public boolean isReorganizeRepositories() throws ServiceException {
        return this.reorg;
    }

    @Override
    public boolean setReorganizeRepositories(boolean doReorg) throws ServiceException {
        if (this.status == null || this.status == MetadataOperation.Status.NOT_STARTED) {
            this.reorg = doReorg;
            return this.reorg;
        }
        throw new MetadataManagerException(RB.getStringResource("mgmt_impl.operation.error.onlyBeforeExecute.txt"));
    }

    @Override
    public Date getJournalStartDateTime() {
        this.checkJournal();
        return this.journalStartDateTime;
    }

    @Override
    public Date getJournalEndDateTime() {
        this.checkJournal();
        return this.journalEndDateTime;
    }

    @Override
    public long getJournalStartEntryNumber() {
        this.checkJournal();
        return this.journalStartEntryNumber;
    }

    @Override
    public long getJournalEndEntryNumber() {
        this.checkJournal();
        return this.journalEndEntryNumber;
    }

    private void checkJournal() {
        long secondsSinceFirstCheck;
        Date thisJournalCheck = new Date();
        if (this.firstJournalCheck == null) {
            this.firstJournalCheck = thisJournalCheck;
        }
        if ((secondsSinceFirstCheck = (thisJournalCheck.getTime() - this.firstJournalCheck.getTime()) / 1000L) > 100L) {
            Document doc = null;
            try {
                doc = this.doStatus(this.journalStats);
                Element omaElement = doc.getDocumentElement();
                String currentJournalPath = this.getAttribute("JOURNALPATH", omaElement);
                if (this.backupJournal != null && currentJournalPath.equals(this.backupJournal.getPath())) {
                    String currentJournalEntryCounterString = this.getAttribute("JOURNALENTRYCOUNTER", omaElement);
                    long currentJournalEntryCounter = Long.parseLong(currentJournalEntryCounterString);
                    String currentJournalHistoricalDataString = this.getAttribute("JOURNALHISTORICALDATA", omaElement);
                    long currentJournalHistoricalData = Long.parseLong(currentJournalHistoricalDataString);
                    if (this.journalEndEntryNumber < currentJournalEntryCounter) {
                        this.journalEndEntryNumber = currentJournalEntryCounter - 1L;
                        this.journalEndDateTime = thisJournalCheck;
                    }
                    if (this.journalStartEntryNumber <= 0L) {
                        this.journalStartEntryNumber = 1L;
                        this.journalStartDateTime = this.backup != null ? this.backup.startDateTime : this.firstJournalCheck;
                    }
                    if (currentJournalHistoricalData == 0L) {
                        this.journalEndEntryNumber = 0L;
                        this.journalStartEntryNumber = 0L;
                    }
                }
            }
            catch (Exception e) {
                this.logWarn(new Message(RB.getResources(), "mgmt_impl.recovery.exceptionQueryingJournalStats.fmt", (Object)e).toString());
            }
        }
    }

    @Override
    public double getSize() throws ServiceException {
        if (!this.haveDetails) {
            this.getDetails(null);
        }
        if (this.recordedFileSize >= 0.0) {
            return this.recordedFileSize;
        }
        return this.computedFileSize;
    }

    public long getFileCount() throws ServiceException {
        if (!this.haveDetails) {
            this.getDetails(null);
        }
        return this.fileCount;
    }

    @Override
    public String getManifestPath() throws ServiceException {
        String path = null;
        if (this.isLatestRecovery) {
            String sep = System.getProperty("file.separator");
            String otherSep = sep.equals("/") ? "\\" : "/";
            MetadataManager mmgr = (MetadataManager)((Object)this.root);
            BackupHistoryImpl history = (BackupHistoryImpl)mmgr.getBackupHistory();
            String serverPath = history.getServerStartPath();
            if (serverPath.indexOf(sep) < 0 && serverPath.indexOf(otherSep) > 0) {
                String swap = sep;
                sep = otherSep;
                otherSep = swap;
            }
            path = serverPath + sep + "MetadataServerRecoveryManifest.xml";
        } else {
            path = RB.getStringResource("mgmt_impl.recovery.onlyMostRecentRecoveryManifestIsAvailable.txt");
        }
        return path;
    }

    @Override
    public void setVerify(boolean doVerify) throws ServiceException {
        if (this.status != null && this.status != MetadataOperation.Status.NOT_STARTED) {
            throw new MetadataManagerException(RB.getStringResource("mgmt_impl.operation.error.onlyBeforeExecute.txt"));
        }
        this.doVerify = doVerify;
    }

    @Override
    public boolean getVerify() {
        return this.doVerify;
    }

    @Override
    public String getGUID() throws ServiceException {
        if (this.GUID == null) {
            this.getDetails(null);
        }
        return this.GUID;
    }

    private void checkGUID() throws ServiceException {
        BackupHistoryImpl history = (BackupHistoryImpl)this.parent;
        String historyGUID = history.getGUID();
        if (historyGUID != null && this.GUID != null && !historyGUID.equals(this.GUID)) {
            this.addServerException("\n" + new Message(RB.getResources(), "mgmt_impl.recovery.mismatchedGUIDwithServer.fmt", (Object)this.GUID, (Object)historyGUID).toString());
        }
    }

    @Override
    public boolean isGUIDValid() throws ServiceException {
        BackupHistoryImpl history = (BackupHistoryImpl)this.parent;
        String historyGUID = history.getGUID();
        return historyGUID != null && this.GUID != null && historyGUID.equals(this.GUID);
    }

    @Override
    public double getTimezoneOffset() {
        return this.timezoneOffset;
    }

    @Override
    public String getTimezoneName() {
        return this.timezoneName;
    }

    @Override
    public void operationCallback(MetadataOperation operation) {
        this.notifyListeners();
    }
}

