/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt.impl;

import com.sas.metadata.mgmt.Backup;
import com.sas.metadata.mgmt.BackupRecovery;
import com.sas.metadata.mgmt.BackupRepository;
import com.sas.metadata.mgmt.MetadataManager;
import com.sas.metadata.mgmt.MetadataManagerException;
import com.sas.metadata.mgmt.MetadataOperation;
import com.sas.metadata.mgmt.impl.BackupHistoryImpl;
import com.sas.metadata.mgmt.impl.BackupRecoveryImpl;
import com.sas.metadata.mgmt.impl.BackupRepositoryImpl;
import com.sas.metadata.mgmt.impl.FileImpl;
import com.sas.metadata.mgmt.impl.ImplFromXMLElement;
import com.sas.metadata.mgmt.impl.RB;
import com.sas.services.ServiceException;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.SimpleTimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BackupImpl
extends ImplFromXMLElement
implements Backup {
    private static String getLastBackup = "       <MetadataServerBackupHistory XPath=\"MetadataServerBackupManifest/Backups/Backup[POSITION()=LAST()]\"/>\n";
    private String executeException = null;
    String directory = null;
    boolean isRunning = false;
    double percentCompletion = 0.0;
    List<BackupRepository> allRepositories = null;
    List<FileImpl> allConfigurationFiles = null;
    Date startDateTime = null;
    String startingUserID = null;
    MetadataOperation.Status status = MetadataOperation.Status.NOT_STARTED;
    String statusString = null;
    boolean hasBeenValidated = false;
    boolean isValid = false;
    boolean isOffline = false;
    private String validateException = null;
    private boolean haveDetails = false;
    private boolean isInHistory = false;
    private List<MetadataOperation.Listener> listeners = null;
    protected boolean isAsynchronous = false;
    private String fullReport = null;
    boolean reorg = false;
    String comment = null;
    String expiredString = null;
    Date expiredDateTime = null;
    double expiredDateTimeTimeZoneOffset = 0.0;
    String lastVerifyStatus = null;
    Date lastVerifyDateTime = null;
    double recordedFileSize = -1.0;
    double computedFileSize = 0.0;
    long computedFileCount = 0L;
    private String GUID = null;
    double timezoneOffset = 0.0;
    String timezoneName = null;

    @Override
    public String getStaticObjectType() {
        return "Backup";
    }

    public BackupImpl(Element realElement, ImplFromXMLElement container) {
        super(realElement, container);
        if (realElement != null) {
            this.setup(realElement, container);
        }
    }

    protected void setStatusString(String description) {
        if (description != null && description.length() > 0) {
            this.statusString = description;
            this.status = MetadataOperation.Status.getStatus(description);
        }
    }

    protected void setStatus(MetadataOperation.Status status) {
        this.status = status;
        this.statusString = status.description();
    }

    @Override
    protected void mapAttributes() {
        String lastVerifyDateTimeString;
        String test = null;
        if (this.GUID == null) {
            this.GUID = this.getAttribute("GUID");
        }
        this.name = this.getAttribute("Name");
        if ((this.directory == null || this.directory.length() == 0) && (test = this.getAttribute("Directory")) != null && test.length() > 0) {
            this.directory = test;
        }
        String statusString = this.getAttribute("Status");
        this.setStatusString(statusString);
        this.comment = this.getAttribute("Comment");
        test = this.getAttribute("Reorg");
        this.reorg = test != null && test.length() > 0 ? test.substring(0, 1).equalsIgnoreCase("Y") : false;
        String startDateTimeString = this.getAttribute("StartDateTime");
        if (startDateTimeString != null) {
            this.startDateTime = this.parseISO8601DateTime(startDateTimeString, "StartDateTime");
            this.timezoneOffset = this.getISO8601DateTimeTimezoneOffset(startDateTimeString, "StartDateTime");
            this.timezoneName = this.getISO8601DateTimeTimezoneName(startDateTimeString, "StartDateTime");
        }
        this.startingUserID = this.getAttribute("StartingUserID");
        String sizeString = this.getAttribute("Size");
        if (sizeString != null) {
            try {
                this.recordedFileSize = Double.parseDouble(sizeString);
            }
            catch (Exception e) {
                this.logDebug("Backup named " + this.name + " has a suspicious Size: " + sizeString);
            }
        }
        this.expiredString = this.getAttribute("Expired");
        if (this.expiredString != null) {
            this.expiredDateTime = this.parseISO8601DateTime(this.expiredString, "Expired");
            this.expiredDateTimeTimeZoneOffset = this.getISO8601DateTimeTimezoneOffset(this.expiredString, "Expired");
        }
        this.lastVerifyStatus = this.getAttribute("LastVerifyStatus");
        if (this.lastVerifyStatus != null && this.lastVerifyStatus.length() > 0 && !this.hasBeenValidated) {
            if (this.lastVerifyStatus.equals(ATTRIBUTE_VALUE_SUCCESSFUL)) {
                this.isValid = true;
                this.isOffline = false;
            } else if (this.lastVerifyStatus.equals(ATTRIBUTE_VALUE_FAILED)) {
                this.isValid = false;
                this.isOffline = false;
            } else if (this.lastVerifyStatus.equals("Offline")) {
                this.isValid = false;
                this.isOffline = true;
            }
            this.hasBeenValidated = true;
        }
        if ((lastVerifyDateTimeString = this.getAttribute("LastVerifyDateTime")) != null) {
            this.lastVerifyDateTime = this.parseISO8601DateTime(lastVerifyDateTimeString, "LastVerifyDateTime");
            this.hasBeenValidated = true;
        }
    }

    @Override
    public boolean isSuccessful() {
        return this.status == MetadataOperation.Status.SUCCESSFUL;
    }

    @Override
    public MetadataOperation.Status execute() throws ServiceException {
        String lastBackupName;
        Element anElement = null;
        NodeList backupElementsList = null;
        Element backupElement = null;
        this.serverException = null;
        this.executeException = null;
        this.logInfo(RB.getStringResource("mgmt_impl.backup.backupWillBeRequested.txt"));
        this.logDebug("Begin executing backup: " + this);
        Document doc = this.doStatus(getLastBackup);
        if (doc != null) {
            anElement = doc.getDocumentElement();
            backupElementsList = anElement.getElementsByTagName("Backup");
            if (backupElementsList.getLength() > 0) {
                backupElement = (Element)backupElementsList.item(0);
            }
            lastBackupName = this.getAttribute("Name", backupElement);
        } else {
            lastBackupName = "UNKNOWN";
        }
        this.status = MetadataOperation.Status.NOT_STARTED;
        String encodedComment = null;
        try {
            encodedComment = this._factory.getOMIUtil().cleanStringForXML(this.comment);
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
            throw new MetadataManagerException(RB.getStringResource("mgmt_impl.operation.error.exceptionEncodingComment.txt"));
        }
        String commentAttributeString = "";
        if (this.comment != null) {
            commentAttributeString = " Comment=\"" + encodedComment + "\"";
        }
        String reorgAttributeString = "";
        if (this.reorg) {
            reorgAttributeString = " Reorg=\"Yes\"";
        }
        String initiateBackup = "<Backup" + commentAttributeString + reorgAttributeString + "/>";
        doc = this.doRefresh(initiateBackup);
        this.logInfo(RB.getStringResource("mgmt_impl.backup.backupRequested.txt"));
        this.isRunning = false;
        while (!this.isRunning) {
            String newLastBackupName;
            doc = this.doStatus(getLastBackup);
            if (doc != null) {
                anElement = doc.getDocumentElement();
                backupElementsList = anElement.getElementsByTagName("Backup");
                if (backupElementsList.getLength() > 0) {
                    backupElement = (Element)backupElementsList.item(0);
                }
                newLastBackupName = this.getAttribute("Name", backupElement);
            } else {
                newLastBackupName = "UNKNOWN";
            }
            if (!newLastBackupName.equals(lastBackupName)) {
                this.logDebug("last Backup name has changed, which means that newly requested backup is already done.");
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.getPercentCompletion();
        }
        this.logInfo(RB.getStringResource("mgmt_impl.backup.backupStarted.txt"));
        do {
            try {
                Thread.sleep(500L);
                doc = this.doStatus(getLastBackup);
                if (doc != null) {
                    anElement = doc.getDocumentElement();
                    backupElementsList = anElement.getElementsByTagName("Backup");
                    if (backupElementsList.getLength() <= 0) continue;
                    backupElement = (Element)backupElementsList.item(0);
                    this.name = this.getAttribute("Name", backupElement);
                    if (this.name.equals("UNKNOWN") || this.name.equals(lastBackupName)) continue;
                    this.setStatusString(this.getAttribute("Status", backupElement));
                    if (this.status == MetadataOperation.Status.STARTED) continue;
                    this.getDetails(backupElement);
                    continue;
                }
                this.name = "UNKNOWN";
            }
            catch (InterruptedException e) {
                this.name = "UNKNOWN";
                e.printStackTrace();
            }
        } while (this.name.equals("UNKNOWN") || this.name.equals(lastBackupName));
        if (this.status == MetadataOperation.Status.NOT_STARTED) {
            this.setStatus(MetadataOperation.Status.STARTED);
        }
        if (this.status == MetadataOperation.Status.STARTED) {
            this.logInfo(new Message(RB.getResources(), "mgmt_impl.backup.backupStarted.fmt", (Object)this.name).toString());
            if (!this.isAsynchronous) {
                this.waitForCompletion();
            } else {
                Runnable waiter = new Runnable(){

                    @Override
                    public void run() {
                        BackupImpl.this.logInfo(RB.getStringResource("mgmt_impl.backup.waitingForCompletion.txt"));
                        while (BackupImpl.this.isRunning) {
                            try {
                                Thread.sleep(500L);
                                BackupImpl.this.waitForCompletion();
                            }
                            catch (ServiceException e) {
                                e.printStackTrace();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                };
                waiter.run();
            }
        } else {
            this.logInfo(new Message(RB.getResources(), "mgmt_impl.backup.isComplete.fmt", (Object)this.name, (Object)this.status.description()).toString());
        }
        return this.status;
    }

    protected MetadataOperation.Status waitForCompletion() throws ServiceException {
        this.getPercentCompletion();
        Document doc = null;
        Element anElement = null;
        while (this.status == MetadataOperation.Status.STARTED && this.isRunning) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.getPercentCompletion();
            doc = this.doStatus(getLastBackup);
            anElement = doc.getDocumentElement();
            NodeList backupElementsList = anElement.getElementsByTagName("Backup");
            if (backupElementsList.getLength() > 0) {
                Element backupElement = (Element)backupElementsList.item(0);
                this.setStatusString(this.getAttribute("Status", backupElement));
            }
            this.notifyListeners();
            this.logDebug(new Message(RB.getResources(), "mgmt_impl.backup.isRunning.fmt", (Object)this.name, (Object)new Boolean(this.isRunning).toString(), (Object)new Double(this.percentCompletion).toString(), (Object)this.statusString).toString());
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.getDetails(null);
        this.logInfo(new Message(RB.getResources(), "mgmt_impl.backup.isComplete.fmt", (Object)this.name, (Object)this.status.description()).toString());
        this.getErrorLog();
        if (this.serverException != null) {
            this.logError(new Message(RB.getResources(), "mgmt_impl.backup.serviceException.fmt", (Object)this.name, (Object)this.serverException).toString());
        }
        if (this.serverException != null && this.serverException.length() > 0) {
            this.executeException = this.serverException.toString() + "\n";
            this.serverException = null;
        }
        this.notifyListeners();
        return this.status;
    }

    @Override
    public String getPath() throws ServiceException {
        if (this.directory == null) {
            this.getDetails(null);
        }
        return this.directory;
    }

    @Override
    public void setPath(String backupPath) throws ServiceException {
        this.directory = backupPath;
    }

    @Override
    public void register() throws ServiceException {
        String tf;
        String unregisteredName;
        this.name = unregisteredName = RB.getStringResource("mgmt_impl.backup.unregistered.txt");
        boolean backupRegisterByManifest = false;
        String backupRegisterByManifestValue = System.getProperty("com.sas.metadata.mgmt.impl.backupRegisterByManifest");
        if (backupRegisterByManifestValue != null && new String("ty1").indexOf(tf = backupRegisterByManifestValue.toLowerCase().substring(0, 1)) > -1) {
            backupRegisterByManifest = true;
        }
        String whatToQuery = backupRegisterByManifest ? "MetadataServerBackupManifest" : "MetadataServerBackupHistory";
        String REGISTER_BACKUP = "    <" + whatToQuery + "\n     BackupPath=\"" + this.directory + "\"/>\n";
        String REGISTER_BACKUP_DO = " <Status>\n   <Metadata>\n    <" + whatToQuery + "\n     BackupPath=\"" + this.directory + "\"/>\n   </Metadata>\n   <Options>\n    <VerifyBackups/>\n   </Options>\n  </Status>";
        Document doc = null;
        MetadataManager.ServerState state = ((MetadataManager)((Object)this.root)).getServerState();
        doc = state == MetadataManager.ServerState.OFFLINE ? this.doRequestWithExclusiveServerLock(REGISTER_BACKUP_DO) : this.doStatus(REGISTER_BACKUP, "<VerifyBackups/>");
        if (doc != null) {
            Element verifyElement = doc.getDocumentElement();
            NodeList backupElementList = verifyElement.getElementsByTagName("Backup");
            Element thisBackupElement = null;
            int maxIndex = backupElementList.getLength();
            for (int index = 0; index < maxIndex; ++index) {
                Node aNode = backupElementList.item(index);
                short nodeType = aNode.getNodeType();
                String nodeName = new String(aNode.getNodeName());
                if (nodeType != 1 || !nodeName.equals("Backup") || !this.name.equals(unregisteredName) && !this.getAttribute("Name", (Element)aNode).equals(this.name)) continue;
                thisBackupElement = (Element)aNode;
                this.name = this.getAttribute("Name", thisBackupElement);
                String statusString = this.getAttribute("Status", thisBackupElement);
                this.setStatusString(statusString);
                String isValidString = this.getAttribute("Verify", thisBackupElement);
                this.isValid = isValidString.equals(MetadataOperation.Status.SUCCESSFUL.description());
                this.isOffline = isValidString.equalsIgnoreCase("Offline");
                this.hasBeenValidated = true;
                break;
            }
        } else {
            this.isValid = false;
            this.isOffline = true;
            this.setStatus(MetadataOperation.Status.FAILED);
            ((BackupHistoryImpl)this.parent).forgetBackup(this);
        }
    }

    @Override
    public Double getPercentCompletion() {
        if (this.status == MetadataOperation.Status.STARTED || this.status == MetadataOperation.Status.NOT_STARTED) {
            long bytesToBackup = 0L;
            long bytesBackedUp = 0L;
            String queryProgress = "<Backup BytesToBackup=\"\" BytesBackedUp=\"\" IsRunning=\"\"/>\n";
            Document doc = this.doStatus(queryProgress);
            if (doc != null) {
                Element backupElement = doc.getDocumentElement();
                String done = this.getAttribute("BytesBackedUp", backupElement);
                String toDo = this.getAttribute("BytesToBackup", backupElement);
                String isRunningString = this.getAttribute("IsRunning", backupElement);
                if (isRunningString != null && isRunningString.length() > 0) {
                    boolean bl = this.isRunning = isRunningString.toLowerCase().charAt(0) == 'y';
                }
                if (done != null && done.length() > 0) {
                    bytesBackedUp = Double.valueOf(done).longValue();
                }
                if (toDo != null && toDo.length() > 0) {
                    bytesToBackup = Double.valueOf(toDo).longValue();
                }
                this.percentCompletion = bytesToBackup > 0L ? (double)bytesBackedUp * 100.0 / (double)bytesToBackup : 0.0;
            }
        } else {
            this.percentCompletion = 100.0;
            this.isRunning = false;
        }
        return new Double(this.percentCompletion);
    }

    @Override
    public BackupRecovery getRecovery() throws ServiceException {
        if (!this.haveDetails) {
            this.getDetails(null);
        }
        if (this.name != null) {
            BackupRecoveryImpl newRecovery = (BackupRecoveryImpl)((BackupHistoryImpl)this.parent).newBackupRecovery(this);
            newRecovery.setBackup(this);
            return newRecovery;
        }
        MetadataManagerException e = new MetadataManagerException(RB.getStringResource("mgmt_impl.backup.error.noName.txt"));
        throw e;
    }

    @Override
    public List<BackupRepository> getRepositories() throws ServiceException {
        if (!this.haveDetails) {
            this.getDetails(null);
        }
        if ((this.allRepositories == null || this.allRepositories.size() == 0) && this.isOffline) {
            return null;
        }
        if (this.allRepositories != null) {
            return Collections.unmodifiableList(this.allRepositories);
        }
        return new ArrayList<BackupRepository>();
    }

    @Override
    public Date getStartDateTime() throws ServiceException {
        if (this.startDateTime == null) {
            this.getDetails(null);
        }
        return this.startDateTime;
    }

    @Override
    public String getStartingUserID() throws ServiceException {
        if (this.startingUserID == null) {
            this.getDetails(null);
        }
        return this.startingUserID;
    }

    @Override
    public MetadataOperation.Status getStatus() throws ServiceException {
        if (this.status == MetadataOperation.Status.STARTED) {
            Document doc;
            Element anElement;
            NodeList backupElementsList;
            if (this.isRunning) {
                this.getPercentCompletion();
                if (this.isRunning) {
                    return this.status;
                }
            }
            if ((backupElementsList = (anElement = (doc = this.doStatus(getLastBackup)).getDocumentElement()).getElementsByTagName("Backup")).getLength() > 0) {
                Element backupElement = (Element)backupElementsList.item(0);
                this.setStatusString(this.getAttribute("Status", backupElement));
                if (this.status != MetadataOperation.Status.STARTED) {
                    this.getDetails(backupElement);
                }
            }
        }
        return this.status;
    }

    @Override
    public boolean isValid() throws ServiceException {
        if (!this.hasBeenValidated) {
            this.validate();
        }
        return this.isValid;
    }

    @Override
    public boolean isOffline() throws ServiceException {
        if (!this.hasBeenValidated || this.expiredDateTime != null && this.lastVerifyDateTime != null && this.expiredDateTime.compareTo(this.lastVerifyDateTime) > 0) {
            this.validate();
        }
        return this.isOffline;
    }

    @Override
    public boolean validate() throws ServiceException {
        if (this.status == MetadataOperation.Status.STARTED) {
            this.isValid = false;
            return this.isValid;
        }
        if (this.directory == null || this.name == null) {
            if (!this.haveDetails) {
                this.getDetails(null);
                if (this.haveDetails && this.hasBeenValidated) {
                    return this.isValid;
                }
            }
            if (!this.haveDetails) {
                this.isValid = false;
                return this.isValid;
            }
        }
        String VERIFY_BACKUP_BY_HISTORY = "    <MetadataServerBackupHistory \n         XPath=\"MetadataServerBackupManifest/Backups/Backup[@Directory='" + this.directory + "']\"/>\n";
        String VERIFY_BACKUP_BY_MANIFEST = "    <MetadataServerBackupManifest\n     BackupPath=\"" + this.directory + "\"/>\n";
        this.serverException = null;
        this.validateException = null;
        Document doc = this.doStatus(VERIFY_BACKUP_BY_HISTORY, "<VerifyBackups/>");
        if (doc == null && this.status != MetadataOperation.Status.STARTED) {
            doc = this.doStatus(VERIFY_BACKUP_BY_MANIFEST, "<VerifyBackups/>");
            this.isInHistory = false;
        } else {
            this.isInHistory = true;
        }
        if (doc != null) {
            this.processVerification(doc);
            if (!this.isOffline && this.status != MetadataOperation.Status.STARTED) {
                doc = this.doStatus(VERIFY_BACKUP_BY_MANIFEST, "<VerifyBackups/>");
                this.processVerification(doc);
            }
        } else {
            this.isOffline = true;
            this.isValid = false;
        }
        if (this.serverException != null && this.serverException.length() > 0) {
            this.validateException = this.serverException.toString() + "\n";
            this.serverException = null;
        }
        if (this.expiredDateTime != null) {
            DateFormat df = DateFormat.getDateTimeInstance(2, 2);
            SimpleTimeZone tz = new SimpleTimeZone((int)this.expiredDateTimeTimeZoneOffset, "");
            df.setTimeZone(tz);
            String expiredDateTimeStr = df.format(this.expiredDateTime);
            this.validateException = (this.validateException != null ? this.validateException : "") + new Message(RB.getResources(), "mgmt_impl.backup.expired.fmt", (Object)expiredDateTimeStr).toString() + "\n";
        }
        return this.isValid;
    }

    private void processVerification(Document doc) throws ServiceException {
        Element thisBackupElement = null;
        if (doc != null) {
            Element verifyElement = doc.getDocumentElement();
            NodeList backupElementList = verifyElement.getElementsByTagName("Backup");
            int maxIndex = backupElementList.getLength();
            for (int index = 0; index < maxIndex; ++index) {
                Node aNode = backupElementList.item(index);
                short nodeType = aNode.getNodeType();
                String nodeName = new String(aNode.getNodeName());
                if (nodeType != 1 || !nodeName.equals("Backup")) continue;
                if (!this.isInHistory && this.name == null) {
                    this.name = this.getAttribute("Name", (Element)aNode);
                }
                if (!this.getAttribute("Name", (Element)aNode).equals(this.name)) continue;
                thisBackupElement = (Element)aNode;
                String isValidString = this.getAttribute("Verify", thisBackupElement);
                this.isValid = isValidString.equals(MetadataOperation.Status.SUCCESSFUL.description());
                this.isOffline = isValidString.equalsIgnoreCase("Offline");
                this.haveDetails = false;
                if (this.serverException == null || this.serverException.length() == 0) {
                    this.checkGUID();
                }
                this.getDetails(thisBackupElement, verifyElement);
                this.hasBeenValidated = true;
                break;
            }
        } else {
            this.isOffline = true;
            this.isValid = false;
        }
        if (thisBackupElement == null) {
            this.validateException = new Message(RB.getResources(), "mgmt_impl.backup.manifestIsMissing.fmt", (Object)"Backup").toString() + "\n";
        }
        if (this.serverException != null && this.serverException.length() > 0) {
            this.validateException = this.serverException.toString() + "\n";
            this.serverException = null;
        }
    }

    public boolean isInHistory() {
        return this.isInHistory;
    }

    public void setIsInHistory(boolean isInHistory) {
        this.isInHistory = isInHistory;
    }

    public void refreshDetails() throws ServiceException {
        this.haveDetails = false;
        this.getDetails(null, null);
    }

    @Override
    public void getDetails(Element backupElement) throws ServiceException {
        this.getDetails(backupElement, null);
    }

    public void getDetails(Element backupElement, Element manifestElement) throws ServiceException {
        int maxIndex;
        if (this.isOffline || this.name == null && this.directory == null || this.haveDetails && backupElement == null) {
            return;
        }
        boolean bGetManifestFromBackupPath = this.directory != null && this.status != MetadataOperation.Status.STARTED;
        String GET_BACKUP_DETAILS = "      <MetadataServerBackupManifest " + (!bGetManifestFromBackupPath ? "          BackupName=\"" + this.name + "\"/>\n" : "          BackupPath=\"" + this.directory + "\"/>\n");
        Element thisBackupElement = null;
        if (this.isRunning) {
            this.getPercentCompletion();
        }
        if (backupElement != null) {
            this.domElement = backupElement;
            thisBackupElement = backupElement;
        }
        if (!(this.isRunning || this.status == MetadataOperation.Status.STARTED || manifestElement != null && thisBackupElement != null)) {
            Document doc = this.doStatus(GET_BACKUP_DETAILS);
            if (doc == null) {
                this.haveDetails = true;
                this.isValid = false;
                this.isOffline = true;
                this.isInHistory = true;
            }
            if (doc != null) {
                this.isInHistory = true;
                manifestElement = doc.getDocumentElement();
                NodeList backupsElementsList = manifestElement.getElementsByTagName("Backups");
                if (backupsElementsList.getLength() > 0) {
                    Element backupsElement = (Element)backupsElementsList.item(0);
                    NodeList backupElementList = backupsElement.getChildNodes();
                    maxIndex = backupElementList.getLength();
                    for (int index = 0; index < maxIndex; ++index) {
                        Node aNode = backupElementList.item(index);
                        short nodeType = aNode.getNodeType();
                        String nodeName = new String(aNode.getNodeName());
                        if (nodeType != 1 || !nodeName.equals("Backup")) continue;
                        String testName = this.getAttribute("Name", (Element)aNode);
                        String testDirectory = this.getAttribute("Directory", (Element)aNode);
                        if (this.name == null && testName != null && testDirectory.equals(this.directory)) {
                            this.name = testName;
                        }
                        if (this.name == null && bGetManifestFromBackupPath && maxIndex == 1) {
                            int ix = this.directory.lastIndexOf(47);
                            if (ix == -1) {
                                ix = this.directory.lastIndexOf(92);
                            }
                            if (ix > 0 && this.directory.length() > ix) {
                                this.name = this.directory.substring(ix + 1);
                            }
                        }
                        if (!testName.equals(this.name)) continue;
                        thisBackupElement = (Element)aNode;
                        break;
                    }
                }
            }
        }
        if (manifestElement != null && thisBackupElement != null) {
            NodeList backupConfigurationFilesElementList = null;
            if (manifestElement != null) {
                long value;
                String valueString;
                NodeList fileElementList;
                Element configurationFilesElement = null;
                NodeList serverElementsList = manifestElement.getElementsByTagName("MetadataServer");
                if (serverElementsList.getLength() > 0) {
                    Element serverElement = (Element)serverElementsList.item(0);
                    if (serverElement != null && (this.GUID == null || this.GUID.length() == 0)) {
                        this.GUID = this.getAttribute("GUID", serverElement);
                        this.checkGUID();
                    }
                    NodeList serverRepositoryElementList = serverElement.getElementsByTagName("Repository");
                    NodeList backupRepositoryElementList = null;
                    NodeList backupConfigurationFilesList = null;
                    if (thisBackupElement != null) {
                        backupRepositoryElementList = thisBackupElement.getElementsByTagName("Repository");
                        backupConfigurationFilesList = thisBackupElement.getElementsByTagName("ConfigurationFiles");
                        if (backupConfigurationFilesList.getLength() > 0) {
                            configurationFilesElement = backupConfigurationFilesList.getLength() > 0 ? (Element)backupConfigurationFilesList.item(0) : null;
                            backupConfigurationFilesElementList = configurationFilesElement != null ? configurationFilesElement.getElementsByTagName("File") : null;
                        }
                        this.domElement = thisBackupElement;
                        this.mapAttributes();
                    } else if (!this.status.equals((Object)MetadataOperation.Status.CANCELLED)) {
                        MetadataManagerException e = new MetadataManagerException(RB.getStringResource("mgmt_impl.backup.error.missingManifestDetail.txt"));
                        throw e;
                    }
                    this.computedFileCount = 0L;
                    this.computedFileSize = 0.0;
                    this.allRepositories = new ArrayList<BackupRepository>();
                    int maxIndexInServer = serverRepositoryElementList != null ? serverRepositoryElementList.getLength() : 0;
                    int maxIndexInBackup = backupRepositoryElementList != null ? backupRepositoryElementList.getLength() : 0;
                    maxIndex = Math.max(maxIndexInServer, maxIndexInBackup);
                    for (int serverIndex = 0; serverIndex < maxIndexInServer; ++serverIndex) {
                        boolean bHaveMatch = false;
                        BackupRepositoryImpl newRepository = null;
                        Element serverRepository = null;
                        Element backupRepository = null;
                        serverRepository = (Element)serverRepositoryElementList.item(serverIndex);
                        String serverRepositoryName = this.getAttribute("Name", serverRepository);
                        for (int backupIndex = 0; backupIndex < maxIndexInBackup; ++backupIndex) {
                            backupRepository = (Element)backupRepositoryElementList.item(backupIndex);
                            if (backupRepository == null || !this.getAttribute("Name", backupRepository).equals(serverRepositoryName)) continue;
                            bHaveMatch = true;
                            break;
                        }
                        newRepository = bHaveMatch ? new BackupRepositoryImpl(serverRepository, backupRepository, null, this) : new BackupRepositoryImpl(serverRepository, null, null, this);
                        this.allRepositories.add(newRepository);
                        this.computedFileCount += newRepository.getFileCount();
                        this.computedFileSize += newRepository.getSize();
                    }
                }
                maxIndex = (fileElementList = backupConfigurationFilesElementList) != null ? fileElementList.getLength() : 0;
                long configurationFileSizeTotal = 0L;
                this.allConfigurationFiles = new ArrayList<FileImpl>();
                for (int fileIndex = 0; fileIndex < maxIndex; ++fileIndex) {
                    Element fileElement = (Element)fileElementList.item(fileIndex);
                    FileImpl file = new FileImpl(fileElement, this);
                    this.allConfigurationFiles.add(file);
                    ++this.computedFileCount;
                    configurationFileSizeTotal = (long)((double)configurationFileSizeTotal + file.getFileSize());
                }
                this.computedFileSize += (double)configurationFileSizeTotal;
                if (configurationFilesElement != null && (valueString = configurationFilesElement.getAttribute("Size")) != null && valueString.length() > 0 && (value = Long.parseLong(valueString)) != configurationFileSizeTotal) {
                    this.logDebug("Configuration files recorded file size of " + value + " which is different than the computed size of " + configurationFileSizeTotal);
                }
                if (this.computedFileSize > 0.0 && this.recordedFileSize > 0.0 && this.computedFileSize != this.recordedFileSize) {
                    this.logWarn(new Message(RB.getResources(), "mgmt_impl.backup.fileSizeDiscrepency.fmt", (Object)new Double(this.computedFileSize).toString(), (Object)new Double(this.recordedFileSize).toString(), (Object)this.name).toString());
                }
                this.haveDetails = true;
            }
        }
    }

    public void addListener(MetadataOperation.Listener listener, Object parm) throws ServiceException {
        if (this.listeners == null) {
            this.listeners = new ArrayList<MetadataOperation.Listener>();
        }
        this.logDebug("add new listener: " + listener + " parm=" + parm);
        this.listeners.add(listener);
    }

    @Override
    public void addListener(MetadataOperation.Listener listener) throws ServiceException {
        this.addListener(listener, null);
    }

    @Override
    public void removeListener(MetadataOperation.Listener listener) throws ServiceException {
        this.logDebug("remove listener: " + listener);
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        if (this.listeners != null) {
            for (MetadataOperation.Listener l : this.listeners) {
                this.logDebug("notify listener: " + l);
                l.operationCallback(this);
            }
        }
    }

    @Override
    public void cancel() throws ServiceException {
        String cancelBackup = "<Cancel Backup=\"\"/>";
        this.doRefresh(cancelBackup);
        this.waitForCompletion();
        this.status = MetadataOperation.Status.CANCELLED;
    }

    @Override
    public boolean isAsynchronous() throws ServiceException {
        return this.isAsynchronous;
    }

    @Override
    public void setAsynchronous(boolean asynchronous) throws ServiceException {
        if (this.status != MetadataOperation.Status.NOT_STARTED) {
            throw new MetadataManagerException(RB.getStringResource("mgmt_impl.operation.error.onlyBeforeExecute.txt"));
        }
        this.isAsynchronous = asynchronous;
    }

    @Override
    public void debugDump() throws ServiceException {
        this.debugDump(" status=" + (Object)((Object)this.status) + " directory=" + this.getPath() + " started=" + this.getStartDateTime() + " user=" + this.getStartingUserID() + " isSuccessful=" + this.isSuccessful());
        if (this.haveDetails) {
            this.debugDump(" reorg=" + this.isReorganizeRepositories() + " isAsynchronous=" + this.isAsynchronous() + " comment=\"" + this.getComment() + "\"");
            this.debugDump(" fileCount=" + this.getFileCount() + " fileSize=" + this.getSize());
            this.debugDump("Error Log=\"" + this.getErrorLog() + "\"");
            if (this.allRepositories != null) {
                for (BackupRepositoryImpl backupRepositoryImpl : this.allRepositories) {
                    backupRepositoryImpl.debugDump();
                }
            }
        }
    }

    @Override
    public String getErrorLog() throws ServiceException {
        StringBuffer verifyErrorLog;
        StringBuffer backupErrorLog;
        int verifyFailedCount;
        int backupErrorCount;
        if (!this.haveDetails) {
            this.getDetails(null);
        }
        String reposBackupErrors = "";
        String reposVerifyErrors = "";
        String fileBackupErrors = "";
        String fileVerifyErrors = "";
        String fileBackupErrorsFull = "";
        String fileVerifyErrorsFull = "";
        StringBuffer backupErrorFullLog = new StringBuffer();
        if (this.allRepositories != null) {
            backupErrorCount = 0;
            verifyFailedCount = 0;
            backupErrorLog = new StringBuffer();
            verifyErrorLog = new StringBuffer();
            for (BackupRepositoryImpl backupRepositoryImpl : this.allRepositories) {
                String thisReposVerifyErrors;
                if (!backupRepositoryImpl.getStatus().equals((Object)MetadataOperation.Status.SUCCESSFUL)) {
                    if (backupErrorCount > 0) {
                        backupErrorLog.append(", ");
                    }
                    backupErrorLog.append("\"" + backupRepositoryImpl.getName() + "\"");
                    ++backupErrorCount;
                }
                if ((thisReposVerifyErrors = backupRepositoryImpl.getVerifyErrors()) != null && thisReposVerifyErrors.length() > 0) {
                    if (verifyFailedCount > 0) {
                        verifyErrorLog.append(", ");
                    }
                    verifyErrorLog.append("\"" + backupRepositoryImpl.getName() + "\"");
                    ++verifyFailedCount;
                }
                if (backupRepositoryImpl.getStatus().equals((Object)MetadataOperation.Status.SUCCESSFUL) && (thisReposVerifyErrors == null || thisReposVerifyErrors.length() <= 0)) continue;
                backupErrorFullLog.append("\n\n" + new Message(RB.getResources(), "mgmt_impl.backup.repositoryWithCopyErrors.fmt", (Object)backupRepositoryImpl.getName()).toString());
                backupErrorFullLog.append("\n");
                backupErrorFullLog.append(backupRepositoryImpl.getFullReport());
            }
            if (verifyFailedCount > 0) {
                reposVerifyErrors = new Message(RB.getResources(), "mgmt_impl.backup.repositoriesWithVerifyErrors.fmt", (Object)verifyErrorLog).toString();
            }
            if (backupErrorCount > 0) {
                reposBackupErrors = new Message(RB.getResources(), "mgmt_impl.backup.repositoriesWithCopyErrors.fmt", (Object)backupErrorLog).toString();
            }
        }
        if (this.allConfigurationFiles != null) {
            backupErrorCount = 0;
            verifyFailedCount = 0;
            backupErrorLog = new StringBuffer();
            verifyErrorLog = new StringBuffer();
            StringBuffer fileBackupErrorFullLog = new StringBuffer();
            StringBuffer stringBuffer = new StringBuffer();
            for (FileImpl file : this.allConfigurationFiles) {
                String fileName = file.getName();
                MetadataOperation.Status fileStatus = file.getStatus();
                if (fileStatus != null && !fileStatus.equals((Object)MetadataOperation.Status.SUCCESSFUL)) {
                    this.status = fileStatus;
                    if (backupErrorCount > 0) {
                        backupErrorLog.append(", ");
                    }
                    backupErrorLog.append("\"" + fileName + "\"");
                    fileBackupErrorFullLog.append("\n          \"" + fileName + "\" " + RB.getStringResource("mgmt_impl.backup.filesWasNotCopied.txt"));
                    ++backupErrorCount;
                }
                String thisFileVerifyErrors = file.getVerifyErrors();
                String thisFileVerifyFullErrors = file.getFullVerifyErrors();
                if (thisFileVerifyErrors == null || thisFileVerifyErrors.length() <= 0) continue;
                if (verifyFailedCount == 0) {
                    verifyErrorLog.append("\n    ");
                } else {
                    verifyErrorLog.append(",\n    ");
                }
                verifyErrorLog.append("\"" + fileName + "\"");
                verifyErrorLog.append(" ");
                verifyErrorLog.append(thisFileVerifyErrors);
                stringBuffer.append("\n          \"" + fileName + "\" ");
                stringBuffer.append(thisFileVerifyFullErrors);
                ++verifyFailedCount;
            }
            if (verifyFailedCount > 0) {
                fileVerifyErrors = new Message(RB.getResources(), "mgmt_impl.backup.filesWithVerifyErrors.fmt", (Object)verifyErrorLog).toString();
                fileVerifyErrorsFull = "     " + new Message(RB.getResources(), "mgmt_impl.backup.filesWithVerifyErrorsFull.fmt", (Object)new Integer(verifyFailedCount).toString(), (Object)stringBuffer.toString()).toString();
            }
            if (backupErrorCount > 0) {
                fileBackupErrors = new Message(RB.getResources(), "mgmt_impl.backup.filesWithCopyErrors.fmt", (Object)backupErrorLog).toString();
                fileBackupErrorsFull = "     " + new Message(RB.getResources(), "mgmt_impl.backup.filesWithCopyErrorsFull.fmt", (Object)new Integer(backupErrorCount).toString(), (Object)fileBackupErrorFullLog.toString()).toString();
            }
            if (verifyFailedCount > 0 || backupErrorCount > 0) {
                backupErrorFullLog.append("\n\n" + RB.getStringResource("mgmt_impl.backup.configurationFiles.txt"));
                if (backupErrorCount > 0) {
                    backupErrorFullLog.append("\n");
                    backupErrorFullLog.append(fileBackupErrorsFull);
                }
                if (verifyFailedCount > 0) {
                    backupErrorFullLog.append("\n");
                    backupErrorFullLog.append(fileVerifyErrorsFull);
                }
            }
        }
        String result = (this.serverException != null && this.serverException.length() > 0 ? this.serverException : "") + (this.executeException != null && this.executeException.length() > 0 ? this.executeException : "") + (this.validateException != null && this.validateException.length() > 0 ? this.validateException : "") + (reposBackupErrors.length() > 0 ? "\n" + reposBackupErrors : "") + (reposVerifyErrors.length() > 0 ? "\n" + reposVerifyErrors : "") + (fileBackupErrors.length() > 0 ? "\n" + fileBackupErrors : "") + (fileVerifyErrors.length() > 0 ? "\n" + fileVerifyErrors : "");
        result = result.trim();
        this.fullReport = backupErrorFullLog.toString();
        if (result.length() > 0) {
            return result;
        }
        return "";
    }

    @Override
    public String getFullReport() throws ServiceException {
        if (this.fullReport == null) {
            this.getErrorLog();
        }
        String result = this.fullReport;
        if ((result = result.trim()).length() > 0) {
            return result;
        }
        return null;
    }

    @Override
    public boolean isReorganizeRepositories() throws ServiceException {
        return this.reorg;
    }

    @Override
    public boolean setReorganizeRepositories(boolean doReorg) throws ServiceException {
        if (this.status == MetadataOperation.Status.NOT_STARTED) {
            this.reorg = doReorg;
            return this.reorg;
        }
        throw new MetadataManagerException(RB.getStringResource("mgmt_impl.operation.error.onlyBeforeExecute.txt"));
    }

    @Override
    public String getComment() throws ServiceException {
        return this.comment;
    }

    @Override
    public void setComment(String comment) throws ServiceException {
        if (this.status != MetadataOperation.Status.NOT_STARTED) {
            throw new MetadataManagerException(RB.getStringResource("mgmt_impl.operation.error.onlyBeforeExecute.txt"));
        }
        this.comment = comment;
    }

    @Override
    public double getSize() throws ServiceException {
        if (!(this.haveDetails || !(this.recordedFileSize < 0.0) || this.lastVerifyStatus != null && this.lastVerifyStatus.equals("Offline") || this.expiredDateTime != null)) {
            this.getDetails(null);
        }
        if (this.recordedFileSize >= 0.0) {
            return this.recordedFileSize;
        }
        return this.computedFileSize;
    }

    public long getFileCount() throws ServiceException {
        if (!this.haveDetails) {
            this.getDetails(null);
        }
        return this.computedFileCount;
    }

    @Override
    public String getManifestPath() throws ServiceException {
        if (this.isOffline) {
            return "";
        }
        String sep = System.getProperty("file.separator");
        String otherSep = sep.equals("/") ? "\\" : "/";
        MetadataManager mmgr = (MetadataManager)((Object)this.root);
        BackupHistoryImpl history = (BackupHistoryImpl)mmgr.getBackupHistory();
        String serverPath = history.getServerStartPath();
        int ixSep = serverPath.indexOf(sep);
        int ixOther = serverPath.indexOf(otherSep);
        if (ixSep < 0 && ixOther >= 0) {
            String swap = sep;
            sep = otherSep;
            otherSep = swap;
        }
        char sepChar = sep.charAt(0);
        char otherSepChar = otherSep.charAt(0);
        String directory = this.directory;
        if (directory != null && directory.length() > 1 && directory.indexOf(sepChar) != 0 && directory.indexOf(58) != 1) {
            directory = serverPath + sep + directory;
        }
        if (directory == null) {
            return "";
        }
        directory = directory.replace(otherSepChar, sepChar);
        String path = directory + sep + "MetadataServerBackupManifest.xml";
        return path;
    }

    @Override
    public String getGUID() throws ServiceException {
        if (this.GUID == null) {
            this.getDetails(null);
        }
        return this.GUID;
    }

    private void checkGUID() throws ServiceException {
        BackupHistoryImpl history = (BackupHistoryImpl)this.parent;
        String historyGUID = history.getGUID();
        if (historyGUID != null && this.GUID != null && !historyGUID.equals(this.GUID)) {
            this.addServerException("\n" + new Message(RB.getResources(), "mgmt_impl.backup.mismatchedGUIDwithServer.fmt", (Object)this.GUID, (Object)historyGUID).toString());
            this.isValid = false;
        }
    }

    @Override
    public boolean isGUIDValid() throws ServiceException {
        BackupHistoryImpl history = (BackupHistoryImpl)this.parent;
        String historyGUID = history.getGUID();
        return historyGUID != null && this.GUID != null && historyGUID.equals(this.GUID);
    }

    @Override
    public double getTimezoneOffset() {
        return this.timezoneOffset;
    }

    @Override
    public String getTimezoneName() {
        return this.timezoneName;
    }
}

