/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt.impl;

import com.sas.metadata.mgmt.BackupConfiguration;
import com.sas.metadata.mgmt.MetadataManagerException;
import com.sas.metadata.mgmt.impl.ImplFromXMLElement;
import com.sas.metadata.mgmt.impl.RB;
import com.sas.services.ServiceException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BackupConfigurationImpl
extends ImplFromXMLElement
implements BackupConfiguration {
    private static String BACKUP_CONFIGURATION = "  <BackupConfiguration \n   BackupLocation=\"\"\n   RunScheduledBackups=\"\"\n   DaysToRetainBackups=\"\"\n  />";
    String backupLocation = null;
    boolean runScheduledBackups = false;
    int daysToRetainBackups = 0;
    boolean haveDetails = false;
    private static String ELEMENT_NAME_SCHEDULE = "Schedule";
    private static String ATTRIBUTE_NAME_EVENT = "Event";
    private static String ATTRIBUTE_NAME_WEEKDAY1 = "Weekday1";
    private static String ATTRIBUTE_NAME_WEEKDAY2 = "Weekday2";
    private static String ATTRIBUTE_NAME_WEEKDAY3 = "Weekday3";
    private static String ATTRIBUTE_NAME_WEEKDAY4 = "Weekday4";
    private static String ATTRIBUTE_NAME_WEEKDAY5 = "Weekday5";
    private static String ATTRIBUTE_NAME_WEEKDAY6 = "Weekday6";
    private static String ATTRIBUTE_NAME_WEEKDAY7 = "Weekday7";
    private static String EVENT_NAME_BACKUP = "Backup";
    private String weekday1 = null;
    private String weekday2 = null;
    private String weekday3 = null;
    private String weekday4 = null;
    private String weekday5 = null;
    private String weekday6 = null;
    private String weekday7 = null;
    private String currentWeekday1 = null;
    private String currentWeekday2 = null;
    private String currentWeekday3 = null;
    private String currentWeekday4 = null;
    private String currentWeekday5 = null;
    private String currentWeekday6 = null;
    private String currentWeekday7 = null;

    @Override
    public String getOptions() {
        return null;
    }

    @Override
    public String getStaticObjectType() {
        return "BackupConfiguration";
    }

    public BackupConfigurationImpl(ImplFromXMLElement container) {
        super(null, container);
        this.refresh();
    }

    @Override
    public void refresh() {
        Document doc = null;
        try {
            doc = this.doStatus(BACKUP_CONFIGURATION);
            this.domElement = doc.getDocumentElement();
            this.mapAttributes();
        }
        catch (Exception e) {
            this.logWarn(RB.getStringResource("mgmt_impl.backupConfiguration.error.noBackupConfiguration.txt"));
        }
        try {
            this.refreshBackupSchedule();
        }
        catch (Exception e) {
            this.logWarn(RB.getStringResource("mgmt_impl.backupConfiguration.error.noBackupSchedule.txt"));
        }
        this.haveDetails = true;
    }

    @Override
    protected void mapAttributes() {
        if (this.name == null) {
            this.name = this.getAttribute("Name");
        }
        this.backupLocation = this.getAttribute("BackupLocation");
        String temp = this.getAttribute("RunScheduledBackups");
        this.runScheduledBackups = "YyTt".contains(temp);
        temp = this.getAttribute("DaysToRetainBackups");
        this.daysToRetainBackups = Integer.parseInt(temp);
    }

    @Override
    public String getBackupLocation() {
        return this.backupLocation;
    }

    @Override
    public void setBackupLocation(String value) throws ServiceException {
        this.backupLocation = value;
        this.update();
    }

    @Override
    public boolean getRunScheduledBackups() {
        return this.runScheduledBackups;
    }

    @Override
    public void setRunScheduledBackups(boolean value) throws ServiceException {
        this.runScheduledBackups = value;
        this.update();
    }

    @Override
    public int getDaysToRetainBackups() {
        return this.daysToRetainBackups;
    }

    @Override
    public void setDaysToRetainBackups(int value) throws ServiceException {
        this.daysToRetainBackups = value;
        this.update();
    }

    @Override
    public boolean update() throws ServiceException {
        boolean didSucceed = false;
        String SET_BACKUP_CONFIGURATION = "  <BackupConfiguration \n   BackupLocation=\"" + this.backupLocation + "\"\n   " + "RunScheduledBackups" + "=\"" + (this.runScheduledBackups ? "Y" : "N") + "\"\n   " + "DaysToRetainBackups" + "=\"" + this.daysToRetainBackups + "\"\n  />";
        try {
            this.serverException = null;
            this.lastServerException = null;
            this.doRefresh(SET_BACKUP_CONFIGURATION);
            if (this.lastServerException != null) {
                Exception savedException = this.lastServerException;
                didSucceed = false;
                this.refresh();
                throw new MetadataManagerException(savedException.getMessage());
            }
            didSucceed = true;
        }
        catch (Exception e) {
            didSucceed = false;
            this.refresh();
            throw new MetadataManagerException(e.getMessage());
        }
        if (didSucceed) {
            didSucceed = this.updateBackupSchedule();
        }
        this.refresh();
        return didSucceed;
    }

    public void refreshBackupSchedule() {
        String GET_BACKUP_SCHEDULE = "    <" + ELEMENT_NAME_SCHEDULE + " " + ATTRIBUTE_NAME_EVENT + "=\"" + EVENT_NAME_BACKUP + "\"\n     " + ATTRIBUTE_NAME_WEEKDAY1 + "=\"\"\n     " + ATTRIBUTE_NAME_WEEKDAY2 + "=\"\"\n     " + ATTRIBUTE_NAME_WEEKDAY3 + "=\"\"\n     " + ATTRIBUTE_NAME_WEEKDAY4 + "=\"\"\n     " + ATTRIBUTE_NAME_WEEKDAY5 + "=\"\"\n     " + ATTRIBUTE_NAME_WEEKDAY6 + "=\"\"\n     " + ATTRIBUTE_NAME_WEEKDAY7 + "=\"\"\n    />\n";
        Document doc = this.doStatus(GET_BACKUP_SCHEDULE);
        if (doc != null) {
            Element scheduleElement = doc.getDocumentElement();
            this.setWeekday1(this.getAttribute(ATTRIBUTE_NAME_WEEKDAY1, scheduleElement));
            this.currentWeekday1 = this.weekday1;
            this.setWeekday2(this.getAttribute(ATTRIBUTE_NAME_WEEKDAY2, scheduleElement));
            this.currentWeekday2 = this.weekday2;
            this.setWeekday3(this.getAttribute(ATTRIBUTE_NAME_WEEKDAY3, scheduleElement));
            this.currentWeekday3 = this.weekday3;
            this.setWeekday4(this.getAttribute(ATTRIBUTE_NAME_WEEKDAY4, scheduleElement));
            this.currentWeekday4 = this.weekday4;
            this.setWeekday5(this.getAttribute(ATTRIBUTE_NAME_WEEKDAY5, scheduleElement));
            this.currentWeekday5 = this.weekday5;
            this.setWeekday6(this.getAttribute(ATTRIBUTE_NAME_WEEKDAY6, scheduleElement));
            this.currentWeekday6 = this.weekday6;
            this.setWeekday7(this.getAttribute(ATTRIBUTE_NAME_WEEKDAY7, scheduleElement));
            this.currentWeekday7 = this.weekday7;
        } else {
            this.weekday7 = "";
            this.weekday6 = "";
            this.weekday5 = "";
            this.weekday4 = "";
            this.weekday3 = "";
            this.weekday2 = "";
            this.weekday1 = "";
        }
    }

    public boolean updateBackupSchedule() {
        boolean didSucceed = false;
        if (!(this.weekday1 == null || this.weekday1.equals(this.currentWeekday1) && this.weekday2.equals(this.currentWeekday2) && this.weekday3.equals(this.currentWeekday3) && this.weekday4.equals(this.currentWeekday4) && this.weekday5.equals(this.currentWeekday5) && this.weekday6.equals(this.currentWeekday6) && this.weekday7.equals(this.currentWeekday7))) {
            try {
                String SET_BACKUP_SCHEDULE = "    <" + ELEMENT_NAME_SCHEDULE + " " + ATTRIBUTE_NAME_EVENT + "=\"" + EVENT_NAME_BACKUP + "\"\n     " + ATTRIBUTE_NAME_WEEKDAY1 + "=\"" + this.weekday1 + "\"\n     " + ATTRIBUTE_NAME_WEEKDAY2 + "=\"" + this.weekday2 + "\"\n     " + ATTRIBUTE_NAME_WEEKDAY3 + "=\"" + this.weekday3 + "\"\n     " + ATTRIBUTE_NAME_WEEKDAY4 + "=\"" + this.weekday4 + "\"\n     " + ATTRIBUTE_NAME_WEEKDAY5 + "=\"" + this.weekday5 + "\"\n     " + ATTRIBUTE_NAME_WEEKDAY6 + "=\"" + this.weekday6 + "\"\n     " + ATTRIBUTE_NAME_WEEKDAY7 + "=\"" + this.weekday7 + "\"\n    />\n";
                this.doRefresh(SET_BACKUP_SCHEDULE);
                didSucceed = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                didSucceed = false;
            }
        }
        return didSucceed;
    }

    @Override
    public void debugDump() throws ServiceException {
        this.debugDump(" backupLocation=" + this.getBackupLocation() + " runScheduledBackups=" + this.getRunScheduledBackups() + " daysToRetainBackups=" + this.getDaysToRetainBackups());
        this.debugDump(" The days of the week as strings of backup events is the way the MetadataServer likes it: ");
        this.debugDump(" weekday1=" + this.getWeekday1() + " weekday2=" + this.getWeekday2() + " weekday3=" + this.getWeekday3() + " weekday4=" + this.getWeekday4() + " weekday5=" + this.getWeekday5() + " weekday6=" + this.getWeekday6() + " weekday7=" + this.getWeekday7());
        this.debugDump(" For a human eye, this form makes a bit more sense:");
        this.debugDumpTimeList("weekday1", this.getWeekday1Times());
        this.debugDumpTimeList("weekday2", this.getWeekday2Times());
        this.debugDumpTimeList("weekday3", this.getWeekday3Times());
        this.debugDumpTimeList("weekday4", this.getWeekday4Times());
        this.debugDumpTimeList("weekday5", this.getWeekday5Times());
        this.debugDumpTimeList("weekday6", this.getWeekday6Times());
        this.debugDumpTimeList("weekday7", this.getWeekday7Times());
        this.debugDump("But, a List of ScheduleItems is how clients will want it: ");
        List<BackupConfiguration.ScheduleItem> items = this.getScheduleItems();
        for (BackupConfiguration.ScheduleItem item : items) {
            this.debugDump(" ScheduleItem: hour=" + item.hour + " minute=" + item.minute + " reorganizeRepositories=" + item.reorganizeRepositories + (item.day1 ? " day1" : " ") + (item.day2 ? " day2" : " ") + (item.day3 ? " day3" : " ") + (item.day4 ? " day4" : " ") + (item.day5 ? " day5" : " ") + (item.day6 ? " day6" : " ") + (item.day7 ? " day7" : " "));
        }
    }

    public void debugDumpTimeList(String name, List<String> list) throws ServiceException {
        String line = null;
        if (list == null || list.size() == 0) {
            line = "  " + name + " has no backups scheduled.";
        } else {
            line = "  " + name + " has " + list.size() + " backups scheduled: ";
            Iterator<String> iter = list.iterator();
            while (iter.hasNext()) {
                line = line + " " + iter.next();
            }
        }
        this.debugDump(line);
    }

    private void setWeekday6(String value) {
        this.weekday6 = value;
    }

    private String getWeekday6() {
        return this.weekday6;
    }

    private void setWeekday2(String value) {
        this.weekday2 = value;
    }

    private String getWeekday2() {
        return this.weekday2;
    }

    private void setWeekday7(String value) {
        this.weekday7 = value;
    }

    private String getWeekday7() {
        return this.weekday7;
    }

    private void setWeekday1(String value) {
        this.weekday1 = value;
    }

    private String getWeekday1() {
        return this.weekday1;
    }

    private void setWeekday5(String value) {
        this.weekday5 = value;
    }

    private String getWeekday5() {
        return this.weekday5;
    }

    private void setWeekday3(String value) {
        this.weekday3 = value;
    }

    private String getWeekday3() {
        return this.weekday3;
    }

    private void setWeekday4(String value) {
        this.weekday4 = value;
    }

    private String getWeekday4() {
        return this.weekday4;
    }

    private List<String> getWeekday1Times() {
        return this.parseTimeList(this.weekday1);
    }

    private List<String> getWeekday2Times() {
        return this.parseTimeList(this.weekday2);
    }

    private List<String> getWeekday3Times() {
        return this.parseTimeList(this.weekday3);
    }

    private List<String> getWeekday4Times() {
        return this.parseTimeList(this.weekday4);
    }

    private List<String> getWeekday5Times() {
        return this.parseTimeList(this.weekday5);
    }

    private List<String> getWeekday6Times() {
        return this.parseTimeList(this.weekday6);
    }

    private List<String> getWeekday7Times() {
        return this.parseTimeList(this.weekday7);
    }

    private List<String> parseTimeList(String semiSepList) {
        if (semiSepList != null) {
            semiSepList = semiSepList.trim();
        }
        if (semiSepList == null || semiSepList.length() == 0) {
            return null;
        }
        ArrayList<String> newList = new ArrayList<String>();
        StringTokenizer toker = new StringTokenizer(semiSepList, ",;");
        while (toker.hasMoreElements()) {
            boolean reorganizeRepositories;
            String token = toker.nextToken();
            int rIndex = token.indexOf(82);
            boolean bl = reorganizeRepositories = rIndex > 0;
            if (rIndex > 0) {
                token = token.substring(0, rIndex);
            }
            int intValue = Integer.parseInt(token);
            int hour = intValue / 100;
            int minute = intValue % 100;
            token = (hour < 10 ? "0" : "") + Integer.toString(hour) + ":" + (minute < 10 ? "0" : "") + Integer.toString(minute) + (reorganizeRepositories ? "R" : "");
            newList.add(token);
        }
        return newList;
    }

    @Override
    public void addScheduleItem(Date timeOfDay, boolean[] daysOfWeek, boolean reorganizeRepositories) throws ServiceException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(timeOfDay);
        int hour = cal.get(11);
        int minute = cal.get(12);
        this.addScheduleItem(hour, minute, daysOfWeek, reorganizeRepositories);
    }

    @Override
    public void addScheduleItem(int hour, int minute, boolean day1, boolean day2, boolean day3, boolean day4, boolean day5, boolean day6, boolean day7, boolean reorganizeRepositories) throws ServiceException {
        boolean[] daysOfWeek = new boolean[]{day1, day2, day3, day4, day5, day6, day7};
        this.addScheduleItem(hour, minute, daysOfWeek, reorganizeRepositories);
    }

    @Override
    public void addScheduleItem(String hourminute, boolean day1, boolean day2, boolean day3, boolean day4, boolean day5, boolean day6, boolean day7, boolean reorganizeRepositories) throws ServiceException {
        int ix = hourminute.indexOf(58);
        if (ix <= 0 || ix >= hourminute.length() - 1) {
            throw new ServiceException(RB.getStringResource("mgmt_impl.backupConfiguration.error.badHHMMSyntax.txt"));
        }
        int hour = Integer.parseInt(hourminute.substring(0, ix));
        String temp = hourminute.substring(ix + 1);
        int minute = Integer.parseInt(temp);
        boolean[] daysOfWeek = new boolean[]{day1, day2, day3, day4, day5, day6, day7};
        this.addScheduleItem(hour, minute, daysOfWeek, reorganizeRepositories);
    }

    @Override
    public void addScheduleItem(int hour, int minute, boolean[] daysOfWeek, boolean reorganizeRepositories) throws ServiceException {
        String s;
        String minutesString;
        String hourString = Integer.toString(hour);
        if (hourString.length() < 2) {
            hourString = "0" + hourString;
        }
        if ((minutesString = Integer.toString(minute)).length() < 2) {
            minutesString = "0" + minutesString;
        }
        String spec = hourString + minutesString + (reorganizeRepositories ? "R" : "");
        if (daysOfWeek[0]) {
            s = this.getWeekday1();
            if (s != null && s.length() > 1) {
                s = s + ";";
            }
            s = s + spec;
            this.setWeekday1(s);
        }
        if (daysOfWeek[1]) {
            s = this.getWeekday2();
            if (s != null && s.length() > 1) {
                s = s + ";";
            }
            s = s + spec;
            this.setWeekday2(s);
        }
        if (daysOfWeek[2]) {
            s = this.getWeekday3();
            if (s != null && s.length() > 1) {
                s = s + ";";
            }
            s = s + spec;
            this.setWeekday3(s);
        }
        if (daysOfWeek[3]) {
            s = this.getWeekday4();
            if (s != null && s.length() > 1) {
                s = s + ";";
            }
            s = s + spec;
            this.setWeekday4(s);
        }
        if (daysOfWeek[4]) {
            s = this.getWeekday5();
            if (s != null && s.length() > 1) {
                s = s + ";";
            }
            s = s + spec;
            this.setWeekday5(s);
        }
        if (daysOfWeek[5]) {
            s = this.getWeekday6();
            if (s != null && s.length() > 1) {
                s = s + ";";
            }
            s = s + spec;
            this.setWeekday6(s);
        }
        if (daysOfWeek[6]) {
            s = this.getWeekday7();
            if (s != null && s.length() > 1) {
                s = s + ";";
            }
            s = s + spec;
            this.setWeekday7(s);
        }
    }

    @Override
    public void resetSchedule() throws ServiceException {
        this.setWeekday1("");
        this.setWeekday2("");
        this.setWeekday3("");
        this.setWeekday4("");
        this.setWeekday5("");
        this.setWeekday6("");
        this.setWeekday7("");
    }

    @Override
    public List<BackupConfiguration.ScheduleItem> getScheduleItems() throws ServiceException {
        ArrayList<BackupConfiguration.ScheduleItem> items = new ArrayList<BackupConfiguration.ScheduleItem>();
        HashMap<String, BackupConfiguration.ScheduleItem> timesMap = new HashMap<String, BackupConfiguration.ScheduleItem>();
        this.parseDay(items, timesMap, this.weekday1, 1);
        this.parseDay(items, timesMap, this.weekday2, 2);
        this.parseDay(items, timesMap, this.weekday3, 3);
        this.parseDay(items, timesMap, this.weekday4, 4);
        this.parseDay(items, timesMap, this.weekday5, 5);
        this.parseDay(items, timesMap, this.weekday6, 6);
        this.parseDay(items, timesMap, this.weekday7, 7);
        return items;
    }

    private void parseDay(List<BackupConfiguration.ScheduleItem> items, HashMap<String, BackupConfiguration.ScheduleItem> timesMap, String daySpec, int dayOfWeek) {
        StringTokenizer parser = new StringTokenizer(daySpec, ",;");
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            BackupConfiguration.ScheduleItem item = timesMap.get(token);
            if (item == null) {
                item = new BackupConfiguration.ScheduleItem();
                String hour = token.substring(0, 2);
                String minute = token.substring(2, 4);
                item.hour = Integer.parseInt(hour);
                item.minute = Integer.parseInt(minute);
                item.hourminute = hour + ":" + minute;
                item.reorganizeRepositories = token.indexOf(82) > 0;
                timesMap.put(token, item);
                items.add(item);
            }
            if (dayOfWeek == 1) {
                item.day1 = true;
                continue;
            }
            if (dayOfWeek == 2) {
                item.day2 = true;
                continue;
            }
            if (dayOfWeek == 3) {
                item.day3 = true;
                continue;
            }
            if (dayOfWeek == 4) {
                item.day4 = true;
                continue;
            }
            if (dayOfWeek == 5) {
                item.day5 = true;
                continue;
            }
            if (dayOfWeek == 6) {
                item.day6 = true;
                continue;
            }
            if (dayOfWeek != 7) continue;
            item.day7 = true;
        }
    }
}

