/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt;

public interface Repository {

    public static enum Access {
        ONLINE(0, "Online"),
        READONLY(1, "ReadOnly"),
        ADMINISTRATION(2, "Administration"),
        ADMINISTRATION_READONLY(3, "Administration_Readonly"),
        OFFLINE(4, "Offline"),
        UNCERTAIN(5, "Uncertain");

        private final int access;
        private final String description;

        private Access(int anAccess, String description) {
            this.access = anAccess;
            this.description = description;
        }

        public int access() {
            return this.access;
        }

        public String description() {
            return this.description;
        }

        public static Access getAccess(String accessString) {
            Access access = accessString.equals(ONLINE.description()) ? ONLINE : (accessString.equals(READONLY.description()) ? READONLY : (accessString.equals(ADMINISTRATION.description()) ? ADMINISTRATION : (accessString.equals(ADMINISTRATION_READONLY.description()) ? ADMINISTRATION_READONLY : (accessString.equals(OFFLINE.description()) ? OFFLINE : null))));
            return access;
        }

        public static Access getAccess(int accessInt) {
            Access access = accessInt == Access.ONLINE.access ? ONLINE : (accessInt == Access.READONLY.access ? READONLY : (accessInt == Access.ADMINISTRATION.access ? ADMINISTRATION : (accessInt == Access.ADMINISTRATION_READONLY.access ? ADMINISTRATION_READONLY : (accessInt == Access.OFFLINE.access ? OFFLINE : null))));
            return access;
        }
    }

    public static enum Type {
        FOUNDATION("Foundation"),
        CUSTOM("Custom"),
        PROJECT("Project");

        private final String description;

        private Type(String description) {
            this.description = description;
        }

        public String description() {
            return this.description;
        }

        public static Type getType(String typeString) {
            Type type = typeString.equalsIgnoreCase(FOUNDATION.description()) ? FOUNDATION : (typeString.equalsIgnoreCase(CUSTOM.description()) ? CUSTOM : (typeString.equalsIgnoreCase(PROJECT.description()) ? PROJECT : CUSTOM));
            return type;
        }
    }
}

