/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt;

import com.sas.services.ServiceException;
import java.util.Date;

public interface MetadataOperation {
    public Status execute() throws ServiceException;

    public void cancel() throws ServiceException;

    public boolean isAsynchronous() throws ServiceException;

    public void setAsynchronous(boolean var1) throws ServiceException;

    public Status getStatus() throws ServiceException;

    public String getErrorLog() throws ServiceException;

    public String getFullReport() throws ServiceException;

    public boolean isSuccessful() throws ServiceException;

    public String getStartingUserID() throws ServiceException;

    public Date getStartDateTime() throws ServiceException;

    public Double getPercentCompletion() throws ServiceException;

    public void addListener(Listener var1) throws ServiceException;

    public void removeListener(Listener var1) throws ServiceException;

    public double getSize() throws ServiceException;

    public String getManifestPath() throws ServiceException;

    public static interface Listener {
        public void operationCallback(MetadataOperation var1);
    }

    public static enum Status {
        NOT_STARTED(1, "NotStarted"),
        STARTED(2, "Started"),
        SUCCESSFUL(3, "Successful"),
        FAILED(4, "Failed"),
        CANCELLED(5, "Cancelled"),
        UNCERTAIN(6, "Uncertain");

        private final int status;
        private final String description;

        private Status(int aStatus, String description) {
            this.status = aStatus;
            this.description = description;
        }

        public int status() {
            return this.status;
        }

        public String description() {
            return this.description;
        }

        public static Status getStatus(String statusString) {
            Status status = statusString.equals(NOT_STARTED.description()) ? NOT_STARTED : (statusString.equals(STARTED.description()) ? STARTED : (statusString.equals(SUCCESSFUL.description()) ? SUCCESSFUL : (statusString.equals(FAILED.description()) ? FAILED : (statusString.equals(CANCELLED.description()) ? CANCELLED : null))));
            return status;
        }
    }
}

