/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.mgmt;

import com.sas.metadata.mgmt.MetadataManager;
import com.sas.metadata.mgmt.impl.MetadataManagerImpl;
import com.sas.metadata.remote.MdFactory;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import java.util.HashMap;
import java.util.Map;

public final class MetadataManagerFactory {
    private static Map<Object, MetadataManager> _loadedManagers;

    public static MetadataManager getMetadataManager(SessionContextInterface session) throws ServiceException {
        MetadataManager service;
        if (_loadedManagers == null) {
            _loadedManagers = new HashMap<Object, MetadataManager>();
        } else if (_loadedManagers.containsKey(session)) {
            service = _loadedManagers.get(session);
            if (!service.isDisposed()) {
                return service;
            }
            _loadedManagers.remove(session);
        }
        service = new MetadataManagerImpl(session);
        _loadedManagers.put(session, service);
        return service;
    }

    public static MetadataManager getMetadataManager(MdFactory _factory) throws ServiceException {
        MetadataManager service;
        if (_loadedManagers == null) {
            _loadedManagers = new HashMap<Object, MetadataManager>();
        } else if (_loadedManagers.containsKey(_factory)) {
            service = _loadedManagers.get(_factory);
            if (!service.isDisposed()) {
                return service;
            }
            _loadedManagers.remove(_factory);
        }
        service = new MetadataManagerImpl(_factory);
        _loadedManagers.put(_factory, service);
        return service;
    }

    public static void disposeAll() {
        if (_loadedManagers != null) {
            for (MetadataManager service : _loadedManagers.values()) {
                service.dispose();
            }
            _loadedManagers = null;
        }
    }
}

