/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tk.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;

public class logOutputVMS {
    private static FileOutputStream logfile;
    private static FileOutputStream errlogfile;
    private static PrintStream plogfile;
    private static PrintStream errplogfile;
    private static File parentFile;
    private static File errFile;
    private static PrintStream originalOut;
    private static PrintStream originalErr;
    private static PipedOutputStream logpipe;
    private static PipedInputStream is;
    private static StringBuffer buffer;
    static boolean debug;

    public static synchronized byte[] snapLog() {
        byte[] rc = null;
        try {
            if (buffer.length() > 0) {
                rc = buffer.toString().getBytes();
                if (debug) {
                    System.err.println("Snapped " + buffer.toString());
                    System.err.println("Length = " + rc.length);
                    System.err.println("CP = " + buffer.codePointCount(0, rc.length));
                }
                buffer.delete(0, rc.length);
                if (debug) {
                    System.out.println("Something else after delete");
                    System.err.println("Actual buffer contents now: " + buffer.toString());
                }
            } else {
                if (debug) {
                    System.err.println("Snapped called, nothing in buffer");
                }
                rc = new byte[]{};
            }
        }
        catch (Exception e) {
            rc = new byte[]{};
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int stopLog() {
        int rc = 0;
        try {
            System.setOut(originalOut);
            System.setErr(originalErr);
        }
        catch (SecurityException e) {
            rc = -1;
        }
        if (parentFile == null) {
            return -1;
        }
        if (logfile != null) {
            try {
                logfile.flush();
                logfile.close();
            }
            catch (IOException ioe) {
                rc = -1;
            }
            finally {
                logfile = null;
            }
        }
        if (plogfile != null) {
            plogfile.close();
            plogfile = null;
        }
        try {
            if (logpipe != null) {
                logpipe.close();
            }
            if (is != null) {
                is.close();
            }
        }
        catch (IOException ioe) {
            rc = -1;
        }
        finally {
            logpipe = null;
        }
        if (!debug && parentFile != null) {
            try {
                parentFile.delete();
            }
            catch (SecurityException se) {
                rc = -1;
            }
            finally {
                parentFile = null;
            }
        }
        return rc;
    }

    public static synchronized int startLog(String filename) {
        int rc = 0;
        if (parentFile != null) {
            return -1;
        }
        try {
            parentFile = new File(filename);
            logfile = new FileOutputStream(parentFile);
            logpipe = new PipedOutputStream();
            plogfile = new PrintStream(logpipe);
            buffer = new StringBuffer();
            System.setOut(plogfile);
            if (debug) {
                errFile = new File("/hv/sasdzd/saserr.log");
                errlogfile = new FileOutputStream(errFile);
                errplogfile = new PrintStream(errlogfile);
                System.setErr(errplogfile);
            } else {
                System.setErr(plogfile);
            }
            PipeReader pr = new PipeReader();
            pr.start();
            if (debug) {
                System.err.println("Is anybody listening?");
            }
        }
        catch (IOException e) {
            logOutputVMS.stopLog();
            rc = -1;
        }
        return rc;
    }

    public static int startLog() {
        String filename = System.getProperty("user.home") + "\\Application Data\\SAS\\LOGS\\sasjavaout.log";
        return logOutputVMS.startLog(filename);
    }

    public static int startLog(long n1, long n2) {
        StringBuffer filename = new StringBuffer(256);
        String fileSeparator = System.getProperty("file.separator");
        filename.setLength(0);
        filename.append(System.getProperty("java.io.tmpdir"));
        filename.append(fileSeparator);
        filename.append("sasjava_");
        filename.append(Long.toHexString(n1));
        filename.append("_");
        filename.append(Long.toHexString(n2));
        filename.append(".log");
        int rc = logOutputVMS.startLog(filename.toString());
        return rc;
    }

    public static byte[] getSeparationChars() {
        return System.getProperty("line.separator").getBytes();
    }

    public static byte[] getLogFilename() {
        byte[] rc;
        if (parentFile != null) {
            byte[] byteName = parentFile.getAbsolutePath().getBytes();
            rc = new byte[byteName.length + 1];
            System.arraycopy(byteName, 0, rc, 0, byteName.length);
            rc[byteName.length] = 0;
        } else {
            rc = new byte[]{};
        }
        return rc;
    }

    private logOutputVMS() {
    }

    static {
        errplogfile = null;
        plogfile = null;
        logpipe = null;
        errFile = null;
        parentFile = null;
        originalOut = System.out;
        originalErr = System.err;
        buffer = null;
        debug = false;
    }

    private static class PipeReader
    extends Thread {
        private PipeReader() {
        }

        @Override
        public void run() {
            try {
                is = new PipedInputStream(logpipe);
                byte[] b = new byte[256];
                int i = 0;
                while (true) {
                    try {
                        if (debug) {
                            System.err.println("Reading...");
                        }
                        int len = is.read(b, 0, 256);
                        if (debug) {
                            System.err.println("Got num bytes: " + len);
                        }
                        String s = new String(b, 0, len);
                        if (debug) {
                            System.err.println("Got some data: " + s);
                        }
                        buffer.append(s);
                        logfile.write(b, 0, len);
                    }
                    catch (IOException ex) {
                        String msg = ex.getMessage();
                        if (msg.compareToIgnoreCase("pipe broken") == 0 || msg.compareToIgnoreCase("write end dead") == 0) {
                            System.err.println("");
                        }
                        ex.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
    }
}

