/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.ZoomScrollBar;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalScrollButton;

public class ZoomScrollBarUI
extends BasicScrollBarUI
implements MouseListener,
MouseMotionListener {
    private Color shadowColor;
    private Color darkShadowColor;
    private Color highlightColor;
    private Color thumbColor;
    private Color thumbShadow;
    private Color thumbHighlightColor;
    private static int edgeWidth = 4;
    private static int edgeHeight = 4;
    public static final int MIN_THUMB_SIZE = 10;
    protected MetalScrollButton increaseButton;
    protected MetalScrollButton decreaseButton;
    protected int scrollBarWidth;
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    protected boolean isFreeStanding = true;
    protected transient int offset;
    protected transient int currentMouseX;
    protected transient int currentMouseY;
    protected transient int currentThumbLength;
    protected transient int currentValue;
    protected transient int currentExtent;
    protected transient int dragEdge;
    protected transient int maximumExtent;
    protected transient int maximumThumbLength;
    protected transient int minimumExtent;
    protected transient int minimumThumbLength;
    protected transient boolean showArrows;
    protected transient boolean newLook = false;
    protected transient boolean trackPatterned = false;
    int direction = 1;

    public static ComponentUI createUI(JComponent c) {
        return new ZoomScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        this.scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        if (this.scrollbar.getBackground() == null || this.scrollbar.getBackground() instanceof UIResource) {
            this.scrollbar.setBackground(UIManager.getColor("ScrollBar.background"));
        }
        super.installDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.scrollbar.removeMouseListener(this.trackListener);
        this.scrollbar.removeMouseMotionListener(this.trackListener);
        this.scrollbar.addMouseListener(this);
        this.scrollbar.addMouseMotionListener(this);
        ((ScrollBarListener)this.propertyChangeListener).handlePropertyChange(this.scrollbar.getClientProperty(FREE_STANDING_PROP));
        this.scrollListener = new ScrollListener();
        this.scrollTimer = new Timer(60, this.scrollListener);
        this.scrollTimer.setInitialDelay(300);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.scrollbar.removeMouseListener(this);
        this.scrollbar.removeMouseMotionListener(this);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new ScrollBarListener();
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        this.shadowColor = UIManager.getColor("ScrollBar.shadow");
        this.thumbColor = UIManager.getColor("ScrollBar.thumb");
        this.thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        this.trackColor = UIManager.getColor("ScrollBar.track");
        this.trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
        this.darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        this.highlightColor = UIManager.getColor("ScrollBar.highlight");
        if (this.darkShadowColor == null) {
            UIManager.put("ScrollBar.darkShadow", this.thumbDarkShadowColor);
            this.darkShadowColor = this.thumbDarkShadowColor;
        }
        if (this.highlightColor == null) {
            UIManager.put("ScrollBar.highlight", this.thumbHighlightColor);
            this.highlightColor = this.thumbHighlightColor;
        }
    }

    protected void modifyThumbColors() {
        if (((ZoomScrollBar)this.scrollbar).getThumbColor() == null) {
            return;
        }
        this.thumbColor = ((ZoomScrollBar)this.scrollbar).getThumbColor();
        this.thumbShadow = this.thumbColor.darker();
        this.thumbHighlightColor = this.thumbColor.brighter();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 10);
        }
        return new Dimension(this.scrollBarWidth * 3 + 10, this.scrollBarWidth);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new MetalScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new MetalScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.scrollbar.getVisibleAmount() == this.scrollbar.getMaximum() - this.scrollbar.getMinimum()) {
            this.setThumbBounds(this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height);
        }
        super.paint(g, c);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.translate(trackBounds.x, trackBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                trackBounds.width += 2;
            }
            if (c.isEnabled()) {
                if (this.isShowNewLook()) {
                    g.setColor(this.trackColor);
                    g.fillRect(0, 0, trackBounds.width, trackBounds.height);
                    g.setColor(this.trackHighlightColor);
                    g.drawRect(0, 0, trackBounds.width, trackBounds.height);
                } else {
                    g.setColor(this.darkShadowColor);
                    g.drawLine(0, 0, 0, trackBounds.height - 1);
                    g.drawLine(trackBounds.width - 2, 0, trackBounds.width - 2, trackBounds.height - 1);
                    g.drawLine(2, trackBounds.height - 1, trackBounds.width - 1, trackBounds.height - 1);
                    g.drawLine(2, 0, trackBounds.width - 2, 0);
                    g.setColor(this.shadowColor);
                    g.drawLine(1, 1, 1, trackBounds.height - 2);
                    g.drawLine(1, 1, trackBounds.width - 3, 1);
                }
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int y = this.thumbRect.y + this.thumbRect.height - trackBounds.y;
                    g.drawLine(1, y, trackBounds.width - 1, y);
                }
                g.drawLine(trackBounds.width - 1, 0, trackBounds.width - 1, trackBounds.height - 1);
                if (this.isPatternTrack()) {
                    Color patternColor = this.trackHighlightColor;
                    g.setColor(patternColor);
                    boolean first = true;
                    int h = trackBounds.height;
                    int w = trackBounds.width;
                    for (int x = 0; x <= w - 2; ++x) {
                        int y = 0;
                        if (!first) {
                            ++y;
                        }
                        boolean bl = first = !first;
                        while (y <= h) {
                            g.fillRect(x, y, 1, 1);
                            y += 2;
                        }
                    }
                }
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(0, 0, trackBounds.width - 1, trackBounds.height - 1);
            }
            if (!this.isFreeStanding) {
                trackBounds.width -= 2;
            }
        } else {
            if (!this.isFreeStanding) {
                trackBounds.height += 2;
            }
            if (c.isEnabled()) {
                if (this.isShowNewLook()) {
                    g.setColor(this.trackColor);
                    g.fillRect(0, 0, trackBounds.width, trackBounds.height);
                    g.setColor(this.trackHighlightColor);
                    g.drawRect(0, 0, trackBounds.width, trackBounds.height);
                } else {
                    g.setColor(this.darkShadowColor);
                    g.drawLine(0, 0, trackBounds.width - 1, 0);
                    g.drawLine(0, 2, 0, trackBounds.height - 2);
                    g.drawLine(0, trackBounds.height - 2, trackBounds.width - 1, trackBounds.height - 2);
                    g.drawLine(trackBounds.width - 1, 2, trackBounds.width - 1, trackBounds.height - 1);
                    g.setColor(this.shadowColor);
                    g.drawLine(1, 1, trackBounds.width - 2, 1);
                    g.drawLine(1, 1, 1, trackBounds.height - 3);
                }
                g.setColor(this.shadowColor);
                g.drawLine(0, trackBounds.height - 1, trackBounds.width - 1, trackBounds.height - 1);
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int x = this.thumbRect.x + this.thumbRect.width - trackBounds.x;
                    g.drawLine(x, 1, x, trackBounds.height - 1);
                }
                if (this.isPatternTrack()) {
                    Color patternColor = this.trackHighlightColor;
                    g.setColor(patternColor);
                    boolean first = true;
                    int h = trackBounds.height;
                    int w = trackBounds.width;
                    for (int x = 1; x <= w - 2; ++x) {
                        int y = 0;
                        if (!first) {
                            ++y;
                        }
                        boolean bl = first = !first;
                        while (y <= h) {
                            g.fillRect(x, y, 1, 1);
                            y += 2;
                        }
                    }
                }
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(0, 0, trackBounds.width - 1, trackBounds.height - 1);
            }
            if (!this.isFreeStanding) {
                trackBounds.height -= 2;
            }
        }
        g.translate(-trackBounds.x, -trackBounds.y);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        this.modifyThumbColors();
        if (this.scrollbar.getVisibleAmount() == this.scrollbar.getMaximum() - this.scrollbar.getMinimum()) {
            thumbBounds.x = this.trackRect.x;
            thumbBounds.y = this.trackRect.y;
            thumbBounds.width = this.trackRect.width;
            thumbBounds.height = this.trackRect.height;
        }
        g.translate(thumbBounds.x, thumbBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            int h;
            if (!this.isFreeStanding) {
                thumbBounds.width += 2;
            }
            g.setColor(this.thumbColor);
            g.fillRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g.setColor(this.thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 2, thumbBounds.height - 1);
            g.setColor(this.thumbHighlightColor);
            g.drawLine(1, 1, thumbBounds.width - 3, 1);
            g.drawLine(1, 1, 1, thumbBounds.height - 2);
            int halfThumbWidth = (int)Math.ceil((double)thumbBounds.width * 0.5);
            int halfThumbHeight = (int)Math.ceil((double)thumbBounds.height * 0.5);
            int leftHandleLine = halfThumbWidth - (int)((double)halfThumbWidth * 0.5);
            int rightHandleLine = halfThumbWidth + (int)((double)halfThumbWidth * 0.5) - 2;
            if (thumbBounds.height >= 3 * edgeHeight) {
                int y;
                int x;
                h = edgeHeight;
                g.setColor(this.thumbHighlightColor);
                boolean first = true;
                for (x = 2; x <= thumbBounds.width - 2; ++x) {
                    y = 2;
                    if (!first) {
                        ++y;
                    }
                    boolean bl = first = !first;
                    while (y <= h) {
                        g.fillRect(x, y, 1, 1);
                        y += 2;
                    }
                }
                g.setColor(this.thumbShadow);
                g.drawRect(0, 0, thumbBounds.width - 2, h);
                g.setColor(this.thumbHighlightColor);
                g.drawLine(1, 1, 1, h - 1);
                g.setColor(this.thumbHighlightColor);
                first = true;
                for (x = 2; x <= thumbBounds.width - 2; ++x) {
                    y = thumbBounds.height + 1 - h;
                    if (!first) {
                        ++y;
                    }
                    boolean bl = first = !first;
                    while (y <= thumbBounds.height - 1) {
                        g.fillRect(x, y, 1, 1);
                        y += 2;
                    }
                }
                g.setColor(this.thumbShadow);
                g.drawRect(0, thumbBounds.height - 1 - h, thumbBounds.width - 2, h);
                g.setColor(this.thumbHighlightColor);
                g.drawLine(1, thumbBounds.height - h, 1, thumbBounds.height - 2);
                if (this.isShowNewLook()) {
                    int lineSpace = 2;
                    int halfHandleHeight = (int)((double)h * 0.5);
                    g.setColor(this.thumbShadow);
                    g.drawLine(leftHandleLine, halfThumbHeight - lineSpace, rightHandleLine, halfThumbHeight - lineSpace);
                    g.drawLine(leftHandleLine, halfThumbHeight, rightHandleLine, halfThumbHeight);
                    g.drawLine(leftHandleLine, halfThumbHeight + lineSpace, rightHandleLine, halfThumbHeight + lineSpace);
                    g.drawLine(leftHandleLine, halfHandleHeight, rightHandleLine, halfHandleHeight);
                    g.drawLine(leftHandleLine, thumbBounds.height - halfHandleHeight, rightHandleLine, thumbBounds.height - halfHandleHeight);
                    g.setColor(this.thumbHighlightColor);
                    g.drawLine(leftHandleLine, halfThumbHeight - 1 - lineSpace, rightHandleLine, halfThumbHeight - 1 - lineSpace);
                    g.drawLine(leftHandleLine, halfThumbHeight - 1, rightHandleLine, halfThumbHeight - 1);
                    g.drawLine(leftHandleLine, halfThumbHeight - 1 + lineSpace, rightHandleLine, halfThumbHeight - 1 + lineSpace);
                    g.drawLine(leftHandleLine, halfHandleHeight - 1, rightHandleLine, halfHandleHeight - 1);
                    g.drawLine(leftHandleLine, thumbBounds.height - halfHandleHeight - 1, rightHandleLine, thumbBounds.height - halfHandleHeight - 1);
                }
            } else {
                if (this.isShowNewLook()) {
                    g.setColor(this.thumbShadow);
                    g.drawLine(leftHandleLine, halfThumbHeight, rightHandleLine, halfThumbHeight);
                    g.setColor(this.thumbHighlightColor);
                    g.drawLine(leftHandleLine, halfThumbHeight - 1, rightHandleLine, halfThumbHeight - 1);
                }
                h = 0;
            }
            g.setColor(this.thumbHighlightColor);
            g.drawLine(1, 1 + h, 1, thumbBounds.height - h - 3);
            g.drawLine(1, 1 + h, thumbBounds.width - 3, 1 + h);
            if (!this.isFreeStanding) {
                thumbBounds.width -= 2;
            }
        } else {
            int w;
            if (!this.isFreeStanding) {
                thumbBounds.height += 2;
            }
            g.setColor(this.thumbColor);
            g.fillRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            g.setColor(this.thumbShadow);
            g.drawRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 2);
            int halfThumbWidth = (int)Math.ceil((double)thumbBounds.width * 0.5);
            int halfThumbHeight = (int)Math.ceil((double)thumbBounds.height * 0.5);
            int topHandleLine = halfThumbHeight - (int)((double)halfThumbHeight * 0.5);
            int bottomHandleLine = halfThumbHeight + (int)((double)halfThumbHeight * 0.5) - 2;
            if (thumbBounds.width >= 3 * edgeWidth) {
                int x;
                int y;
                w = edgeWidth;
                g.setColor(this.thumbHighlightColor);
                boolean first = true;
                for (y = 2; y <= thumbBounds.height - 2; ++y) {
                    x = 2;
                    if (!first) {
                        ++x;
                    }
                    boolean bl = first = !first;
                    while (x <= w) {
                        g.fillRect(x, y, 1, 1);
                        x += 2;
                    }
                }
                g.setColor(this.thumbShadow);
                g.drawRect(0, 0, w, thumbBounds.height - 2);
                g.setColor(this.thumbHighlightColor);
                g.drawLine(1, 1, w - 1, 1);
                g.setColor(this.thumbHighlightColor);
                first = true;
                for (y = 2; y <= thumbBounds.height - 2; ++y) {
                    x = thumbBounds.width + 1 - w;
                    if (!first) {
                        ++x;
                    }
                    boolean bl = first = !first;
                    while (x <= thumbBounds.width - 1) {
                        g.fillRect(x, y, 1, 1);
                        x += 2;
                    }
                }
                g.setColor(this.thumbShadow);
                g.drawRect(thumbBounds.width - 1 - w, 0, w, thumbBounds.height - 2);
                g.setColor(this.thumbHighlightColor);
                g.drawLine(thumbBounds.width - w, 1, thumbBounds.width - 2, 1);
                if (this.isShowNewLook()) {
                    int lineSpace = 2;
                    int halfHandleWidth = (int)((double)w * 0.5);
                    g.setColor(this.thumbShadow);
                    g.drawLine(halfThumbWidth - lineSpace, topHandleLine, halfThumbWidth - lineSpace, bottomHandleLine);
                    g.drawLine(halfThumbWidth, topHandleLine, halfThumbWidth, bottomHandleLine);
                    g.drawLine(halfThumbWidth + lineSpace, topHandleLine, halfThumbWidth + lineSpace, bottomHandleLine);
                    g.drawLine(halfHandleWidth, topHandleLine, halfHandleWidth, bottomHandleLine);
                    g.drawLine(thumbBounds.width - halfHandleWidth - 1, topHandleLine, thumbBounds.width - halfHandleWidth - 1, bottomHandleLine);
                    g.setColor(this.thumbHighlightColor);
                    g.drawLine(halfThumbWidth - 1 - lineSpace, topHandleLine, halfThumbWidth - 1 - lineSpace, bottomHandleLine);
                    g.drawLine(halfThumbWidth - 1, topHandleLine, halfThumbWidth - 1, bottomHandleLine);
                    g.drawLine(halfThumbWidth - 1 + lineSpace, topHandleLine, halfThumbWidth - 1 + lineSpace, bottomHandleLine);
                    g.drawLine(halfHandleWidth - 1, topHandleLine, halfHandleWidth - 1, bottomHandleLine);
                    g.drawLine(thumbBounds.width - halfHandleWidth - 2, topHandleLine, thumbBounds.width - halfHandleWidth - 2, bottomHandleLine);
                }
            } else {
                if (this.isShowNewLook()) {
                    g.setColor(this.thumbShadow);
                    g.drawLine(halfThumbWidth, topHandleLine, halfThumbWidth, bottomHandleLine);
                    g.setColor(this.thumbHighlightColor);
                    g.drawLine(halfThumbWidth - 1, topHandleLine, halfThumbWidth - 1, bottomHandleLine);
                }
                w = 0;
            }
            g.setColor(this.thumbHighlightColor);
            g.drawLine(1 + w, 1, thumbBounds.width - w - 3, 1);
            g.drawLine(1 + w, 1, 1 + w, thumbBounds.height - 3);
            if (!this.isFreeStanding) {
                thumbBounds.height -= 2;
            }
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, 10);
        }
        return new Dimension(10, this.scrollBarWidth);
    }

    @Override
    protected void setThumbBounds(int x, int y, int width, int height) {
        if (this.thumbRect.x == x && this.thumbRect.y == y && this.thumbRect.width == width && this.thumbRect.height == height) {
            return;
        }
        int minX = Math.min(x, this.thumbRect.x);
        int minY = Math.min(y, this.thumbRect.y);
        int maxX = Math.max(x + width, this.thumbRect.x + this.thumbRect.width);
        int maxY = Math.max(y + height, this.thumbRect.y + this.thumbRect.height);
        this.thumbRect.setBounds(x, y, width, height);
        this.scrollbar.repaint(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }

    public int getArrowButtonWidth() {
        if (this.showArrows) {
            return this.decrButton.getWidth();
        }
        return 0;
    }

    public void setShowArrows(boolean arrow) {
        this.showArrows = arrow;
        if (!arrow) {
            this.scrollbar.remove(this.incrButton);
            this.scrollbar.remove(this.decrButton);
        }
    }

    public void setShowNewLook(boolean look) {
        this.newLook = look;
    }

    public boolean isShowNewLook() {
        return this.newLook;
    }

    public void setPatternTrack(boolean patterned) {
        this.trackPatterned = patterned;
    }

    public boolean isPatternTrack() {
        return this.trackPatterned;
    }

    public void setHandleSize(int size) {
        if (size > -1) {
            edgeWidth = size;
            edgeHeight = size;
        }
    }

    public int getHandleSize() {
        return edgeWidth;
    }

    @Override
    protected void layoutVScrollbar(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int decrButtonH = this.showArrows ? this.decrButton.getPreferredSize().height : 0;
        int decrButtonY = sbInsets.top;
        int incrButtonH = this.showArrows ? this.incrButton.getPreferredSize().height : 0;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButtonH + incrButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float value = sb.getValue();
        float range = (float)sb.getMaximum() - min;
        int thumbH = (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = incrButtonY - thumbH;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += decrButtonY + decrButtonH;
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            incrButtonH = decrButtonH = sbAvailButtonH / 2;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        int itrackY = decrButtonY + decrButtonH;
        int itrackH = incrButtonY - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > incrButtonY) {
                thumbY = incrButtonY - thumbH;
            }
            if (thumbY < decrButtonY + decrButtonH) {
                thumbY = decrButtonY + decrButtonH + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    @Override
    protected void layoutHScrollbar(JScrollBar sb) {
        int sbAvailButtonW;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        int decrButtonW = this.showArrows ? this.decrButton.getPreferredSize().width : 0;
        int decrButtonX = sbInsets.left;
        int incrButtonW = this.showArrows ? this.incrButton.getPreferredSize().width : 0;
        int incrButtonX = sbSize.width - (sbInsets.right + incrButtonW);
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = decrButtonW + incrButtonW;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbW = (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int thumbX = incrButtonX - thumbW;
        if (sb.getValue() < sb.getMaximum() - sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbX += decrButtonX + decrButtonW;
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            incrButtonW = decrButtonW = sbAvailButtonW / 2;
            incrButtonX = sbSize.width - (sbInsets.right + incrButtonW);
        }
        this.decrButton.setBounds(decrButtonX, itemY, decrButtonW, itemH);
        this.incrButton.setBounds(incrButtonX, itemY, incrButtonW, itemH);
        int itrackX = decrButtonX + decrButtonW;
        int itrackW = incrButtonX - itrackX;
        this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbX + thumbW > incrButtonX) {
                thumbX = incrButtonX - thumbW;
            }
            if (thumbX < decrButtonX + decrButtonW) {
                thumbX = decrButtonX + decrButtonW + 1;
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        float trackLength;
        int thumbMax;
        int thumbMin;
        if (!this.scrollbar.isEnabled() || !this.isDragging) {
            return;
        }
        BoundedRangeModel model = this.scrollbar.getModel();
        Rectangle thumbR = this.getThumbBounds();
        int thumbLength = this.currentThumbLength;
        if (this.scrollbar.getOrientation() == 1) {
            thumbMin = this.showArrows ? this.decrButton.getY() + this.decrButton.getHeight() : this.decrButton.getY();
            thumbMax = this.incrButton.getY() - this.getThumbBounds().height;
            trackLength = this.getTrackBounds().height;
        } else {
            thumbMin = this.showArrows ? this.decrButton.getX() + this.decrButton.getWidth() : this.decrButton.getX();
            thumbMax = this.incrButton.getX() - this.getThumbBounds().width;
            trackLength = this.getTrackBounds().width;
        }
        if (this.dragEdge == 0 && ((ZoomScrollBar)this.scrollbar).isThumbMoveEnabled()) {
            int thumbPos;
            if (this.scrollbar.getOrientation() == 1) {
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, evt.getY() - this.offset));
                this.setThumbBounds(thumbR.x, thumbPos, thumbR.width, thumbR.height);
            } else {
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, evt.getX() - this.offset));
                this.setThumbBounds(thumbPos, thumbR.y, thumbR.width, thumbR.height);
            }
            if (thumbPos == thumbMax) {
                this.scrollbar.setValue(model.getMaximum() - model.getExtent());
            } else {
                float valueMax = model.getMaximum() - model.getExtent();
                float valueRange = valueMax - (float)model.getMinimum();
                float thumbValue = thumbPos - thumbMin;
                float thumbRange = thumbMax - thumbMin;
                int value = (int)(0.5 + (double)(thumbValue / thumbRange * valueRange));
                this.scrollbar.setValue(value + model.getMinimum());
            }
        } else if (this.dragEdge == -1 && ((ZoomScrollBar)this.scrollbar).isThumbStartEdgeDragEnabled()) {
            if (this.scrollbar.getOrientation() == 1) {
                int maxLength = this.currentMouseY - this.offset - thumbMin + this.currentThumbLength;
                maxLength = Math.min(maxLength, this.maximumThumbLength);
                thumbMin = this.currentMouseY - this.offset + this.currentThumbLength - maxLength;
                int minLength = (int)((double)this.currentThumbLength / (double)this.currentExtent);
                minLength = Math.max(minLength, this.minimumThumbLength);
                int thumbPos = Math.max(thumbMin, Math.min(thumbMin + (maxLength - minLength), evt.getY() - this.offset));
                thumbLength = this.currentThumbLength - (evt.getY() - this.currentMouseY);
                thumbLength = Math.max(minLength, Math.min(thumbLength, maxLength));
                this.setThumbBounds(thumbR.x, thumbPos, thumbR.width, thumbLength);
            } else {
                int maxLength = this.currentMouseX - this.offset - thumbMin + this.currentThumbLength;
                maxLength = Math.min(maxLength, this.maximumThumbLength);
                thumbMin = this.currentMouseX - this.offset + this.currentThumbLength - maxLength;
                int minLength = (int)((double)this.currentThumbLength / (double)this.currentExtent);
                minLength = Math.max(minLength, this.minimumThumbLength);
                int thumbPos = Math.max(thumbMin, Math.min(thumbMin + (maxLength - minLength), evt.getX() - this.offset));
                thumbLength = this.currentThumbLength - (evt.getX() - this.currentMouseX);
                thumbLength = Math.max(minLength, Math.min(thumbLength, maxLength));
                this.setThumbBounds(thumbPos, thumbR.y, thumbLength, thumbR.height);
            }
            int deltaExtent = (int)((double)(thumbLength - this.currentThumbLength) / (double)this.currentThumbLength * (double)this.currentExtent);
            if (deltaExtent >= 0) {
                if (deltaExtent + this.currentExtent > this.maximumExtent) {
                    deltaExtent = this.maximumExtent - this.currentExtent;
                }
            } else if (deltaExtent + this.currentExtent < this.minimumExtent) {
                deltaExtent = this.minimumExtent - this.currentExtent;
            }
            this.scrollbar.setVisibleAmount(Math.max(1, deltaExtent + this.currentExtent));
            this.scrollbar.setValue(-deltaExtent + this.currentValue);
            this.scrollbar.setVisibleAmount(Math.max(1, deltaExtent + this.currentExtent));
        } else if (this.dragEdge == 1 && ((ZoomScrollBar)this.scrollbar).isThumbEndEdgeDragEnabled()) {
            if (this.scrollbar.getOrientation() == 1) {
                int maxLength = (int)trackLength - (this.currentMouseY - this.offset - thumbMin);
                maxLength = Math.min(maxLength, this.maximumThumbLength);
                int minLength = (int)((double)this.currentThumbLength / (double)this.currentExtent);
                minLength = Math.max(minLength, this.minimumThumbLength);
                thumbLength = this.currentThumbLength + (evt.getY() - this.currentMouseY);
                thumbLength = Math.max(minLength, Math.min(thumbLength, maxLength));
                this.setThumbBounds(thumbR.x, thumbR.y, thumbR.width, thumbLength);
            } else {
                int maxLength = (int)trackLength - (this.currentMouseX - this.offset - thumbMin);
                maxLength = Math.min(maxLength, this.maximumThumbLength);
                int minLength = (int)((double)this.currentThumbLength / (double)this.currentExtent);
                minLength = Math.max(minLength, this.minimumThumbLength);
                thumbLength = this.currentThumbLength + (evt.getX() - this.currentMouseX);
                thumbLength = Math.max(minLength, Math.min(thumbLength, maxLength));
                this.setThumbBounds(thumbR.x, thumbR.y, thumbLength, thumbR.height);
            }
            int deltaExtent = (int)((double)(thumbLength - this.currentThumbLength) / (double)this.currentThumbLength * (double)this.currentExtent);
            if (deltaExtent >= 0) {
                if (deltaExtent + this.currentExtent > this.maximumExtent) {
                    deltaExtent = this.maximumExtent - this.currentExtent;
                }
            } else if (deltaExtent + this.currentExtent < this.minimumExtent) {
                deltaExtent = this.minimumExtent - this.currentExtent;
            }
            this.scrollbar.setVisibleAmount(Math.max(1, deltaExtent + this.currentExtent));
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.currentMouseX = evt.getX();
        this.currentMouseY = evt.getY();
        if (this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
            switch (this.scrollbar.getOrientation()) {
                case 1: {
                    if (this.currentMouseY < this.getThumbBounds().y + edgeHeight) {
                        if (((ZoomScrollBar)this.scrollbar).isThumbStartEdgeDragEnabled()) {
                            this.scrollbar.setCursor(new Cursor(9));
                            break;
                        }
                        this.scrollbar.setCursor(new Cursor(0));
                        break;
                    }
                    if (this.currentMouseY > this.getThumbBounds().y + this.getThumbBounds().height - edgeHeight) {
                        if (((ZoomScrollBar)this.scrollbar).isThumbEndEdgeDragEnabled()) {
                            this.scrollbar.setCursor(new Cursor(9));
                            break;
                        }
                        this.scrollbar.setCursor(new Cursor(0));
                        break;
                    }
                    if (((ZoomScrollBar)this.scrollbar).isThumbMoveEnabled()) {
                        this.scrollbar.setCursor(new Cursor(12));
                        break;
                    }
                    this.scrollbar.setCursor(new Cursor(0));
                    break;
                }
                case 0: {
                    if (this.currentMouseX < this.getThumbBounds().x + edgeWidth) {
                        if (((ZoomScrollBar)this.scrollbar).isThumbStartEdgeDragEnabled()) {
                            this.scrollbar.setCursor(new Cursor(10));
                            break;
                        }
                        this.scrollbar.setCursor(new Cursor(0));
                        break;
                    }
                    if (this.currentMouseX > this.getThumbBounds().x + this.getThumbBounds().width - edgeWidth) {
                        if (((ZoomScrollBar)this.scrollbar).isThumbEndEdgeDragEnabled()) {
                            this.scrollbar.setCursor(new Cursor(11));
                            break;
                        }
                        this.scrollbar.setCursor(new Cursor(0));
                        break;
                    }
                    if (((ZoomScrollBar)this.scrollbar).isThumbMoveEnabled()) {
                        this.scrollbar.setCursor(new Cursor(12));
                        break;
                    }
                    this.scrollbar.setCursor(new Cursor(0));
                }
            }
        } else {
            this.scrollbar.setCursor(new Cursor(0));
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!this.scrollbar.isEnabled()) {
            return;
        }
        this.currentMouseX = evt.getX();
        this.currentMouseY = evt.getY();
        this.currentValue = this.scrollbar.getValue();
        this.currentExtent = this.scrollbar.getVisibleAmount();
        if (this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
            switch (this.scrollbar.getOrientation()) {
                case 1: {
                    this.offset = this.currentMouseY - this.getThumbBounds().y;
                    this.currentThumbLength = this.getThumbBounds().height;
                    if (this.currentMouseY < this.getThumbBounds().y + edgeHeight) {
                        this.dragEdge = -1;
                        break;
                    }
                    if (this.currentMouseY > this.getThumbBounds().y + this.getThumbBounds().height - edgeHeight) {
                        this.dragEdge = 1;
                        break;
                    }
                    this.dragEdge = 0;
                    break;
                }
                case 0: {
                    this.offset = this.currentMouseX - this.getThumbBounds().x;
                    this.currentThumbLength = this.getThumbBounds().width;
                    this.dragEdge = this.currentMouseX < this.getThumbBounds().x + edgeWidth ? -1 : (this.currentMouseX > this.getThumbBounds().x + this.getThumbBounds().width - edgeWidth ? 1 : 0);
                }
            }
            this.scrollbar.setValueIsAdjusting(true);
            this.isDragging = true;
            this.maximumExtent = -1;
            if (this.scrollbar instanceof ZoomScrollBar) {
                this.maximumExtent = ((ZoomScrollBar)this.scrollbar).getMaximumVisibleAmount();
            }
            if (this.maximumExtent < 1) {
                this.maximumExtent = this.scrollbar.getMaximum() - this.scrollbar.getMinimum();
            }
            this.maximumThumbLength = (int)Math.ceil((double)(this.maximumExtent * this.currentThumbLength) / (double)this.currentExtent);
            this.minimumExtent = -1;
            if (this.scrollbar instanceof ZoomScrollBar) {
                this.minimumExtent = ((ZoomScrollBar)this.scrollbar).getMinimumVisibleAmount();
            }
            if (this.minimumExtent < 1) {
                this.minimumExtent = 1;
            }
            this.minimumThumbLength = (int)Math.ceil((double)(this.minimumExtent * this.currentThumbLength) / (double)this.currentExtent);
            this.minimumThumbLength = Math.max(this.minimumThumbLength, 10);
            return;
        }
        this.scrollbar.setValueIsAdjusting(true);
        this.isDragging = false;
        Dimension sbSize = this.scrollbar.getSize();
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                if (this.getThumbBounds().isEmpty()) {
                    int scrollbarCenter = sbSize.height / 2;
                    this.direction = this.currentMouseY < scrollbarCenter ? -1 : 1;
                    break;
                }
                int thumbY = this.getThumbBounds().y;
                this.direction = this.currentMouseY < thumbY ? -1 : 1;
                break;
            }
            case 0: {
                int thumbX;
                int scrollbarCenter;
                this.direction = this.getThumbBounds().isEmpty() ? (this.currentMouseX < (scrollbarCenter = sbSize.width / 2) ? -1 : 1) : (this.currentMouseX < (thumbX = this.getThumbBounds().x) ? -1 : 1);
            }
        }
        this.scrollByBlock(this.direction);
        if (!this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
            this.scrollTimer.stop();
            this.scrollListener.setDirection(this.direction);
            this.scrollListener.setScrollByBlock(true);
            ((ScrollListener)this.scrollListener).setCurrentMouseX(this.currentMouseX);
            ((ScrollListener)this.scrollListener).setCurrentMouseY(this.currentMouseY);
            this.scrollTimer.start();
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.scrollbar.setCursor(new Cursor(0));
        if (!this.scrollbar.isEnabled()) {
            return;
        }
        if (this.trackHighlight != 0) {
            Rectangle r = this.getTrackBounds();
            this.scrollbar.repaint(r.x, r.y, r.width, r.height);
        }
        this.trackHighlight = 0;
        this.isDragging = false;
        this.offset = 0;
        this.scrollTimer.stop();
        this.scrollbar.setValueIsAdjusting(false);
    }

    class ScrollBarListener
    extends BasicScrollBarUI.PropertyChangeHandler {
        ScrollBarListener() {
            super(ZoomScrollBarUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals(ZoomScrollBarUI.FREE_STANDING_PROP)) {
                this.handlePropertyChange(e.getNewValue());
            } else {
                super.propertyChange(e);
            }
        }

        public void handlePropertyChange(Object newValue) {
            if (newValue != null) {
                boolean temp = (Boolean)newValue;
                boolean becameFlush = !temp && ZoomScrollBarUI.this.isFreeStanding;
                boolean becameNormal = temp && !ZoomScrollBarUI.this.isFreeStanding;
                ZoomScrollBarUI.this.isFreeStanding = temp;
                if (becameFlush) {
                    this.toFlush();
                } else if (becameNormal) {
                    this.toFreeStanding();
                }
            } else if (!ZoomScrollBarUI.this.isFreeStanding) {
                ZoomScrollBarUI.this.isFreeStanding = true;
                this.toFreeStanding();
            }
            if (ZoomScrollBarUI.this.increaseButton != null) {
                ZoomScrollBarUI.this.increaseButton.setFreeStanding(ZoomScrollBarUI.this.isFreeStanding);
            }
            if (ZoomScrollBarUI.this.decreaseButton != null) {
                ZoomScrollBarUI.this.decreaseButton.setFreeStanding(ZoomScrollBarUI.this.isFreeStanding);
            }
        }

        protected void toFlush() {
            ZoomScrollBarUI.this.scrollBarWidth -= 2;
        }

        protected void toFreeStanding() {
            ZoomScrollBarUI.this.scrollBarWidth += 2;
        }
    }

    protected class ScrollListener
    extends BasicScrollBarUI.ScrollListener
    implements ActionListener {
        int direction;
        boolean useBlockIncrement;
        int currentMouseX;
        int currentMouseY;

        public ScrollListener() {
            super(ZoomScrollBarUI.this);
            this.direction = 1;
            this.currentMouseX = 0;
            this.currentMouseY = 0;
            this.direction = 1;
            this.useBlockIncrement = false;
        }

        public ScrollListener(int dir, boolean block) {
            super(ZoomScrollBarUI.this);
            this.direction = 1;
            this.currentMouseX = 0;
            this.currentMouseY = 0;
            this.direction = dir;
            this.useBlockIncrement = block;
        }

        public void setCurrentMouseX(int x) {
            this.currentMouseX = x;
        }

        public void setCurrentMouseY(int y) {
            this.currentMouseY = y;
        }

        @Override
        public void setDirection(int direction) {
            this.direction = direction;
        }

        @Override
        public void setScrollByBlock(boolean block) {
            this.useBlockIncrement = block;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.useBlockIncrement) {
                ZoomScrollBarUI.this.scrollByBlock(this.direction);
                if (ZoomScrollBarUI.this.scrollbar.getOrientation() == 1) {
                    if (this.direction > 0) {
                        if (((ZoomScrollBarUI)ZoomScrollBarUI.this).getThumbBounds().y + ((ZoomScrollBarUI)ZoomScrollBarUI.this).getThumbBounds().height >= this.currentMouseY) {
                            ((Timer)e.getSource()).stop();
                        }
                    } else if (((ZoomScrollBarUI)ZoomScrollBarUI.this).getThumbBounds().y <= this.currentMouseY) {
                        ((Timer)e.getSource()).stop();
                    }
                } else if (this.direction > 0) {
                    if (((ZoomScrollBarUI)ZoomScrollBarUI.this).getThumbBounds().x + ((ZoomScrollBarUI)ZoomScrollBarUI.this).getThumbBounds().width >= this.currentMouseX) {
                        ((Timer)e.getSource()).stop();
                    }
                } else if (((ZoomScrollBarUI)ZoomScrollBarUI.this).getThumbBounds().x <= this.currentMouseX) {
                    ((Timer)e.getSource()).stop();
                }
            } else {
                ZoomScrollBarUI.this.scrollByUnit(this.direction);
            }
            if (this.direction > 0 && ZoomScrollBarUI.this.scrollbar.getValue() + ZoomScrollBarUI.this.scrollbar.getVisibleAmount() >= ZoomScrollBarUI.this.scrollbar.getMaximum()) {
                ((Timer)e.getSource()).stop();
            } else if (this.direction < 0 && ZoomScrollBarUI.this.scrollbar.getValue() <= ZoomScrollBarUI.this.scrollbar.getMinimum()) {
                ((Timer)e.getSource()).stop();
            }
        }
    }
}

