/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

public class Vec3d {
    public double x;
    public double y;
    public double z;

    public Vec3d() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Vec3d(double anx, double ay, double az) {
        this.x = anx;
        this.y = ay;
        this.z = az;
    }

    public Vec3d(Vec3d aVec3d) {
        this.x = aVec3d.x;
        this.y = aVec3d.y;
        this.z = aVec3d.z;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Vec3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void add(Vec3d increment) {
        this.x += increment.x;
        this.y += increment.y;
        this.z += increment.z;
    }

    public void subtract(Vec3d decrement) {
        this.x -= decrement.x;
        this.y -= decrement.y;
        this.z -= decrement.z;
    }

    public static Vec3d subtract(Vec3d a, Vec3d b) {
        Vec3d result = new Vec3d(a);
        result.subtract(b);
        return result;
    }

    public static void subtract(Vec3d a, Vec3d b, Vec3d result) {
        result.x = a.x - b.x;
        result.x = a.y - b.y;
        result.x = a.z - b.z;
    }

    public void scale(double m) {
        this.x *= m;
        this.y *= m;
        this.z *= m;
    }

    public void normalize() {
        double length = this.length();
        if (length != 0.0) {
            this.x /= length;
            this.y /= length;
            this.z /= length;
        }
    }

    public double dot(Vec3d otherVec3d) {
        double result = this.x * otherVec3d.x + this.y * otherVec3d.y + this.z * otherVec3d.z;
        return result;
    }

    public double angle(Vec3d otherVec3d) {
        double thisLength = this.length();
        double otherLength = otherVec3d.length();
        double angle = thisLength == 0.0 || otherLength == 0.0 ? 0.0 : Math.acos(this.dot(otherVec3d) / (thisLength * otherLength));
        return angle;
    }

    public double gradient(Vec3d v) {
        return Math.abs(this.x - v.x) + Math.abs(this.y - v.y) + Math.abs(this.z - v.z);
    }

    public static double gradient(Vec3d v1, Vec3d v2) {
        return Math.abs(v1.x - v2.x) + Math.abs(v1.y - v2.y) + Math.abs(v1.z - v2.z);
    }

    public Vec3d cross(Vec3d otherVec3d) {
        double tx = this.y * otherVec3d.z - this.z * otherVec3d.y;
        double ty = this.z * otherVec3d.x - this.x * otherVec3d.z;
        double tz = this.x * otherVec3d.y - this.y * otherVec3d.x;
        this.set(tx, ty, tz);
        return this;
    }

    public double getDistance(Vec3d vec) {
        return Math.sqrt((vec.x - this.x) * (vec.x - this.x) + (vec.y - this.y) * (vec.y - this.y) + (vec.z - this.z) * (vec.z - this.z));
    }

    public Vec3d Rotate(Vec3d axis, double angle) {
        Vec3d v = new Vec3d();
        double cosine = Math.cos(angle);
        double cosine1 = 1.0 - cosine;
        double sine = Math.sin(angle);
        v.x = (axis.x * axis.x + cosine * (1.0 - axis.x * axis.x)) * this.x + (axis.x * axis.y * cosine1 - axis.z * sine) * this.y + (axis.x * axis.z * cosine1 + axis.y * sine) * this.z;
        v.y = (axis.x * axis.y * cosine1 + axis.z * sine) * this.x + (axis.y * axis.y + cosine * (1.0 - axis.y * axis.y)) * this.y + (axis.y * axis.z * cosine1 - axis.x * sine) * this.z;
        v.z = (axis.x * axis.z * cosine1 - axis.y * sine) * this.x + (axis.y * axis.z * cosine1 + axis.x * sine) * this.y + (axis.z * axis.z + cosine * (1.0 - axis.z * axis.z)) * this.z;
        return v;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof Vec3d) {
            Vec3d vec = (Vec3d)obj;
            result = this.x == vec.x && this.y == vec.y && this.z == vec.z;
        }
        return result;
    }

    public static Vec3d getXAxis() {
        return new Vec3d(1.0, 0.0, 0.0);
    }

    public static Vec3d getYAxis() {
        return new Vec3d(0.0, 1.0, 0.0);
    }

    public static Vec3d getZAxis() {
        return new Vec3d(0.0, 0.0, 1.0);
    }

    public static Vec3d getNegativeXAxis() {
        return new Vec3d(-1.0, 0.0, 0.0);
    }

    public static Vec3d getNegativeYAxis() {
        return new Vec3d(0.0, -1.0, 0.0);
    }

    public static Vec3d getNegativeZAxis() {
        return new Vec3d(0.0, 0.0, -1.0);
    }
}

