/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.UserDefinedMarkerInterface;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import javax.swing.ImageIcon;

public class UserDefinedIconMarker
implements UserDefinedMarkerInterface {
    private Image image;
    private double dpi = 1.0;
    private double xScale = 1.0;
    private double yScale = 1.0;
    private double rotation = 0.0;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private boolean border = false;

    public UserDefinedIconMarker(double dpi) {
        this.dpi = dpi;
    }

    public boolean setImagePath(String path) {
        if (!new File(path).exists()) {
            return false;
        }
        try {
            this.image = Toolkit.getDefaultToolkit().createImage(path);
        }
        catch (Exception ee) {
            this.image = null;
            return false;
        }
        this.image.getHeight(null);
        this.image.getWidth(null);
        int wait = 0;
        while ((Toolkit.getDefaultToolkit().checkImage(this.image, -1, -1, null) & 0x20) == 0) {
            try {
                Thread.sleep(100L);
                if ((wait += 100) <= 120000) continue;
                this.image = null;
                return false;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return true;
    }

    @Override
    public double getMarkerOffsetX() {
        return this.xOffset;
    }

    @Override
    public void setMarkerOffsetX(double offset) {
        this.xOffset = offset;
    }

    @Override
    public double getMarkerOffsetY() {
        return this.yOffset;
    }

    @Override
    public void setMarkerOffsetY(double offset) {
        this.yOffset = offset;
    }

    @Override
    public double getMarkerScaleX() {
        return this.xScale;
    }

    @Override
    public void setMarkerScaleX(double scale) {
        this.xScale = scale;
    }

    @Override
    public double getMarkerScaleY() {
        return this.yScale;
    }

    @Override
    public void setMarkerScaleY(double scale) {
        this.yScale = scale;
    }

    @Override
    public double getMarkerRotation() {
        return this.rotation;
    }

    @Override
    public void setMarkerRotation(double angle) {
        this.rotation = angle;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    @Override
    public void paint(Graphics2D g2d, Color color, Color edgeColor, double x, double y, int w, int h) {
        this.paint(g2d, color, edgeColor, (int)(x + 0.5), (int)(y + 0.5), w, h);
    }

    @Override
    public void paint(Graphics2D g2d, Color color, Color edgeColor, int x, int y, int w, int h) {
        int height;
        int width;
        double aspect;
        Color clr;
        int iw = this.image.getWidth(null);
        int ih = this.image.getHeight(null);
        if (iw == 0 || ih == 0) {
            return;
        }
        Graphics2D gc = (Graphics2D)g2d.create();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.rotation != 0.0) {
            gc.rotate(-this.rotation, x, y);
        }
        Color color2 = clr = color != null ? color : g2d.getColor();
        if (clr != null && clr.getAlpha() != 255) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)((double)clr.getAlpha() / 255.0)));
        }
        if ((aspect = (double)iw / (double)ih) <= 1.0) {
            double size = (double)h * this.yScale;
            width = (int)(size * aspect);
            height = (int)Math.round(size);
        } else {
            double size = (double)w * this.xScale;
            width = (int)Math.round(size);
            height = (int)(size / aspect);
        }
        gc.clip(new Rectangle(x - w / 2, y - h / 2, w, h));
        if (width < iw || height < ih) {
            BufferedImage scaled = this.getScaledInstance(this.toBufferedImage(this.image), width, height, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
            gc.drawImage((Image)scaled, x - width / 2, y - height / 2, null);
        } else {
            gc.drawImage(this.image, x - width / 2, y - height / 2, width, height, null);
        }
        gc.dispose();
    }

    public static BasicStroke getStroke(int lineStyle, float lineWidth) {
        BasicStroke bs;
        int mask = SASLinePatterns.getStipplePattern(lineStyle);
        int factor = SASLinePatterns.getStippleFactor(lineStyle);
        int[] dashes = new int[16];
        int index = 0;
        int scanner = 32768;
        while (scanner > 0) {
            int bitcount = 0;
            while ((scanner & mask) != 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount > 0) {
                dashes[index++] = factor * bitcount;
            }
            bitcount = 0;
            while ((scanner & mask) == 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount <= 0) continue;
            dashes[index++] = -factor * bitcount;
        }
        int[] glPattern = new int[index--];
        int i = 0;
        while (index >= 0) {
            glPattern[i] = dashes[index];
            ++i;
            --index;
        }
        float dashPhase = 0.0f;
        float[] dashArray = null;
        float lw = lineWidth;
        int stippleIndex = 0;
        if (lineWidth < 1.0f) {
            lw = 0.5f;
        }
        if (glPattern.length == 1) {
            bs = glPattern[0] < 0 ? null : new BasicStroke(lw, 0, 0);
        } else {
            if (glPattern[0] < 0 && glPattern[glPattern.length - 1] > 0) {
                ++stippleIndex;
                dashPhase = glPattern[1];
                dashArray = new float[glPattern.length];
                dashArray[glPattern.length - 1] = Math.abs(glPattern[0]);
            } else if (glPattern[0] < 0 && glPattern[glPattern.length - 1] < 0) {
                int n = glPattern.length - 1;
                glPattern[n] = glPattern[n] + glPattern[0];
                int[] newStipplePattern = new int[glPattern.length - 1];
                System.arraycopy(glPattern, 1, newStipplePattern, 0, glPattern.length - 1);
                glPattern = newStipplePattern;
                dashArray = new float[glPattern.length];
            } else {
                dashArray = new float[glPattern.length];
            }
            int dashIndex = 0;
            while (stippleIndex < glPattern.length) {
                dashArray[dashIndex] = Math.abs(glPattern[stippleIndex]);
                ++stippleIndex;
                ++dashIndex;
            }
            bs = new BasicStroke(lw, 0, 0, (int)Math.max(lineWidth, 1.0f), dashArray, dashPhase);
        }
        return bs;
    }

    private boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pg.getColorModel().hasAlpha();
    }

    protected BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = this.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    protected BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        int w = img.getWidth();
        int h = img.getHeight();
        while (w != targetWidth || h != targetHeight) {
            if (w > targetWidth) {
                if ((w /= 2) < targetWidth) {
                    w = targetWidth;
                }
            } else if (w < targetWidth) {
                w = targetWidth;
            }
            if (h > targetHeight) {
                if ((h /= 2) < targetHeight) {
                    h = targetHeight;
                }
            } else if (h < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        }
        return ret;
    }
}

