/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.UserDefinedMarkerInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class SubPixelScalableMarkers {
    private static double NORMAL_PERCENT = 0.15;
    private static double SEMI_BOLD_PERCENT = 0.2;
    private static double BOLD_PERCENT = 0.3;
    private static int MAX_SIZE = 100000;
    private static final int UP = 0;
    private static final int DOWN = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;

    public static void draw(Graphics2D g, Color color, Color edge, int shape, double maxSize, double x0, double y0, int thickness, boolean antialiasingIsOn) {
        double left;
        double top;
        int half;
        if (maxSize <= 0.0) {
            return;
        }
        if (shape == 63 || shape == 65) {
            maxSize = Math.min(maxSize, (double)MAX_SIZE);
        }
        if (color != null) {
            g.setColor(color);
        } else {
            color = g.getColor();
        }
        boolean edgeOn = edge != null && !edge.equals(color) && edge.getAlpha() > 0;
        int size = SubPixelScalableMarkers.getAdjustedSize(shape, (int)maxSize);
        if (thickness == 0) {
            edgeOn = false;
            thickness = 1;
        }
        if (edgeOn && thickness > 1 && SubPixelScalableMarkers.isFilled(shape)) {
            if (thickness > (size - 1) / 2) {
                g.setColor(edge);
                edgeOn = false;
                thickness = 1;
            } else {
                int adj = thickness % 2 == 0 ? thickness : thickness - 1;
                size -= adj;
            }
        }
        if (size == 1) {
            g.draw(new Line2D.Double(x0, y0, x0, y0));
            return;
        }
        if (size == 2) {
            if (edgeOn) {
                g.setColor(edge);
            }
            g.draw(new Rectangle2D.Double(x0, y0, 1.0, 1.0));
            if (edgeOn) {
                g.setColor(color);
            }
            return;
        }
        if (size % 2 == 0) {
            half = size / 2;
            top = y0 - (double)(half - 1);
            left = x0 - (double)(half - 1);
        } else {
            half = (size - 1) / 2;
            top = y0 - (double)half;
            left = x0 - (double)half;
        }
        double bottom = y0 + (double)half;
        double right = x0 + (double)half;
        Stroke oldStroke = null;
        if (!SubPixelScalableMarkers.isFilled(shape) && thickness > 1 && g instanceof Graphics2D) {
            oldStroke = g.getStroke();
            if (SubPixelScalableMarkers.isRound(shape, size)) {
                g.setStroke(new BasicStroke(thickness, 0, 1));
            } else {
                g.setStroke(new BasicStroke(thickness));
            }
        }
        Color edgeColor = edgeOn ? edge : null;
        switch (shape) {
            default: {
                if (!Markers.isUserDefinedMarker(shape)) break;
                UserDefinedMarkerInterface udm = Markers.getUserDefinedMarker(shape);
                udm.paint(g, color, edgeColor, x0, y0, size, size);
                break;
            }
            case 0: {
                SubPixelScalableMarkers.drawCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, antialiasingIsOn);
                break;
            }
            case 16: {
                SubPixelScalableMarkers.drawFilledCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, edgeColor, antialiasingIsOn);
                break;
            }
            case 1: {
                SubPixelScalableMarkers.drawPlus(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 4: {
                SubPixelScalableMarkers.drawX(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 2: {
                SubPixelScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 0);
                break;
            }
            case 18: {
                SubPixelScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 0);
                break;
            }
            case 5: {
                SubPixelScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 1);
                break;
            }
            case 21: {
                SubPixelScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 1);
                break;
            }
            case 59: {
                SubPixelScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 2);
                break;
            }
            case 105: {
                SubPixelScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 2);
                break;
            }
            case 60: {
                SubPixelScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 3);
                break;
            }
            case 106: {
                SubPixelScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 3);
                break;
            }
            case 63: {
                SubPixelScalableMarkers.drawTilde(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 66: {
                SubPixelScalableMarkers.drawIBeam(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 3: {
                SubPixelScalableMarkers.drawSquare(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                break;
            }
            case 19: {
                SubPixelScalableMarkers.drawSquare(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                break;
            }
            case 58: {
                SubPixelScalableMarkers.drawAsterisk(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 150: {
                SubPixelScalableMarkers.drawY(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 6: {
                SubPixelScalableMarkers.drawDiamond(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                break;
            }
            case 22: {
                SubPixelScalableMarkers.drawDiamond(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                break;
            }
            case 151: {
                SubPixelScalableMarkers.drawZ(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 65: {
                SubPixelScalableMarkers.drawUnion(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 56: {
                SubPixelScalableMarkers.drawHash(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 70: {
                SubPixelScalableMarkers.drawTack(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 73: {
                SubPixelScalableMarkers.drawHomeDown(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                break;
            }
            case 108: {
                SubPixelScalableMarkers.drawHomeDown(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                break;
            }
            case 62: {
                SubPixelScalableMarkers.drawGreaterThan(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 61: {
                SubPixelScalableMarkers.drawLessThan(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 134: {
                SubPixelScalableMarkers.drawArrowDown(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 54: {
                SubPixelScalableMarkers.drawStar(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                break;
            }
            case 23: {
                SubPixelScalableMarkers.drawStar(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                break;
            }
            case 146: {
                SubPixelScalableMarkers.drawHexagon(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                break;
            }
            case 148: {
                SubPixelScalableMarkers.drawHexagon(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                break;
            }
            case 52: {
                SubPixelScalableMarkers.drawCross(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                break;
            }
            case 17: {
                SubPixelScalableMarkers.drawCross(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                break;
            }
            case 158: {
                SubPixelScalableMarkers.drawOctagon(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                break;
            }
            case 159: {
                SubPixelScalableMarkers.drawOctagon(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                break;
            }
            case 160: {
                SubPixelScalableMarkers.drawOctagonRotated(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                break;
            }
            case 161: {
                SubPixelScalableMarkers.drawOctagonRotated(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                break;
            }
            case 162: {
                SubPixelScalableMarkers.drawPentagon(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                break;
            }
            case 163: {
                SubPixelScalableMarkers.drawPentagon(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                break;
            }
            case 164: {
                SubPixelScalableMarkers.drawCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, antialiasingIsOn);
                if ((size /= 4) % 2 == 0) {
                    half = size / 2;
                    top = y0 - (double)half;
                    left = x0 - (double)half;
                } else {
                    half = (size - 1) / 2;
                    top = y0 - (double)half;
                    left = x0 - (double)half;
                }
                bottom = y0 + (double)half;
                right = x0 + (double)half;
                SubPixelScalableMarkers.drawDiamond(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                break;
            }
            case 165: {
                SubPixelScalableMarkers.drawFilledCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, edgeColor, antialiasingIsOn);
                if ((size /= 4) % 2 == 0) {
                    half = size / 2;
                    top = y0 - (double)half;
                    left = x0 - (double)half;
                } else {
                    half = (size - 1) / 2;
                    top = y0 - (double)half;
                    left = x0 - (double)half;
                }
                bottom = y0 + (double)half;
                right = x0 + (double)half;
                SubPixelScalableMarkers.drawDiamond(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                break;
            }
            case 166: {
                SubPixelScalableMarkers.drawCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, antialiasingIsOn);
                if ((size /= 4) % 2 == 0) {
                    half = size / 2;
                    top = y0 - (double)half;
                    left = x0 - (double)half;
                } else {
                    half = (size - 1) / 2;
                    top = y0 - (double)half;
                    left = x0 - (double)half;
                }
                bottom = y0 + (double)half;
                right = x0 + (double)half;
                SubPixelScalableMarkers.drawDiamond(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                break;
            }
            case 167: {
                SubPixelScalableMarkers.drawCheckmark(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 168: {
                SubPixelScalableMarkers.drawCircumflex(g, x0, y0, size, half, top, bottom, left, right, thickness, false);
                break;
            }
            case 169: {
                SubPixelScalableMarkers.drawCircumflex(g, x0, y0, size, half, top, bottom, left, right, thickness, true);
                break;
            }
            case 170: {
                SubPixelScalableMarkers.drawDollarsign(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 171: {
                SubPixelScalableMarkers.drawRegisteredTrademark(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 172: {
                SubPixelScalableMarkers.drawCopywrite(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 173: {
                SubPixelScalableMarkers.drawSVGCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, null, false);
                break;
            }
            case 174: {
                SubPixelScalableMarkers.drawSVGCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, edgeColor, true);
                break;
            }
            case 176: {
                SubPixelScalableMarkers.drawSVGUnion(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 175: {
                SubPixelScalableMarkers.drawSVGTilde(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 178: {
                SubPixelScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 0);
                break;
            }
            case 179: {
                SubPixelScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 0);
                break;
            }
            case 180: {
                SubPixelScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 1);
                break;
            }
            case 181: {
                SubPixelScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 1);
                break;
            }
            case 182: {
                SubPixelScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 2);
                break;
            }
            case 183: {
                SubPixelScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 2);
                break;
            }
            case 184: {
                SubPixelScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 3);
                break;
            }
            case 185: {
                SubPixelScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 3);
                break;
            }
            case 177: {
                SubPixelScalableMarkers.drawSVGSquare(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                break;
            }
            case 186: {
                SubPixelScalableMarkers.drawSVGY(g, x0, y0, size, half, top, bottom, left, right, thickness);
                break;
            }
            case 187: {
                SubPixelScalableMarkers.drawOutlinedCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, edgeColor);
                break;
            }
            case 188: {
                SubPixelScalableMarkers.drawOutlinedCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
            }
        }
        if (edgeOn) {
            g.setColor(color);
        }
        if (oldStroke != null) {
            g.setStroke(oldStroke);
        }
    }

    public static void draw(Graphics2D g, Color color, Color edge, int shape, double maxSize, double x0, double y0, boolean bold, int weight, boolean antialiasingOn) {
        if (maxSize <= 0.0) {
            return;
        }
        int thickness = 1;
        if (bold) {
            boolean edgeOn;
            if (color == null) {
                color = g.getColor();
            }
            boolean bl = edgeOn = edge != null && !edge.equals(color);
            if (SubPixelScalableMarkers.isFilled(shape) && !edgeOn) {
                maxSize = SubPixelScalableMarkers.getFilledMarkerSize(shape, (int)maxSize, weight);
            } else {
                thickness = SubPixelScalableMarkers.getOutlineThickness(shape, (int)maxSize, weight);
            }
        }
        SubPixelScalableMarkers.draw(g, color, edge, shape, maxSize, x0, y0, thickness, antialiasingOn);
    }

    public static void draw(Graphics2D g, Color color, Color edge, int shape, double maxSize, double x0, double y0) {
        SubPixelScalableMarkers.draw(g, color, edge, shape, maxSize, x0, y0, 1, false);
    }

    private static void drawCircle(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor, boolean antialiasingOn) {
        g.draw(new Ellipse2D.Double(left, top, size - 1, size - 1));
    }

    private static void drawFilledCircle(Graphics2D g, double x0, double y0, int size, double half, double top, double bottom, double left, double right, int thickness, Color edgeColor, boolean antialiasingOn) {
        g.fill(new Ellipse2D.Double(left, top, size, size));
        if (edgeColor != null || thickness > 1) {
            Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, true);
            g.draw(new Ellipse2D.Double(left, top, size - 1, size - 1));
            if (oldStroke != null) {
                g.setStroke(oldStroke);
            }
        }
    }

    private static void drawOutlinedCircle(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor) {
        if (fillOn) {
            g.fill(new Ellipse2D.Double(left, top, size, size));
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, true);
                g.draw(new Ellipse2D.Double(left, top, size - 1, size - 1));
                if (oldStroke != null) {
                    g.setStroke(oldStroke);
                }
            }
        } else {
            g.draw(new Ellipse2D.Double(left, top, size - 1, size - 1));
        }
    }

    private static void drawPlus(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        g.draw(new Line2D.Double(left, y0, right, y0));
        g.draw(new Line2D.Double(x0, top, x0, bottom));
    }

    private static void drawX(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        g.draw(new Line2D.Double(left, top, right, bottom));
        g.draw(new Line2D.Double(right, top, left, bottom));
    }

    private static void drawTriangle(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor, int dir) {
        double[] x = new double[4];
        double[] y = new double[4];
        int d = fillOn && edgeColor == null && thickness == 1 ? 1 : 0;
        switch (dir) {
            default: {
                x[0] = x0;
                y[0] = top - (double)d;
                x[1] = left - (double)d;
                y[1] = bottom + (double)d;
                x[2] = right + (double)d;
                y[2] = bottom + (double)d;
                x[3] = x[0] + 1.0;
                y[3] = y[0] + 1.0;
                break;
            }
            case 1: {
                x[0] = x0;
                y[0] = bottom + (double)d;
                x[1] = left;
                y[1] = top;
                x[2] = right + (double)d;
                y[2] = top;
                x[3] = x[0] + 1.0;
                y[3] = y[0] - 1.0;
                break;
            }
            case 2: {
                x[0] = left;
                y[0] = y0;
                x[1] = right + (double)d;
                y[1] = top - (double)d;
                x[2] = right + (double)d;
                y[2] = bottom + (double)d;
                x[3] = x[0] + 1.0;
                y[3] = y[0] + 1.0;
                break;
            }
            case 3: {
                x[0] = right + (double)d;
                y[0] = y0;
                x[1] = left;
                y[1] = top - (double)d;
                x[2] = left;
                y[2] = bottom + (double)d;
                x[3] = x[0] - 1.0;
                y[3] = y[0] + 1.0;
            }
        }
        int np = d > 0 ? 4 : 3;
        GeneralPath path = new GeneralPath();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < np; ++i) {
            path.lineTo(x[i], y[i]);
        }
        path.closePath();
        if (fillOn) {
            g.fill(path);
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, false);
                g.draw(path);
                if (oldStroke != null) {
                    g.setStroke(oldStroke);
                }
            }
        } else {
            g.draw(path);
        }
    }

    private static void drawCircumflex(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean down) {
        if (!down) {
            g.draw(new Line2D.Double(left, bottom, x0, top));
            g.draw(new Line2D.Double(x0, top, right, bottom));
        } else {
            g.draw(new Line2D.Double(left, top, x0, bottom));
            g.draw(new Line2D.Double(x0, bottom, right, top));
        }
    }

    private static void drawCheckmark(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, double thickness) {
        g.draw(new Line2D.Double(left + (double)(half / 2) + 1.0, top + (double)(half / 2), x0, y0));
        g.draw(new Line2D.Double(x0, y0, right, top - (double)(half / 4)));
    }

    private static void drawDollarsign(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        int adj = half / 3;
        g.setFont(FontManager.getFont("Helvetica", 0, half + adj));
        g.drawString("$", (float)x0, (float)(y0 + (double)adj));
    }

    private static void drawRegisteredTrademark(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        g.setFont(FontManager.getFont("Helvetica", 1, half - 2));
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D r = fm.getStringBounds("R", g);
        double x = x0 - r.getWidth() / 2.0;
        y0 -= (double)(half / 2);
        size = half;
        if (size % 2 == 0) {
            half = size / 2;
            top = y0 - (double)half;
            left = x0 - (double)half;
        } else {
            half = (size - 1) / 2;
            top = y0 - (double)half;
            left = x0 - (double)half;
        }
        bottom = y0 + (double)half;
        right = x0 + (double)half;
        g.drawString("R", (float)x, (float)(y0 + (double)fm.getAscent() - (double)(fm.getHeight() / 2)));
    }

    private static void drawCopywrite(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        g.setFont(FontManager.getFont("Helvetica", 1, half - 2));
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D r = fm.getStringBounds("C", g);
        double x = x0 - r.getWidth() / 2.0;
        y0 -= (double)(half / 2);
        size = half;
        if (size % 2 == 0) {
            half = size / 2;
            top = y0 - (double)half;
            left = x0 - (double)half;
        } else {
            half = (size - 1) / 2;
            top = y0 - (double)half;
            left = x0 - (double)half;
        }
        bottom = y0 + (double)half;
        right = x0 + (double)half;
        g.drawString("C", (float)x, (float)(y0 + (double)fm.getAscent() - (double)(fm.getHeight() / 2)));
    }

    private static void drawTilde(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        double bottom_left = bottom - (double)(half / 2);
        double top_right = top + (double)(half / 2);
        double[] px = null;
        double[] py = null;
        if (size <= 6) {
            px = new double[]{left, x0 - (double)(half / 2), x0 + (double)(half / 2), right};
            py = new double[]{bottom_left, top, bottom, top_right};
        } else if (size <= 14) {
            double d = (double)(half + 1) / 4.0;
            px = new double[]{left, left, left + d, x0 - d, x0, x0, x0 + d, right - d, right, right};
            py = new double[]{bottom_left, top + d, top, top, top + d, bottom - d, bottom, bottom, bottom - d, top_right};
        } else {
            int i;
            int r = half / 2;
            int d = half % 2;
            double[] octX = new double[r * 4];
            double[] octY = new double[r * 4];
            int num = SubPixelScalableMarkers.getPointsInOctant(0.0, 0.0, r, octX, octY);
            int n = 2 * (4 * num - 3);
            px = new double[n += 2];
            py = new double[n];
            n = 0;
            px[n] = left;
            py[n] = bottom_left;
            ++n;
            double x02 = x0 - (double)r;
            double y02 = top + (double)r;
            for (i = 0; i < num - 1; ++i) {
                px[n] = x02 - octY[i] - (double)d;
                py[n] = y02 - octX[i];
                ++n;
            }
            for (i = num - 1; i > 0; --i) {
                px[n] = x02 - octX[i] - (double)d;
                py[n] = y02 - octY[i];
                ++n;
            }
            for (i = 0; i < num - 1; ++i) {
                px[n] = x02 + octX[i];
                py[n] = y02 - octY[i];
                ++n;
            }
            for (i = num - 1; i >= 0; --i) {
                px[n] = x02 + octY[i];
                py[n] = y02 - octX[i];
                ++n;
            }
            x02 = x0 + (double)r;
            y02 = bottom - (double)r;
            for (i = 0; i < num - 1; ++i) {
                px[n] = x02 - octY[i];
                py[n] = y02 + octX[i];
                ++n;
            }
            for (i = num - 1; i > 0; --i) {
                px[n] = x02 - octX[i];
                py[n] = y02 + octY[i];
                ++n;
            }
            for (i = 0; i < num - 1; ++i) {
                px[n] = x02 + octX[i] + (double)d;
                py[n] = y02 + octY[i];
                ++n;
            }
            for (i = num - 1; i >= 0; --i) {
                px[n] = x02 + octY[i] + (double)d;
                py[n] = y02 + octX[i];
                ++n;
            }
            px[n] = right;
            py[n] = top_right;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(px[0], py[0]);
        for (int i = 1; i < px.length; ++i) {
            path.lineTo(px[i], py[i]);
        }
        g.draw(path);
    }

    private static void drawIBeam(Graphics2D g, double x0, double y0, int size, double half, double top, double bottom, double left, double right, int thickness) {
        int d = size / 3;
        g.draw(new Line2D.Double(x0, top + 1.0, x0, bottom - 1.0));
        g.draw(new Line2D.Double(x0 - (double)d, top, x0 + (double)d, top));
        g.draw(new Line2D.Double(x0 - (double)d, bottom, x0 + (double)d, bottom));
    }

    private static void drawSquare(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor) {
        if (fillOn) {
            g.fill(new Rectangle2D.Double(left, top, size, size));
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, false);
                g.draw(new Rectangle2D.Double(left, top, size - 1, size - 1));
                if (oldStroke != null) {
                    g.setStroke(oldStroke);
                }
            }
        } else {
            g.draw(new Rectangle2D.Double(left, top, size - 1, size - 1));
        }
    }

    private static void drawAsterisk(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        int d = size / 3;
        g.draw(new Line2D.Double(x0, top, x0, bottom));
        g.draw(new Line2D.Double(left, y0 - (double)d, x0 - 1.0, y0));
        g.draw(new Line2D.Double(left, y0 + (double)d, x0 - 1.0, y0));
        g.draw(new Line2D.Double(right, y0 - (double)d, x0 + 1.0, y0));
        g.draw(new Line2D.Double(right, y0 + (double)d, x0 + 1.0, y0));
    }

    private static void drawY(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        g.draw(new Line2D.Double(x0, y0, x0, bottom));
        g.draw(new Line2D.Double(left, top, x0 - 1.0, y0 - 1.0));
        g.draw(new Line2D.Double(right, top, x0 + 1.0, y0 - 1.0));
    }

    private static void drawDiamond(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor) {
        double[] x = new double[4];
        double[] y = new double[4];
        boolean d = fillOn && edgeColor == null && thickness == 1;
        x[0] = left - (double)d;
        y[0] = y0;
        x[1] = x0;
        y[1] = top - (double)d;
        x[2] = right + (double)d;
        y[2] = y0;
        x[3] = x0;
        y[3] = bottom + (double)d;
        GeneralPath path = new GeneralPath();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < 4; ++i) {
            path.lineTo(x[i], y[i]);
        }
        path.closePath();
        if (fillOn) {
            g.fill(path);
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, false);
                g.draw(path);
                if (oldStroke != null) {
                    g.setStroke(oldStroke);
                }
            }
        } else {
            g.draw(path);
        }
    }

    private static void drawZ(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        double[] x = new double[6];
        double[] y = new double[6];
        x[0] = left;
        y[0] = top;
        x[1] = right;
        y[1] = top;
        x[2] = right;
        y[2] = top + 1.0;
        x[3] = left;
        y[3] = bottom - 1.0;
        x[4] = left;
        y[4] = bottom;
        x[5] = right;
        y[5] = bottom;
        GeneralPath path = new GeneralPath();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < 6; ++i) {
            path.lineTo(x[i], y[i]);
        }
        g.draw(path);
    }

    private static void drawUnion(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        if (size <= 3) {
            g.draw(new Line2D.Double(left, top, left, bottom - 1.0));
            g.draw(new Line2D.Double(right, top, right, bottom - 1.0));
            g.draw(new Line2D.Double(x0, bottom, x0, bottom));
            return;
        }
        int r = size / 3;
        double x0_l = left + (double)r;
        double x0_r = right - (double)r;
        double y02 = bottom - (double)r;
        double[] px = null;
        double[] py = null;
        if (size <= 6) {
            px = new double[]{left, left, left + 1.0, right - 1.0, right, right};
            py = new double[]{top, bottom - 1.0, bottom, bottom, bottom - 1.0, top};
        } else if (size <= 14) {
            double d = (double)(2 * r + 1) / 4.0;
            px = new double[]{left, left, x0_l - d, x0_l, x0_r, x0_r + d, right, right};
            py = new double[]{top, bottom - (double)r, bottom - d, bottom, bottom, bottom - d, bottom - (double)r, top};
        } else {
            int i;
            double[] octX = new double[r * 4];
            double[] octY = new double[r * 4];
            int num = SubPixelScalableMarkers.getPointsInOctant(0.0, 0.0, r, octX, octY);
            int n = 2 * (2 * num - 1);
            px = new double[n += 2];
            py = new double[n];
            n = 0;
            px[n] = left;
            py[n] = top;
            ++n;
            for (i = 0; i < num - 1; ++i) {
                px[n] = x0_l - octY[i];
                py[n] = y02 + octX[i];
                ++n;
            }
            for (i = num - 1; i >= 0; --i) {
                px[n] = x0_l - octX[i];
                py[n] = y02 + octY[i];
                ++n;
            }
            for (i = 0; i < num - 1; ++i) {
                px[n] = x0_r + octX[i];
                py[n] = y02 + octY[i];
                ++n;
            }
            for (i = num - 1; i >= 0; --i) {
                px[n] = x0_r + octY[i];
                py[n] = y02 + octX[i];
                ++n;
            }
            px[n] = right;
            py[n] = top;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(px[0], py[0]);
        for (int i = 1; i < px.length; ++i) {
            path.lineTo(px[i], py[i]);
        }
        g.draw(path);
    }

    private static void drawHash(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        if (size <= 4) {
            g.draw(new Line2D.Double(left, y0, right, y0));
            g.draw(new Line2D.Double(x0, top, x0, bottom));
        } else {
            int d = size / 4;
            d = Math.max(d, thickness);
            g.draw(new Line2D.Double(left, y0 - (double)d, right, y0 - (double)d));
            g.draw(new Line2D.Double(left, y0 + (double)d, right, y0 + (double)d));
            g.draw(new Line2D.Double(x0 - (double)d, top, x0 - (double)d, bottom));
            g.draw(new Line2D.Double(x0 + (double)d, top, x0 + (double)d, bottom));
        }
    }

    private static void drawTack(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        g.draw(new Line2D.Double(left, top, right, top));
        g.draw(new Line2D.Double(x0, top + 1.0, x0, bottom));
    }

    private static void drawHomeDown(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor) {
        if (size > 6) {
            bottom += 1.0;
            y0 += 1.0;
        }
        double[] x = new double[5];
        double[] y = new double[5];
        boolean d = fillOn && edgeColor == null && thickness == 1;
        x[0] = left;
        y[0] = y0;
        x[1] = left;
        y[1] = top;
        x[2] = right + (double)d;
        y[2] = top;
        x[3] = right + (double)d;
        y[3] = y0;
        x[4] = x0;
        y[4] = bottom + (double)d;
        GeneralPath path = new GeneralPath();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < 5; ++i) {
            path.lineTo(x[i], y[i]);
        }
        path.closePath();
        if (fillOn) {
            g.fill(path);
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, false);
                g.draw(path);
                if (oldStroke != null) {
                    g.setStroke(oldStroke);
                }
            }
        } else {
            g.draw(path);
        }
    }

    private static void drawGreaterThan(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        double[] x = new double[3];
        double[] y = new double[3];
        x[0] = left;
        y[0] = top;
        x[1] = right;
        y[1] = y0;
        x[2] = left;
        y[2] = bottom;
        GeneralPath path = new GeneralPath();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < 3; ++i) {
            path.lineTo(x[i], y[i]);
        }
        g.draw(path);
    }

    private static void drawLessThan(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        double[] x = new double[3];
        double[] y = new double[3];
        x[0] = right;
        y[0] = top;
        x[1] = left;
        y[1] = y0;
        x[2] = right;
        y[2] = bottom;
        GeneralPath path = new GeneralPath();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < 3; ++i) {
            path.lineTo(x[i], y[i]);
        }
        g.draw(path);
    }

    private static void drawArrowDown(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        g.draw(new Line2D.Double(x0, top, x0, (bottom += 1.0) - (double)(thickness / 2)));
        double[] px = new double[]{left, x0, right};
        double[] py = new double[]{y0 += 1.0, bottom, y0};
        GeneralPath path = new GeneralPath();
        path.moveTo(px[0], py[0]);
        for (int i = 1; i < 3; ++i) {
            path.lineTo(px[i], py[i]);
        }
        g.draw(path);
    }

    private static void drawStar(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor) {
        boolean aa = false;
        if (g instanceof Graphics2D && g.getRenderingHint(RenderingHints.KEY_ANTIALIASING) != null) {
            aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (size <= 4) {
            g.draw(new Line2D.Double(x0, y0 - 1.0, x0, y0 - 1.0));
            g.draw(new Line2D.Double(x0 - 1.0, y0, x0 + 1.0, y0));
            g.draw(new Line2D.Double(x0 - 1.0, y0 + 1.0, x0 - 1.0, y0 + 1.0));
            g.draw(new Line2D.Double(x0 + 1.0, y0 + 1.0, x0 + 1.0, y0 + 1.0));
            return;
        }
        double[] x = new double[10];
        double[] y = new double[10];
        if (size <= 5) {
            x[0] = x0;
            y[0] = top;
            x[1] = x0 + 1.0;
            y[1] = top + 1.0;
            x[2] = right;
            y[2] = top + 1.0;
            x[3] = x0 + 1.0;
            y[3] = y0 + 1.0;
            x[4] = x0 + 1.0;
            y[4] = bottom;
            x[5] = x0;
            y[5] = y0 + 1.0;
            x[6] = x0 - 1.0;
            y[6] = bottom;
            x[7] = x0 - 1.0;
            y[7] = aa ? y0 + 1.0 : top + 1.0;
            x[8] = left;
            y[8] = top + 1.0;
            x[9] = x0 - 1.0;
            y[9] = top + 1.0;
        } else {
            double r = (double)half / 2.0;
            if (size <= 8) {
                r = 2.0;
            }
            boolean d = size <= 10;
            boolean e = size <= 8;
            double sin54 = Math.sin(0.9424777960769379);
            double cos54 = Math.cos(0.9424777960769379);
            double sin18 = Math.sin(0.3141592653589793);
            double cos18 = Math.cos(0.3141592653589793);
            double hsin54 = Math.ceil((double)half * sin54);
            double hcos54 = Math.ceil((double)half * cos54);
            double rsin54 = Math.ceil(r * sin54);
            double rcos54 = Math.ceil(r * cos54);
            double hsin18 = Math.ceil((double)half * sin18);
            double hcos18 = Math.ceil((double)half * cos18);
            double rsin18 = Math.ceil(r * sin18);
            double rcos18 = Math.ceil(r * cos18);
            x[0] = x0;
            y[0] = top - (double)d + (double)e;
            x[1] = x0 + rcos54 - (double)d;
            y[1] = y0 - rsin54 + (double)e;
            x[2] = x0 + hcos18;
            y[2] = y0 - hsin18;
            x[3] = x0 + rcos18 - (double)e;
            y[3] = y0 + rsin18 - (double)d + (double)e;
            x[4] = x0 + hcos54;
            y[4] = y0 + hsin54;
            x[5] = x0;
            y[5] = y0 + r - (double)d;
            x[6] = x0 - hcos54;
            y[6] = y0 + hsin54;
            x[7] = x0 - rcos18 + (double)e;
            y[7] = y0 + rsin18 - (double)d + (double)e;
            x[8] = x0 - hcos18;
            y[8] = y0 - hsin18;
            x[9] = x0 - rcos54 + (double)d;
            y[9] = y0 - rsin54 + (double)e;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < 10; ++i) {
            path.lineTo(x[i], y[i]);
        }
        path.closePath();
        Stroke oldStroke = null;
        if (fillOn) {
            g.fill(path);
            if (edgeColor != null || thickness > 1) {
                oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, SubPixelScalableMarkers.isRound(54, size));
            }
        }
        g.draw(path);
        if (oldStroke != null) {
            g.setStroke(oldStroke);
        }
    }

    private static void drawHexagon(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor) {
        if (size <= 3) {
            g.draw(new Line2D.Double(left, y0, x0, bottom));
            g.draw(new Line2D.Double(x0, top, right, y0));
            if (fillOn) {
                g.draw(new Line2D.Double(x0, y0, x0, y0));
            }
            return;
        }
        double d = (half + 1) / 2;
        double[] x = new double[6];
        double[] y = new double[6];
        x[0] = left;
        y[0] = y0;
        x[1] = left + d;
        y[1] = top;
        x[2] = right - d;
        y[2] = top;
        x[3] = right;
        y[3] = y0;
        x[4] = right - d;
        y[4] = bottom;
        x[5] = left + d;
        y[5] = bottom;
        GeneralPath path = new GeneralPath();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < 6; ++i) {
            path.lineTo(x[i], y[i]);
        }
        path.closePath();
        if (fillOn) {
            g.fill(path);
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, false);
                g.draw(path);
                if (oldStroke != null) {
                    g.setStroke(oldStroke);
                }
            }
        } else {
            g.draw(path);
        }
    }

    private static void drawOctagon(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor) {
        if (size <= 3) {
            g.draw(new Line2D.Double(left, y0, x0, bottom));
            g.draw(new Line2D.Double(x0, top, right, y0));
            if (fillOn) {
                g.draw(new Line2D.Double(x0, y0, x0, y0));
            }
            return;
        }
        double d = (double)half / 2.0;
        double[] x = new double[8];
        double[] y = new double[8];
        x[0] = left;
        y[0] = y0 - d;
        x[1] = x0 - d;
        y[1] = top;
        x[2] = x0 + d;
        y[2] = top;
        x[3] = right;
        y[3] = y0 - d;
        x[4] = right;
        y[4] = y0 + d;
        x[5] = x0 + d;
        y[5] = bottom;
        x[6] = x0 - d;
        y[6] = bottom;
        x[7] = left;
        y[7] = y0 + d;
        GeneralPath path = new GeneralPath();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < 8; ++i) {
            path.lineTo(x[i], y[i]);
        }
        path.closePath();
        if (fillOn) {
            g.fill(path);
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, false);
                g.draw(path);
                if (oldStroke != null) {
                    g.setStroke(oldStroke);
                }
            }
        } else {
            g.draw(path);
        }
    }

    private static void drawOctagonRotated(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor) {
        if (size <= 3) {
            g.draw(new Line2D.Double(left, y0, x0, bottom));
            g.draw(new Line2D.Double(x0, top, right, y0));
            if (fillOn) {
                g.draw(new Line2D.Double(x0, y0, x0, y0));
            }
            return;
        }
        double d = half / 3;
        double[] x = new double[8];
        double[] y = new double[8];
        x[0] = left;
        y[0] = y0;
        x[1] = left + d;
        y[1] = top + d;
        x[2] = x0;
        y[2] = top;
        x[3] = right - d;
        y[3] = top + d;
        x[4] = right;
        y[4] = y0;
        x[5] = right - d;
        y[5] = bottom - d;
        x[6] = x0;
        y[6] = bottom;
        x[7] = left + d;
        y[7] = bottom - d;
        GeneralPath path = new GeneralPath();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < 8; ++i) {
            path.lineTo(x[i], y[i]);
        }
        path.closePath();
        if (fillOn) {
            g.fill(path);
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, false);
                g.draw(path);
                if (oldStroke != null) {
                    g.setStroke(oldStroke);
                }
            }
        } else {
            g.draw(path);
        }
    }

    private static void drawPentagon(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor) {
        if (size <= 3) {
            g.draw(new Line2D.Double(left, y0, x0, bottom));
            g.draw(new Line2D.Double(x0, top, right, y0));
            if (fillOn) {
                g.draw(new Line2D.Double(x0, y0, x0, y0));
            }
            return;
        }
        double d = half / 4;
        double[] x = new double[5];
        double[] y = new double[5];
        x[0] = left;
        y[0] = y0 - d;
        x[1] = x0;
        y[1] = top;
        x[2] = right;
        y[2] = y0 - d;
        x[3] = x0 + 2.5 * d;
        y[3] = bottom;
        x[4] = x0 - 2.5 * d;
        y[4] = bottom;
        GeneralPath path = new GeneralPath();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < 5; ++i) {
            path.lineTo(x[i], y[i]);
        }
        path.closePath();
        if (fillOn) {
            g.fill(path);
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, false);
                g.draw(path);
                if (oldStroke != null) {
                    g.setStroke(oldStroke);
                }
            }
        } else {
            g.draw(path);
        }
    }

    private static void drawCross(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor) {
        if (size <= 3) {
            g.draw(new Line2D.Double(left, y0, right, y0));
            g.draw(new Line2D.Double(x0, top, x0, bottom));
            return;
        }
        double d = (size + 1) / 6;
        boolean e = (d = Math.max(d, (double)(thickness - 1))) == 1.0 && thickness > 1;
        double[] x = new double[]{left, left, x0 - d, x0 - d, x0 + d + (double)e, x0 + d + (double)e, right + (double)e, right + (double)e, x0 + d + (double)e, x0 + d + (double)e, x0 - d, x0 - d};
        double[] y = new double[]{y0 + d + (double)e, y0 - d, y0 - d, top, top, y0 - d, y0 - d, y0 + d + (double)e, y0 + d + (double)e, bottom + (double)e, bottom + (double)e, y0 + d + (double)e};
        GeneralPath path = new GeneralPath();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < x.length; ++i) {
            path.lineTo(x[i], y[i]);
        }
        path.closePath();
        if (fillOn) {
            g.fill(path);
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, false);
                g.draw(path);
                if (oldStroke != null) {
                    g.setStroke(oldStroke);
                }
            }
        } else {
            g.draw(path);
        }
    }

    private static void drawSVGUnion(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        double r = (double)size / 3.0;
        g.draw(new Arc2D.Double(left, bottom - 2.0 * r, size - 1, r * 2.0, 180.0, 180.0, 0));
        g.draw(new Line2D.Double(left, top, left, bottom - r + 0.5));
        g.draw(new Line2D.Double(right, top, right, bottom - r + 0.5));
    }

    private static void drawSVGCircle(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, Color edgeColor, boolean fill) {
        Ellipse2D.Double circle = new Ellipse2D.Double(left, top, size - 1, size - 1);
        if (fill) {
            g.fill(circle);
        } else {
            g.draw(circle);
        }
        if (edgeColor != null || thickness > 1) {
            Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, true);
            g.draw(circle);
            if (oldStroke != null) {
                g.setStroke(oldStroke);
            }
        }
    }

    private static void drawSVGTilde(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        if (size < 5) {
            double bottom_left = bottom - (double)half / 2.0;
            double top_right = top + (double)half / 2.0;
            double[] px = new double[]{left, x0 - (double)(half / 2), x0 + (double)(half / 2), right};
            double[] py = new double[]{bottom_left, top, bottom, top_right};
            GeneralPath path = new GeneralPath();
            path.moveTo(px[0], py[0]);
            for (int i = 1; i < px.length; ++i) {
                path.lineTo(px[i], py[i]);
            }
            g.draw(path);
        } else {
            double r = (double)half / 2.0;
            g.draw(new Arc2D.Double(left, top, half, half, 0.0, 180.0, 0));
            g.draw(new Arc2D.Double(x0, y0, half, half, 180.0, 180.0, 0));
            g.draw(new Line2D.Double(left, top + r - 0.5, left, bottom - r));
            g.draw(new Line2D.Double(right, top + r, right, bottom - r + 0.5));
            g.draw(new Line2D.Double(x0, top + r - 0.5, x0, bottom - r + 0.5));
        }
    }

    private static void drawSVGY(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness) {
        g.draw(new Line2D.Double(x0, y0, x0, bottom));
        g.draw(new Line2D.Double(left, top, x0, y0));
        g.draw(new Line2D.Double(right, top, x0, y0));
    }

    private static void drawSVGSquare(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor) {
        Rectangle2D.Double rect = new Rectangle2D.Double(left, top, size - 1, size - 1);
        if (fillOn) {
            g.fill(rect);
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, false);
                g.draw(rect);
                if (oldStroke != null) {
                    g.setStroke(oldStroke);
                }
            }
        } else {
            g.draw(rect);
        }
    }

    private static void drawSVGTriangle(Graphics2D g, double x0, double y0, int size, int half, double top, double bottom, double left, double right, int thickness, boolean fillOn, Color edgeColor, int dir) {
        double[] x = new double[3];
        double[] y = new double[3];
        switch (dir) {
            default: {
                x[0] = x0;
                y[0] = top;
                x[1] = left;
                y[1] = bottom;
                x[2] = right;
                y[2] = bottom;
                break;
            }
            case 1: {
                x[0] = x0;
                y[0] = bottom;
                x[1] = left;
                y[1] = top;
                x[2] = right;
                y[2] = top;
                break;
            }
            case 2: {
                x[0] = left;
                y[0] = y0;
                x[1] = right;
                y[1] = top;
                x[2] = right;
                y[2] = bottom;
                break;
            }
            case 3: {
                x[0] = right;
                y[0] = y0;
                x[1] = left;
                y[1] = top;
                x[2] = left;
                y[2] = bottom;
            }
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(x[0], y[0]);
        for (int i = 1; i < 3; ++i) {
            path.lineTo(x[i], y[i]);
        }
        path.closePath();
        if (fillOn) {
            g.fill(path);
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = SubPixelScalableMarkers.setOutlineDrawingProperties(g, edgeColor, thickness, false);
                g.draw(path);
                if (oldStroke != null) {
                    g.setStroke(oldStroke);
                }
            }
        } else {
            g.draw(path);
        }
    }

    private static boolean isFilled(int shape) {
        switch (shape) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 105: 
            case 106: 
            case 108: 
            case 148: 
            case 174: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 188: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRound(int shape, int size) {
        switch (shape) {
            default: {
                return false;
            }
            case 0: 
            case 16: 
            case 63: 
            case 65: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 187: 
            case 188: {
                return true;
            }
            case 23: 
            case 54: 
        }
        return size <= 9;
    }

    private static int getAdjustedSize(int shape, int maxSize) {
        int size = maxSize % 2 == 0 ? maxSize - 1 : maxSize;
        int half = size / 2;
        switch (shape) {
            case 23: 
            case 54: {
                double adj = (double)half * 0.1;
                size = (int)Math.ceil((double)half / Math.cos(0.3141592653589793) + adj) * 2 + 1;
                break;
            }
            case 6: 
            case 22: {
                size = (int)((1.414 * (double)half + (double)half) / 2.0 + 0.5) * 2 + 1;
                break;
            }
        }
        return size;
    }

    private static int getOutlineThickness(int shape, int maxSize, int weight) {
        double wt;
        switch (shape) {
            case 0: {
                break;
            }
            case 16: {
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 2: 
            case 5: 
            case 59: 
            case 60: {
                break;
            }
            case 18: 
            case 21: 
            case 105: 
            case 106: {
                break;
            }
            case 63: {
                break;
            }
            case 66: {
                break;
            }
            case 3: {
                break;
            }
            case 19: {
                break;
            }
            case 58: {
                break;
            }
            case 150: {
                break;
            }
            case 6: {
                break;
            }
            case 22: {
                break;
            }
            case 151: {
                break;
            }
            case 65: {
                break;
            }
            case 56: {
                break;
            }
            case 70: {
                break;
            }
            case 73: {
                break;
            }
            case 108: {
                break;
            }
            case 62: {
                break;
            }
            case 134: {
                break;
            }
        }
        switch (weight) {
            default: {
                wt = (double)maxSize * NORMAL_PERCENT;
                break;
            }
            case 1: {
                wt = (double)maxSize * SEMI_BOLD_PERCENT;
                break;
            }
            case 2: {
                wt = (double)maxSize * BOLD_PERCENT;
            }
        }
        return Math.max(1, (int)wt);
    }

    private static int getFilledMarkerSize(int shape, int maxSize, int weight) {
        if (SubPixelScalableMarkers.isFilled(shape)) {
            int d = maxSize % 2 == 0 ? 0 : 1;
            int wt = SubPixelScalableMarkers.getOutlineThickness(shape, maxSize, weight);
            maxSize = shape == 23 ? (maxSize += (int)Math.ceil((double)(wt - 1) / Math.sin(0.6283185307179586))) : (maxSize += wt - 1);
            maxSize = maxSize / 2 * 2 + d;
        }
        return maxSize;
    }

    private static int getPointsInOctant(double x0, double y0, int r, double[] X, double[] Y) {
        int comparator;
        double x = 0.0;
        double y = r;
        double d = 1 - r;
        int n = 0;
        X[n] = x0 + x;
        Y[n] = y0 + y;
        ++n;
        boolean hasPoint = false;
        int n2 = comparator = r == 16 ? -1 : 0;
        while (y > x) {
            if (d <= (double)comparator) {
                d += 2.0 * x + 3.0;
                x += 1.0;
                hasPoint = true;
                continue;
            }
            if (hasPoint) {
                X[n] = x0 + x;
                Y[n] = y0 + y;
                ++n;
                hasPoint = false;
            }
            d += 2.0 * (x - y) + 5.0;
            X[n] = x0 + (x += 1.0);
            Y[n] = y0 + (y -= 1.0);
            ++n;
        }
        if (hasPoint) {
            X[n] = x0 + x;
            Y[n] = y0 + y;
            ++n;
        }
        return n;
    }

    private static Stroke setOutlineDrawingProperties(Graphics2D g, Color color, int thickness, boolean round) {
        if (color != null) {
            g.setColor(color);
        }
        if (thickness <= 1) {
            return null;
        }
        Stroke oldStroke = g.getStroke();
        if (round) {
            g.setStroke(new BasicStroke(thickness, 0, 1));
        } else {
            g.setStroke(new BasicStroke(thickness));
        }
        return oldStroke;
    }
}

