/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.RB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.RepaintManager;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class PrintSupport
implements Pageable,
Printable {
    private static final int PAGE_NUMBER_WIDTH = 20;
    private static final int PAGE_NUMBER_HEIGHT = 15;
    private static DoubleInsets default_margins;
    private static UnitItem default_units;
    private double mScaleX = 1.0;
    private double mScaleY = 1.0;
    private int mNumPagesX = 1;
    private int mNumPagesY = 1;
    private Component mComponent;
    private boolean mFitToPages = false;
    private boolean mFillSinglePage = false;
    private boolean mShowDialog = true;
    private boolean mDialogCancelled = false;
    private boolean mNumberingPages = false;
    private int mPageNumber = 1;
    private PageFormat mFormat = new PageFormat();
    private boolean mPageOrderHorizontal = true;
    private SetupDialogTabInterface mChartSetupTab;
    private boolean mUseCrossPlatformDialog = false;
    private PrintRequestAttributeSet mCrossPlatformAttributes = null;
    private double tScaleX;
    private double tScaleY;
    private int tNumPagesX;
    private int tNumPagesY;
    private int tNumPages;
    private int tCompWidth;
    private int tCompHeight;
    private boolean upToDate = false;
    private BufferedImage pageImage = null;
    private JDialog previewDialog;
    private JDialog setupDialog;
    private PrinterJob pj = PrinterJob.getPrinterJob();
    private int printingPageNumber = -1;

    public static void print(Component c) {
        PrintSupport ps = new PrintSupport();
        ps.setComponent(c);
        ps.print();
    }

    public boolean print() {
        this.setSize();
        this.pj.setPageable(this);
        if (this.mShowDialog) {
            this.printDialog(this.pj);
        }
        if (!this.mDialogCancelled) {
            try {
                if (this.mUseCrossPlatformDialog && this.mCrossPlatformAttributes != null) {
                    this.pj.print(this.mCrossPlatformAttributes);
                } else {
                    this.pj.print();
                }
                this.mPageNumber += this.tNumPages;
            }
            catch (PrinterException x) {
                x.printStackTrace();
            }
        }
        this.pageImage = null;
        this.printingPageNumber = -1;
        return !this.mDialogCancelled;
    }

    public void printDialog() {
        this.printDialog(this.pj);
    }

    private void printDialog(PrinterJob j) {
        if (this.mUseCrossPlatformDialog) {
            this.mCrossPlatformAttributes = new HashPrintRequestAttributeSet();
            this.mCrossPlatformAttributes.add(this.isPortraitMode() ? OrientationRequested.PORTRAIT : OrientationRequested.LANDSCAPE);
            boolean oldPortraitMode = this.isPortraitMode();
            this.mCrossPlatformAttributes.add(this.getNonMarginArea());
            MediaPrintableArea oldMargins = this.getNonMarginArea();
            this.mCrossPlatformAttributes.add(new PageRanges(1, this.getNumberOfPages()));
            boolean bl = this.mDialogCancelled = !j.printDialog(this.mCrossPlatformAttributes);
            if (!this.mDialogCancelled) {
                Attribute nonMarginArea;
                Attribute orientationAttr = this.mCrossPlatformAttributes.get(OrientationRequested.class);
                boolean portraitReq = orientationAttr.equals(OrientationRequested.PORTRAIT);
                if (portraitReq != oldPortraitMode) {
                    this.setPortraitMode(portraitReq);
                }
                if (!oldMargins.equals(nonMarginArea = this.mCrossPlatformAttributes.get(MediaPrintableArea.class))) {
                    this.setNonMarginArea((MediaPrintableArea)nonMarginArea);
                }
            }
        } else {
            this.mDialogCancelled = !j.printDialog();
        }
    }

    public void setupDialog(Dialog owner) {
        this._setupDialog(owner);
    }

    public void setupDialog(Frame owner) {
        this._setupDialog(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setupDialog(Window owner) {
        PrintSupport printSupport = this;
        synchronized (printSupport) {
            if (this.setupDialog != null && this.setupDialog.isShowing()) {
                return;
            }
            this._setSize();
            this.setupDialog = owner instanceof Dialog ? new Setup((Dialog)owner, this.mChartSetupTab) : new Setup((Frame)owner, this.mChartSetupTab);
        }
        this.setupDialog.pack();
        this.setupDialog.setLocationRelativeTo(owner);
        this.setupDialog.show();
        this.setupDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Window w;
                PrintSupport.this.setSize();
                if (PrintSupport.this.setupDialog != null && (w = PrintSupport.this.setupDialog.getOwner()) instanceof Preview) {
                    ((Preview)w).refresh();
                }
                PrintSupport.this.setupDialog = null;
            }
        });
    }

    public void previewDialog(Dialog owner) {
        this._previewDialog(owner);
    }

    public void previewDialog(Frame owner) {
        this._previewDialog(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _previewDialog(Object owner) {
        PrintSupport printSupport = this;
        synchronized (printSupport) {
            if (this.previewDialog != null && this.previewDialog.isShowing()) {
                return;
            }
            this._setSize();
            this.previewDialog = owner instanceof Dialog ? new Preview((Dialog)owner) : new Preview((Frame)owner);
        }
        this.previewDialog.pack();
        if (owner instanceof Dialog) {
            this.previewDialog.setLocationRelativeTo((Dialog)owner);
        } else {
            this.previewDialog.setLocationRelativeTo((Window)owner);
        }
        this.previewDialog.show();
        this.previewDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Window w;
                PrintSupport.this.setSize();
                if (PrintSupport.this.previewDialog != null && (w = PrintSupport.this.previewDialog.getOwner()) instanceof Setup) {
                    w.repaint();
                }
                PrintSupport.this.previewDialog = null;
            }
        });
    }

    public Window previewHiddenDialog(Dialog owner) {
        return this.getHiddenPreviewDialog(owner);
    }

    public Window previewHiddenDialog(Frame owner) {
        return this.getHiddenPreviewDialog(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Window getHiddenPreviewDialog(Object owner) {
        PrintSupport printSupport = this;
        synchronized (printSupport) {
            if (this.previewDialog != null && this.previewDialog.isShowing()) {
                return null;
            }
            this._setSize();
            this.previewDialog = owner instanceof Dialog ? new Preview((Dialog)owner) : new Preview((Frame)owner);
        }
        this.previewDialog.pack();
        if (owner instanceof Dialog) {
            this.previewDialog.setLocationRelativeTo((Dialog)owner);
        } else {
            this.previewDialog.setLocationRelativeTo((Window)owner);
        }
        this.previewDialog.setVisible(false);
        this.previewDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Window w;
                PrintSupport.this.setSize();
                if (PrintSupport.this.previewDialog != null && (w = PrintSupport.this.previewDialog.getOwner()) instanceof Setup) {
                    w.repaint();
                }
                PrintSupport.this.previewDialog = null;
            }
        });
        return this.previewDialog;
    }

    public void setComponent(Component c) {
        this.mComponent = c;
        this.upToDate = false;
    }

    public Component getComponent() {
        return this.mComponent;
    }

    public void setPageFormat(PageFormat f) {
        this.mFormat = f;
        this.upToDate = false;
    }

    public PageFormat getPageFormat() {
        return this.mFormat;
    }

    public void setDialogEnabled(boolean show) {
        this.mShowDialog = show;
        this.upToDate = false;
    }

    public boolean isDialogEnabled() {
        return this.mShowDialog;
    }

    public void setScale(double[] scale) {
        if (scale == null) {
            this.mUseCrossPlatformDialog = true;
        }
        this.setScale(scale[0], scale[1]);
    }

    public void setScale(double scaleX, double scaleY) {
        this.mScaleX = scaleX;
        this.mScaleY = scaleY;
        this.mFitToPages = false;
        this.upToDate = false;
    }

    public double[] getScale() {
        return new double[]{this.mScaleX, this.mScaleY};
    }

    public double[] getComputedScale() {
        this.setSize();
        return new double[]{this.tScaleX, this.tScaleY};
    }

    public void setFitToPageEnabled(boolean fit) {
        this.mFitToPages = fit;
        this.upToDate = false;
    }

    public boolean isFitToPageEnabled() {
        return this.mFitToPages;
    }

    public void fitToSinglePage() {
        this.setFitToPages(1, 1);
    }

    public void setFitToPages(int h, int v) {
        this.mNumPagesX = h;
        this.mNumPagesY = v;
        this.setFitToPageEnabled(true);
    }

    public int[] getFitToPages() {
        int[] p = new int[]{this.mNumPagesX, this.mNumPagesY};
        return p;
    }

    public int[] getComputedFitToPages() {
        this.setSize();
        int[] p = new int[]{this.tNumPagesX, this.tNumPagesY};
        return p;
    }

    public void setFillSinglePage(boolean fill) {
        this.mFillSinglePage = fill;
        this.upToDate = false;
    }

    public boolean isFillSinglePage() {
        return this.mFillSinglePage;
    }

    public void setDialogCancelled(boolean b) {
        this.mDialogCancelled = b;
    }

    public boolean isDialogCancelled() {
        return this.mDialogCancelled;
    }

    public void setNumberingPages(boolean doPageNumbering) {
        if (this.mNumberingPages != doPageNumbering) {
            Insets s = this.getMargins();
            this.mNumberingPages = doPageNumbering;
            this.setMargins(s.top, s.left, s.bottom, s.right);
        }
    }

    public boolean isNumberingPages() {
        return this.mNumberingPages;
    }

    public void setPageNumber(int pagenum) {
        this.mPageNumber = pagenum;
    }

    public int getPageNumber() {
        return this.mPageNumber;
    }

    public void setPortraitMode() {
        this.setPortraitMode(true);
    }

    public void setLandscapeMode() {
        this.setPortraitMode(false);
    }

    public void setPortraitMode(boolean newPortrait) {
        boolean oldPortrait = this.isPortraitMode();
        if (newPortrait != oldPortrait) {
            boolean wasNumberingPages = this.mNumberingPages;
            this.setNumberingPages(false);
            this.mFormat.setOrientation(newPortrait ? 1 : 0);
            this.setNumberingPages(wasNumberingPages);
        }
        this.upToDate = false;
    }

    public boolean isPortraitMode() {
        return this.mFormat.getOrientation() == 1;
    }

    public boolean isLandscapeMode() {
        return this.mFormat.getOrientation() == 0;
    }

    @Override
    public int getNumberOfPages() {
        this.setSize();
        return this.tNumPages;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex >= this.tNumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this.mFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex >= this.tNumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    public void setPageOrderHorizontal(boolean horiz) {
        this.mPageOrderHorizontal = horiz;
    }

    public void setPageOrderHorizontal() {
        this.setPageOrderHorizontal(true);
    }

    public void setPageOrderVertical() {
        this.setPageOrderHorizontal(false);
    }

    public boolean isPageOrderHorizontal() {
        return this.mPageOrderHorizontal;
    }

    public boolean isPageOrderVertical() {
        return !this.mPageOrderHorizontal;
    }

    public void setMargins(int top, int left, int bottom, int right) {
        this.setMargins((double)top, (double)left, (double)bottom, (double)right);
    }

    private void setMargins(double top, double left, double bottom, double right) {
        double ih;
        double iw;
        double iy;
        double ix;
        int pnh;
        PageFormat f = this.getPageFormat();
        Paper p = f.getPaper();
        int pw = (int)p.getWidth();
        int pw9 = pw * 9 / 10;
        int pw1 = pw - pw9;
        int ph = (int)p.getHeight();
        int ph9 = ph * 9 / 10;
        int ph1 = ph - ph9;
        int n = pnh = this.mNumberingPages ? 15 : 0;
        if (top < 0.0) {
            top = 0.0;
        }
        if (left < 0.0) {
            left = 0.0;
        }
        if (bottom < 0.0) {
            bottom = 0.0;
        }
        if (right < 0.0) {
            right = 0.0;
        }
        if (this.isPortraitMode()) {
            if (top > (double)ph9) {
                top = ph9;
            }
            if (bottom > (double)ph9) {
                bottom = ph9;
            }
            if (top + bottom > (double)ph9) {
                bottom = (double)ph9 - top;
            }
            if (left > (double)pw9) {
                left = pw9;
            }
            if (right > (double)pw9) {
                right = pw9;
            }
            if (left + right > (double)pw9) {
                right = (double)pw9 - left;
            }
            ix = left;
            iy = top;
            iw = (double)pw - (left + right);
            ih = (double)ph - (top + bottom) + (double)pnh;
        } else {
            if (top > (double)pw9) {
                top = pw9;
            }
            if (bottom > (double)pw9) {
                bottom = pw9;
            }
            if (top + bottom > (double)pw9) {
                bottom = (double)pw9 - top;
            }
            if (left > (double)ph9) {
                left = ph9;
            }
            if (right > (double)ph9) {
                right = ph9;
            }
            if (left + right > (double)ph9) {
                right = (double)ph9 - left;
            }
            ix = top;
            iy = right;
            iw = (double)pw - (top + bottom) + (double)pnh;
            ih = (double)ph - (left + right);
        }
        if (ix + iw > (double)pw) {
            iw = (double)pw - ix;
        }
        if (iy + ih > (double)ph) {
            ih = (double)ph - iy;
        }
        if (default_margins == null) {
            default_margins = new DoubleInsets(top, left, bottom, right);
        }
        p.setImageableArea(ix, iy, iw, ih);
        f.setPaper(p);
        this.upToDate = false;
    }

    public void setMargins(int m) {
        this.setMargins(m, m, m, m);
    }

    public Insets getMargins() {
        DoubleInsets ii = this.getMargins(null);
        return new Insets((int)(ii.top + 0.5), (int)(ii.left + 0.5), (int)(ii.bottom + 0.5), (int)(ii.right + 0.5));
    }

    private DoubleInsets getMargins(DoubleInsets ii) {
        PageFormat f = this.getPageFormat();
        Paper p = f.getPaper();
        double pw = f.getWidth();
        double ph = f.getHeight();
        double ix = f.getImageableX();
        double iy = f.getImageableY();
        double iw = f.getImageableWidth();
        double ih = f.getImageableHeight();
        int pnh = this.mNumberingPages ? 15 : 0;
        double left = ix;
        double top = iy;
        double right = pw - (ix + iw);
        double bottom = ph - (iy + ih) + (double)pnh;
        if (ii != null) {
            ii.reset(top, left, bottom, right);
        } else {
            ii = new DoubleInsets(top, left, bottom, right);
        }
        return ii;
    }

    private MediaPrintableArea getNonMarginArea() {
        int pnh;
        PageFormat f = this.getPageFormat();
        Paper p = f.getPaper();
        double ix = p.getImageableX();
        double iy = p.getImageableY();
        double iw = p.getImageableWidth();
        double ih = p.getImageableHeight();
        int n = pnh = this.mNumberingPages ? 15 : 0;
        if (this.isPortraitMode()) {
            ih -= (double)pnh;
        } else {
            iw -= (double)pnh;
        }
        MediaPrintableArea mpa = new MediaPrintableArea((float)(ix / 72.0), (float)(iy / 72.0), (float)(iw / 72.0), (float)(ih / 72.0), 25400);
        return mpa;
    }

    private void setNonMarginArea(MediaPrintableArea mpa) {
        float ix = mpa.getX(25400) * 72.0f;
        float iy = mpa.getY(25400) * 72.0f;
        float iw = mpa.getWidth(25400) * 72.0f;
        float ih = mpa.getHeight(25400) * 72.0f;
        int pnh = this.mNumberingPages ? 15 : 0;
        PageFormat f = this.getPageFormat();
        Paper p = f.getPaper();
        p.setImageableArea(ix, iy, iw, ih += (float)pnh);
        f.setPaper(p);
    }

    private int getBodyHeight() {
        Insets margins = this.getMargins();
        PageFormat f = this.getPageFormat();
        return (int)f.getHeight() - (margins.top + margins.bottom);
    }

    private int getBodyWidth() {
        Insets margins = this.getMargins();
        PageFormat f = this.getPageFormat();
        return (int)f.getWidth() - (margins.left + margins.right);
    }

    private void setSize() {
        if (this.mComponent != null) {
            Rectangle b = this.mComponent.getBounds();
            if (this.tCompWidth != b.width || this.tCompHeight != b.height) {
                this.upToDate = false;
            }
            if (!this.upToDate) {
                this._setSize();
            }
        }
    }

    private void _setSize() {
        Rectangle b = this.mComponent.getBounds();
        this.tCompWidth = b.width;
        this.tCompHeight = b.height;
        int fw = this.getBodyWidth();
        int fh = this.getBodyHeight();
        if (this.mFitToPages) {
            this.tNumPagesX = this.mNumPagesX;
            this.tNumPagesY = this.mNumPagesY;
            if (this.mNumPagesX == 0) {
                this.tNumPagesX = (this.tCompWidth + fw / 2) / fw;
            }
            if (this.mNumPagesY == 0) {
                this.tNumPagesY = (this.tCompHeight + fh / 2) / fh;
            }
            if (this.tNumPagesX < 1) {
                this.tNumPagesX = 1;
            }
            if (this.tNumPagesY < 1) {
                this.tNumPagesY = 1;
            }
            this.tScaleX = (double)(fw * this.tNumPagesX) * 1.0 / (double)this.tCompWidth;
            this.tScaleY = (double)(fh * this.tNumPagesY) * 1.0 / (double)this.tCompHeight;
            if (this.mNumPagesX != 1 || this.mNumPagesY != 1 || !this.mFillSinglePage) {
                if (this.tScaleX > 1.0) {
                    this.tScaleX = 1.0;
                }
                if (this.tScaleY > 1.0) {
                    this.tScaleY = 1.0;
                }
            }
            if (this.mNumPagesX == -1 && this.mNumPagesY == -1) {
                this.tScaleY = 1.0;
                this.tScaleX = 1.0;
            } else if (this.mNumPagesX == -1) {
                this.tScaleX = this.tScaleY;
            } else if (this.mNumPagesY == -1) {
                this.tScaleY = this.tScaleX;
            } else if (this.tScaleX > this.tScaleY) {
                this.tScaleX = this.tScaleY;
            } else if (this.tScaleY > this.tScaleX) {
                this.tScaleY = this.tScaleX;
            }
            this.tNumPagesY = (int)(((double)this.tCompHeight * this.tScaleY + (double)fh - 1.0) / (double)fh);
            this.tNumPagesX = (int)(((double)this.tCompWidth * this.tScaleX + (double)fw - 1.0) / (double)fw);
        } else {
            this.tScaleX = this.mScaleX;
            this.tScaleY = this.mScaleY;
            this.tNumPagesX = (int)(((double)this.tCompWidth * this.tScaleX + (double)fw - 1.0) / (double)fw);
            this.tNumPagesY = (int)(((double)this.tCompHeight * this.tScaleY + (double)fh - 1.0) / (double)fh);
        }
        this.tNumPages = this.tNumPagesX * this.tNumPagesY;
        this.upToDate = true;
    }

    @Override
    public int print(Graphics g, PageFormat f, int pageIndex) throws PrinterException {
        Graphics2D g2page;
        int iPageNumY;
        int iPageNumX;
        int rc = 0;
        this.printingPageNumber = pageIndex;
        if (pageIndex >= this.tNumPages) {
            return 1;
        }
        this.setSize();
        Graphics2D g2 = (Graphics2D)g;
        Hashtable<RenderingHints.Key, Object> hints = new Hashtable<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.addRenderingHints(hints);
        Insets margin = this.getMargins();
        int mt = margin.top;
        int ml = margin.left;
        int mb = margin.bottom;
        int mr = margin.right;
        int pw = (int)this.mFormat.getWidth();
        int ph = (int)this.mFormat.getHeight();
        int pnh = this.mNumberingPages ? 15 : 0;
        int pBodyWidth = pw - (ml + mr);
        int pBodyHeight = ph - (mt + mb);
        int pImageableX = ml;
        int pImageableY = mt;
        int pImageableWidth = pBodyWidth;
        int pImageableHeight = pBodyHeight + pnh;
        if (this.mPageOrderHorizontal) {
            iPageNumX = pageIndex % this.tNumPagesX;
            iPageNumY = pageIndex / this.tNumPagesX;
        } else {
            iPageNumY = pageIndex % this.tNumPagesY;
            iPageNumX = pageIndex / this.tNumPagesY;
        }
        int iImageSlackX = 0;
        int iImageSlackY = 0;
        int iPageWidth = (int)((double)pBodyWidth / this.tScaleX);
        int iPageHeight = (int)((double)pBodyHeight / this.tScaleY);
        int iImageX0 = iPageNumX * iPageWidth;
        int iImageY0 = iPageNumY * iPageHeight;
        int iImageX1 = iImageX0 + iPageWidth;
        int iImageY1 = iImageY0 + iPageHeight;
        if (iImageX1 > this.tCompWidth) {
            iImageSlackX = iImageX1 - this.tCompWidth;
            iImageX1 = this.tCompWidth;
        }
        if (iImageY1 > this.tCompHeight) {
            iImageSlackY = iImageY1 - this.tCompHeight;
            iImageY1 = this.tCompHeight;
        }
        int iImageWidth = iImageX1 - iImageX0;
        int iImageHeight = iImageY1 - iImageY0;
        boolean buffered = true;
        if (buffered) {
            if (this.pageImage == null || this.pageImage.getWidth() != pw || this.pageImage.getHeight() != ph) {
                this.pageImage = new BufferedImage(pw, ph, 2);
            }
            g2page = this.pageImage.createGraphics();
        } else {
            g2page = (Graphics2D)g2.create();
        }
        g2page.addRenderingHints(hints);
        g2page.setColor(Color.white);
        g2page.fillRect(0, 0, pw, ph);
        Graphics2D g2body = (Graphics2D)g2page.create();
        g2body.addRenderingHints(hints);
        g2body.translate(pImageableX, pImageableY);
        g2body.scale(this.tScaleX, this.tScaleY);
        g2body.translate(-iImageX0, -iImageY0);
        RepaintManager rman = RepaintManager.currentManager(this.mComponent);
        boolean dub = rman.isDoubleBufferingEnabled();
        rman.setDoubleBufferingEnabled(false);
        this.mComponent.paint(g2body);
        rman.setDoubleBufferingEnabled(dub);
        g2body.dispose();
        g2page.setColor(Color.white);
        g2page.fillRect(0, 0, pw, mt);
        g2page.fillRect(0, 0, ml, ph);
        g2page.fillRect(0, ph - mb, pw, mb);
        g2page.fillRect(pw - mr, 0, mr, ph);
        if (this.mNumberingPages) {
            String pageno = "" + (this.mPageNumber + pageIndex);
            int pagenoPositionX = pImageableX + pImageableWidth - 20;
            int pagenoPositionY = pImageableY + pImageableHeight;
            g2page.setColor(Color.black);
            g2page.drawString(pageno, pagenoPositionX, pagenoPositionY);
        }
        if (buffered) {
            ((Graphics2D)g).drawRenderedImage(this.pageImage, new AffineTransform());
        }
        g2page.dispose();
        return rc;
    }

    public int getCurrentPrintingPageNumber() {
        if (this.printingPageNumber == -1) {
            return this.printingPageNumber;
        }
        return this.printingPageNumber + 1;
    }

    public void setSetupDialogTab(SetupDialogTabInterface tab) {
        this.mChartSetupTab = tab;
    }

    public SetupDialogTabInterface getSetupDialogTab() {
        return this.mChartSetupTab;
    }

    private static ImageIcon makeImageIcon(String name) {
        String iconPath = "com/sas/graphics/util/";
        URL url = PrintSupport.class.getClassLoader().getResource("com/sas/graphics/util/" + name);
        return new ImageIcon(url);
    }

    private static final String intToString(int i) {
        return "" + i;
    }

    private static final double min(double a, double b) {
        return a < b ? a : b;
    }

    private static final double min(double a, double b, double c) {
        return PrintSupport.min(PrintSupport.min(a, b), c);
    }

    private class DoubleInsets {
        public double top;
        public double left;
        public double bottom;
        public double right;

        public DoubleInsets(double top, double left, double bottom, double right) {
            this.reset(top, left, bottom, right);
        }

        public void reset(double top, double left, double bottom, double right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }
    }

    private static class UnitItem {
        private static final String RB_KEY = "MarginUnits.";
        public static final int UNIT_PIXELS = 0;
        public static final int UNIT_CENTIMETERS = 1;
        public static final int UNIT_INCHES = 2;
        private static final double PIXELS_PER_INCH = 72.0;
        private static final double PIXELS_PER_CENTIMETER = 28.3464567;
        private static final UnitItem[] allItems = new UnitItem[]{new UnitItem(RB.getStringResource("MarginUnits.", "Pixels.txt"), 0), new UnitItem(RB.getStringResource("MarginUnits.", "Centimeters.txt"), 1), new UnitItem(RB.getStringResource("MarginUnits.", "Inches.txt"), 2)};
        private String unitName;
        private int unit;
        private int decimals;

        private UnitItem(String name, int unit) {
            this.unitName = name;
            switch (unit) {
                case 0: {
                    this.decimals = 0;
                    break;
                }
                case 2: {
                    this.decimals = 1;
                    break;
                }
                case 1: {
                    this.decimals = 1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.unit = unit;
        }

        public static UnitItem getUnitItem(int unit) {
            if (unit < 0 || unit >= allItems.length) {
                throw new IllegalArgumentException();
            }
            return allItems[unit];
        }

        public int getUnit() {
            return this.unit;
        }

        public String getName() {
            return this.unitName;
        }

        public String toString() {
            return this.unitName;
        }

        public int getDecimals() {
            return this.decimals;
        }

        public double toPixels(Number units) {
            return this.toPixels(units.doubleValue());
        }

        public double toPixels(double units) {
            switch (this.unit) {
                case 0: {
                    return units;
                }
                case 2: {
                    return units * 72.0;
                }
                case 1: {
                    return units * 28.3464567;
                }
            }
            throw new IllegalArgumentException();
        }

        public double fromPixels(double pixels) {
            switch (this.unit) {
                case 0: {
                    return pixels;
                }
                case 2: {
                    return pixels / 72.0;
                }
                case 1: {
                    return pixels / 28.3464567;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private class Setup
    extends JDialog {
        private static final String RB_KEY = "PrintSetupDialog.";
        private JTabbedPane tabs;
        private SetupDialogTabInterface chartTab;
        private SetupDialogTabInterface pageTab;
        private JDialog advancedDialog;

        public Setup(Frame parent, SetupDialogTabInterface tab) {
            super(parent);
            this.tabs = new JTabbedPane();
            this.createDialog(tab);
        }

        public Setup(Dialog parent, SetupDialogTabInterface tab) {
            super(parent);
            this.tabs = new JTabbedPane();
            this.createDialog(tab);
        }

        @Override
        public void show() {
            if (this.chartTab != null) {
                this.chartTab.readModel();
            }
            if (this.pageTab != null) {
                this.pageTab.readModel();
            }
            super.show();
        }

        private void createDialog(SetupDialogTabInterface tab) {
            this.setResizable(false);
            this.chartTab = tab;
            this.pageTab = new PageTab();
            this.setTitle(RB.getStringResource(RB_KEY, "PrintSetup.txt"));
            this.getContentPane().setLayout(new BorderLayout(5, 5));
            if (this.chartTab != null && this.pageTab != null) {
                this.tabs.setBorder(new EmptyBorder(5, 5, 5, 5));
                this.tabs.add((Component)this.pageTab.getTabContents(), this.pageTab.getTabName());
                this.tabs.add((Component)this.chartTab.getTabContents(), this.chartTab.getTabName());
                this.getContentPane().add(this.tabs);
            } else if (this.pageTab != null) {
                this.getContentPane().add(this.pageTab.getTabContents());
            }
            this.getContentPane().add((Component)this.makeButtonPanel(), "South");
            this.pack();
            this.setSize(this.getSize().width + 20, this.getSize().height);
        }

        private JPanel makeButtonPanel() {
            JButton okButton = new JButton(RB.getStringResource(RB_KEY, "OK.txt"));
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Setup.this.ok();
                }
            });
            JButton cancelButton = new JButton(RB.getStringResource(RB_KEY, "Cancel.txt"));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Setup.this.cancel();
                }
            });
            JButton advancedButton = new JButton(RB.getStringResource(RB_KEY, "AdvancedEtc.txt"));
            advancedButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Setup.this.advanced();
                }
            });
            JPanel okCancelPanel = new JPanel(new GridLayout(0, 2, 5, 5));
            okCancelPanel.add(okButton);
            okCancelPanel.add(cancelButton);
            JPanel advancedPanel = new JPanel(new GridLayout(0, 2, 5, 5));
            advancedPanel.add(advancedButton);
            JPanel buttonPanel = new JPanel(new BorderLayout(5, 5));
            buttonPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
            buttonPanel.add((Component)advancedPanel, "West");
            buttonPanel.add((Component)okCancelPanel, "East");
            return buttonPanel;
        }

        private void ok() {
            if (this.pageTab != null) {
                this.pageTab.writeModel();
            }
            if (this.chartTab != null) {
                this.chartTab.writeModel();
            }
            this.close();
        }

        private void cancel() {
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void advanced() {
            Setup setup = this;
            synchronized (setup) {
                if (this.advancedDialog != null && this.advancedDialog.isShowing()) {
                    return;
                }
                this.advancedDialog = new AdvancedDialog(this);
            }
            this.advancedDialog.pack();
            this.advancedDialog.setLocationRelativeTo(this);
            this.advancedDialog.show();
            this.advancedDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    Setup.this.advancedDialog = null;
                }
            });
        }

        private void close() {
            if (this.chartTab != null) {
                this.tabs.remove(this.chartTab.getTabContents());
                this.chartTab.close();
            }
            if (this.pageTab != null) {
                this.tabs.remove(this.pageTab.getTabContents());
                this.pageTab.close();
            }
            this.dispose();
        }

        private void addGridBagElement(JPanel p, JComponent c, GridBagLayout gbl, GridBagConstraints gbc, int x, int y, int w, int h) {
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridx = x;
            gbc.gridy = y;
            gbc.gridwidth = w;
            gbc.gridheight = h;
            int leftInset = c instanceof JLabel ? 13 : 2;
            gbc.insets = new Insets(2, leftInset, 3, 3);
            gbl.setConstraints(c, gbc);
            p.add(c);
        }

        private class PageTab
        implements SetupDialogTabInterface {
            JPanel content = this.makePageSetupPanel();
            String name;
            private JRadioButton noScalingBtn;
            private JRadioButton fitOnPageBtn;
            private JRadioButton fitPageHorzBtn;
            private JRadioButton fitPageVertBtn;
            private JSpinner leftMarginSbx;
            private JSpinner rightMarginSbx;
            private JSpinner topMarginSbx;
            private JSpinner bottomMarginSbx;
            private JButton resetBtn;
            private UnitItem marginUnits;
            private JRadioButton portraitBtn;
            private JRadioButton landscapeBtn;
            private ImageIcon portraitIcon;
            private ImageIcon landscapeIcon;
            private JLabel orientationImageLbl;
            private JComboBox unitsCombo;

            public PageTab() {
                this.readModel();
                this.name = RB.getStringResource(Setup.RB_KEY, "PageSetupTab.txt");
            }

            @Override
            public JComponent getTabContents() {
                return this.content;
            }

            @Override
            public String getTabName() {
                return this.name;
            }

            @Override
            public void readModel() {
                this.portraitBtn.setSelected(PrintSupport.this.isPortraitMode());
                this.landscapeBtn.setSelected(!PrintSupport.this.isPortraitMode());
                this.orientationImageLbl.setIcon(PrintSupport.this.isPortraitMode() ? this.portraitIcon : this.landscapeIcon);
                int[] fit = PrintSupport.this.getFitToPages();
                double[] scale = PrintSupport.this.getScale();
                if (PrintSupport.this.isFitToPageEnabled() && fit[0] == 1 && fit[1] == 1) {
                    this.fitOnPageBtn.setSelected(true);
                }
                if (PrintSupport.this.isFitToPageEnabled() && fit[0] == 1 && fit[1] == -1) {
                    this.fitPageHorzBtn.setSelected(true);
                }
                if (PrintSupport.this.isFitToPageEnabled() && fit[0] == -1 && fit[1] == 1) {
                    this.fitPageVertBtn.setSelected(true);
                }
                if (!PrintSupport.this.isFitToPageEnabled() && scale[0] == 1.0 && scale[1] == 1.0) {
                    this.noScalingBtn.setSelected(true);
                }
                DoubleInsets m = PrintSupport.this.getMargins(null);
                UnitItem u = (UnitItem)this.unitsCombo.getSelectedItem();
                this.topMarginSbx.setValue(new Double(u.fromPixels(m.top)));
                this.leftMarginSbx.setValue(new Double(u.fromPixels(m.left)));
                this.bottomMarginSbx.setValue(new Double(u.fromPixels(m.bottom)));
                this.rightMarginSbx.setValue(new Double(u.fromPixels(m.right)));
            }

            @Override
            public void writeModel() {
                PrintSupport.this.setPortraitMode(this.portraitBtn.isSelected());
                if (this.fitOnPageBtn.isSelected()) {
                    PrintSupport.this.fitToSinglePage();
                } else if (this.fitPageHorzBtn.isSelected()) {
                    PrintSupport.this.setFitToPages(1, -1);
                } else if (this.fitPageVertBtn.isSelected()) {
                    PrintSupport.this.setFitToPages(-1, 1);
                } else {
                    PrintSupport.this.setScale(1.0, 1.0);
                }
                UnitItem u = (UnitItem)this.unitsCombo.getSelectedItem();
                double top = u.toPixels((Number)this.topMarginSbx.getValue());
                double left = u.toPixels((Number)this.leftMarginSbx.getValue());
                double bottom = u.toPixels((Number)this.bottomMarginSbx.getValue());
                double right = u.toPixels((Number)this.rightMarginSbx.getValue());
                PrintSupport.this.setMargins(top, left, bottom, right);
            }

            @Override
            public void close() {
            }

            private JPanel makePageSetupPanel() {
                JPanel panel = new JPanel(new BorderLayout(5, 5));
                panel.add((Component)this.makeScalingPanel(), "North");
                panel.add((Component)this.makeMarginPanel(), "Center");
                panel.add((Component)this.makeOrientationPanel(), "South");
                panel.setBorder(new EmptyBorder(7, 10, 10, 10));
                return panel;
            }

            protected JPanel makeScalingPanel() {
                JPanel scalingPanel = new JPanel(new GridLayout(0, 1, 0, 0));
                JPanel scaledPrintSizePanel = new JPanel(new BorderLayout(5, 5));
                JLabel scaledPrintSizeLbl = new JLabel(RB.getStringResource(Setup.RB_KEY, "ScaledPrintSize.txt"));
                scaledPrintSizePanel.add((Component)scaledPrintSizeLbl, "West");
                scaledPrintSizePanel.add(new HorizontalSeparator());
                scalingPanel.add(scaledPrintSizePanel);
                JPanel noScalingPanel = new JPanel(new BorderLayout(5, 5));
                noScalingPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
                this.noScalingBtn = new JRadioButton(RB.getStringResource(Setup.RB_KEY, "NoScaling.txt"));
                noScalingPanel.add((Component)this.noScalingBtn, "West");
                scalingPanel.add(noScalingPanel);
                JPanel fitOnPagePanel = new JPanel(new BorderLayout(5, 5));
                fitOnPagePanel.setBorder(new EmptyBorder(0, 10, 0, 10));
                this.fitOnPageBtn = new JRadioButton(RB.getStringResource(Setup.RB_KEY, "FitOnPage.txt"));
                fitOnPagePanel.add((Component)this.fitOnPageBtn, "West");
                scalingPanel.add(fitOnPagePanel);
                JPanel fitPageHorzPanel = new JPanel(new BorderLayout(5, 5));
                fitPageHorzPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
                this.fitPageHorzBtn = new JRadioButton(RB.getStringResource(Setup.RB_KEY, "FitPageHorz.txt"));
                fitPageHorzPanel.add((Component)this.fitPageHorzBtn, "West");
                scalingPanel.add(fitPageHorzPanel);
                JPanel fitPageVertPanel = new JPanel(new BorderLayout(5, 5));
                fitPageVertPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
                this.fitPageVertBtn = new JRadioButton(RB.getStringResource(Setup.RB_KEY, "FitPageVert.txt"));
                fitPageVertPanel.add((Component)this.fitPageVertBtn, "West");
                scalingPanel.add(fitPageVertPanel);
                ButtonGroup scalingGroup = new ButtonGroup();
                scalingGroup.add(this.noScalingBtn);
                scalingGroup.add(this.fitPageHorzBtn);
                scalingGroup.add(this.fitPageVertBtn);
                scalingGroup.add(this.fitOnPageBtn);
                return scalingPanel;
            }

            protected JPanel makeMarginPanel() {
                JPanel titlePanel = new JPanel(new BorderLayout(5, 5));
                JLabel titleLbl = new JLabel(RB.getStringResource(Setup.RB_KEY, "Margins.txt"));
                titlePanel.add((Component)titleLbl, "West");
                titlePanel.add((Component)new HorizontalSeparator(), "Center");
                UnitLabel unitsLbl = new UnitLabel(RB.getStringResource(Setup.RB_KEY, "Units.txt"));
                UnitLabel leftLbl = new UnitLabel(RB.getStringResource(Setup.RB_KEY, "LeftMargin.txt"));
                UnitLabel rightLbl = new UnitLabel(RB.getStringResource(Setup.RB_KEY, "RightMargin.txt"));
                UnitLabel topLbl = new UnitLabel(RB.getStringResource(Setup.RB_KEY, "TopMargin.txt"));
                UnitLabel bottomLbl = new UnitLabel(RB.getStringResource(Setup.RB_KEY, "BottomMargin.txt"));
                this.leftMarginSbx = new JSpinner();
                this.topMarginSbx = new JSpinner();
                this.rightMarginSbx = new JSpinner();
                this.bottomMarginSbx = new JSpinner();
                this.unitsCombo = new JComboBox();
                this.unitsCombo.addItem(UnitItem.getUnitItem(2));
                this.unitsCombo.addItem(UnitItem.getUnitItem(1));
                this.unitsCombo.addItem(UnitItem.getUnitItem(0));
                this.resetBtn = new JButton(RB.getStringResource(Setup.RB_KEY, "Reset.txt"));
                JPanel unitsResetPanel = new JPanel();
                unitsResetPanel.setLayout(new BorderLayout(10, 0));
                unitsResetPanel.add((Component)this.unitsCombo, "Center");
                unitsResetPanel.add((Component)this.resetBtn, "East");
                unitsLbl.setHorizontalAlignment(4);
                leftLbl.setHorizontalAlignment(4);
                rightLbl.setHorizontalAlignment(4);
                topLbl.setHorizontalAlignment(4);
                bottomLbl.setHorizontalAlignment(4);
                GridBagLayout gb = new GridBagLayout();
                GridBagConstraints gbc = new GridBagConstraints();
                JPanel contentPanel = new JPanel();
                contentPanel.setBorder(new EmptyBorder(0, 13, 0, 13));
                contentPanel.setLayout(gb);
                Setup.this.addGridBagElement(contentPanel, leftLbl, gb, gbc, 0, 0, 1, 1);
                Setup.this.addGridBagElement(contentPanel, this.leftMarginSbx, gb, gbc, 1, 0, 1, 1);
                Setup.this.addGridBagElement(contentPanel, rightLbl, gb, gbc, 2, 0, 1, 1);
                Setup.this.addGridBagElement(contentPanel, this.rightMarginSbx, gb, gbc, 3, 0, 1, 1);
                Setup.this.addGridBagElement(contentPanel, topLbl, gb, gbc, 0, 1, 1, 1);
                Setup.this.addGridBagElement(contentPanel, this.topMarginSbx, gb, gbc, 1, 1, 1, 1);
                Setup.this.addGridBagElement(contentPanel, bottomLbl, gb, gbc, 2, 1, 1, 1);
                Setup.this.addGridBagElement(contentPanel, this.bottomMarginSbx, gb, gbc, 3, 1, 1, 1);
                Setup.this.addGridBagElement(contentPanel, unitsLbl, gb, gbc, 0, 2, 1, 1);
                Setup.this.addGridBagElement(contentPanel, unitsResetPanel, gb, gbc, 1, 2, 3, 1);
                this.topMarginSbx.setModel(new DecimalSpinnerModel());
                this.leftMarginSbx.setModel(new DecimalSpinnerModel());
                this.bottomMarginSbx.setModel(new DecimalSpinnerModel());
                this.rightMarginSbx.setModel(new DecimalSpinnerModel());
                this.resetBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PageTab.this.resetMarginsToDefault();
                    }
                });
                this.marginUnits = null;
                if (default_units != null) {
                    this.unitsCombo.setSelectedItem(default_units);
                }
                this.updateSpinnerUnits();
                this.unitsCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PageTab.this.updateSpinnerUnits();
                    }
                });
                JPanel marginPanel = new JPanel(new BorderLayout(5, 5));
                marginPanel.add((Component)titlePanel, "North");
                marginPanel.add((Component)contentPanel, "Center");
                return marginPanel;
            }

            private JPanel makeOrientationPanel() {
                this.portraitIcon = PrintSupport.makeImageIcon("Print_Portrait.gif");
                this.landscapeIcon = PrintSupport.makeImageIcon("Print_Landscape.gif");
                JPanel orientationPanel = new JPanel(new BorderLayout(5, 5));
                JPanel separatorPanel = new JPanel(new BorderLayout(5, 5));
                JLabel separatorLbl = new JLabel(RB.getStringResource(Setup.RB_KEY, "Orientation.txt"));
                separatorPanel.add((Component)separatorLbl, "West");
                separatorPanel.add(new HorizontalSeparator());
                orientationPanel.add((Component)separatorPanel, "North");
                JPanel controlPanel = new JPanel(new BorderLayout(5, 5));
                controlPanel.setBorder(new EmptyBorder(0, 13, 0, 13));
                this.orientationImageLbl = new JLabel(this.portraitIcon);
                this.orientationImageLbl.setBorder(new EmptyBorder(5, 5, 5, 5));
                controlPanel.add((Component)this.orientationImageLbl, "West");
                JPanel rightPanel = new JPanel(new BorderLayout(5, 5));
                JPanel radioPanel = new JPanel(new GridLayout(0, 1, 5, 5));
                this.portraitBtn = new JRadioButton(RB.getStringResource(Setup.RB_KEY, "Portrait.txt"));
                radioPanel.add(this.portraitBtn);
                this.landscapeBtn = new JRadioButton(RB.getStringResource(Setup.RB_KEY, "Landscape.txt"));
                radioPanel.add(this.landscapeBtn);
                rightPanel.add((Component)radioPanel, "West");
                controlPanel.add(rightPanel);
                orientationPanel.add(controlPanel);
                ButtonGroup orientationGroup = new ButtonGroup();
                orientationGroup.add(this.landscapeBtn);
                orientationGroup.add(this.portraitBtn);
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PageTab.this.orientationImageLbl.setIcon(PageTab.this.landscapeBtn.isSelected() ? PageTab.this.landscapeIcon : PageTab.this.portraitIcon);
                        PageTab.this.orientationImageLbl.repaint();
                    }
                };
                this.landscapeBtn.addActionListener(listener);
                this.portraitBtn.addActionListener(listener);
                return orientationPanel;
            }

            private void updateSpinnerUnits() {
                UnitItem newMarginUnits = (UnitItem)this.unitsCombo.getSelectedItem();
                if (!newMarginUnits.equals(this.marginUnits)) {
                    this.updateSpinnerUnit(this.topMarginSbx, newMarginUnits);
                    this.updateSpinnerUnit(this.leftMarginSbx, newMarginUnits);
                    this.updateSpinnerUnit(this.bottomMarginSbx, newMarginUnits);
                    this.updateSpinnerUnit(this.rightMarginSbx, newMarginUnits);
                }
                this.marginUnits = newMarginUnits;
                default_units = this.marginUnits;
            }

            private void updateSpinnerUnit(JSpinner s, UnitItem newUnits) {
                DecimalSpinnerModel m = (DecimalSpinnerModel)s.getModel();
                m.setDecimalPlaces(newUnits.getDecimals());
                if (this.marginUnits != null) {
                    Number oldValue = (Number)s.getValue();
                    double oldPixels = this.marginUnits.toPixels(oldValue);
                    Double newValue = new Double(newUnits.fromPixels(oldPixels));
                    s.setValue(newValue);
                }
            }

            private void resetMarginsToDefault() {
                UnitItem u = (UnitItem)this.unitsCombo.getSelectedItem();
                DoubleInsets m = default_margins;
                if (m != null) {
                    this.topMarginSbx.setValue(new Double(u.fromPixels(m.top)));
                    this.leftMarginSbx.setValue(new Double(u.fromPixels(m.left)));
                    this.bottomMarginSbx.setValue(new Double(u.fromPixels(m.bottom)));
                    this.rightMarginSbx.setValue(new Double(u.fromPixels(m.right)));
                }
            }
        }

        private class AdvancedDialog
        extends JDialog {
            private JRadioButton javaPrintDialogBtn;
            private JRadioButton nativePrintDialogBtn;

            public AdvancedDialog(JDialog parent) {
                super(parent);
                this.createDialog();
            }

            private void createDialog() {
                this.setTitle(RB.getStringResource(Setup.RB_KEY, "AdvancedEtc.txt"));
                this.javaPrintDialogBtn = new JRadioButton(RB.getStringResource(Setup.RB_KEY, "CrossPlatformPrintDialog.txt"));
                this.nativePrintDialogBtn = new JRadioButton(RB.getStringResource(Setup.RB_KEY, "NativePrintDialog.txt"));
                ButtonGroup printDialogSelectionGroup = new ButtonGroup();
                printDialogSelectionGroup.add(this.javaPrintDialogBtn);
                printDialogSelectionGroup.add(this.nativePrintDialogBtn);
                Vector<String> explanation = new Vector<String>();
                for (int i = 1; i <= 99; ++i) {
                    String si;
                    try {
                        si = RB.getStringResource(Setup.RB_KEY, "PrintDialogChoiceExplanation" + i + ".txt");
                    }
                    catch (MissingResourceException x) {
                        break;
                    }
                    if (si == null || si.length() <= 0) continue;
                    explanation.add(si);
                }
                GridBagLayout gb = new GridBagLayout();
                GridBagConstraints gbc = new GridBagConstraints();
                JPanel p2 = new JPanel();
                p2.setLayout(gb);
                p2.setBorder(new EmptyBorder(5, 10, 10, 10));
                Setup.this.addGridBagElement(p2, this.nativePrintDialogBtn, gb, gbc, 0, 0, 1, 1);
                Setup.this.addGridBagElement(p2, this.javaPrintDialogBtn, gb, gbc, 0, 1, 1, 1);
                for (int i = 0; i < explanation.size(); ++i) {
                    String si = (String)explanation.elementAt(i);
                    JLabel ei = new JLabel(si);
                    Setup.this.addGridBagElement(p2, ei, gb, gbc, 0, 3 + i, 1, 1);
                }
                JPanel p1 = new JPanel();
                p1.setBorder(new TitledBorder(new EtchedBorder(), RB.getStringResource(Setup.RB_KEY, "WhichPrintDialog.txt"), 4, 2));
                p1.setLayout(new BorderLayout());
                p1.add((Component)p2, "Center");
                JPanel cp = new JPanel();
                cp.setLayout(new BorderLayout(10, 15));
                cp.add((Component)p1, "Center");
                cp.add((Component)this.makeButtonPanel(), "South");
                cp.setBorder(new EmptyBorder(15, 15, 15, 15));
                this.setContentPane(cp);
                this.pack();
            }

            @Override
            public void show() {
                this.readModel();
                super.show();
            }

            private void ok() {
                this.writeModel();
                this.close();
            }

            private void cancel() {
                this.close();
            }

            private void close() {
                this.dispose();
            }

            private void readModel() {
                boolean b = PrintSupport.this.mUseCrossPlatformDialog;
                this.javaPrintDialogBtn.setSelected(b);
                this.nativePrintDialogBtn.setSelected(!b);
            }

            private void writeModel() {
                PrintSupport.this.mUseCrossPlatformDialog = this.javaPrintDialogBtn.isSelected();
            }

            private JPanel makeButtonPanel() {
                JButton okButton = new JButton(RB.getStringResource(Setup.RB_KEY, "OK.txt"));
                okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdvancedDialog.this.ok();
                    }
                });
                JButton cancelButton = new JButton(RB.getStringResource(Setup.RB_KEY, "Cancel.txt"));
                cancelButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdvancedDialog.this.cancel();
                    }
                });
                JPanel okCancelPanel = new JPanel(new GridLayout(0, 2, 5, 5));
                okCancelPanel.add(okButton);
                okCancelPanel.add(cancelButton);
                JPanel buttonPanel = new JPanel(new BorderLayout(5, 5));
                buttonPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
                buttonPanel.add((Component)okCancelPanel, "East");
                return buttonPanel;
            }
        }

        class DecimalSpinnerModel
        extends SpinnerNumberModel {
            int d;

            public DecimalSpinnerModel() {
                super(0.0, 0.0, 999999.0, 1.0);
                this.setDecimalPlaces(0);
            }

            public int getDecimalPlaces() {
                return this.d;
            }

            public void setDecimalPlaces(int decimals) {
                this.d = decimals;
                double step = 1.0;
                if (this.d > 0) {
                    for (int i = 0; i < this.d; ++i) {
                        step /= 10.0;
                    }
                } else if (this.d < 0) {
                    for (int i = 0; i > this.d; --i) {
                        step *= 10.0;
                    }
                }
                this.setStepSize(new Double(step));
            }

            @Override
            public void setValue(Object value) {
                double v;
                String s = "";
                if (value instanceof String) {
                    try {
                        v = Double.parseDouble((String)value);
                    }
                    catch (NumberFormatException x) {
                        v = 0.0;
                    }
                } else {
                    v = value instanceof Number ? ((Number)value).doubleValue() : 0.0;
                }
                if (this.d > 0) {
                    for (int i = 0; i < this.d; ++i) {
                        v *= 10.0;
                    }
                } else if (this.d < 0) {
                    for (int i = 0; i > this.d; --i) {
                        v /= 10.0;
                    }
                }
                int vi = (int)(v + 0.5);
                v = vi;
                if (this.d > 0) {
                    for (int i = 0; i < this.d; ++i) {
                        v /= 10.0;
                    }
                } else if (this.d < 0) {
                    for (int i = 0; i > this.d; --i) {
                        v *= 10.0;
                    }
                }
                super.setValue(new Double(v));
            }
        }

        private class HorizontalSeparator
        extends JComponent {
            private final Dimension prefSize;

            public HorizontalSeparator() {
                this.setOpaque(false);
                int h = new JLabel((String)"W").getPreferredSize().height;
                this.prefSize = new Dimension(1, h);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.prefSize;
            }

            @Override
            public void paint(Graphics g) {
                Dimension size = this.getSize();
                int width = size.width;
                int height = size.height;
                int midY = height / 2;
                Color bgColor = this.getBackground();
                g.setColor(bgColor.brighter());
                g.drawLine(0, midY + 1, width - 1, midY + 1);
                g.setColor(bgColor.darker());
                g.drawLine(1, midY, width, midY);
            }
        }
    }

    public static interface SetupDialogTabInterface {
        public JComponent getTabContents();

        public String getTabName();

        public void readModel();

        public void writeModel();

        public void close();
    }

    private class Preview
    extends JDialog {
        private static final String RB_KEY = "PrintPreviewDialog.";
        private static final double SINGLE_PAGE_SCALE = 1.0;
        private static final double MULTI_PAGE_SCALE = 0.25;
        private static final int padding = 8;
        private final Color bgColor;
        private final Color fgColor;
        private final Color mlColor;
        private static final int disableAlpha = 180;
        private int pageNumber;
        private int minPage;
        private int maxPage;
        private boolean multiPageMode;
        private boolean showMarginLines;
        private JButton printButton;
        private JButton printSetupButton;
        private JButton multiPageButton;
        private JButton singlePageButton;
        private JButton marginButton;
        private JButton closeButton;
        private JScrollPane previewPane;
        private PageNavigationPanel pageNavigationPanel;
        private MultiPagePreview mpp;
        private SinglePagePreview spp;

        public Preview(Dialog owner) {
            super(owner, RB.getStringResource(RB_KEY, "PrintPreview.txt"), true);
            this.bgColor = new Color(178, 178, 178);
            this.fgColor = new Color(255, 255, 255);
            this.mlColor = new Color(0, 0, 255);
            this.init();
        }

        public Preview(Frame owner) {
            super(owner, RB.getStringResource(RB_KEY, "PrintPreview.txt"), true);
            this.bgColor = new Color(178, 178, 178);
            this.fgColor = new Color(255, 255, 255);
            this.mlColor = new Color(0, 0, 255);
            this.init();
        }

        private void init() {
            this.pageNumber = 1;
            this.minPage = 1;
            this.maxPage = PrintSupport.this.getNumberOfPages();
            this.showMarginLines = true;
            this.previewPane = new JScrollPane();
            this.previewPane.getViewport().setBackground(this.bgColor);
            this.previewPane.setBackground(this.bgColor);
            this.previewPane.setHorizontalScrollBarPolicy(30);
            this.previewPane.setVerticalScrollBarPolicy(20);
            this.getContentPane().add((Component)this.makeButtonPanel(), "North");
            this.getContentPane().add((Component)this.previewPane, "Center");
            this.refresh();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    Preview.this.flush();
                }
            });
        }

        public int getPageNumber() {
            return this.multiPageMode ? -1 : this.pageNumber;
        }

        public void setPageNumber(int pn) {
            boolean bl = this.multiPageMode = pn == -1;
            if (pn >= 0) {
                this.pageNumber = pn;
            }
            this.checkPage();
        }

        private JPanel makeButtonPanel() {
            this.printButton = new JButton(RB.getStringResource(RB_KEY, "PrintEtc.txt"));
            this.printButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preview.this.print();
                }
            });
            this.printButton.setBorder(new EmptyBorder(4, 4, 4, 4));
            this.printSetupButton = new JButton(RB.getStringResource(RB_KEY, "SetupEtc.txt"));
            this.printSetupButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preview.this.printSetup();
                }
            });
            this.printSetupButton.setBorder(new EmptyBorder(4, 4, 4, 4));
            this.multiPageButton = new IconButton(PrintSupport.makeImageIcon("PrintPreview_MultiPage.gif"), RB.getStringResource(RB_KEY, "ShowAllPages.txt"), 3);
            this.multiPageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preview.this.setMultiPageMode(true);
                }
            });
            this.singlePageButton = new IconButton(PrintSupport.makeImageIcon("PrintPreview_SinglePage.gif"), RB.getStringResource(RB_KEY, "ShowOnePage.txt"), 3);
            this.singlePageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preview.this.setMultiPageMode(false);
                }
            });
            this.marginButton = new IconButton(PrintSupport.makeImageIcon("PrintPreview_MarginsToggle.gif"), RB.getStringResource(RB_KEY, "ToggleMarginLines.txt"), 3);
            this.marginButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preview.this.toggleMarginLines();
                }
            });
            this.closeButton = new JButton(RB.getStringResource(RB_KEY, "Close.txt"));
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preview.this.close();
                }
            });
            this.closeButton.setBorder(new EmptyBorder(4, 4, 4, 4));
            this.pageNavigationPanel = new PageNavigationPanel();
            JPanel controlPane = new JPanel();
            controlPane.setLayout(new FlowLayout());
            controlPane.add(this.printButton);
            controlPane.add(new VerticalSeparator());
            controlPane.add(this.printSetupButton);
            controlPane.add(new VerticalSeparator());
            controlPane.add(this.multiPageButton);
            controlPane.add(this.singlePageButton);
            controlPane.add(new VerticalSeparator());
            controlPane.add(this.pageNavigationPanel);
            controlPane.add(new VerticalSeparator());
            controlPane.add(this.marginButton);
            controlPane.add(new VerticalSeparator());
            controlPane.add(this.closeButton);
            controlPane.setMinimumSize(controlPane.getPreferredSize());
            return controlPane;
        }

        public void print() {
            boolean en = PrintSupport.this.isDialogEnabled();
            PrintSupport.this.setDialogEnabled(true);
            int p = PrintSupport.this.getPageNumber();
            PrintSupport.this.print();
            PrintSupport.this.setPageNumber(p);
            PrintSupport.this.setDialogEnabled(en);
            if (PrintSupport.this.mUseCrossPlatformDialog) {
                this.refresh();
            }
        }

        public void printSetup() {
            PrintSupport.this.setupDialog(this);
        }

        public void nextPage() {
            ++this.pageNumber;
            this.checkPage();
        }

        public void prevPage() {
            --this.pageNumber;
            this.checkPage();
        }

        public void next10Page() {
            this.pageNumber += 10;
            this.checkPage();
        }

        public void prev10Page() {
            this.pageNumber -= 10;
            this.checkPage();
        }

        public void firstPage() {
            this.pageNumber = this.minPage;
            this.checkPage();
        }

        public void lastPage() {
            this.pageNumber = this.maxPage;
            this.checkPage();
        }

        private void checkPage() {
            if (this.pageNumber <= this.minPage) {
                this.pageNumber = this.minPage;
            }
            if (this.pageNumber >= this.maxPage) {
                this.pageNumber = this.maxPage;
            }
            this.pageNavigationPanel.refresh();
            this.refreshPreviewPane();
        }

        public void toggleMarginLines() {
            this.showMarginLines = !this.showMarginLines;
            this.repaint();
        }

        public void setMultiPageMode(boolean mp) {
            this.multiPageMode = mp;
            this.refreshPreviewPane();
            this.pageNavigationPanel.refresh();
            this.repaint();
        }

        public void close() {
            this.flush();
            this.dispose();
        }

        public void refresh() {
            this.flush();
            this.refreshMaxPage();
            this.checkPage();
            this.pageNavigationPanel.refresh();
            this.repaint();
        }

        private void refreshPreviewPane() {
            int y;
            int x;
            Point newPosition;
            Cursor oldCursor = this.getCursor();
            this.setCursor(new Cursor(3));
            JViewport viewport = this.previewPane.getViewport();
            Component view = viewport.getView();
            Point oldPosition = viewport.getViewPosition();
            if (this.multiPageMode) {
                if (view == this.spp && this.spp != null) {
                    this.spp.setScrollPosition(oldPosition);
                }
                if (this.mpp == null) {
                    this.mpp = new MultiPagePreview();
                }
                this.previewPane.setViewportView(this.mpp);
                newPosition = this.mpp.getScrollPosition();
            } else {
                if (view == this.mpp && this.mpp != null) {
                    this.mpp.setScrollPosition(oldPosition);
                }
                if (this.spp == null) {
                    this.spp = new SinglePagePreview(-1, 1.0);
                }
                this.previewPane.setViewportView(this.spp);
                newPosition = this.spp.getScrollPosition();
            }
            this.multiPageButton.setEnabled(!this.multiPageMode);
            this.singlePageButton.setEnabled(this.multiPageMode);
            if (newPosition == null) {
                newPosition = new Point(0, 0);
            }
            if ((x = newPosition.x - 1) < 0) {
                x = 1;
            }
            if ((y = newPosition.y - 1) < 0) {
                y = 1;
            }
            viewport.setViewPosition(new Point(x, y));
            viewport.setViewPosition(newPosition);
            this.setCursor(oldCursor);
        }

        private void refreshMaxPage() {
            this.maxPage = PrintSupport.this.getNumberOfPages();
        }

        public void flush() {
            if (this.mpp != null) {
                this.mpp.flush();
            }
            this.mpp = null;
            if (this.spp != null) {
                this.spp.flush();
            }
            this.spp = null;
        }

        class IconButton
        extends JButton {
            Dimension mySize;
            int rounding;

            public IconButton(Icon ii, String toolTip, int cornerRadius) {
                super(ii);
                this.setOpaque(false);
                this.setSizeFromIcon(ii);
                int n = this.rounding = cornerRadius >= 0 ? cornerRadius : ii.getIconWidth();
                if (toolTip != null) {
                    this.setToolTipText(toolTip);
                }
            }

            private void setSizeFromIcon(Icon ii) {
                int w = ii.getIconWidth();
                int h = ii.getIconHeight();
                this.mySize = new Dimension(w, h);
                this.setSize(w, h);
                this.setMinimumSize(this.mySize);
                this.setMaximumSize(this.mySize);
                this.setPreferredSize(this.mySize);
                this.setBorder(new EmptyBorder(0, 0, 0, 0));
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (!this.isEnabled()) {
                    Color bg = this.getBackground();
                    Color dmColor = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 180);
                    g.setColor(dmColor);
                    int w = this.getWidth();
                    int h = this.getHeight();
                    g.fillRoundRect(0, 0, w, h, this.rounding, this.rounding);
                }
            }
        }

        private class PageNavigationPanel
        extends JPanel {
            private IconButton firstButton;
            private IconButton prev1Button;
            private IconButton next1Button;
            private IconButton lastButton;
            private JTextField pageNumberMsg;
            private JLabel maxPageMsg;
            private JPanel pageMsg;

            public PageNavigationPanel() {
                this.init();
            }

            private void init() {
                this.setLayout(new FlowLayout());
                this.maxPageMsg = new JLabel("    ");
                this.pageNumberMsg = new JTextField("", 3);
                this.pageNumberMsg.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PageNavigationPanel.this.validatePageNumberMsg();
                    }
                });
                this.pageMsg = new JPanel();
                this.pageMsg.setLayout(new FlowLayout());
                this.pageMsg.add(new JLabel(RB.getStringResource(Preview.RB_KEY, "Page.txt")));
                this.pageMsg.add(this.pageNumberMsg);
                this.pageMsg.add(new JLabel(RB.getStringResource(Preview.RB_KEY, "XofY.txt")));
                this.pageMsg.add(this.maxPageMsg);
                this.firstButton = new IconButton(PrintSupport.makeImageIcon("PrintPreview_First.gif"), RB.getStringResource(Preview.RB_KEY, "FirstPage.txt"), 10);
                this.firstButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Preview.this.firstPage();
                    }
                });
                this.prev1Button = new IconButton(PrintSupport.makeImageIcon("PrintPreview_Previous.gif"), RB.getStringResource(Preview.RB_KEY, "PreviousPage.txt"), 10);
                this.prev1Button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Preview.this.prevPage();
                    }
                });
                this.next1Button = new IconButton(PrintSupport.makeImageIcon("PrintPreview_Next.gif"), RB.getStringResource(Preview.RB_KEY, "NextPage.txt"), 10);
                this.next1Button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Preview.this.nextPage();
                    }
                });
                this.lastButton = new IconButton(PrintSupport.makeImageIcon("PrintPreview_Last.gif"), RB.getStringResource(Preview.RB_KEY, "LastPage.txt"), 10);
                this.lastButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Preview.this.lastPage();
                    }
                });
                this.add(this.firstButton);
                this.add(this.prev1Button);
                this.add(this.pageMsg);
                this.add(this.next1Button);
                this.add(this.lastButton);
            }

            public void refresh() {
                this.refreshMaxPageMsg();
                this.refreshEnables();
            }

            public void refreshMaxPageMsg() {
                int p = Preview.this.maxPage;
                this.maxPageMsg.setText(PrintSupport.intToString(p) + "  ");
            }

            private void validatePageNumberMsg() {
                String s = this.pageNumberMsg.getText();
                try {
                    Preview.this.pageNumber = Integer.parseInt(s);
                    Preview.this.checkPage();
                }
                catch (NumberFormatException x) {
                    this.pageNumberMsg.setText(PrintSupport.intToString(Preview.this.pageNumber));
                }
            }

            private void refreshEnables() {
                boolean singlePageMode = !Preview.this.multiPageMode;
                int p = Preview.this.pageNumber;
                int min = Preview.this.minPage;
                int max = Preview.this.maxPage;
                boolean prev = singlePageMode && p > min;
                this.prev1Button.setEnabled(prev);
                this.firstButton.setEnabled(prev);
                boolean next = singlePageMode && p < max;
                this.next1Button.setEnabled(next);
                this.lastButton.setEnabled(next);
                this.pageNumberMsg.setText(singlePageMode ? PrintSupport.intToString(p) : "");
                this.pageNumberMsg.setEnabled(singlePageMode);
                this.setEnabled(singlePageMode);
                this.repaint();
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (!this.isEnabled()) {
                    Color bg = this.getBackground();
                    Color dmColor = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 180);
                    g.setColor(dmColor);
                    this.paintOver(g, this.pageMsg);
                }
            }

            private void paintOver(Graphics g, JComponent c) {
                Rectangle r = c.getBounds();
                g.fillRect(r.x, r.y, r.width, r.height);
            }
        }

        class VerticalSeparator
        extends JComponent {
            private Dimension prefSize = new Dimension(10, 25);
            private Color lineColor = Color.gray.brighter();

            public VerticalSeparator() {
                this.setOpaque(false);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.prefSize;
            }

            @Override
            public void paint(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                int x = w / 2;
                int y0 = h / 10;
                int y1 = 9 * h / 10;
                g.setColor(this.lineColor);
                g.drawLine(x, y0, x, y1);
            }
        }

        private class SinglePagePreview
        extends JPanel {
            private final int shadowDepth = 5;
            private final int pageBorderThickness = 1;
            private final Color shadowColor = new Color(128, 128, 128);
            private final Color pageBorderColor = Color.black;
            private double pageScale;
            private int fixedPageNumber;
            private Dimension mySize;
            private BufferedImage pageImage;
            private int pageImagePageNumber;
            private Point scrollPosition;

            public SinglePagePreview(int pageno, double scale) {
                this.setBackground(Preview.this.bgColor);
                this.setOpaque(false);
                this.pageScale = scale;
                this.fixedPageNumber = pageno;
                if (pageno == -1) {
                    this.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            int pn;
                            if (e.getClickCount() == 2 && e.getSource() == SinglePagePreview.this && (pn = SinglePagePreview.this.fixedPageNumber) == -1) {
                                Preview.this.setPageNumber(-1);
                            }
                        }
                    });
                }
                this._setSize();
            }

            public void _setSize() {
                PageFormat f = PrintSupport.this.getPageFormat();
                int fw = (int)f.getWidth();
                int fh = (int)f.getHeight();
                if (this.mySize == null) {
                    this.mySize = new Dimension(0, 0);
                }
                this.mySize.setSize((double)fw * this.pageScale + 5.0 + 16.0 + 2.0, (double)fh * this.pageScale + 5.0 + 16.0 + 2.0);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.mySize;
            }

            public Point getScrollPosition() {
                return this.scrollPosition;
            }

            public void setScrollPosition(Point p) {
                this.scrollPosition = p;
            }

            public int getPageNumber() {
                return this.fixedPageNumber != -1 ? this.fixedPageNumber : Preview.this.pageNumber;
            }

            public void flush() {
                if (this.pageImage != null) {
                    this.pageImage.flush();
                }
                this.pageImage = null;
            }

            @Override
            public void paint(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, w, h);
                if (w < 10 || h < 10 || PrintSupport.this.tNumPagesX == 0 && PrintSupport.this.tNumPagesY == 0) {
                    return;
                }
                PageFormat f = PrintSupport.this.getPageFormat();
                int fw = (int)f.getWidth();
                int fh = (int)f.getHeight();
                Insets fm = PrintSupport.this.getMargins();
                int fx0 = 0;
                int fx1 = fm.left;
                int fx2 = fw - fm.right;
                int fx3 = fw;
                int fy0 = 0;
                int fy1 = fm.top;
                int fy2 = fh - fm.bottom;
                int fy3 = fh;
                int px0 = 9;
                int py0 = 9;
                int px1 = px0 + (int)(this.pageScale * (double)fx1);
                int py1 = py0 + (int)(this.pageScale * (double)fy1);
                int px2 = px0 + (int)(this.pageScale * (double)fx2);
                int py2 = py0 + (int)(this.pageScale * (double)fy2);
                int px3 = px0 + (int)(this.pageScale * (double)fx3);
                int py3 = py0 + (int)(this.pageScale * (double)fy3);
                int pw = px3 - px0;
                int ph = py3 - py0;
                try {
                    int pn;
                    if (this.pageImage == null) {
                        this.pageImage = new BufferedImage(pw, ph, 2);
                        this.pageImagePageNumber = -1;
                    }
                    if ((pn = this.getPageNumber() - 1) != this.pageImagePageNumber) {
                        Graphics2D pg = this.pageImage.createGraphics();
                        pg.scale(this.pageScale, this.pageScale);
                        PrintSupport.this.print(pg, f, pn);
                        this.pageImagePageNumber = pn;
                    }
                    g.translate(px0, py0);
                    ((Graphics2D)g).drawRenderedImage(this.pageImage, new AffineTransform());
                    g.translate(-px0, -py0);
                }
                catch (PrinterException x) {
                    x.printStackTrace();
                }
                int t = 1;
                g.setColor(this.shadowColor);
                g.fillRect(px3 + t, py0 - t + 5, 5, ph + t + t);
                g.fillRect(px0 - t + 5, py3 + t, pw + t + t, 5);
                g.setColor(this.pageBorderColor);
                for (int i = 1; i <= t; ++i) {
                    g.drawRect(px0 - i, py0 - i, pw + i + i, ph + i + i);
                }
                if (Preview.this.showMarginLines && (fx0 < fx1 || fx2 < fx2 || fy0 < fy1 || fy2 < fy3)) {
                    g.setColor(Preview.this.mlColor);
                    g.drawLine(px0, py1 - 1, px3, py1 - 1);
                    g.drawLine(px0, py2 + 1, px3, py2 + 1);
                    g.drawLine(px1 - 1, py0, px1 - 1, py3);
                    g.drawLine(px2 + 1, py0, px2 + 1, py3);
                }
            }
        }

        private class MultiPagePreview
        extends JPanel {
            private Point scrollPosition;

            public MultiPagePreview() {
                this.init();
            }

            public Point getScrollPosition() {
                return this.scrollPosition;
            }

            public void setScrollPosition(Point p) {
                this.scrollPosition = p;
            }

            private void init() {
                Color backgroundColor = Preview.this.bgColor;
                this.setBackground(backgroundColor);
                this.setOpaque(false);
                if (PrintSupport.this.tNumPagesX == 0 && PrintSupport.this.tNumPagesY == 0) {
                    return;
                }
                MouseAdapter pageChooser = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        SinglePagePreview spp;
                        int pn;
                        Object x = e.getSource();
                        if (e.getClickCount() == 2 && x instanceof SinglePagePreview && (pn = (spp = (SinglePagePreview)x).getPageNumber()) != -1) {
                            Preview.this.setPageNumber(pn);
                        }
                    }
                };
                GridLayout gl = new GridLayout(PrintSupport.this.tNumPagesY, PrintSupport.this.tNumPagesX);
                gl.setVgap(8);
                gl.setHgap(8);
                this.setLayout(gl);
                for (int y = 0; y < PrintSupport.this.tNumPagesY; ++y) {
                    for (int x = 0; x < PrintSupport.this.tNumPagesX; ++x) {
                        int pagenum = PrintSupport.this.mPageOrderHorizontal ? y * PrintSupport.this.tNumPagesX + x : x * PrintSupport.this.tNumPagesY + y;
                        SinglePagePreview spp = new SinglePagePreview(pagenum + 1, 0.25);
                        spp.addMouseListener(pageChooser);
                        PageNumberBox pnb = new PageNumberBox(pagenum + 1);
                        JPanel p1 = new JPanel();
                        p1.setBackground(backgroundColor);
                        p1.setLayout(new BorderLayout(0, 0));
                        p1.add((Component)spp, "North");
                        p1.add((Component)pnb, "Center");
                        JPanel p2 = new JPanel();
                        p2.setBackground(backgroundColor);
                        p2.add(p1);
                        this.add(p2);
                    }
                }
            }

            @Override
            public void paint(Graphics g) {
                Cursor oldCursor = this.getCursor();
                Preview.this.setCursor(new Cursor(3));
                super.paint(g);
                Preview.this.setCursor(oldCursor);
            }

            public void flush() {
            }

            private class PageNumberBox
            extends JPanel {
                private Color bgColor;
                private Color labelFgColor;
                private Color labelBgColor;

                public PageNumberBox(int n) {
                    this.bgColor = Preview.this.bgColor;
                    this.labelFgColor = new Color(80, 80, 80);
                    this.labelBgColor = new Color(200, 200, 200);
                    JLabel nn = new JLabel("  " + PrintSupport.intToString(n) + "  "){

                        @Override
                        public void paint(Graphics g) {
                            g.setColor(this.getBackground());
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            super.paint(g);
                        }
                    };
                    nn.setBackground(this.labelBgColor);
                    nn.setForeground(this.labelFgColor);
                    nn.setBorder(new LineBorder(this.labelFgColor, 1, true));
                    this.setBackground(this.bgColor);
                    this.add(nn);
                }
            }
        }
    }

    class UnitLabel
    extends JLabel {
        int myWidth;

        public UnitLabel(String label) {
            super(label);
            FontMetrics fm = this.getFontMetrics(this.getFont());
            this.myWidth = fm.stringWidth(label);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.myWidth, super.getPreferredSize().height);
        }
    }
}

