/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.ColorVertex;
import java.awt.Color;
import java.util.Vector;

public class Palette {
    public static final int RGB_MASK_RED = 1;
    public static final int RGB_MASK_GREEN = 2;
    public static final int RGB_MASK_BLUE = 4;
    public static final int RGB_MASK_ALL = 7;
    protected Vector entries = new Vector();
    protected boolean continuous = true;
    protected Color overflowColor;
    protected Color underflowColor;
    protected Color missingColor;

    public Palette() {
        ColorVertex temp = new ColorVertex();
        ColorVertex temp2 = new ColorVertex();
        temp.color = Color.black;
        temp2.color = Color.white;
        temp.value = 0.0;
        temp2.value = 1.0;
        temp2.mask = 7;
        temp.mask = 7;
        this.entries.addElement(temp);
        this.entries.addElement(temp2);
        this.overflowColor = Color.magenta;
        this.underflowColor = Color.cyan;
        this.missingColor = Color.white;
    }

    public void addEntry(double value, Color newColor) {
        this.addEntry(value, newColor, 7);
    }

    public void addEntry(double value, Color newColor, int mask) {
        int i;
        if (value < 0.0 || value > 1.0) {
            return;
        }
        int index = -1;
        int foundIndex = -1;
        for (i = 0; i < this.entries.size() - 1; ++i) {
            if (!(((ColorVertex)this.entries.elementAt((int)i)).value < value) || !(((ColorVertex)this.entries.elementAt((int)(i + 1))).value > value)) continue;
            index = i + 1;
        }
        if (index != -1) {
            ColorVertex temp = new ColorVertex();
            temp.color = newColor;
            temp.value = value;
            temp.mask = mask;
            this.entries.insertElementAt(temp, index);
        } else {
            for (i = 0; i < this.entries.size(); ++i) {
                if (((ColorVertex)this.entries.elementAt((int)i)).value != value) continue;
                foundIndex = i;
            }
            if (foundIndex != -1) {
                ColorVertex temp = new ColorVertex();
                temp.color = newColor;
                temp.value = value;
                temp.mask = mask;
                this.entries.setElementAt(temp, foundIndex);
            }
        }
    }

    public void removeEntryAt(int index) {
        if (this.entries.size() > 2 && index > 0 && index != this.entries.size() - 1) {
            this.entries.removeElementAt(index);
        }
    }

    public void clear() {
        this.entries.removeAllElements();
        ColorVertex temp = new ColorVertex();
        ColorVertex temp2 = new ColorVertex();
        temp.color = Color.black;
        temp2.color = Color.white;
        temp.value = 0.0;
        temp2.value = 1.0;
        temp2.mask = 7;
        temp.mask = 7;
        this.entries.addElement(temp);
        this.entries.addElement(temp2);
    }

    public int size() {
        return this.entries.size();
    }

    public ColorVertex getEntry(int i) {
        return (ColorVertex)this.entries.elementAt(i);
    }

    public void setEntry(int i, ColorVertex entry) {
        if (i == 0) {
            entry.value = 0.0;
        } else if (i == this.entries.size() - 1) {
            entry.value = 1.0;
        } else if (entry.value < ((ColorVertex)this.entries.elementAt((int)(i - 1))).value) {
            entry.value = ((ColorVertex)this.entries.elementAt((int)(i - 1))).value;
        } else if (entry.value > ((ColorVertex)this.entries.elementAt((int)(i + 1))).value) {
            entry.value = ((ColorVertex)this.entries.elementAt((int)(i + 1))).value;
        }
        this.entries.removeElementAt(i);
        this.entries.insertElementAt(entry, i);
    }

    public int findClosestEntry(double val) {
        int index = -1;
        double distance = 2.0;
        for (int i = 0; i < this.entries.size(); ++i) {
            double tempDistance = Math.abs(((ColorVertex)this.entries.elementAt((int)i)).value - val);
            if (!(tempDistance < distance)) continue;
            distance = tempDistance;
            index = i;
        }
        return index;
    }

    public Color getValue(double val) {
        if (!this.continuous) {
            int index = this.findClosestEntry(val);
            return ((ColorVertex)this.entries.elementAt((int)index)).color;
        }
        int above = 0;
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!(val <= ((ColorVertex)this.entries.elementAt((int)i)).value)) continue;
            above = i;
            break;
        }
        if (val == ((ColorVertex)this.entries.elementAt((int)above)).value) {
            Color newColor = new Color(((ColorVertex)this.entries.elementAt((int)above)).color.getRed(), ((ColorVertex)this.entries.elementAt((int)above)).color.getGreen(), ((ColorVertex)this.entries.elementAt((int)above)).color.getBlue());
            return newColor;
        }
        int below = above - 1;
        double aboveVal = ((ColorVertex)this.entries.elementAt((int)above)).value;
        double belowVal = ((ColorVertex)this.entries.elementAt((int)below)).value;
        double newpercent = (val - belowVal) / (aboveVal - belowVal);
        int aboveRed = ((ColorVertex)this.entries.elementAt((int)above)).color.getRed();
        int belowRed = ((ColorVertex)this.entries.elementAt((int)below)).color.getRed();
        int aboveGreen = ((ColorVertex)this.entries.elementAt((int)above)).color.getGreen();
        int belowGreen = ((ColorVertex)this.entries.elementAt((int)below)).color.getGreen();
        int aboveBlue = ((ColorVertex)this.entries.elementAt((int)above)).color.getBlue();
        int belowBlue = ((ColorVertex)this.entries.elementAt((int)below)).color.getBlue();
        int newRed = belowRed > aboveRed ? (int)((double)(belowRed - aboveRed) * (1.0 - newpercent) + (double)aboveRed) : (int)((double)(aboveRed - belowRed) * newpercent + (double)belowRed);
        int newGreen = belowGreen > aboveGreen ? (int)((double)(belowGreen - aboveGreen) * (1.0 - newpercent) + (double)aboveGreen) : (int)((double)(aboveGreen - belowGreen) * newpercent + (double)belowGreen);
        int newBlue = belowBlue > aboveBlue ? (int)((double)(belowBlue - aboveBlue) * (1.0 - newpercent) + (double)aboveBlue) : (int)((double)(aboveBlue - belowBlue) * newpercent + (double)belowBlue);
        return new Color(newRed, newGreen, newBlue);
    }

    public void setUnderflowColor(Color newColor) {
        this.underflowColor = newColor;
    }

    public Color getUnderflowColor() {
        return this.underflowColor;
    }

    public void setOverflowColor(Color newColor) {
        this.overflowColor = newColor;
    }

    public Color getOverflowColor() {
        return this.overflowColor;
    }

    public void setMissingColor(Color newColor) {
        this.missingColor = newColor;
    }

    public Color getMissingColor() {
        return this.missingColor;
    }

    public void setContinuous(boolean val) {
        if (this.continuous && !val) {
            Color[] colors = this.getColors();
            double[] values = this.getValues();
            this.clear();
            this.addEntry(0.0, colors[0]);
            for (int i = 0; i < values.length - 1; ++i) {
                double val1 = values[i];
                double val2 = values[i + 1];
                double newVal = (val1 + val2) / 2.0;
                this.addEntry(newVal, colors[i + 1]);
            }
            this.addEntry(1.0, colors[colors.length - 1]);
            this.continuous = val;
        } else if (!this.continuous && val) {
            Color[] colors = this.getColors();
            double[] values = this.getValues();
            this.clear();
            this.addEntry(0.0, colors[0]);
            if (colors.length > 2) {
                this.addEntry(1.0, colors[colors.length - 2]);
            } else {
                this.addEntry(1.0, colors[0]);
            }
            for (int i = 1; i < values.length - 2; ++i) {
                this.addEntry((values[i] + values[i + 1]) / 2.0, colors[i]);
            }
            this.continuous = val;
        }
    }

    public boolean getContinuous() {
        return this.continuous;
    }

    public Color[] getColors() {
        return this.getColors(true);
    }

    public Color[] getColors(boolean cont) {
        int size = this.entries.size();
        if (!cont) {
            --size;
        }
        Color[] colors = new Color[size];
        for (int i = 0; i < size; ++i) {
            colors[i] = ((ColorVertex)this.entries.elementAt((int)i)).color;
        }
        return colors;
    }

    public double[] getValues() {
        double[] values = new double[this.entries.size()];
        for (int i = 0; i < this.entries.size(); ++i) {
            values[i] = ((ColorVertex)this.entries.elementAt((int)i)).value;
        }
        return values;
    }

    public void setContinuousRamp(boolean val) {
        this.continuous = val;
    }

    public void copyInto(Palette newPalette) {
        newPalette.clear();
        ColorVertex tempEntry = new ColorVertex();
        ColorVertex tempEntry3 = new ColorVertex();
        ColorVertex tempEntry2 = (ColorVertex)this.entries.elementAt(0);
        tempEntry.value = tempEntry2.value;
        tempEntry.mask = tempEntry2.mask;
        tempEntry.color = tempEntry2.color;
        newPalette.setEntry(0, tempEntry);
        tempEntry2 = (ColorVertex)this.entries.elementAt(this.entries.size() - 1);
        tempEntry3.value = tempEntry2.value;
        tempEntry3.mask = tempEntry2.mask;
        tempEntry3.color = tempEntry2.color;
        newPalette.setEntry(1, tempEntry3);
        for (int i = 1; i < this.entries.size() - 1; ++i) {
            ColorVertex entry = (ColorVertex)this.entries.elementAt(i);
            newPalette.addEntry(entry.value, entry.color, entry.mask);
        }
        newPalette.continuous = this.continuous;
        newPalette.setOverflowColor(this.overflowColor);
        newPalette.setUnderflowColor(this.underflowColor);
        newPalette.setMissingColor(this.missingColor);
    }

    public void setColors(Color[] colors) {
        if (colors == null) {
            return;
        }
        this.clear();
        this.continuous = false;
        double stride = 1.0 / (double)colors.length;
        for (int i = 0; i < colors.length; ++i) {
            this.addEntry((double)i * stride, colors[i]);
        }
        this.addEntry(1.0, colors[colors.length - 1]);
    }

    public void setColors(Vector colors) {
        if (colors == null) {
            return;
        }
        this.clear();
        this.continuous = false;
        double stride = 1.0 / (double)colors.size();
        for (int i = 0; i < colors.size(); ++i) {
            this.addEntry((double)i * stride, (Color)colors.elementAt(i));
        }
        this.addEntry(1.0, (Color)colors.elementAt(colors.size() - 1));
    }
}

