/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.SubPixelScalableMarkers;
import com.sas.graphics.util.UserDefinedMarkerInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class Markers {
    public static final int NONE = -1;
    public static final int CIRCLE = 0;
    public static final int PLUS = 1;
    public static final int TRIANGLE = 2;
    public static final int UP = 2;
    public static final int SQUARE = 3;
    public static final int X = 4;
    public static final int TRIANGLE_DOWN = 5;
    public static final int DOWN = 5;
    public static final int DIAMOND = 6;
    public static final int ASTER = 7;
    public static final int CIRCLE_BOLD = 8;
    public static final int PLUS_BOLD = 9;
    public static final int TRIANGLE_BOLD = 10;
    public static final int UP_BOLD = 10;
    public static final int SQUARE_BOLD = 11;
    public static final int X_BOLD = 12;
    public static final int TRIANGLE_DOWN_BOLD = 13;
    public static final int DOWN_BOLD = 13;
    public static final int DIAMOND_BOLD = 14;
    public static final int ASTER_BOLD = 15;
    public static final int STAR_BOLD = 15;
    public static final int CIRCLE_FILLED = 16;
    public static final int CROSS_FILLED = 17;
    public static final int PLUS_FILLED = 17;
    public static final int TRIANGLE_FILLED = 18;
    public static final int UP_FILLED = 18;
    public static final int SQUARE_FILLED = 19;
    public static final int SALTIRE_FILLED = 20;
    public static final int X_FILLED = 20;
    public static final int TRIANGLE_DOWN_FILLED = 21;
    public static final int DOWN_FILLED = 21;
    public static final int DIAMOND_FILLED = 22;
    public static final int STAR_FILLED = 23;
    public static final int VENUS = 24;
    public static final int FEMALE = 24;
    public static final int MARS = 25;
    public static final int MALE = 25;
    public static final int EARTH = 26;
    public static final int OTHER = 26;
    public static final int VENUS_BOLD = 27;
    public static final int FEMALE_BOLD = 27;
    public static final int MARS_BOLD = 28;
    public static final int MALE_BOLD = 28;
    public static final int EARTH_BOLD = 29;
    public static final int OTHER_BOLD = 29;
    public static final int VENUS_FILLED = 30;
    public static final int FEMALE_FILLED = 30;
    public static final int MARS_FILLED = 31;
    public static final int MALE_FILLED = 31;
    public static final int EARTH_FILLED = 32;
    public static final int OTHER_FILLED = 32;
    public static final int HORIZONTAL = 33;
    public static final int VERTICAL = 34;
    public static final int HORIZONTAL_BOLD = 35;
    public static final int VERTICAL_BOLD = 36;
    public static final int RECTANGLE_HORIZONTAL_FILLED = 37;
    public static final int HORIZONTAL_FILLED = 37;
    public static final int RECTANGLE_VERTICAL_FILLED = 38;
    public static final int VERTICAL_FILLED = 38;
    public static final int PLUS_X = 39;
    public static final int CIRCLE_PLUS = 40;
    public static final int CIRCLE_X = 41;
    public static final int SQUARE_PLUS = 42;
    public static final int SQUARE_X = 43;
    public static final int SQUARE_UP = 44;
    public static final int SQUARE_DOWN = 45;
    public static final int SQUARE_LEFT = 46;
    public static final int SQUARE_RIGHT = 47;
    public static final int UP_DOWN = 48;
    public static final int LEFT_RIGHT = 49;
    public static final int DIAMOND_PLUS = 50;
    public static final int DIAMOND_X = 51;
    public static final int CROSS = 52;
    public static final int CROSS_OPEN = 52;
    public static final int SALTIRE = 53;
    public static final int X_OPEN = 53;
    public static final int STAR = 54;
    public static final int STAR_OPEN = 54;
    public static final int CROSS_MALTESE = 55;
    public static final int HASH = 56;
    public static final int SMASH = 57;
    public static final int ASTERISK = 58;
    public static final int TRIANGLE_LEFT = 59;
    public static final int LEFT = 59;
    public static final int TRIANGLE_RIGHT = 60;
    public static final int RIGHT = 60;
    public static final int LESS_THAN = 61;
    public static final int LEFT_ANGLE = 61;
    public static final int GREATER_THAN = 62;
    public static final int RIGHT_ANGLE = 62;
    public static final int TILDE = 63;
    public static final int WREATH = 64;
    public static final int UNION = 65;
    public static final int IBEAM = 66;
    public static final int HEX = 67;
    public static final int HOME = 68;
    public static final int HEART = 69;
    public static final int TACK = 70;
    public static final int SPIRAL = 71;
    public static final int WEAVE = 72;
    public static final int HOME_DOWN = 73;
    public static final int FIXED_STAR = 74;
    public static final int CHAIN = 75;
    public static final int ARROW = 76;
    public static final int DIAMOND_NARROW = 77;
    public static final int HOME_NARROW = 78;
    public static final int HOME_NARROW_DOWN = 79;
    public static final int DAGGER = 80;
    public static final int FLAG = 81;
    public static final int CIRCLE_TRIANGLE = 82;
    public static final int CIRCLE_TRIANGLE_DOWN = 83;
    public static final int CIRCLE_ODD = 84;
    public static final int ARROW_WIDE = 85;
    public static final int ARROW_WIDE_DOWN = 86;
    public static final int CIRCLE_ARROW_WIDE = 87;
    public static final int CIRCLE_ARROW_WIDE_DOWN = 88;
    public static final int HOURGLASS = 89;
    public static final int TRIANGLE_LEFT_BOLD = 90;
    public static final int TRIANGLE_RIGHT_BOLD = 91;
    public static final int ASTERISK_BOLD = 92;
    public static final int UNION_BOLD = 93;
    public static final int IBEAM_BOLD = 94;
    public static final int HEX_BOLD = 95;
    public static final int HOME_BOLD = 96;
    public static final int HEART_BOLD = 97;
    public static final int TACK_BOLD = 98;
    public static final int SPIRAL_BOLD = 99;
    public static final int WEAVE_BOLD = 100;
    public static final int HOME_DOWN_BOLD = 101;
    public static final int FIXED_STAR_BOLD = 102;
    public static final int CHAIN_BOLD = 103;
    public static final int ARROW_BOLD = 104;
    public static final int TRIANGLE_LEFT_FILLED = 105;
    public static final int TRIANGLE_RIGHT_FILLED = 106;
    public static final int HOME_FILLED = 107;
    public static final int HOME_DOWN_FILLED = 108;
    public static final int DIAMOND_NARROW_FILLED = 109;
    public static final int HOME_NARROW_FILLED = 110;
    public static final int HOME_NARROW_DOWN_FILLED = 111;
    public static final int FLAG_FILLED = 112;
    public static final int ARROW_WIDE_FILLED = 113;
    public static final int ARROW_WIDE_DOWN_FILLED = 114;
    public static final int CIRCLE_ARROW_WIDE_FILLED = 115;
    public static final int CIRCLE_ARROW_WIDE_DOWN_FILLED = 116;
    public static final int CIRCLE_TRIANGLE_FILLED = 117;
    public static final int CIRCLE_TRIANGLE_DOWN_FILLED = 118;
    public static final int CIRCLE_ODD_FILLED = 119;
    public static final int HOURGLASS_FILLED = 120;
    public static final int HEART_FILLED = 121;
    public static final int CLUB_FILLED = 122;
    public static final int SPADE_FILLED = 123;
    public static final int ARROW_NARROW_FILLED = 124;
    public static final int ARROW_NARROW_DOWN_FILLED = 125;
    public static final int ARROW_NARROW_LEFT_FILLED = 126;
    public static final int ARROW_NARROW_RIGHT_FILLED = 127;
    public static final int FEMALE_FIGURE_FILLED = 128;
    public static final int MALE_FIGURE_FILLED = 129;
    public static final int FEMALE_FIGURE = 130;
    public static final int MALE_FIGURE = 131;
    public static final int RECTANGLE_HORIZONTAL = 132;
    public static final int RECTANGLE_VERTICAL = 133;
    public static final int ARROW_DOWN = 134;
    public static final int ARROW_LEFT = 135;
    public static final int ARROW_RIGHT = 136;
    public static final int ARROW_DOWN_BOLD = 137;
    public static final int ARROW_LEFT_BOLD = 138;
    public static final int ARROW_RIGHT_BOLD = 139;
    public static final int ARROW_NARROW = 140;
    public static final int ARROW_NARROW_DOWN = 141;
    public static final int ARROW_NARROW_LEFT = 142;
    public static final int ARROW_NARROW_RIGHT = 143;
    public static final int CLUB = 144;
    public static final int SPADE = 145;
    public static final int HEXAGON = 146;
    public static final int HEXAGON_VERTICAL = 147;
    public static final int HEXAGON_FILLED = 148;
    public static final int HEXAGON_VERTICAL_FILLED = 149;
    public static final int Y = 150;
    public static final int Z = 151;
    public static final int CIRCLE_ARROW_NARROW_FILLED = 152;
    public static final int CIRCLE_ARROW_NARROW_DOWN_FILLED = 153;
    public static final int CIRCLE_FILLED_ARROW_NARROW = 154;
    public static final int CIRCLE_FILLED_ARROW_NARROW_DOWN = 155;
    public static final int CIRCLE_ARROW_NARROW = 156;
    public static final int CIRCLE_ARROW_NARROW_DOWN = 157;
    public static final int OCTAGON = 158;
    public static final int OCTAGON_FILLED = 159;
    public static final int OCTAGON_ROTATED = 160;
    public static final int OCTAGON_ROTATED_FILLED = 161;
    public static final int PENTAGON = 162;
    public static final int PENTAGON_FILLED = 163;
    public static final int CIRCLE_DOT_FILLED = 164;
    public static final int CIRCLE_FILLED_DOT = 165;
    public static final int CIRCLE_DOT = 166;
    public static final int CHECKMARK = 167;
    public static final int CIRCUMFLEX = 168;
    public static final int CIRCUMFLEX_DOWN = 169;
    public static final int DOLLARSIGN = 170;
    public static final int REGISTERED_TRADEMARK = 171;
    public static final int COPYWRITE = 172;
    public static final int SVG_CIRCLE = 173;
    public static final int SVG_CIRCLE_FILLED = 174;
    public static final int SVG_TILDE = 175;
    public static final int SVG_UNION = 176;
    public static final int SVG_SQUARE_FILLED = 177;
    public static final int SVG_TRIANGLE = 178;
    public static final int SVG_TRIANGLE_FILLED = 179;
    public static final int SVG_TRIANGLE_DOWN = 180;
    public static final int SVG_TRIANGLE_DOWN_FILLED = 181;
    public static final int SVG_TRIANGLE_LEFT = 182;
    public static final int SVG_TRIANGLE_LEFT_FILLED = 183;
    public static final int SVG_TRIANGLE_RIGHT = 184;
    public static final int SVG_TRIANGLE_RIGHT_FILLED = 185;
    public static final int SVG_Y = 186;
    public static final int CIRCLE_OUTLINED = 187;
    public static final int CIRCLE_FILLED_OUTLINED = 188;
    public static final int COUNT = 189;
    private static final String[] names = new String[]{"CIRCLE", "PLUS", "TRIANGLE", "SQUARE", "X", "TRIANGLEDOWN", "DIAMOND", "ASTER", "CIRCLEBOLD", "PLUSBOLD", "TRIANGLEBOLD", "SQUAREBOLD", "XBOLD", "TRIANGLEDOWNBOLD", "DIAMONDBOLD", "ASTERBOLD", "CIRCLEFILLED", "CROSSFILLED", "TRIANGLEFILLED", "SQUAREFILLED", "SALTIREFILLED", "TRIANGLEDOWNFILLED", "DIAMONDFILLED", "STARFILLED", "VENUS", "MARS", "EARTH", "VENUSBOLD", "MARSBOLD", "EARTHBOLD", "VENUSFILLED", "MARSFILLED", "EARTHFILLED", "HORIZONTAL", "VERTICAL", "HORIZONTALBOLD", "VERTICALBOLD", "RECTANGLEHORIZONTALFILLED", "RECTANGLEVERTICALFILLED", "PLUSX", "CIRCLEPLUS", "CIRCLEX", "SQUAREPLUS", "SQUAREX", "SQUAREUP", "SQUAREDOWN", "SQUARELEFT", "SQUARERIGHT", "UPDOWN", "LEFTRIGHT", "DIAMONDPLUS", "DIAMONDX", "CROSS", "SALTIRE", "STAR", "CROSSMALTESE", "HASH", "SMASH", "ASTERISK", "TRIANGLELEFT", "TRIANGLERIGHT", "LESSTHAN", "GREATERTHAN", "TILDE", "WREATH", "UNION", "IBEAM", "HEX", "HOME", "HEART", "TACK", "SPIRAL", "WEAVE", "HOMEDOWN", "FIXEDSTAR", "CHAIN", "ARROW", "DIAMONDNARROW", "HOMENARROW", "HOMENARROWDOWN", "DAGGER", "FLAG", "CIRCLETRIANGLE", "CIRCLETRIANGLEDOWN", "CIRCLEODD", "ARROWWIDE", "ARROWWIDEDOWN", "CIRCLEARROWWIDE", "CIRCLEARROWWIDEDOWN", "HOURGLASS", "TRIANGLELEFTBOLD", "TRIANGLERIGHTBOLD", "ASTERISKBOLD", "UNIONBOLD", "IBEAMBOLD", "HEXBOLD", "HOMEBOLD", "HEARTBOLD", "TACKBOLD", "SPIRALBOLD", "WEAVEBOLD", "HOMEDOWNBOLD", "FIXEDSTARBOLD", "CHAINBOLD", "ARROWBOLD", "TRIANGLELEFTFILLED", "TRIANGLERIGHTFILLED", "HOMEFILLED", "HOMEDOWNFILLED", "DIAMONDNARROWFILLED", "HOMENARROWFILLED", "HOMENARROWDOWNFILLED", "FLAGFILLED", "ARROWWIDEFILLED", "ARROWWIDEDOWNFILLED", "CIRCLEARROWWIDEFILLED", "CIRCLEARROWWIDEDOWNFILLED", "CIRCLETRIANGLEFILLED", "CIRCLETRIANGLEDOWNFILLED", "CIRCLEODDFILLED", "HOURGLASSFILLED", "HEARTFILLED", "CLUBFILLED", "SPADEFILLED", "ARROWNARROWFILLED", "ARROWNARROWDOWNFILLED", "ARROWNARROWLEFTFILLED", "ARROWNARROWRIGHTFILLED", "FEMALEFIGUREFILLED", "MALEFIGUREFILLED", "FEMALEFIGURE", "MALEFIGURE", "RECTANGLEHORIZONTAL", "RECTANGLEVERTICAL", "ARROWDOWN", "ARROWLEFT", "ARROWRIGHT", "ARROWDOWNBOLD", "ARROWLEFTBOLD", "ARROWRIGHTBOLD", "ARROWNARROW", "ARROWNARROWDOWN", "ARROWNARROWLEFT", "ARROWNARROWRIGHT", "CLUB", "SPADE", "HEXAGON", "HEXAGONVERTICAL", "HEXAGONFILLED", "HEXAGONVERTICALFILLED", "Y", "Z", "CIRCLEARROWNARROWFILLED", "CIRCLEARROWNARROWDOWNFILLED", "CIRCLEFILLEDARROWNARROW", "CIRCLEFILLEDARROWNARROWDOWN", "CIRCLEARROWNARROW", "CIRCLEARROWNARROWDOWN", "OCTAGON", "OCTAGONFILLED", "OCTAGONROTATED", "OCTAGONROTATEDFILLED", "PENTAGON", "PENTAGONFILLED", "CIRCLEDOTFILLED", "CIRCLEFILLEDDOT", "CIRCLEDOTFILLED", "CIRCLEDOT", "CHECKMARK", "CIRCUMFLEX", "CIRCUMFLEXDOWN", "DOLLARSIGN", "REGISTEREDTRADEMARK", "COPYWRITE", "SVGCIRCLE", "SVGCIRCLEFILLED", "SVGTILDE", "SVGUNION", "SVGSQUAREFILLED", "SVGTRIANGLE", "SVGTRIANGLEFILLED", "SVGTRIANGLEDOWN", "SVGTRIANGLEDOWNFILLED", "SVGTRIANGLELEFT", "SVGTRIANGLELEFTFILLED", "SVGTRIANGLERIGHT", "SVGTRIANGLERIGHTFILLED", "SVGY", "CIRCLEOUTLINED", "CIRCLEFILLEDOUTLINED"};
    public static final int WEIGHT_NORMAL = 0;
    public static final int WEIGHT_SEMI_BOLD = 1;
    public static final int WEIGHT_BOLD = 2;
    private static final int[] scalableMarkers = new int[]{0, 1, 4, 2, 63, 66, 3, 58, 150, 6, 151, 65, 56, 70, 73, 62, 134, 54, 146, 52, 16, 18, 19, 22, 108, 23, 148, 17, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 5, 59, 60, 21, 105, 106, 61, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188};
    private static final int[] GTLSupportedMarkers = new int[]{0, 1, 4, 2, 63, 66, 3, 58, 150, 6, 151, 65, 56, 70, 73, 62, 134, 54, 16, 18, 19, 22, 108, 23, 5, 59, 60, 21, 105, 106, 61};
    private static boolean JBI_COMPILER_TRICK = false;
    public static final int[] SET_ASTRONOMY = new int[]{24, 25, 26, 74};
    public static final int[] SET_ASTRONOMY_BOLD = new int[]{27, 28, 29, 102};
    public static final int[] SET_ASTRONOMY_FILLED = new int[]{30, 31, 32};
    public static final int[] SET_DETAIL = new int[]{55, 56, 57, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    public static final int[] SET_GEOMETRY = new int[]{0, 52, 3, 2, 53, 5, 54, 59, 60, 68, 73, 146, 147, 6, 69, 144, 145, 132, 133, 140, 141, 142, 143};
    public static final int[] SET_GEOMETRY_BOLD = new int[]{8, 11, 10, 13, 90, 91, 96, 101, 14, 97};
    public static final int[] SET_GEOMETRY_FILLED = new int[]{16, 17, 19, 18, 20, 21, 23, 105, 106, 107, 108, 148, 149, 22, 121, 122, 123, 37, 38, 124, 125, 126, 127};
    public static final int[] SET_LINE = new int[]{33, 34, 1, 80, 61, 62};
    public static final int[] SET_LINE_BOLD = new int[]{35, 36, 9};
    public static final int[] SET_OR = new int[]{2, 5, 59, 60, 3, 6, 77, 68, 73, 89, 54, 85, 86, 87, 88, 82, 83, 84, 78, 79, 52, 81, 130, 131, 1, 58, 80, 34, 156, 157, 158, 160, 162, 165, 166, 167, 168, 169, 170, 171, 172};
    public static final int[] SET_OR_FILLED = new int[]{18, 21, 105, 106, 19, 22, 109, 107, 108, 120, 23, 113, 114, 115, 116, 152, 153, 154, 155, 117, 118, 119, 110, 111, 17, 112, 128, 129, 152, 153, 154, 155, 159, 161, 163, 164};
    public static final int[] SET_SIMPLE = new int[]{76, 134, 135, 136, 7, 63, 64};
    public static final int[] SET_SIMPLE_BOLD = new int[]{104, 137, 138, 139, 15};
    public static final int[] SET_STANDARD = new int[]{0, 1, 4, 2, 58, 3, 65, 66, 6, 67, 5, 70, 69, 72, 68, 74, 73, 71, 75, 76};
    public static final int[] SET_STANDARD_BOLD = new int[]{8, 9, 12, 10, 92, 11, 93, 94, 14, 95, 13, 98, 97, 100, 96, 102, 101, 99, 103, 104};
    private static final int PLAIN = 0;
    private static final int BOLD = 1;
    private static final int FILL = 2;
    private static ArrayList<UserDefinedMarkerInterface> udm = new ArrayList();
    private static ArrayList<String> udmName = new ArrayList();

    public Markers() {
        if (JBI_COMPILER_TRICK) {
            new ScalableMarkers();
        }
    }

    private static boolean isScalableMarker(int shape) {
        for (int i = 0; i < scalableMarkers.length; ++i) {
            if (scalableMarkers[i] != shape) continue;
            return true;
        }
        return false;
    }

    public static boolean isGTLSupportedMarker(int shape) {
        if (Markers.isUserDefinedMarker(shape)) {
            return true;
        }
        for (int i = 0; i < GTLSupportedMarkers.length; ++i) {
            if (GTLSupportedMarkers[i] != shape) continue;
            return true;
        }
        return false;
    }

    public static int getMaximumMarkerSize(int markerSize, boolean scalable, int weight) {
        if (scalable) {
            return ScalableMarkers.getMaximumMarkerSize(markerSize, scalable, weight);
        }
        return markerSize;
    }

    public static int getAdjustedSize(int shape, int markerSize, boolean scalable) {
        if (scalable) {
            return ScalableMarkers.getAdjustedSize(shape, markerSize);
        }
        return markerSize;
    }

    public static String getShapeName(int shape) {
        if (shape < 0 || shape >= names.length) {
            return null;
        }
        return names[shape];
    }

    public static int getShape(String name) {
        if (Markers.isUserDefinedMarker(name.toUpperCase())) {
            return Markers.getUserDefinedMarker(name.toUpperCase());
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') continue;
            b.append(c);
        }
        String s = b.toString().toUpperCase();
        int shape = -1;
        for (int i = 0; shape == -1 && i < names.length; ++i) {
            if (!names[i].equals(s)) continue;
            shape = i;
        }
        return shape;
    }

    public static int getSVGShape(int shape) {
        switch (shape) {
            case 0: 
            case 187: {
                return 173;
            }
            case 16: 
            case 188: {
                return 174;
            }
            case 65: {
                return 176;
            }
            case 63: {
                return 175;
            }
            case 2: {
                return 178;
            }
            case 18: {
                return 179;
            }
            case 5: {
                return 180;
            }
            case 21: {
                return 181;
            }
            case 60: {
                return 184;
            }
            case 106: {
                return 185;
            }
            case 59: {
                return 182;
            }
            case 105: {
                return 183;
            }
            case 19: {
                return 177;
            }
            case 150: {
                return 186;
            }
        }
        return shape;
    }

    public static boolean isBold(int shape) {
        return 8 <= shape && shape <= 15 || 27 <= shape && shape <= 29 || 35 <= shape && shape <= 36 || 90 <= shape && shape <= 104 || 137 <= shape && shape <= 139;
    }

    public static boolean isFilled(int shape) {
        if (Markers.isScalableMarker(shape)) {
            return ScalableMarkers.isFilled(shape);
        }
        if (Markers.isUserDefinedMarker(shape)) {
            return false;
        }
        return 16 <= shape && shape <= 23 || 30 <= shape && shape <= 32 || 37 <= shape && shape <= 38 || 105 <= shape && shape <= 129 || 148 <= shape && shape <= 149;
    }

    private static int adjustSize(int shape, int maxSize) {
        int size = maxSize;
        if (shape == 0 || shape == 16 || shape == 8) {
            size -= (size + 4) / 8;
        } else if (shape == 3 || shape == 19 || shape == 11) {
            size -= (size + 6) / 6;
        } else if (shape == 4 || shape == 12) {
            size -= (size + 4) / 12;
        } else if ((40 <= shape && shape <= 49 || shape == 87 || shape == 115 || shape == 88 || shape == 116 || shape == 156 || shape == 152 || shape == 157 || shape == 153 || shape == 154 || shape == 155 || shape == 82 || shape == 117 || shape == 83 || shape == 118 || shape == 84 || shape == 119) && (size -= (size + 4) / 12) % 2 == 0) {
            --size;
        }
        return size;
    }

    public static void drawStroke(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0, boolean adjust) {
        boolean gotEdge = edge != null;
        Color myColor = color;
        if (color != null) {
            g.setColor(color);
            gotEdge = gotEdge && !color.equals(edge);
        } else if (gotEdge) {
            myColor = g.getColor();
        }
        if (maxSize <= 4 && (Markers.isBold(shape) || Markers.isFilled(shape))) {
            Markers.draw(g, color, edge, shape, maxSize, x0, y0);
            return;
        }
        if (maxSize <= 2) {
            Markers.draw(g, color, edge, shape, maxSize, x0, y0);
            return;
        }
        int size = adjust ? Markers.adjustSize(shape, maxSize) : maxSize;
        int half1 = (size - 1) / 2;
        int top = y0 - half1;
        int bottom = y0 + half1;
        int left = x0 - half1;
        int right = x0 + half1;
        switch (shape) {
            case 0: 
            case 16: {
                if (shape == 16) {
                    g.fillOval(left, top, size, size);
                    if (gotEdge) {
                        g.setColor(edge);
                    }
                }
                g.drawOval(left, top, size - 1, size - 1);
                if (shape != 16 || !gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 17: 
            case 52: {
                int d1 = (half1 + 1) / 3;
                int[] x = new int[12];
                int[] y = new int[12];
                x[0] = x0 + half1;
                y[0] = y0 - d1;
                x[1] = x0 + d1;
                y[1] = y0 - d1;
                x[2] = x0 + d1;
                y[2] = y0 - half1;
                x[3] = x0 - d1;
                y[3] = y0 - half1;
                x[4] = x0 - d1;
                y[4] = y0 - d1;
                x[5] = x0 - half1;
                y[5] = y0 - d1;
                x[6] = x0 - half1;
                y[6] = y0 + d1;
                x[7] = x0 - d1;
                y[7] = y0 + d1;
                x[8] = x0 - d1;
                y[8] = y0 + half1;
                x[9] = x0 + d1;
                y[9] = y0 + half1;
                x[10] = x0 + d1;
                y[10] = y0 + d1;
                x[11] = x0 + half1;
                y[11] = y0 + d1;
                if (shape == 17) {
                    g.fillPolygon(x, y, 12);
                    if (gotEdge) {
                        g.setColor(edge);
                    }
                }
                g.drawPolygon(x, y, 12);
                if (shape != 17 || !gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 6: 
            case 22: {
                int[] x = new int[4];
                int[] y = new int[4];
                x[0] = x0;
                y[0] = top;
                x[1] = left;
                y[1] = y0;
                x[2] = x0;
                y[2] = bottom;
                x[3] = right;
                y[3] = y0;
                if (shape == 22) {
                    g.fillPolygon(x, y, 4);
                    if (gotEdge) {
                        g.setColor(edge);
                    }
                }
                g.drawPolygon(x, y, 4);
                if (shape != 22 || !gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 2: {
                int[] x = new int[3];
                int[] y = new int[3];
                x[0] = x0;
                y[0] = top;
                x[1] = left;
                y[1] = bottom;
                x[2] = right;
                y[2] = bottom;
                g.drawPolygon(x, y, 3);
                break;
            }
            case 18: {
                Markers.drawTriangleFilled(g, myColor, edge, gotEdge, x0, y0, top, bottom, left, right, 0);
                break;
            }
            default: {
                Markers.draw(g, color, edge, shape, maxSize, x0, y0);
            }
        }
    }

    private static void drawTriangleFilled(Graphics g, Color myColor, Color edge, boolean gotEdge, int x0, int y0, int top, int bottom, int left, int right, int dir) {
        int[] x = new int[3];
        int[] y = new int[3];
        if (dir == 0) {
            x[0] = x0;
            y[0] = top;
            x[1] = left;
            y[1] = bottom;
            x[2] = right;
            y[2] = bottom;
        } else if (dir == 1) {
            x[0] = x0;
            y[0] = bottom;
            x[1] = left;
            y[1] = top;
            x[2] = right;
            y[2] = top;
        } else if (dir == 2) {
            x[0] = left;
            y[0] = y0;
            x[1] = right;
            y[1] = top;
            x[2] = right;
            y[2] = bottom;
        } else {
            x[0] = right;
            y[0] = y0;
            x[1] = left;
            y[1] = top;
            x[2] = left;
            y[2] = bottom;
        }
        g.fillPolygon(x, y, 3);
        if (gotEdge) {
            g.setColor(edge);
        }
        g.drawPolygon(x, y, 3);
        if (gotEdge) {
            g.setColor(myColor);
        }
    }

    public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0, boolean weightedEdgeEnabled, int edgeWeight, int edgeWidth) {
        Markers.draw(g, color, edge, shape, maxSize, x0, y0, weightedEdgeEnabled, edgeWeight, edgeWidth, false, null);
    }

    public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0, boolean weightedEdgeEnabled, int edgeWeight, int edgeWidth, boolean antialiasingOn) {
        Markers.draw(g, color, edge, shape, maxSize, x0, y0, weightedEdgeEnabled, edgeWeight, edgeWidth, antialiasingOn, null);
    }

    public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0, boolean weightedEdgeEnabled, int edgeWeight, int edgeWidth, Image skin) {
        Markers.draw(g, color, edge, shape, maxSize, x0, y0, weightedEdgeEnabled, edgeWeight, edgeWidth, false, skin);
    }

    public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0, boolean weightedEdgeEnabled, int edgeWeight, int edgeWidth, boolean antialiasingOn, Image skin) {
        if (Markers.isScalableMarker(shape)) {
            if (weightedEdgeEnabled) {
                ScalableMarkers.draw(g, color, edge, shape, maxSize, x0, y0, weightedEdgeEnabled, edgeWeight, antialiasingOn, skin);
            } else {
                ScalableMarkers.draw(g, color, edge, shape, maxSize, x0, y0, edgeWidth, antialiasingOn, skin);
            }
        } else {
            Markers.draw(g, color, edge, shape, maxSize, x0, y0, skin);
        }
    }

    public static void draw(Graphics g, Color color, Color edge, int shape, double maxSize, double x0, double y0, boolean weightedEdgeEnabled, int edgeWeight, int edgeWidth, boolean antialiasingOn, Image skin) {
        if (Markers.isScalableMarker(shape)) {
            if (weightedEdgeEnabled) {
                SubPixelScalableMarkers.draw((Graphics2D)g, color, edge, shape, maxSize, x0, y0, weightedEdgeEnabled, edgeWeight, antialiasingOn);
            } else {
                SubPixelScalableMarkers.draw((Graphics2D)g, color, edge, shape, maxSize, x0, y0, edgeWidth, antialiasingOn);
            }
        } else if (Markers.isUserDefinedMarker(shape)) {
            SubPixelScalableMarkers.draw((Graphics2D)g, color, edge, shape, maxSize, x0, y0, edgeWidth, antialiasingOn);
        } else {
            Markers.draw(g, color, edge, shape, (int)maxSize, (int)x0, (int)y0, skin);
        }
    }

    public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0) {
        Markers.draw(g, color, edge, shape, maxSize, x0, y0, null);
    }

    public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0, Image skin) {
        if (Markers.isScalableMarker(shape)) {
            ScalableMarkers.draw(g, color, edge, shape, maxSize, x0, y0, skin);
            return;
        }
        boolean gotEdge = edge != null;
        Color myColor = color;
        if (color != null) {
            g.setColor(color);
            gotEdge = gotEdge && !color.equals(edge);
        } else if (gotEdge) {
            myColor = g.getColor();
        }
        if (maxSize <= 4 && (Markers.isBold(shape) || Markers.isFilled(shape))) {
            if (maxSize != 0) {
                if (maxSize > 2 && shape != 35 && shape != 36) {
                    g.fillRect(x0, y0, 1, 1);
                }
                if (gotEdge) {
                    g.setColor(edge);
                }
                if (maxSize == 1) {
                    g.drawLine(x0, y0, x0 + 1, y0);
                    Markers.drawSkin(g, x0, y0, x0 + 1, y0, skin);
                } else if (maxSize == 2) {
                    g.drawRect(x0, y0, 1, 1);
                    Markers.drawSkin(g, x0, y0, 1, 1, skin);
                } else if (shape == 35) {
                    g.drawRect(x0 - 1, y0, 2, 1);
                    Markers.drawSkin(g, x0 - 1, y0, 2, 1, skin);
                } else if (shape == 36) {
                    g.drawRect(x0, y0 - 1, 1, 2);
                    Markers.drawSkin(g, x0, y0 - 1, 1, 2, skin);
                } else {
                    g.drawRect(x0 - 1, y0 - 1, 2, 2);
                    Markers.drawSkin(g, x0 - 1, y0 - 1, 2, 2, skin);
                }
                if (gotEdge) {
                    g.setColor(myColor);
                }
            }
            return;
        }
        if (maxSize <= 2) {
            if (maxSize != 0) {
                if (gotEdge) {
                    g.setColor(edge);
                }
                g.drawLine(x0, y0, x0 + maxSize - 1, y0);
                if (gotEdge) {
                    g.setColor(myColor);
                }
            }
            return;
        }
        int size = Markers.adjustSize(shape, maxSize);
        int half1 = (size - 1) / 2;
        int top = y0 - half1;
        int bottom = y0 + half1;
        int left = x0 - half1;
        int right = x0 + half1;
        switch (shape) {
            default: {
                if (!Markers.isUserDefinedMarker(shape)) break;
                UserDefinedMarkerInterface udm = Markers.getUserDefinedMarker(shape);
                udm.paint((Graphics2D)g, color, edge, x0, y0, size, size);
                break;
            }
            case 0: 
            case 84: {
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                break;
            }
            case 1: {
                Markers.drawPlus(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 4: {
                Markers.drawX(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 3: {
                Markers.drawSquare(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 58: {
                Markers.drawAsterisk(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 2: {
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 65: {
                Markers.drawUnion(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 6: {
                Markers.drawDiamond(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 66: {
                Markers.drawIBeam(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 67: {
                Markers.drawHex(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 68: {
                Markers.drawHome(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 69: {
                Markers.drawHeart(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 70: {
                Markers.drawTack(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 71: {
                Markers.drawSpiral(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 5: {
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 72: {
                Markers.drawWeave(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 73: {
                Markers.drawHome(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 74: {
                Markers.drawAsterisk(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 75: {
                Markers.drawChain(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 76: {
                Markers.drawArrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 134: {
                Markers.drawArrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 135: {
                Markers.drawArrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 2);
                break;
            }
            case 136: {
                Markers.drawArrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 3);
                break;
            }
            case 8: {
                Markers.drawCircleBold(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                break;
            }
            case 9: {
                Markers.drawPlus(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 12: {
                Markers.drawX(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 11: {
                Markers.drawSquare(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 92: {
                Markers.drawAsterisk(g, x0, y0, size, half1, top, bottom, left, right, 1, 0);
                break;
            }
            case 10: {
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 1, 0);
                break;
            }
            case 93: {
                Markers.drawUnion(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 14: {
                Markers.drawDiamond(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 94: {
                Markers.drawIBeam(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 95: {
                Markers.drawHex(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 96: {
                Markers.drawHome(g, x0, y0, size, half1, top, bottom, left, right, 1, 0);
                break;
            }
            case 97: {
                Markers.drawHeart(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 98: {
                Markers.drawTack(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 99: {
                Markers.drawSpiral(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 13: {
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 1, 1);
                break;
            }
            case 100: {
                Markers.drawWeave(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 101: {
                Markers.drawHome(g, x0, y0, size, half1, top, bottom, left, right, 1, 1);
                break;
            }
            case 102: {
                Markers.drawAsterisk(g, x0, y0, size, half1, top, bottom, left, right, 1, 1);
                break;
            }
            case 103: {
                Markers.drawChain(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 104: {
                Markers.drawArrow(g, x0, y0, size, half1, top, bottom, left, right, 1, 0);
                break;
            }
            case 137: {
                Markers.drawArrow(g, x0, y0, size, half1, top, bottom, left, right, 1, 1);
                break;
            }
            case 138: {
                Markers.drawArrow(g, x0, y0, size, half1, top, bottom, left, right, 1, 2);
                break;
            }
            case 139: {
                Markers.drawArrow(g, x0, y0, size, half1, top, bottom, left, right, 1, 3);
                break;
            }
            case 90: {
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 1, 2);
                break;
            }
            case 91: {
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 1, 3);
                break;
            }
            case 15: {
                Markers.drawAster(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 16: 
            case 119: {
                Markers.drawCircleFilled(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 18: {
                Markers.drawTriangleFilled(g, myColor, edge, gotEdge, x0, y0, top, bottom, left, right, 0);
                break;
            }
            case 19: {
                Markers.drawSquare(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawSquare(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 21: {
                Markers.drawTriangleFilled(g, myColor, edge, gotEdge, x0, y0, top, bottom, left, right, 1);
                break;
            }
            case 105: {
                Markers.drawTriangleFilled(g, myColor, edge, gotEdge, x0, y0, top, bottom, left, right, 2);
                break;
            }
            case 106: {
                Markers.drawTriangleFilled(g, myColor, edge, gotEdge, x0, y0, top, bottom, left, right, 3);
                break;
            }
            case 22: {
                Markers.drawDiamond(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawDiamond(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 17: {
                Markers.drawCross(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawCross(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 20: {
                Markers.drawSaltire(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawSaltire(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 23: {
                Markers.drawStar(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawStar(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 33: {
                g.drawLine(x0 - half1, y0, x0 + half1, y0);
                break;
            }
            case 34: {
                g.drawLine(x0, y0 - half1, x0, y0 + half1);
                break;
            }
            case 35: 
            case 36: {
                int w = 2;
                int w1 = (w - 1) / 2;
                int w2 = (size - w) / 2;
                if (shape == 35) {
                    g.fillRect(x0 - w1 - w2, y0 - w1, w + 2 * w2, w);
                    break;
                }
                g.fillRect(x0 - w1, y0 - w1 - w2, w, w + 2 * w2);
                break;
            }
            case 132: {
                Markers.drawRectangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 133: {
                Markers.drawRectangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 37: {
                Markers.drawRectangle(g, x0, y0, size, half1, top, bottom, left, right, 2, 0);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawRectangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 38: {
                Markers.drawRectangle(g, x0, y0, size, half1, top, bottom, left, right, 2, 1);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawRectangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 24: {
                Markers.drawVenus(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 25: {
                Markers.drawMars(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 26: {
                Markers.drawEarth(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 27: {
                Markers.drawVenus(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 28: {
                Markers.drawMars(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 29: {
                Markers.drawEarth(g, x0, y0, size, half1, top, bottom, left, right, 1);
                break;
            }
            case 30: {
                Markers.drawVenus(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawVenus(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 31: {
                Markers.drawMars(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawMars(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 32: {
                Markers.drawEarth(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawEarth(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 39: {
                Markers.drawPlus(g, x0, y0, size, half1, top, bottom, left, right, 0);
                Markers.drawX(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 40: {
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                Markers.drawPlus(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 41: {
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                Markers.drawX(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 42: {
                Markers.drawSquare(g, x0, y0, size, half1, top, bottom, left, right, 0);
                Markers.drawPlus(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 43: {
                Markers.drawSquare(g, x0, y0, size, half1, top, bottom, left, right, 0);
                Markers.drawX(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 44: {
                Markers.drawSquare(g, x0, y0, size, half1, top, bottom, left, right, 0);
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 45: {
                Markers.drawSquare(g, x0, y0, size, half1, top, bottom, left, right, 0);
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 46: {
                Markers.drawSquare(g, x0, y0, size, half1, top, bottom, left, right, 0);
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 2);
                break;
            }
            case 47: {
                Markers.drawSquare(g, x0, y0, size, half1, top, bottom, left, right, 0);
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 3);
                break;
            }
            case 48: {
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 49: {
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 2);
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 3);
                break;
            }
            case 50: {
                Markers.drawDiamond(g, x0, y0, size, half1, top, bottom, left, right, 0);
                Markers.drawPlus(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 51: {
                Markers.drawDiamond(g, x0, y0, size, half1, top, bottom, left, right, 0);
                Markers.drawX(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 52: {
                Markers.drawCross(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 53: {
                Markers.drawSaltire(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 54: {
                Markers.drawStar(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 7: {
                Markers.drawAster(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 55: {
                Markers.drawMaltese(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 56: {
                Markers.drawHash(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 57: {
                Markers.drawSmash(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 59: {
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 2);
                break;
            }
            case 60: {
                Markers.drawTriangle(g, x0, y0, size, half1, top, bottom, left, right, 0, 3);
                break;
            }
            case 61: {
                Markers.drawAngle(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 62: {
                Markers.drawAngle(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 63: {
                Markers.drawCurve(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 64: {
                Markers.drawCurve(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 107: {
                Markers.drawHome(g, x0, y0, size, half1, top, bottom, left, right, 2, 0);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawHome(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 108: {
                Markers.drawHome(g, x0, y0, size, half1, top, bottom, left, right, 2, 1);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawHome(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 77: {
                Markers.drawNarrowDiamond(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 109: {
                Markers.drawNarrowDiamond(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawNarrowDiamond(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 78: {
                Markers.drawNarrowHome(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 110: {
                Markers.drawNarrowHome(g, x0, y0, size, half1, top, bottom, left, right, 2, 0);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawNarrowHome(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 79: {
                Markers.drawNarrowHome(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 111: {
                Markers.drawNarrowHome(g, x0, y0, size, half1, top, bottom, left, right, 2, 1);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawNarrowHome(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 80: {
                int d1 = (size + 1) / 4;
                g.drawLine(x0, y0 - half1, x0, y0 + half1);
                g.drawLine(x0 - d1, y0 - half1 + d1, x0 - 1, y0 - half1 + d1);
                g.drawLine(x0 + 1, y0 - half1 + d1, x0 + d1, y0 - half1 + d1);
                break;
            }
            case 81: {
                Markers.drawFlag(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 112: {
                Markers.drawFlag(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawFlag(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 82: {
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                size = 4 * size / 5;
                half1 = (size - 1) / 2;
                int d1 = size / 10;
                if (maxSize < 14 || 15 < maxSize) {
                    ++d1;
                }
                Markers.drawTriangle(g, x0, y0 -= d1, size, half1, y0 - half1, y0 + half1, x0 - half1, x0 + half1, 0, 0);
                break;
            }
            case 83: {
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                size = 4 * size / 5;
                half1 = (size - 1) / 2;
                int d1 = size / 10;
                if (maxSize < 14 || 15 < maxSize) {
                    ++d1;
                }
                Markers.drawTriangle(g, x0, y0 += d1, size, half1, y0 - half1, y0 + half1, x0 - half1, x0 + half1, 0, 1);
                break;
            }
            case 117: {
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                if (gotEdge) {
                    g.setColor(myColor);
                }
                size = 4 * size / 5;
                half1 = (size - 1) / 2;
                int d1 = size / 10;
                if (maxSize < 14 || 15 < maxSize) {
                    ++d1;
                }
                Markers.drawTriangle(g, x0, y0 -= d1, size, half1, y0 - half1, y0 + half1, x0 - half1, x0 + half1, 2, 0);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawTriangle(g, x0, y0, size, half1, y0 - half1, y0 + half1, x0 - half1, x0 + half1, 0, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 118: {
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                if (gotEdge) {
                    g.setColor(myColor);
                }
                size = 4 * size / 5;
                half1 = (size - 1) / 2;
                int d1 = size / 10;
                if (maxSize < 14 || 15 < maxSize) {
                    ++d1;
                }
                Markers.drawTriangle(g, x0, y0 += d1, size, half1, y0 - half1, y0 + half1, x0 - half1, x0 + half1, 2, 1);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawTriangle(g, x0, y0, size, half1, y0 - half1, y0 + half1, x0 - half1, x0 + half1, 0, 1);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 140: {
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 141: {
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 142: {
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 2);
                break;
            }
            case 143: {
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 3);
                break;
            }
            case 124: {
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 2, 0);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 125: {
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 2, 1);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 126: {
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 2, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 2);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 127: {
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 2, 3);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 3);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 85: {
                Markers.drawArrowWide(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 86: {
                Markers.drawArrowWide(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 113: {
                Markers.drawArrowWide(g, x0, y0, size, half1, top, bottom, left, right, 2, 0);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawArrowWide(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 114: {
                Markers.drawArrowWide(g, x0, y0, size, half1, top, bottom, left, right, 2, 1);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawArrowWide(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 87: {
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                size = 9 * size / 10;
                half1 = (size - 1) / 2;
                Markers.drawArrowWide(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 88: {
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                size = 9 * size / 10;
                half1 = (size - 1) / 2;
                Markers.drawArrowWide(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 115: {
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                if (gotEdge) {
                    g.setColor(myColor);
                }
                size = 9 * size / 10;
                half1 = (size - 1) / 2;
                Markers.drawArrowWide(g, x0, y0, size, half1, top, bottom, left, right, 2, 0);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawArrowWide(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 116: {
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                if (gotEdge) {
                    g.setColor(myColor);
                }
                size = 9 * size / 10;
                half1 = (size - 1) / 2;
                Markers.drawArrowWide(g, x0, y0, size, half1, top, bottom, left, right, 2, 1);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawArrowWide(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 156: {
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                size = 9 * size / 10;
                half1 = (size - 1) / 2;
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 157: {
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                size = 9 * size / 10;
                half1 = (size - 1) / 2;
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 152: {
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                if (gotEdge) {
                    g.setColor(myColor);
                }
                size = 9 * size / 10;
                half1 = (size - 1) / 2;
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 2, 0);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 153: {
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                if (gotEdge) {
                    g.setColor(myColor);
                }
                size = 9 * size / 10;
                half1 = (size - 1) / 2;
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 2, 1);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 154: {
                Markers.drawCircleFilled(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                size = 9 * size / 10;
                half1 = (size - 1) / 2;
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 2, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 155: {
                Markers.drawCircleFilled(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
                size = 9 * size / 10;
                half1 = (size - 1) / 2;
                Markers.drawArrowNarrow(g, x0, y0, size, half1, top, bottom, left, right, 2, 1);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 89: {
                Markers.drawHourglass(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 120: {
                Markers.drawHourglass(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawHourglass(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 130: {
                Markers.drawFigure(g, x0, y0, size, half1, top, bottom, left, right, 0, false);
                break;
            }
            case 131: {
                Markers.drawFigure(g, x0, y0, size, half1, top, bottom, left, right, 0, true);
                break;
            }
            case 128: {
                Markers.drawFigure(g, x0, y0, size, half1, top, bottom, left, right, 2, false);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawFigure(g, x0, y0, size, half1, top, bottom, left, right, 0, false);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 129: {
                Markers.drawFigure(g, x0, y0, size, half1, top, bottom, left, right, 2, true);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawFigure(g, x0, y0, size, half1, top, bottom, left, right, 0, true);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 145: {
                Markers.drawSpade(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 144: {
                Markers.drawClub(g, x0, y0, size, half1, top, bottom, left, right, 0);
                break;
            }
            case 123: {
                Markers.drawSpade(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawSpade(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 122: {
                Markers.drawClub(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawClub(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 121: {
                Markers.drawHeart(g, x0, y0, size, half1, top, bottom, left, right, 2);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawHeart(g, x0, y0, size, half1, top, bottom, left, right, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 146: {
                Markers.drawHexagon(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                break;
            }
            case 148: {
                Markers.drawHexagon(g, x0, y0, size, half1, top, bottom, left, right, 2, 0);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawHexagon(g, x0, y0, size, half1, top, bottom, left, right, 0, 0);
                if (!gotEdge) break;
                g.setColor(myColor);
                break;
            }
            case 147: {
                Markers.drawHexagon(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                break;
            }
            case 149: {
                Markers.drawHexagon(g, x0, y0, size, half1, top, bottom, left, right, 2, 1);
                if (gotEdge) {
                    g.setColor(edge);
                }
                Markers.drawHexagon(g, x0, y0, size, half1, top, bottom, left, right, 0, 1);
                if (!gotEdge) break;
                g.setColor(myColor);
            }
        }
        Markers.drawSkin(g, left, top, size, size, skin);
    }

    private static int genderSize(int size) {
        int genderSize;
        if (size <= 5) {
            genderSize = 3;
        } else if (size == 6) {
            genderSize = 4;
        } else if (size <= 8) {
            genderSize = 5;
        } else if (size <= 11) {
            genderSize = 7;
        } else if (size <= 14) {
            genderSize = 9;
        } else if (size <= 17) {
            genderSize = 11;
        } else if (size <= 19) {
            genderSize = 13;
        } else {
            genderSize = 2 * size / 3;
            if (genderSize % 2 == 0) {
                --genderSize;
            }
        }
        return genderSize;
    }

    private static void drawCircle(Graphics g, int x0, int y0, int maxSize, int size, int half1, int top, int bottom, int left, int right) {
        int half = size / 2;
        boolean aa = false;
        if (g instanceof Graphics2D) {
            aa = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (size <= 3) {
            g.drawLine(left, y0, x0, bottom);
            g.drawLine(x0, top, right, y0);
        } else if (size <= 6 && !aa) {
            bottom = y0 + half;
            right = x0 + half;
            g.drawLine(left + 1, top, right - 1, top);
            g.drawLine(left + 1, bottom, right - 1, bottom);
            g.drawLine(left, top + 1, left, bottom - 1);
            g.drawLine(right, top + 1, right, bottom - 1);
        } else if (size <= 12) {
            bottom = y0 + half;
            right = x0 + half;
            int d = (size + (aa ? 2 : 1)) / 4;
            int e = d + 1;
            g.drawLine(left, top + d, left + d, top);
            g.drawLine(right, top + d, right - d, top);
            g.drawLine(left + d, bottom, left, bottom - d);
            g.drawLine(right - d, bottom, right, bottom - d);
            if (top + e <= bottom - e) {
                g.drawLine(left, top + e, left, bottom - e);
                g.drawLine(right, top + e, right, bottom - e);
                g.drawLine(left + e, top, right - e, top);
                g.drawLine(left + e, bottom, right - e, bottom);
            }
        } else {
            boolean first = true;
            boolean last = true;
            for (int i = 0; i < 8; ++i) {
                int dx = 0;
                if (i < 2 || 5 < i) {
                    dx = half - half1;
                }
                int dy = 0;
                if (i > 3) {
                    dy = half - half1;
                }
                if (half == half1) {
                    if (i % 4 == 0 || i % 4 == 3) {
                        first = i % 2 == 0;
                    } else {
                        boolean bl = first = i % 2 == 1;
                    }
                }
                if (size >= 15) {
                    last = i % 2 == 0;
                }
                Markers.drawEighth(g, first, last, x0 + dx, y0 + dy, half1, i);
            }
        }
    }

    private static void drawCircleBold(Graphics g, int x0, int y0, int maxSize, int size, int half1, int top, int bottom, int left, int right) {
        int half = size / 2;
        boolean aa = false;
        if (g instanceof Graphics2D) {
            aa = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (size <= 3) {
            g.fillRect(x0 - half1, y0 - half1, size, size);
        } else {
            Markers.drawCircle(g, x0, y0, maxSize, size, half1, top, bottom, left, right);
        }
        if (size <= 10) {
            g.drawRect(x0 - half1 + 1, y0 - half1 + 1, size - 3, size - 3);
        } else {
            Markers.drawCircle(g, x0, y0, maxSize - 2, size - 2, half1 - 1, top + 1, bottom - 1, left + 1, right - 1);
        }
        if (size >= 8) {
            int d2 = size / 4 + 2;
            if (12 <= size && size <= 14) {
                --d2;
            } else if (size == 19) {
                ++d2;
            }
            int d1 = d2;
            if (19 <= size && size <= 20) {
                --d1;
            }
            int e = 2;
            if (size == 12 || size == 19 || size == 20) {
                --e;
            }
            for (int d = d1; d <= d2; ++d) {
                g.drawLine(x0 - half1 + e, y0 - half1 + d - e, x0 - half1 + d - e, y0 - half1 + e);
                g.drawLine(x0 - half1 + e, y0 + half - d + e, x0 - half1 + d - e, y0 + half - e);
                g.drawLine(x0 + half - d + e, y0 - half1 + e, x0 + half - e, y0 - half1 + d - e);
                g.drawLine(x0 + half - d + e, y0 + half - e, x0 + half - e, y0 + half - d + e);
            }
        }
    }

    private static void drawCircleFilled(Graphics g, int x0, int y0, int maxSize, int size, int half1, int top, int bottom, int left, int right) {
        if (size <= 25) {
            bottom = top + size - 1;
            int d = (size + 4) / 5;
            if (size == 6) {
                --d;
            } else if (size == 9) {
                ++d;
            } else if (size >= 16) {
                --d;
            }
            int e = size % 2;
            boolean aa = false;
            if (g instanceof Graphics2D) {
                aa = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (size <= 5 || size <= 6 && !aa) {
                int s = size - 2;
                g.fillRect(x0 - s / 3, y0 - s / 3, s, s);
            } else {
                g.fillRect(x0 - d + 1, top + 1, 2 * d - e, size - 2);
                int l = size / 2 - d;
                if (size % 2 == 0) {
                    --l;
                }
                for (int i = 0; i < l; ++i) {
                    int f = i + 2;
                    if (size >= 13 && 0 < i && i < l - 1) {
                        --f;
                    }
                    if (size == 6) {
                        ++f;
                    } else if (size == 10 && !aa) {
                        --f;
                    } else if (size == 19 || size == 20 || size == 23) {
                        --f;
                    }
                    g.drawLine(x0 - d - i, top + f, x0 - d - i, bottom - f);
                    g.drawLine(x0 + d - e + 1 + i, top + f, x0 + d - e + 1 + i, bottom - f);
                }
            }
        } else {
            g.fillOval(x0 - half1, y0 - half1, size, size);
        }
    }

    private static void drawPlus(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        if (mode == 0 || size <= 4) {
            g.drawLine(left, y0, right, y0);
            g.drawLine(x0, top, x0, y0 - 1);
            g.drawLine(x0, y0 + 1, x0, bottom);
        } else if (mode == 1) {
            int w = 2;
            int w2 = (size - w) / 2;
            g.fillRect(x0 - w2, y0, w + 2 * w2, w);
            g.fillRect(x0, y0 - w2, w, w2);
            g.fillRect(x0, y0 + w, w, w2);
        }
    }

    private static void drawHash(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        if (size <= 4) {
            Markers.drawPlus(g, x0, y0, size, half1, top, bottom, left, right, mode);
            return;
        }
        int quarter = (size + size % 2) / 4;
        g.drawLine(left, top + quarter, right, top + quarter);
        g.drawLine(left, bottom - quarter, right, bottom - quarter);
        g.drawLine(left + quarter, top, left + quarter, bottom);
        g.drawLine(right - quarter, top, right - quarter, bottom);
    }

    private static void drawSmash(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        if (size <= 4) {
            g.drawLine(left, top, right, bottom);
            g.drawLine(left, bottom, right, top);
        } else {
            int quarter = (size + 2) / 4;
            if (size == 6) {
                quarter = 1;
            }
            g.drawLine(left + quarter, top, right, bottom - quarter);
            g.drawLine(left, top + quarter, right - quarter, bottom);
            g.drawLine(left, bottom - quarter, right - quarter, top);
            g.drawLine(left + quarter, bottom, right, top + quarter);
        }
    }

    private static void drawX(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        if (mode == 0 || size <= 4) {
            g.drawLine(left, top, right, bottom);
            g.drawLine(right, top, x0 + 1, y0 - 1);
            g.drawLine(x0 - 1, y0 + 1, left, bottom);
        } else if (mode == 1) {
            g.drawLine(left, top, right, bottom);
            g.drawLine(left + 1, top, right, bottom - 1);
            g.drawLine(left, top + 1, right - 1, bottom);
            g.drawLine(right, top, x0 + 1, y0 - 1);
            g.drawLine(right - 1, top, x0 + 1, y0 - 2);
            g.drawLine(right, top + 1, x0 + 2, y0 - 1);
            g.drawLine(x0 - 1, y0 + 1, left, bottom);
            g.drawLine(x0 - 1, y0 + 2, left + 1, bottom);
            g.drawLine(x0 - 2, y0 + 1, left, bottom - 1);
        }
    }

    private static void drawSquare(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        if (mode == 2) {
            g.fillRect(left + 1, top + 1, size - 2, size - 2);
        } else {
            g.drawRect(left, top, size - 1, size - 1);
            if (mode == 1 && size > 2) {
                g.drawRect(left + 1, top + 1, size - 3, size - 3);
            }
        }
    }

    private static void drawAsterisk(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode, int dir) {
        int d1 = 1;
        if (size <= 12) {
            d1 = (size - 3) / 4 + 1;
        }
        int d2 = half1 / 2 - 1;
        if (mode == 0) {
            if (dir == 0) {
                g.drawLine(x0, top, x0, bottom);
                g.drawLine(x0 - 1, y0, x0 - 1, y0);
                g.drawLine(x0 + 1, y0, x0 + 1, y0);
                if (size >= 5) {
                    g.drawLine(x0 - 2, y0 - 1, x0 - 1 - d1, y0 - d1);
                    g.drawLine(x0 - 2, y0 + 1, x0 - 1 - d1, y0 + d1);
                    g.drawLine(x0 + 2, y0 - 1, x0 + 1 + d1, y0 - d1);
                    g.drawLine(x0 + 2, y0 + 1, x0 + 1 + d1, y0 + d1);
                    if (size > 12) {
                        g.drawLine(x0 - 3, y0 - 2, x0 - 2 - 2 * d2, y0 - 1 - d2);
                        g.drawLine(x0 - 3, y0 + 2, x0 - 2 - 2 * d2, y0 + 1 + d2);
                        g.drawLine(x0 + 3, y0 - 2, x0 + 2 + 2 * d2, y0 - 1 - d2);
                        g.drawLine(x0 + 3, y0 + 2, x0 + 2 + 2 * d2, y0 + 1 + d2);
                    }
                }
            } else {
                g.drawLine(left, y0, right, y0);
                g.drawLine(x0, y0 - 1, x0, y0 - 1);
                g.drawLine(x0, y0 + 1, x0, y0 + 1);
                if (size >= 5) {
                    g.drawLine(x0 - 1, y0 - 2, x0 - d1, y0 - 1 - d1);
                    g.drawLine(x0 + 1, y0 - 2, x0 + d1, y0 - 1 - d1);
                    g.drawLine(x0 - 1, y0 + 2, x0 - d1, y0 + 1 + d1);
                    g.drawLine(x0 + 1, y0 + 2, x0 + d1, y0 + 1 + d1);
                    if (size > 12) {
                        g.drawLine(x0 - 2, y0 - 3, x0 - 1 - d2, y0 - 2 - 2 * d2);
                        g.drawLine(x0 + 2, y0 - 3, x0 + 1 + d2, y0 - 2 - 2 * d2);
                        g.drawLine(x0 - 2, y0 + 3, x0 - 1 - d2, y0 + 2 + 2 * d2);
                        g.drawLine(x0 + 2, y0 + 3, x0 + 1 + d2, y0 + 2 + 2 * d2);
                    }
                }
            }
        } else if (mode == 1) {
            int f;
            int half = size / 2;
            int w = size < 6 ? 1 : 2;
            int w2 = (size - w) / 2;
            if (size == 10) {
                --w2;
            }
            int e = size % 4 >= 2 ? 2 : 1;
            int n = f = size < 7 || size == 8 || size == 12 ? 0 : 1;
            if (dir == 0) {
                boolean dy;
                int dx = size == 8 ? -1 : 0;
                boolean bl = dy = size > 10;
                if (size == 5 || size == 6) {
                    g.fillRect(x0 - 1, y0, size - 2, size - 4);
                    g.drawLine(x0, top, x0 + w - 1, top);
                    g.drawLine(x0, top + size - 1, x0 + w - 1, top + size - 1);
                    g.drawLine(left, top + 1, left + size - 1, top + 1);
                    g.drawLine(left, top + size - 2, left + size - 1, top + size - 2);
                    return;
                }
                if (size <= 12) {
                    g.fillRect(x0, y0 - w2 - f, w, 2 * w2 + 2 * f + 1);
                    g.drawLine(x0 - 1, y0 - 1, x0 - d1, y0 - d1);
                    g.drawLine(x0 - 1, y0 + 1, x0 - d1, y0 + d1);
                    g.drawLine(x0 + 2, y0 - 1, x0 + 1 + d1, y0 - d1);
                    g.drawLine(x0 + 2, y0 + 1, x0 + 1 + d1, y0 + d1);
                    for (int i = 0; i < 2; ++i) {
                        g.drawLine(x0 - 1, y0 + i, x0 - 1 - d1, y0 + i - d1);
                        g.drawLine(x0 - 1, y0 - i, x0 - 1 - d1, y0 - i + d1);
                        g.drawLine(x0 + 2, y0 + i, x0 + 2 + d1, y0 + i - d1);
                        g.drawLine(x0 + 2, y0 - i, x0 + 2 + d1, y0 - i + d1);
                    }
                } else {
                    g.fillRect(x0, y0 - w2 - f, w, w2 + f);
                    g.fillRect(x0, y0 + 1, w, w2 + f);
                    int h = 0;
                    if (half1 % 2 == 0) {
                        h = 1;
                    }
                    g.drawLine(x0 + h, y0, x0 - half1, y0 - half1 / 2);
                    g.drawLine(x0 + h, y0, x0 - half1, y0 + half1 / 2);
                    g.drawLine(x0 + 1 - h, y0, x0 + 1 + half1, y0 - half1 / 2);
                    g.drawLine(x0 + 1 - h, y0, x0 + 1 + half1, y0 + half1 / 2);
                    int i = 1;
                    if (h == 1) {
                        i = -1;
                    }
                    g.drawLine(x0 + h, y0 - i, x0 - half1, y0 - i - half1 / 2);
                    g.drawLine(x0 + h, y0 + i, x0 - half1, y0 + i + half1 / 2);
                    g.drawLine(x0 + 1 - h, y0 - i, x0 + 1 + half1, y0 - i - half1 / 2);
                    g.drawLine(x0 + 1 - h, y0 + i, x0 + 1 + half1, y0 + i + half1 / 2);
                }
            } else {
                int dy;
                boolean dx = size > 10;
                int n2 = dy = size == 8 ? -1 : 0;
                if (size == 5 || size == 6) {
                    g.fillRect(x0, y0 - 1, size - 4, size - 2);
                    g.drawLine(left, y0, left, y0 + w - 1);
                    g.drawLine(left + size - 1, y0, left + size - 1, y0 + w - 1);
                    g.drawLine(left + 1, top, left + 1, top + size - 1);
                    g.drawLine(left + size - 2, top, left + size - 2, top + size - 1);
                    return;
                }
                if (size <= 12) {
                    g.fillRect(x0 - w2 - f, y0, 2 * w2 + 2 * f + 1, w);
                    g.drawLine(x0 - 1, y0 - 1, x0 - d1, y0 - d1);
                    g.drawLine(x0 + 1, y0 - 1, x0 + d1, y0 - d1);
                    g.drawLine(x0 - 1, y0 + 1 + 1, x0 - d1, y0 + 1 + d1);
                    g.drawLine(x0 + 1, y0 + 1 + 1, x0 + d1, y0 + 1 + d1);
                    for (int i = 0; i < 2; ++i) {
                        g.drawLine(x0 + i, y0 - 1, x0 + i - d1, y0 - 1 - d1);
                        g.drawLine(x0 - i, y0 - 1, x0 - i + d1, y0 - 1 - d1);
                        g.drawLine(x0 + i, y0 + 2, x0 + i - d1, y0 + 2 + d1);
                        g.drawLine(x0 - i, y0 + 2, x0 - i + d1, y0 + 2 + d1);
                    }
                } else {
                    g.fillRect(x0 - w2 - f, y0, w2 + f, w);
                    g.fillRect(x0 + 1, y0, w2 + f, w);
                    int h = 0;
                    if (half1 % 2 == 0) {
                        h = 1;
                    }
                    g.drawLine(x0, y0 + h, x0 - half1 / 2, y0 - half1);
                    g.drawLine(x0, y0 + h, x0 + half1 / 2, y0 - half1);
                    g.drawLine(x0, y0 + 1 - h, x0 - half1 / 2, y0 + 1 + half1);
                    g.drawLine(x0, y0 + 1 - h, x0 + half1 / 2, y0 + 1 + half1);
                    int i = 1;
                    if (h == 1) {
                        i = -1;
                    }
                    g.drawLine(x0 - i, y0 + h, x0 - i - half1 / 2, y0 - half1);
                    g.drawLine(x0 + i, y0 + h, x0 + i + half1 / 2, y0 - half1);
                    g.drawLine(x0 - i, y0 + 1 - h, x0 - i - half1 / 2, y0 + 1 + half1);
                    g.drawLine(x0 + i, y0 + 1 - h, x0 + i + half1 / 2, y0 + 1 + half1);
                }
            }
        }
    }

    private static void drawTriangle(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode, int dir) {
        if (mode == 2) {
            for (int i = 1; i <= half1; ++i) {
                int j = i < half1 ? 2 : 1;
                int k = 2 * i;
                if (dir == 0) {
                    g.fillRect(x0 - i + 1, top + k - 1, k - 1, j);
                    continue;
                }
                if (dir == 1) {
                    g.fillRect(x0 - i + 1, bottom - k - j + 2, k - 1, j);
                    continue;
                }
                if (dir == 2) {
                    g.fillRect(left + k - 1, y0 - i + 1, j, k - 1);
                    continue;
                }
                g.fillRect(right - k - j + 2, y0 - i + 1, j, k - 1);
            }
        } else {
            int x01 = x0;
            int y01 = top;
            int x02 = x0 - 1;
            int y02 = top + 1;
            int x03 = x0 + 1;
            int y03 = top + 1;
            int x04 = left;
            int y04 = bottom - 1;
            int x05 = right;
            int y05 = bottom;
            int x06 = left;
            int y06 = bottom;
            int x07 = right - 1;
            int y07 = bottom;
            int x08 = x0;
            int y08 = top + 1;
            int x09 = x0;
            int y09 = top + 2;
            int x10 = x0 - 1;
            int y10 = top + 3;
            int x11 = x0 + 1;
            int y11 = top + 3;
            int x12 = left + 2;
            int y12 = bottom - 2;
            int x13 = right - 2;
            int y13 = bottom - 2;
            int x14 = left + 1;
            int y14 = bottom - 1;
            int x15 = right - 1;
            int y15 = bottom - 1;
            if (dir == 1) {
                x01 = x0;
                y01 = bottom;
                x02 = x0 + 1;
                y02 = bottom - 1;
                x03 = x0 - 1;
                y03 = bottom - 1;
                x04 = right;
                y04 = top + 1;
                x05 = left;
                y05 = top;
                x06 = right;
                y06 = top;
                x07 = left + 1;
                y07 = top;
                x08 = x0;
                y08 = bottom - 1;
                x09 = x0;
                y09 = bottom - 2;
                x10 = x0 + 1;
                y10 = bottom - 3;
                x11 = x0 - 1;
                y11 = bottom - 3;
                x12 = right - 2;
                y12 = top + 2;
                x13 = left + 2;
                y13 = top + 2;
                x14 = right - 1;
                y14 = top + 1;
                x15 = left + 1;
                y15 = top + 1;
            } else if (dir == 2) {
                x01 = left;
                y01 = y0;
                x02 = left + 1;
                y02 = y0 + 1;
                x03 = left + 1;
                y03 = y0 - 1;
                x04 = right - 1;
                y04 = bottom;
                x05 = right;
                y05 = top;
                x06 = right;
                y06 = bottom;
                x07 = right;
                y07 = top + 1;
                x08 = left + 1;
                y08 = y0;
                x09 = left + 2;
                y09 = y0;
                x10 = left + 3;
                y10 = y0 + 1;
                x11 = left + 3;
                y11 = y0 - 1;
                x12 = right - 2;
                y12 = bottom - 2;
                x13 = right - 2;
                y13 = top + 2;
                x14 = right - 1;
                y14 = bottom - 1;
                x15 = right - 1;
                y15 = top + 1;
            } else if (dir == 3) {
                x01 = right;
                y01 = y0;
                x02 = right - 1;
                y02 = y0 + 1;
                x03 = right - 1;
                y03 = y0 - 1;
                x04 = left + 1;
                y04 = bottom;
                x05 = left;
                y05 = top;
                x06 = left;
                y06 = bottom;
                x07 = left;
                y07 = top + 1;
                x08 = right - 1;
                y08 = y0;
                x09 = right - 2;
                y09 = y0;
                x10 = right - 3;
                y10 = y0 + 1;
                x11 = right - 3;
                y11 = y0 - 1;
                x12 = left + 2;
                y12 = bottom - 2;
                x13 = left + 2;
                y13 = top + 2;
                x14 = left + 1;
                y14 = bottom - 1;
                x15 = left + 1;
                y15 = top + 1;
            }
            g.drawLine(x01, y01, x04, y04);
            g.drawLine(x03, y03, x05, y05);
            g.drawLine(x06, y06, x07, y07);
            if (mode == 1) {
                g.drawLine(x08, y08, x09, y09);
                if (size > 6) {
                    g.drawLine(x10, y10, x12, y12);
                    g.drawLine(x11, y11, x13, y13);
                }
                g.drawLine(x14, y14, x15, y15);
            }
        }
    }

    private static void drawHexagon(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode, int dir) {
        int f = size > 10 ? 1 : 0;
        int d1 = (half1 - f) / 2;
        int d2 = 2 * d1;
        boolean aa = false;
        if (g instanceof Graphics2D) {
            aa = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (mode == 2) {
            if (size < 7) {
                g.drawLine(x0, y0 - 1, x0, y0 + 1);
                g.drawLine(x0 - 1, y0, x0 - 1, y0);
                g.drawLine(x0 + 1, y0, x0 + 1, y0);
            } else {
                if (dir == 0) {
                    g.drawLine(left + 1, y0, right - 1, y0);
                } else {
                    g.drawLine(x0, top + 1, x0, bottom - 1);
                }
                for (int i = 1; i <= d1; ++i) {
                    int k = 2 * i;
                    int w = 2 * half1 - k - 1;
                    int h = 2;
                    if (i == d1 && (9 <= size && size <= 12 || 15 <= size && (size % 4 == 3 || size % 4 == 0))) {
                        h = 1;
                    }
                    if (dir == 0) {
                        g.fillRect(left + i + 1, y0 - k + 2 - h, w, h);
                        g.fillRect(left + i + 1, y0 + k - 1, w, h);
                        continue;
                    }
                    g.fillRect(x0 - k + 2 - h, top + i + 1, h, w);
                    g.fillRect(x0 + k - 1, top + i + 1, h, w);
                }
            }
        } else if (size < 5) {
            g.drawLine(x0, y0 + 1, x0 - 1, y0);
            g.drawLine(x0, y0 - 1, x0 + 1, y0);
        } else if (size < 7) {
            g.drawLine(x0 + 2, y0, x0 + 1, y0 - 1);
            g.drawLine(x0, y0 - 2, x0 - 2, y0 - 1);
            g.drawLine(x0 - 2, y0, x0 - 1, y0 + 1);
            g.drawLine(x0, y0 + 2, x0 + 1, y0 + 1);
            int d = dir == 0 ? 1 : 2;
            int e = dir == 0 ? 2 : 1;
            g.drawLine(x0 - d, y0 - e, x0 - d, y0 - e);
            g.drawLine(x0 + d, y0 - e, x0 + d, y0 - e);
            g.drawLine(x0 - d, y0 + e, x0 - d, y0 + e);
            g.drawLine(x0 + d, y0 + e, x0 + d, y0 + e);
        } else if (dir == 0) {
            g.drawLine(left, y0, left, y0);
            g.drawLine(left + 1, y0 - 1, left + d1, y0 - d2);
            g.drawLine(left + 1, y0 + 1, left + d1, y0 + d2);
            g.drawLine(right, y0, right, y0);
            g.drawLine(right - 1, y0 - 1, right - d1, y0 - d2);
            g.drawLine(right - 1, y0 + 1, right - d1, y0 + d2);
            g.drawLine(left + d1 + 1, top + f, right - d1 - 1, top + f);
            g.drawLine(left + d1 + 1, bottom - f, right - d1 - 1, bottom - f);
        } else {
            g.drawLine(x0, top, x0, top);
            g.drawLine(x0 - 1, top + 1, x0 - d2, top + d1);
            g.drawLine(x0 + 1, top + 1, x0 + d2, top + d1);
            g.drawLine(x0, bottom, x0, bottom);
            g.drawLine(x0 - 1, bottom - 1, x0 - d2, bottom - d1);
            g.drawLine(x0 + 1, bottom - 1, x0 + d2, bottom - d1);
            g.drawLine(left + f, top + d1 + 1, left + f, bottom - d1 - 1);
            g.drawLine(right - f, top + d1 + 1, right - f, bottom - d1 - 1);
        }
    }

    private static void drawUnion(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int d = (size + 9) / 4;
        if (size <= 6) {
            d = 1;
        } else if (size <= 10) {
            d = 2;
        } else if (size <= 14) {
            d = 3;
        }
        int d2 = d - (size + 5) / 8;
        if (size <= 4) {
            g.drawLine(left, top, left, bottom - 1);
            g.drawLine(right, top, right, bottom - 1);
            g.drawLine(x0, bottom, x0, bottom);
        } else if (size <= 14) {
            g.drawLine(left, top, left, bottom - d - 1);
            g.drawLine(right, top, right, bottom - d - 1);
            if (left + d + 1 <= right - d - 1) {
                g.drawLine(left + d + 1, bottom, right - d - 1, bottom);
            }
            g.drawLine(left, bottom - d, left + d, bottom);
            g.drawLine(right, bottom - d, right - d, bottom);
            if (mode == 1) {
                g.drawLine(left + 1, top, left + 1, bottom - d - 1);
                g.drawLine(right - 1, top, right - 1, bottom - d - 1);
                if (left + d + 1 <= right - d - 1) {
                    g.drawLine(left + d + 1, bottom - 1, right - d - 1, bottom - 1);
                }
                g.drawLine(left + 1, bottom - d, left + 1 + d, bottom);
                g.drawLine(right - 1, bottom - d, right - 1 - d, bottom);
            }
        } else {
            g.drawLine(left, top, left, bottom - d - 1);
            g.drawLine(right, top, right, bottom - d - 1);
            if (left + d + 1 <= right - d - 1) {
                g.drawLine(left + d + 1, bottom, right - d - 1, bottom);
            }
            Markers.drawEighth(g, true, true, left + d, bottom - d, d, 4);
            Markers.drawEighth(g, true, size < 19, left + d, bottom - d, d, 5);
            Markers.drawEighth(g, true, size < 19, right - d, bottom - d, d, 6);
            Markers.drawEighth(g, true, true, right - d, bottom - d, d, 7);
            if (mode == 1) {
                g.drawLine(left + 1, top, left + 1, bottom - d - 1);
                g.drawLine(right - 1, top, right - 1, bottom - d - 1);
                if (left + d + 1 <= right - d - 1) {
                    g.drawLine(left + d + 1, bottom - 1, right - d - 1, bottom - 1);
                }
                g.drawLine(left, bottom - d2, left + d2, bottom);
                g.drawLine(right, bottom - d2, right - d2, bottom);
                Markers.drawEighth(g, true, true, left + d, bottom - d, d - 1, 4);
                Markers.drawEighth(g, true, true, left + d, bottom - d, d - 1, 5);
                Markers.drawEighth(g, true, true, right - d, bottom - d, d - 1, 6);
                Markers.drawEighth(g, true, true, right - d, bottom - d, d - 1, 7);
            }
        }
    }

    private static void fillLozenge(Graphics g, int x1, int y1, int x2, int y2, boolean ne, boolean nw, boolean se, boolean sw) {
        int yleft = y1 + (y2 - y1 - (x2 - x1)) / 2;
        int yright = y2 - (y2 - y1 - (x2 - x1)) / 2;
        int x = x1;
        int d = 0;
        for (int y = y1; y <= y2; ++y) {
            if (y <= yleft) {
                x = x1 - (y - y1);
                d = 2 * (y - y1);
            } else if (yleft < y && y < yright) {
                x = x2 - (y2 - y);
                d = y2 - y1 - Math.abs(x2 - x1);
            } else {
                x = x2 - (y2 - y);
                d = 2 * (y2 - y);
            }
            if (ne && y < yright || se && y > yright) {
                ++d;
            }
            if (nw && y < yleft || sw && y > yleft) {
                --x;
                ++d;
            }
            g.drawLine(x, y, x + d, y);
        }
    }

    private static void drawDiamond(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        if (mode == 2) {
            Markers.fillLozenge(g, x0, y0 - half1 + 1, x0, y0 + half1 - 1, false, false, false, false);
        } else if (size <= 4) {
            g.drawLine(left, y0, x0, top);
            g.drawLine(right, y0, x0, bottom);
        } else {
            int n = mode == 1 ? (size <= 6 ? 2 : 3) : 1;
            for (int i = 0; i < n; ++i) {
                g.drawLine(left + i, y0, x0 - 1, top + 1 + i);
                g.drawLine(left + i + 1, y0 + 1, x0, bottom - i);
                g.drawLine(right - i - 1, y0 - 1, x0, top + i);
                g.drawLine(right - i, y0, x0 + 1, bottom - 1 - i);
            }
        }
    }

    private static void drawIBeam(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int d = size / 3;
        if (mode == 0) {
            g.drawLine(x0, top + 1, x0, bottom - 1);
            g.drawLine(x0 - d, top, x0 + d, top);
            g.drawLine(x0 - d, bottom, x0 + d, bottom);
        } else if (mode == 1) {
            g.fillRect(x0, top + 2, 2, bottom - top - 3);
            g.fillRect(x0 - d, top, 2 * d + 2, 2);
            g.fillRect(x0 - d, bottom - 1, 2 * d + 2, 2);
        }
    }

    private static void drawHex(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int d1 = (size + 1) / 4;
        int d2 = 2 * d1;
        int d0 = d1 - 1;
        g.drawRect(x0 - d1, y0 - d1, d2, d2);
        if (left <= x0 - d1 - 1) {
            g.drawLine(left, top, x0 - d1 - 1, y0 - d1 - 1);
            g.drawLine(right, top, x0 + d1 + 1, y0 - d1 - 1);
            g.drawLine(left, bottom, x0 - d1 - 1, y0 + d1 + 1);
            g.drawLine(right, bottom, x0 + d1 + 1, y0 + d1 + 1);
        }
        if (mode == 1) {
            g.drawRect(x0 - d0, y0 - d0, d2 - 2, d2 - 2);
            if (left <= x0 - d1 - 1) {
                g.drawLine(left, top + 1, x0 - d1 - 1, y0 - d0 - 1);
                g.drawLine(left + 1, top, x0 - d0 - 1, y0 - d1 - 1);
                g.drawLine(right, top + 1, x0 + d1 + 1, y0 - d0 - 1);
                g.drawLine(right - 1, top, x0 + d0 + 1, y0 - d1 - 1);
                g.drawLine(left, bottom - 1, x0 - d1 - 1, y0 + d0 + 1);
                g.drawLine(left + 1, bottom, x0 - d0 - 1, y0 + d1 + 1);
                g.drawLine(right, bottom - 1, x0 + d1 + 1, y0 + d0 + 1);
                g.drawLine(right - 1, bottom, x0 + d0 + 1, y0 + d1 + 1);
            }
        }
    }

    private static void drawHome(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode, int dir) {
        boolean sides;
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        int top0 = top;
        int top1 = top + 1;
        int top2 = top + 2;
        int bottom0 = bottom;
        int bottom1 = bottom - 1;
        int bottom2 = bottom - 2;
        int left0 = left;
        int left1 = left + 1;
        int left2 = left + 2;
        int right0 = right;
        int right1 = right - 1;
        int right2 = right - 2;
        boolean bl = sides = y1 <= bottom1;
        if (dir == 1) {
            x1 = x0 - 1;
            y1 = y0 - 1;
            top0 = bottom;
            top1 = bottom - 1;
            top2 = bottom - 2;
            bottom0 = top;
            bottom1 = top + 1;
            bottom2 = top + 2;
            left0 = right;
            left1 = right - 1;
            left2 = right - 2;
            right0 = left;
            right1 = left + 1;
            right2 = left + 2;
            boolean bl2 = sides = y1 >= bottom1;
        }
        if (mode == 2) {
            if (dir == 0) {
                g.fillRect(left + 1, y0 + 1, 2 * half1 - 1, half1 - 1);
                for (int i = 1; i <= half1; ++i) {
                    g.fillRect(x0 - i + 1, top + i, 2 * i - 1, 1);
                }
            } else if (dir == 1) {
                g.fillRect(left + 1, top + 1, 2 * half1 - 1, half1 - 1);
                for (int i = 1; i <= half1; ++i) {
                    g.fillRect(x0 - i + 1, bottom - i, 2 * i - 1, 1);
                }
            }
        } else {
            g.drawLine(x0, top0, left0, y0);
            g.drawLine(x1, top1, right0, y0);
            if (sides) {
                g.drawLine(left0, y1, left0, bottom1);
                g.drawLine(right0, y1, right0, bottom1);
            }
            g.drawLine(left0, bottom0, right0, bottom0);
            if (mode == 1) {
                g.drawLine(x0, top1, left1, y0);
                g.drawLine(x0, top2, left2, y0);
                g.drawLine(x0, top1, right1, y0);
                g.drawLine(x0, top2, right2, y0);
                if (sides) {
                    g.drawLine(left1, y1, left1, bottom1);
                    g.drawLine(right1, y1, right1, bottom1);
                }
                g.drawLine(left2, bottom1, right2, bottom1);
            }
        }
    }

    private static void drawHeart(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        if (mode == 2) {
            if (size < 5) {
                g.fillRect(x0, y0, 1, 1);
            } else if (size < 7) {
                g.drawLine(x0 - 1, y0 - 1, x0 - 1, y0);
                g.drawLine(x0 + 1, y0 - 1, x0 + 1, y0);
                g.drawLine(x0, y0, x0, y0 + 1);
            } else if (size < 9) {
                g.fillRect(x0 - 2, y0 - 2, 5, 3);
                g.drawLine(x0 - 1, y0 + 1, x0 + 1, y0 + 1);
                g.drawLine(x0, y0 + 2, x0, y0 + 2);
            } else if (size < 11) {
                g.fillRect(x0 - 3, y0 - 3, 7, 3);
                g.fillRect(x0 - 2, y0, 5, 2);
                g.drawLine(x0 - 1, y0 + 2, x0 + 1, y0 + 2);
                g.drawLine(x0, y0 + 3, x0, y0 + 3);
            } else {
                int i;
                int d1 = (size + 1) / 4;
                int off = 0;
                if (size % 4 == 0 || size % 4 == 3) {
                    off = 1;
                }
                int j = (size + 1) / 10;
                int k = (size - 0) / 5;
                int m = (size - 3) / 2;
                int n = (size - 1) / 3;
                if (size == 25 || size == 22 || size == 20 || size == 16) {
                    --n;
                }
                int y = y0 + off - d1;
                g.fillRect(x0 - m + 1, top + 1, m - 2, y - top - 3);
                g.fillRect(x0 + 1 + 1, top + 1, m - 2, y - top - 3);
                int h = 2;
                if (size == 20 || size == 16 || size == 15 || size == 12 || size == 11) {
                    h = 1;
                }
                g.fillRect(x0 - m, y - 2, m, h);
                g.fillRect(x0 + 1, y - 2, m, h);
                g.fillRect(x0 - m, y - 2 + h, 2 * m + 1, 2);
                for (i = 1; i <= k; ++i) {
                    g.fillRect(x0 - half1 + i, y0 - k + 2 * i - 1, 2 * half1 - 2 * i + 1, 2);
                }
                for (i = 1; i < n; ++i) {
                    g.drawLine(x0 - i + 1, y0 + half1 - i, x0 + i - 1, y0 + half1 - i);
                }
            }
            return;
        }
        if (size < 5) {
            g.drawLine(x0 - 1, y0 - 1, x0 + 1, y0 - 1);
            g.drawLine(x0 - 1, y0, x0, y0 + 1);
            g.drawLine(x0 + 1, y0, x0 + 1, y0);
        } else if (size < 7) {
            if (mode == 0) {
                g.drawLine(x0 - 2, y0 - 1, x0 - 1, y0 - 2);
                g.drawLine(x0 + 2, y0 - 1, x0 + 1, y0 - 2);
                g.drawLine(x0, y0 - 1, x0, y0 - 1);
                g.drawLine(x0, y0 + 2, x0 - 2, y0);
                g.drawLine(x0 + 1, y0 + 1, x0 + 2, y0);
            } else if (mode == 1) {
                g.drawLine(x0 - 2, y0 - 2, x0 - 1, y0 - 2);
                g.drawLine(x0 + 2, y0 - 2, x0 + 1, y0 - 2);
                g.drawLine(x0 - 2, y0 - 1, x0 + 2, y0 - 1);
                g.drawLine(x0 - 2, y0, x0 + 2, y0);
                g.drawLine(x0 - 1, y0 + 1, x0 + 1, y0 + 1);
                g.drawLine(x0, y0 + 2, x0, y0 + 2);
            }
        } else if (size < 9) {
            g.drawLine(x0, y0 + 3, x0 - 3, y0);
            g.drawLine(x0 + 1, y0 + 2, x0 + 3, y0);
            g.drawLine(x0 - 3, y0 - 1, x0 - 3, y0 - 1);
            g.drawLine(x0 + 3, y0 - 1, x0 + 3, y0 - 1);
            g.drawLine(x0 - 3, y0 - 2, x0 - 2, y0 - 3);
            g.drawLine(x0 + 3, y0 - 2, x0 + 2, y0 - 3);
            g.drawLine(x0 - 1, y0 - 3, x0 - 1, y0 - 3);
            g.drawLine(x0, y0 - 2, x0 + 1, y0 - 3);
            if (mode == 1) {
                g.drawLine(x0 - 2, y0 - 2, x0 - 1, y0 - 2);
                g.drawLine(x0 + 2, y0 - 2, x0 + 1, y0 - 2);
                g.drawLine(x0, y0 + 2, x0 - 2, y0);
                g.drawLine(x0 + 1, y0 + 1, x0 + 2, y0);
                g.drawLine(x0, y0 + 1, x0 - 2, y0 - 1);
                g.drawLine(x0 + 1, y0, x0 + 2, y0 - 1);
            }
        } else {
            int d1 = (size + 1) / 4;
            int d2 = 2 * d1;
            int off = 0;
            if (size % 4 == 0 || size % 4 == 3) {
                off = 1;
            }
            int y = y0 + off;
            boolean first = size % 4 == 1 || size % 4 == 2;
            boolean last = size <= 10 || 18 < size;
            Markers.drawEighth(g, false, true, x0 - d1, y - d1, d1, 0);
            Markers.drawEighth(g, first, last, x0 - d1, y - d1, d1, 1);
            Markers.drawEighth(g, false, true, left + d1, y - d1, d1, 2);
            Markers.drawEighth(g, false, last, left + d1, y - d1, d1, 3);
            Markers.drawEighth(g, false, true, right - d1, y - d1, d1, 0);
            Markers.drawEighth(g, first, last, right - d1, y - d1, d1, 1);
            Markers.drawEighth(g, false, true, x0 + d1, y - d1, d1, 2);
            Markers.drawEighth(g, false, last, x0 + d1, y - d1, d1, 3);
            if (mode == 1) {
                Markers.drawEighth(g, false, true, x0 - d1, y - d1, d1 - 1, 0);
                Markers.drawEighth(g, first, true, x0 - d1, y - d1, d1 - 1, 1);
                Markers.drawEighth(g, false, true, left + d1, y - d1, d1 - 1, 2);
                Markers.drawEighth(g, false, true, left + d1, y - d1, d1 - 1, 3);
                Markers.drawEighth(g, false, true, right - d1, y - d1, d1 - 1, 0);
                Markers.drawEighth(g, first, true, right - d1, y - d1, d1 - 1, 1);
                Markers.drawEighth(g, false, true, x0 + d1, y - d1, d1 - 1, 2);
                Markers.drawEighth(g, false, true, x0 + d1, y - d1, d1 - 1, 3);
                if (size > 12) {
                    if (size > 20) {
                        ++d1;
                    }
                    g.drawLine(left + 1, y - d1 - 2, left + 2, y - d1 - 3);
                    g.drawLine(right - 1, y - d1 - 2, right - 2, y - d1 - 3);
                    g.drawLine(x0 - 1, y - d1 - 2, x0 - 2, y - d1 - 3);
                    g.drawLine(x0 + 1, y - d1 - 2, x0 + 2, y - d1 - 3);
                }
            }
            y = y0 - off;
            int d3 = (size - 1) / 8 + off;
            g.drawLine(x0, y + d2, x0 - d2 + d3 + 1, y + d3 + 1);
            g.drawLine(x0 + 1, y + d2 - 1, x0 + d2 - d3 - 1, y + d3 + 1);
            if (mode == 1) {
                g.drawLine(x0, y + d2 - 1, x0 - d2 + d3, y + d3 - 1);
                g.drawLine(x0 + 1, y + d2 - 2, x0 + d2 - d3, y + d3 - 1);
                g.drawLine(x0, y + d2 - 2, x0 - d2 + d3, y + d3 - 2);
                g.drawLine(x0 + 1, y + d2 - 3, x0 + d2 - d3, y + d3 - 2);
            }
            int d4 = 2 * (half1 - d2 + d3) + 1;
            if (size % 4 == 0 || size % 4 == 3) {
                --d1;
            }
            g.drawLine(x0 - d2 + d3, y + d3, left, y + d3 - d4);
            g.drawLine(x0 + d2 - d3, y + d3, right, y + d3 - d4);
            if (y + d3 - d4 - 1 >= y0 - d1) {
                g.drawLine(left, y + d3 - d4 - 1, left, y0 - d1);
                g.drawLine(right, y + d3 - d4 - 1, right, y0 - d1);
            }
            if (mode == 1) {
                g.drawLine(x0 - d2 + d3 + 1, y + d3, left + 1, y + d3 - d4);
                g.drawLine(x0 + d2 - d3 - 1, y + d3, right - 1, y + d3 - d4);
                if (y + d3 - d4 - 1 >= y0 - d1) {
                    g.drawLine(left + 1, y + d3 - d4 - 1, left + 1, y0 - d1);
                    g.drawLine(right - 1, y + d3 - d4 - 1, right - 1, y0 - d1);
                }
            }
        }
    }

    private static void drawClub(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int d1;
        if (size <= 4) {
            Markers.drawPlus(g, x0, y0, size, half1, top, bottom, left, right, mode);
            return;
        }
        int d2 = d1 = half1 / 5;
        int d3 = d1;
        while (half1 - d1 - 2 * d2 - d3 > 0) {
            if (half1 - d1 - 2 * d2 - d3 > 0) {
                ++d3;
            }
            if (half1 - d1 - 2 * d2 - d3 > 1) {
                ++d2;
            }
            if (half1 - d1 - 2 * d2 - d3 <= 0) continue;
            ++d1;
        }
        int d4 = (size + 7) / 16;
        if (mode == 2) {
            if (size < 7) {
                g.drawLine(x0, top + 1, x0, y0 - 1);
                g.drawLine(left + 1, y0, right - 1, y0);
            } else if (size < 9) {
                g.drawLine(x0, top + 1, x0, y0 - 1);
                g.drawLine(left + 1, y0 + 1, right - 1, y0 + 1);
            } else {
                g.fillRect(x0 - d1 + 1, top + 1, 2 * d1 - 1, d1 + d3 + 2 * d2 - 1);
                g.fillRect(left + d2 + 1, y0 - d4 + 1, half1 - d1 - 2 * d2, d1 + d4 + 2 * d2 - 1);
                g.fillRect(x0 + d1 + d2, y0 - d4 + 1, half1 - d1 - 2 * d2, d1 + d4 + 2 * d2 - 1);
                for (int i = 0; i < d2; ++i) {
                    g.drawLine(x0 - d1 - i, top + 1 + i, x0 - d1 - i, top + d1 + d3 + 2 * d2 - 1 - i);
                    g.drawLine(x0 + d1 + i, top + 1 + i, x0 + d1 + i, top + d1 + d3 + 2 * d2 - 1 - i);
                    g.drawLine(left + d2 - i, y0 - d4 + 1 + i, left + d2 - i, y0 + d1 + 2 * d2 - 1 - i);
                    g.drawLine(left + i + half1 - d1 - d2 + 1, y0 - d4 + i, left + i + half1 - d1 - d2 + 1, y0 + d1 + 2 * d2 - 2 - i);
                    g.drawLine(x0 + d1 + d2 - 1 - i, y0 - d4 + i, x0 + d1 + d2 - 1 - i, y0 + d1 + 2 * d2 - 2 - i);
                    g.drawLine(x0 + half1 - d2 + i, y0 - d4 + 1 + i, x0 + half1 - d2 + i, y0 + d1 + 2 * d2 - 1 - i);
                }
                if (size == 24 || size == 23) {
                    g.drawLine(x0 - d1, y0, x0 - d1, y0);
                    g.drawLine(x0 + d1, y0, x0 + d1, y0);
                }
                g.fillRect(x0 - d1 + 1, y0, 2 * d1 - 1, d2 + d4 + 1);
                g.fillRect(x0 - d4 + 1, y0 + d2 + d4 + 1, 2 * d4 - 1, bottom - y0 - d2 - d4 - 1);
            }
        } else if (mode == 0) {
            if (size < 5) {
                g.drawLine(x0, y0 - 1, x0, y0 + 1);
                g.drawLine(x0 - 1, y0, x0 + 1, y0);
            } else if (size < 7) {
                g.drawLine(x0, y0 - 2, x0 + 2, y0);
                g.drawLine(x0 - 1, y0 - 1, x0 + 1, y0 + 1);
                g.drawLine(x0 - 2, y0, x0, y0 + 2);
                g.drawLine(x0 - 1, y0 + 1, x0 + 1, y0 + 1);
            } else {
                if (x0 - d1 + 1 <= x0 + d1 - 1) {
                    g.drawLine(x0 - d1 + 1, top, x0 + d1 - 1, top);
                }
                g.drawLine(x0 - d1, top, x0 - d1 - d2, top + d2);
                g.drawLine(x0 + d1, top, x0 + d1 + d2, top + d2);
                if (top + d2 + 1 <= y0 - d4 - d2 - 1) {
                    g.drawLine(x0 - d1 - d2, top + d2 + 1, x0 - d1 - d2, y0 - d4 - d2 - 1);
                    g.drawLine(x0 + d1 + d2, top + d2 + 1, x0 + d1 + d2, y0 - d4 - d2 - 1);
                }
                g.drawLine(x0 - d1 - d2, y0 - d4 - d2, x0 - d1, y0 - d4);
                g.drawLine(x0 + d1 + d2, y0 - d4 - d2, x0 + d1, y0 - d4);
                if (x0 - d1 - 1 >= left + d2 + 1) {
                    g.drawLine(x0 - d1 - 1, y0 - d4, left + d2 + 1, y0 - d4);
                    g.drawLine(x0 + d1 + 1, y0 - d4, right - d2 - 1, y0 - d4);
                }
                g.drawLine(left + d2, y0 - d4, left, y0 - d4 + d2);
                g.drawLine(right - d2, y0 - d4, right, y0 - d4 + d2);
                if (y0 - d4 + d2 + 1 <= y0 + d1 + d2 - 1) {
                    g.drawLine(left, y0 - d4 + d2 + 1, left, y0 + d1 + d2 - 1);
                    g.drawLine(right, y0 - d4 + d2 + 1, right, y0 + d1 + d2 - 1);
                }
                g.drawLine(left, y0 + d1 + d2, left + d2, y0 + d1 + 2 * d2);
                g.drawLine(right, y0 + d1 + d2, right - d2, y0 + d1 + 2 * d2);
                if (left + d2 + 1 <= x0 - d1 - d2 - 1) {
                    g.drawLine(left + d2 + 1, y0 + d1 + 2 * d2, x0 - d1 - d2 - 1, y0 + d1 + 2 * d2);
                    g.drawLine(right - d2 - 1, y0 + d1 + 2 * d2, x0 + d1 + d2 + 1, y0 + d1 + 2 * d2);
                }
                g.drawLine(x0 - d1 - d2, y0 + d1 + 2 * d2, x0 - d4, y0 + d2 + d4);
                g.drawLine(x0 + d1 + d2, y0 + d1 + 2 * d2, x0 + d4, y0 + d2 + d4);
                g.drawLine(x0 - d4, y0 + d2 + d4 + 1, x0 - d4, bottom - 1);
                g.drawLine(x0 + d4, y0 + d2 + d4 + 1, x0 + d4, bottom - 1);
                g.drawLine(x0 - d4 - (size > 10 ? 1 : 0), bottom, x0 + d4 + (size > 10 ? 1 : 0), bottom);
            }
        }
    }

    private static void drawSpade(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int d1;
        if (size <= 4) {
            Markers.drawPlus(g, x0, y0, size, half1, top, bottom, left, right, mode);
            return;
        }
        int d2 = d1 = half1 / 5;
        int d3 = d1;
        int d4 = d1;
        int d5 = d1;
        while (half1 - d1 - d2 - d3 - d4 - d5 > 0) {
            if (half1 - d1 - d2 - d3 - d4 - d5 > 0) {
                ++d4;
            }
            if (half1 - d1 - d2 - d3 - d4 - d5 > 0) {
                ++d5;
            }
            if (half1 - d1 - d2 - d3 - d4 - d5 > 0) {
                ++d3;
            }
            if (half1 - d1 - d2 - d3 - d4 - d5 <= 0) continue;
            ++d1;
        }
        int y = bottom - 2 * d3 - d2;
        if (size < 11) {
            --y;
            if (size < 9) {
                ++d1;
                if (size > 4) {
                    --d5;
                }
            }
        }
        if (mode == 2) {
            for (int i = 1; i <= half1; ++i) {
                g.drawLine(x0 - i + 1, top + i, x0 + i - 1, top + i);
            }
            g.fillRect(left + 1, y0 + 1, right - left - 1, y - y0 - 1);
            if (size > 8) {
                g.drawLine(x0 - d1, y, x0 + d1, y);
                int d = size <= 16 ? 0 : 1;
                g.drawLine(left + d5 - d, y, left + d4 + d5 + d, y);
                g.drawLine(right - d5 + d, y, right - d4 - d5 - d, y);
                if (size > 16) {
                    g.drawLine(left + d5, y + 1, left + d4 + d5, y + 1);
                    g.drawLine(right - d5, y + 1, right - d4 - d5, y + 1);
                }
            }
            g.fillRect(x0 - d1 + 1, y + 1, 2 * d1 - 1, bottom - y - 2);
            g.drawLine(x0 - d3 - d1 + 2, bottom - 1, x0 + d3 + d1 - 2, bottom - 1);
        } else if (mode == 0) {
            g.drawLine(x0, top, left, y0);
            g.drawLine(x0 + 1, top + 1, right, y0);
            if (y0 + 1 <= y + d3 - d5 - 1) {
                g.drawLine(left, y0 + 1, left, y + d3 - d5 - 1);
                g.drawLine(right, y0 + 1, right, y + d3 - d5 - 1);
            }
            g.drawLine(left, y + d3 - d5, left + d5, y + d3);
            g.drawLine(right, y + d3 - d5, right - d5, y + d3);
            if (1 <= d4 - 1) {
                g.drawLine(left + d5 + 1, y + d3, left + d5 + d4 - 1, y + d3);
                g.drawLine(right - d5 - 1, y + d3, right - d5 - d4 + 1, y + d3);
            }
            g.drawLine(x0 - d1 - d2 - d3, y + d3, x0 - d1 - d2, y);
            g.drawLine(x0 + d1 + d2 + d3, y + d3, x0 + d1 + d2, y);
            if (-d2 + 1 <= -1) {
                g.drawLine(x0 - d1 - d2 + 1, y, x0 - d1 - 1, y);
                g.drawLine(x0 + d1 + d2 - 1, y, x0 + d1 + 1, y);
            }
            if (y + 1 <= bottom - d3 - 1) {
                g.drawLine(x0 - d1, y + 1, x0 - d1, bottom - d3 - 1);
                g.drawLine(x0 + d1, y + 1, x0 + d1, bottom - d3 - 1);
            }
            g.drawLine(x0 - d1, bottom - d3, x0 - d1 - d3, bottom);
            g.drawLine(x0 + d1, bottom - d3, x0 + d1 + d3, bottom);
            g.drawLine(x0 - d1 - d3 + 1, bottom, x0 + d1 + d3 - 1, bottom);
        }
    }

    private static void drawTack(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        if (mode == 0) {
            g.drawLine(left, top, right, top);
            g.drawLine(x0, top + 1, x0, bottom);
        } else if (mode == 1) {
            g.drawLine(left + size % 2, top, x0 + size / 2, top);
            g.drawLine(x0, top + (size > 4 ? 2 : 1), x0, bottom);
            if (size > 4) {
                g.drawLine(left + size % 2, top + 1, x0 + size / 2, top + 1);
                g.drawLine(x0 + 1, top + 2, x0 + 1, bottom);
            }
        }
    }

    private static void drawSpiral(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int d1 = size / 8;
        if (size < 8) {
            d1 = 1;
        }
        int d2 = (size + 1) / 10;
        g.drawLine(x0 - d1, y0 - d1, x0 + d1, y0 + d1);
        g.drawLine(x0 - d1, y0 + d1, x0 - 1, y0 + 1);
        g.drawLine(x0 + 1, y0 - 1, x0 + d1, y0 - d1);
        if (mode == 1 && (d1 > 1 || size < 7)) {
            g.drawLine(x0, y0 - 1, x0 - d1 + 1, y0 - d1);
            g.drawLine(x0, y0 + 1, x0 + d1 - 1, y0 + d1);
            g.drawLine(x0 + 1, y0, x0 + d1, y0 - d1 + 1);
            g.drawLine(x0 - 1, y0, x0 - d1, y0 + d1 - 1);
        }
        if (x0 - d1 - 1 >= left + d2 + 1) {
            g.drawLine(x0 - d1 - 1, y0 - d1, left + d2 + 1, y0 - d1);
            g.drawLine(x0 + d1 + 1, y0 + d1, right - d2 - 1, y0 + d1);
            g.drawLine(x0 - d1, y0 + d1 + 1, x0 - d1, bottom - d2 - 1);
            g.drawLine(x0 + d1, y0 - d1 - 1, x0 + d1, top + d2 + 1);
            if (mode == 1) {
                g.drawLine(x0 - d1, y0 - d1 + 1, left + d2 + 1, y0 - d1 + 1);
                g.drawLine(x0 + d1, y0 + d1 - 1, right - d2 - 1, y0 + d1 - 1);
                g.drawLine(x0 - d1 + 1, y0 + d1, x0 - d1 + 1, bottom - d2 - 1);
                g.drawLine(x0 + d1 - 1, y0 - d1, x0 + d1 - 1, top + d2 + 1);
            }
        }
        if (d2 >= 0 && size > 4) {
            g.drawLine(left + d2, y0 - d1, left, y0 - d1 + d2);
            g.drawLine(right - d2, y0 + d1, right, y0 + d1 - d2);
            g.drawLine(x0 - d1, bottom - d2, x0 - d1 + d2, bottom);
            g.drawLine(x0 + d1, top + d2, x0 + d1 - d2, top);
            if (mode == 1) {
                g.drawLine(left + d2, y0 - d1 + 1, left, y0 - d1 + d2 + 1);
                g.drawLine(right - d2, y0 + d1 - 1, right, y0 + d1 - d2 - 1);
                g.drawLine(x0 - d1 + 1, bottom - d2, x0 - d1 + d2 + 1, bottom);
                g.drawLine(x0 + d1 - 1, top + d2, x0 + d1 - d2 - 1, top);
            }
        }
    }

    private static void drawWeave(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int d1 = (size - 1) / 4;
        if (mode == 1 && size < 13) {
            d1 = (size + 1) / 4;
        }
        int d2 = mode == 1 ? 2 : 1;
        g.drawLine(x0 - d1, top, x0 - d1, y0 + d1 - d2);
        g.drawLine(x0 - d1 + d2, y0 - d1, right, y0 - d1);
        g.drawLine(x0 + d1, bottom, x0 + d1, y0 - d1 + d2);
        g.drawLine(x0 + d1 - d2, y0 + d1, left, y0 + d1);
        if (mode == 1) {
            g.drawLine(x0 - d1 + 1, top, x0 - d1 + 1, y0 + d1 - d2);
            g.drawLine(x0 - d1 + d2, y0 - d1 + 1, right, y0 - d1 + 1);
            g.drawLine(x0 + d1 - 1, bottom, x0 + d1 - 1, y0 - d1 + d2);
            g.drawLine(x0 + d1 - d2, y0 + d1 - 1, left, y0 + d1 - 1);
        }
    }

    private static void drawChain(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int d1 = (size + 1) / 4;
        int xleft = x0 - d1;
        int xright = x0 + d1;
        int ytop = y0 - d1;
        int ybottom = y0 + d1;
        g.drawLine(xleft + 1, y0, xright - 1, y0);
        if (size > 4) {
            g.drawLine(xleft - 1, ytop, left, ytop);
            g.drawLine(xleft - 1, ybottom, left, ybottom);
            g.drawLine(xright + 1, ytop, right, ytop);
            g.drawLine(xright + 1, ybottom, right, ybottom);
        }
        g.drawLine(xleft, ytop, xleft, ybottom);
        g.drawLine(xright, ytop, xright, ybottom);
        if (mode == 1) {
            g.drawLine(xleft + 1, y0 + 1, xright - 1, y0 + 1);
            g.drawLine(xleft - 1, ytop + 1, left, ytop + 1);
            g.drawLine(xleft, ybottom + 1, left, ybottom + 1);
            g.drawLine(xright + 1, ytop + 1, right, ytop + 1);
            g.drawLine(xright, ybottom + 1, right, ybottom + 1);
            if (size > 6) {
                g.drawLine(xleft + 1, ytop, xleft + 1, y0 - 1);
                g.drawLine(xleft + 1, y0 + 2, xleft + 1, ybottom + 1);
                g.drawLine(xright - 1, ytop, xright - 1, y0 - 1);
                g.drawLine(xright - 1, y0 + 2, xright - 1, ybottom + 1);
            }
        }
    }

    private static void drawArrow(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode, int dir) {
        int d1 = (size + 1) / 3;
        if (mode == 1 && 2 + 2 * d1 > size) {
            --d1;
        }
        int xd = 1;
        int yd = 0;
        int xdleft = -1;
        int ydleft = 1;
        int xdright = 1;
        int ydright = 1;
        int xshaft = x0;
        int yshaft = bottom;
        int xpoint = x0;
        int ypoint = top;
        int xleft = x0 - d1;
        int yleft = top + d1;
        int xright = x0 + d1;
        int yright = top + d1;
        if (dir == 1) {
            xd = -1;
            yd = 0;
            xdleft = 1;
            ydleft = -1;
            xdright = -1;
            ydright = -1;
            xshaft = x0;
            yshaft = top;
            xpoint = x0;
            ypoint = bottom;
            xleft = x0 + d1;
            yleft = bottom - d1;
            xright = x0 - d1;
            yright = bottom - d1;
        } else if (dir == 2) {
            xd = 0;
            yd = 1;
            xdleft = 1;
            ydleft = 1;
            xdright = 1;
            ydright = -1;
            xshaft = right;
            yshaft = y0;
            xpoint = left;
            ypoint = y0;
            xleft = left + d1;
            yleft = y0 + d1;
            xright = left + d1;
            yright = y0 - d1;
            if (mode == 1) {
                --yshaft;
                --ypoint;
                --yleft;
                --yright;
            }
        } else if (dir == 3) {
            xd = 0;
            yd = -1;
            xdleft = -1;
            ydleft = -1;
            xdright = -1;
            ydright = 1;
            xshaft = left;
            yshaft = y0;
            xpoint = right;
            ypoint = y0;
            xleft = right - d1;
            yleft = y0 - d1;
            xright = right - d1;
            yright = y0 + d1;
        }
        if (mode == 0) {
            g.drawLine(xpoint, ypoint, xshaft, yshaft);
            g.drawLine(xpoint + xdleft, ypoint + ydleft, xleft, yleft);
            g.drawLine(xpoint + xdright, ypoint + ydright, xright, yright);
        } else if (mode == 1) {
            g.drawLine(xpoint, ypoint, xshaft, yshaft);
            g.drawLine(xpoint + xd, ypoint + yd, xshaft + xd, yshaft + yd);
            for (int i = 0; i < 3; ++i) {
                if (dir < 2) {
                    g.drawLine(xpoint + xdleft, ypoint + (i + 1) * ydleft, xleft, yleft + i * ydleft);
                    g.drawLine(xpoint + xd + xdright, ypoint + yd + (i + 1) * ydright, xright + xd, yright + yd + i * ydright);
                    continue;
                }
                g.drawLine(xpoint + (i + 1) * xdleft, ypoint + 2 * ydleft, xleft + i * xdleft, yleft + ydleft);
                g.drawLine(xpoint + xd + (i + 1) * xdright, ypoint + yd + 2 * ydright, xright + xd + i * xdright, yright + yd + ydright);
            }
        }
    }

    private static void drawAngle(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode, int dir) {
        if (dir == 0) {
            g.drawLine(left, y0, left, y0);
            g.drawLine(left + 1, y0 - 1, right, top);
            g.drawLine(left + 1, y0 + 1, right, bottom);
        } else {
            g.drawLine(right, y0, right, y0);
            g.drawLine(right - 1, y0 - 1, left, top);
            g.drawLine(right - 1, y0 + 1, left, bottom);
        }
    }

    private static void drawCross(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        if (size <= 4) {
            Markers.drawPlus(g, x0, y0, size, half1, top, bottom, left, right, mode);
            return;
        }
        int d1 = (half1 + 1) / 3;
        if (mode == 2) {
            g.fillRect(x0 - half1 + 1, y0 - d1 + 1, 2 * half1 - 1, 2 * d1 - 1);
            g.fillRect(x0 - d1 + 1, y0 - half1 + 1, 2 * d1 - 1, half1 - d1);
            g.fillRect(x0 - d1 + 1, y0 + d1, 2 * d1 - 1, half1 - d1);
        } else if (mode == 0) {
            g.drawLine(x0 + half1, y0 - d1, x0 + d1 + 1, y0 - d1);
            g.drawLine(x0 + d1, y0 - d1, x0 + d1, y0 - half1 + 1);
            g.drawLine(x0 + d1, y0 - half1, x0 - d1 + 1, y0 - half1);
            g.drawLine(x0 - d1, y0 - half1, x0 - d1, y0 - d1 - 1);
            g.drawLine(x0 - d1, y0 - d1, x0 - half1 + 1, y0 - d1);
            g.drawLine(x0 - half1, y0 - d1, x0 - half1, y0 + d1 - 1);
            g.drawLine(x0 - half1, y0 + d1, x0 - d1 - 1, y0 + d1);
            g.drawLine(x0 - d1, y0 + d1, x0 - d1, y0 + half1 - 1);
            g.drawLine(x0 - d1, y0 + half1, x0 + d1 - 1, y0 + half1);
            g.drawLine(x0 + d1, y0 + half1, x0 + d1, y0 + d1 + 1);
            g.drawLine(x0 + d1, y0 + d1, x0 + half1 - 1, y0 + d1);
            g.drawLine(x0 + half1, y0 + d1, x0 + half1, y0 - d1 + 1);
        }
    }

    private static void drawRectangle(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode, int dir) {
        int d1 = (half1 + 1) / 3;
        int w = 2 * half1 + 1;
        int h = 2 * d1 + 1;
        if (d1 < 1) {
            ++h;
        }
        if (mode == 2) {
            if (dir == 0) {
                g.fillRect(x0 - half1 + 1, y0 - d1 + 1, w - 2, h - 2);
            } else {
                g.fillRect(x0 - d1 + 1, y0 - half1 + 1, h - 2, w - 2);
            }
        }
        if (mode == 0) {
            if (dir == 0) {
                g.drawRect(x0 - half1, y0 - d1, w - 1, h - 1);
            } else {
                g.drawRect(x0 - d1, y0 - half1, h - 1, w - 1);
            }
        }
    }

    private static void drawMaltese(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        if (mode == 0) {
            int d = size / 5;
            g.drawLine(x0, top, x0, bottom);
            g.drawLine(x0 - d, top, x0 + d, top);
            g.drawLine(x0 - d, bottom, x0 + d, bottom);
            g.drawLine(left, y0, right, y0);
            g.drawLine(left, y0 - d, left, y0 + d);
            g.drawLine(right, y0 - d, right, y0 + d);
        }
    }

    private static void drawSaltire(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        if (size <= 4) {
            g.drawLine(x0 - 1, y0 - 1, x0 + 1, y0 + 1);
            g.drawLine(x0 - 1, y0 + 1, x0 - 1, y0 + 1);
            g.drawLine(x0 + 1, y0 - 1, x0 + 1, y0 - 1);
            return;
        }
        int w = (size - 1) / 4;
        int d = (size + 1) / 4;
        int e = w + d;
        if (mode == 2) {
            Markers.fillLozenge(g, x0 - w, y0 - e + 1, x0 + w, y0 + e - 1, false, false, false, false);
            Markers.fillLozenge(g, x0 - d, y0 + 1, x0 - w, y0 + e - 1, true, false, false, false);
            Markers.fillLozenge(g, x0 + w, y0 - e + 1, x0 + d, y0 - 1, false, false, false, true);
        } else {
            g.drawLine(x0 - e, y0 - w, x0 - w - 1, y0 - e + 1);
            g.drawLine(x0 - w, y0 - e, x0 - 1, y0 - d - 1);
            g.drawLine(x0, y0 - d, x0 + w - 1, y0 - e + 1);
            g.drawLine(x0 + w, y0 - e, x0 + e - 1, y0 - w - 1);
            g.drawLine(x0 + e, y0 - w, x0 + d + 1, y0 - 1);
            g.drawLine(x0 + d, y0, x0 + e - 1, y0 + w - 1);
            g.drawLine(x0 + e, y0 + w, x0 + w + 1, y0 + e - 1);
            g.drawLine(x0 + w, y0 + e, x0 + 1, y0 + d + 1);
            g.drawLine(x0, y0 + d, x0 - w + 1, y0 + e - 1);
            g.drawLine(x0 - w, y0 + e, x0 - e + 1, y0 + w + 1);
            g.drawLine(x0 - e, y0 + w, x0 - d - 1, y0 + 1);
            g.drawLine(x0 - d, y0, x0 - e + 1, y0 - w + 1);
        }
    }

    private static void drawNarrowDiamond(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        if (size < 7) {
            Markers.drawDiamond(g, x0, y0, size, half1, top, bottom, left, right, mode);
            return;
        }
        int d1 = (half1 - 1) / 2;
        int d2 = 2 * d1;
        if (mode == 2) {
            for (int i = 0; i <= d1; ++i) {
                g.drawLine(x0 - d1 + i, y0 - 2 * i, x0 - d1 + i, y0 + 2 * i);
                if (i == d1) continue;
                g.drawLine(x0 + d1 - i, y0 - 2 * i, x0 + d1 - i, y0 + 2 * i);
            }
        } else {
            g.drawLine(x0, y0 - d2 - 1, x0, top);
            g.drawLine(x0, y0 + d2 + 1, x0, bottom);
            g.drawLine(x0 - d1 - 1, y0, x0 - d1 - 1, y0);
            g.drawLine(x0 + d1 + 1, y0, x0 + d1 + 1, y0);
            g.drawLine(x0 - d1, y0 - 1, x0 - 1, y0 - d2);
            g.drawLine(x0 + d1, y0 - 1, x0 + 1, y0 - d2);
            g.drawLine(x0 - d1, y0 + 1, x0 - 1, y0 + d2);
            g.drawLine(x0 + d1, y0 + 1, x0 + 1, y0 + d2);
        }
    }

    private static void drawNarrowHome(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode, int dir) {
        int d1 = (half1 - 1) / 2 + (half1 - 1) % 2 + 1;
        int d2 = (half1 - 1) / 2;
        if (mode == 2) {
            d1 -= 1 - half1 % 2;
            for (int i = 1; i <= d1; ++i) {
                int d3 = dir == 0 ? -1 : 2 * i - 1;
                int d4 = dir == 0 ? 2 * i - 1 : -1;
                g.drawLine(x0 - d1 + i, y0 - d4, x0 - d1 + i, y0 + d3);
                if (i == d1) continue;
                g.drawLine(x0 + d1 - i, y0 - d4, x0 + d1 - i, y0 + d3);
            }
            g.fillRect(x0 - d1 + 1, y0 + dir - dir * half1, 2 * d1 - 1, half1);
        } else if (size < 5) {
            if (dir == 0) {
                g.drawLine(x0, y0 - 1, x0 - 1, y0);
                g.drawLine(x0 + 1, y0, x0 + 1, y0);
                g.drawLine(x0 - 1, y0 + 1, x0 + 1, y0 + 1);
            } else {
                g.drawLine(x0, y0 + 1, x0 - 1, y0);
                g.drawLine(x0 + 1, y0, x0 + 1, y0);
                g.drawLine(x0 - 1, y0 - 1, x0 + 1, y0 - 1);
            }
        } else if (size < 7) {
            if (dir == 0) {
                g.drawLine(x0, y0 - 2, x0, y0 - 2);
                g.drawLine(x0 - 1, y0, x0 - 1, y0 - 1);
                g.drawLine(x0 + 1, y0, x0 + 1, y0 - 1);
                g.drawLine(x0 - 1, y0 + 1, x0 - 1, y0 + 2);
                g.drawLine(x0 + 1, y0 + 1, x0 + 1, y0 + 2);
                g.drawLine(x0, y0 + 2, x0, y0 + 2);
            } else {
                g.drawLine(x0, y0 + 2, x0, y0 + 2);
                g.drawLine(x0 - 1, y0, x0 - 1, y0 + 1);
                g.drawLine(x0 + 1, y0, x0 + 1, y0 + 1);
                g.drawLine(x0 - 1, y0 - 1, x0 - 1, y0 - 2);
                g.drawLine(x0 + 1, y0 - 1, x0 + 1, y0 - 2);
                g.drawLine(x0, y0 - 2, x0, y0 - 2);
            }
        } else {
            int d3 = 2 * d2 + 2 - half1;
            if (dir == 0) {
                g.drawLine(x0, top, x0, top);
                g.drawLine(x0 - 1, top + 1, x0 - d2 - 1, y0 + d3);
                g.drawLine(x0 + 1, top + 1, x0 + d2 + 1, y0 + d3);
                g.drawLine(x0 - d2 - 1, y0 - d3 + 1, x0 - d2 - 1, bottom);
                g.drawLine(x0 + d2 + 1, y0 - d3 + 1, x0 + d2 + 1, bottom);
                g.drawLine(x0 - d2, bottom, x0 + d2, bottom);
            } else {
                g.drawLine(x0, bottom, x0, bottom);
                g.drawLine(x0 - 1, bottom - 1, x0 - 1 - d2, y0 - d3);
                g.drawLine(x0 + 1, bottom - 1, x0 + 1 + d2, y0 - d3);
                g.drawLine(x0 - d2 - 1, y0 + d3 - 1, x0 - d2 - 1, top);
                g.drawLine(x0 + d2 + 1, y0 + d3 - 1, x0 + d2 + 1, top);
                g.drawLine(x0 - d2, top, x0 + d2, top);
            }
        }
    }

    private static void drawFlag(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int d1 = 3 * (size + 1) / 8;
        if (d1 % 2 == 1) {
            ++d1;
        }
        int d2 = d1 / 2;
        if (mode == 2) {
            for (int i = 1; i < d1; ++i) {
                g.drawLine(x0, top + i, x0 + 2 * (d2 - Math.abs(i - d2)), top + i);
            }
        } else if (size < 5) {
            g.drawLine(x0, top, x0, bottom);
            g.drawLine(x0 + 1, top, x0 + 1, top);
        } else if (size < 7) {
            g.drawLine(x0, top, x0, bottom);
            g.drawLine(x0 + 1, top, x0 + 2, top + 1);
            g.drawLine(x0 + 1, top + 2, x0 + 1, top + 2);
        } else {
            g.drawLine(x0, top + 1, x0, top + d1 - 1);
            g.drawLine(x0, top + d1 + 1, x0, bottom);
            g.drawLine(x0, top, x0 + d1 - 1, top + d2 - 1);
            g.drawLine(x0, top + d1, x0 + d1 - 1, top + d2 + 1);
            g.drawLine(x0 + d1, top + d2, x0 + d1 + 1, top + d2);
        }
    }

    private static void drawAster(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int h = Math.round((float)half1 * 0.89442f);
        h = (float)half1 * 0.89442f < (float)h ? (h -= h % 2) : (h += h % 2);
        int d = Math.round((float)half1 * 0.70711f);
        if (mode == 0) {
            if (size > 12) {
                ++d;
            }
            int c = size > 4 ? 1 : 0;
            int e = size == 5 || size == 6 ? 1 : 0;
            int f = size == 9 || size == 10 || size == 13 || size == 14 || size == 17 || size == 18 ? 1 : 0;
            g.drawLine(x0, top, x0, y0 + 1);
            g.drawLine(x0 + e + f, y0, x0 + h + 1 - e - f, y0 - h / 2 + f);
            g.drawLine(x0 - e - f, y0, x0 - h - 1 + e + f, y0 - h / 2 + f);
            g.drawLine(x0 + 1, y0 + c + 1, x0 + d, y0 + c + d);
            g.drawLine(x0 - 1, y0 + c + 1, x0 - d, y0 + c + d);
        } else if (size == 5) {
            g.drawLine(x0 - 2, y0 - 1, x0 - 2, y0);
            g.drawLine(x0 - 1, y0 - 1, x0 - 1, y0 + 2);
            g.drawLine(x0, y0 - 2, x0, y0 + 1);
            g.drawLine(x0 + 1, y0 - 1, x0 + 1, y0 + 2);
            g.drawLine(x0 + 2, y0 - 1, x0 + 2, y0);
        } else if (size == 6) {
            g.drawLine(x0 - 2, y0 - 1, x0 - 2, y0);
            g.drawLine(x0 - 1, y0 - 1, x0 - 1, y0 + 3);
            g.drawLine(x0, y0 - 2, x0, y0 + 2);
            g.drawLine(x0 + 1, y0 - 2, x0 + 1, y0 + 2);
            g.drawLine(x0 + 2, y0 - 1, x0 + 2, y0 + 3);
            g.drawLine(x0 + 3, y0 - 1, x0 + 3, y0);
        } else {
            if (size == 11) {
                --d;
            } else if (size == 14 || size == 16 || size >= 19) {
                ++d;
            }
            int f = size == 8 || size == 12 || size == 16 ? 1 : (size == 9 || size == 13 || size == 17 ? -1 : 0);
            g.drawLine(x0, y0 + 2, x0, top);
            g.drawLine(x0 + 1, y0 + 2, x0 + 1, top);
            g.drawLine(x0 + f, y0, x0 + h + 1 + f, y0 - h / 2);
            g.drawLine(x0 + 1 - f, y0, x0 - h - f, y0 - h / 2);
            g.drawLine(x0 + f, y0 + 1, x0 + h + 1 + f, y0 - h / 2 + 1);
            g.drawLine(x0 + 1 - f, y0 + 1, x0 - h - f, y0 - h / 2 + 1);
            g.drawLine(x0 - 1, y0 + 1, x0 - d, y0 + d);
            g.drawLine(x0 + 2, y0 + 1, x0 + d + 1, y0 + d);
            g.drawLine(x0 - 1, y0 + 2, x0 - d, y0 + 1 + d);
            g.drawLine(x0 + 2, y0 + 2, x0 + d + 1, y0 + 1 + d);
            g.drawLine(x0 - 1, y0 + 3, x0 - d + 1, y0 + 1 + d);
            g.drawLine(x0 + 2, y0 + 3, x0 + d, y0 + 1 + d);
        }
    }

    private static void drawVenus(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int half = size / 2;
        int circleSize = Markers.genderSize(size);
        int circleHalf = circleSize / 2;
        int circleHalf1 = (circleSize - 1) / 2;
        int handleSize = (size - circleSize) / 2;
        int handleWidth = circleSize / 4;
        if (circleSize <= 7) {
            handleWidth = circleSize / 3;
        }
        if (circleSize <= 5) {
            handleWidth = circleSize / 2;
        }
        if (mode == 2) {
            Markers.drawCircleFilled(g, x0, y0 - half1 + circleHalf1, size, circleSize, circleHalf1, y0 - half1, y0 - half1 + 2 * circleHalf1, x0 - circleHalf1, x0 + circleHalf1);
        } else if (mode == 0) {
            Markers.drawCircle(g, x0, y0 - half1 + circleHalf1, size, circleSize, circleHalf1, y0 - half1, y0 - half1 + 2 * circleHalf1, x0 - circleHalf1, x0 + circleHalf1);
            if (size == 6) {
                g.drawLine(x0 - handleWidth + 1, y0 + half - handleSize, x0 + handleWidth, y0 + half - handleSize);
                g.drawLine(x0, y0 + half - handleSize + 1, x0 + 1, y0 + half - handleSize + 1);
            } else {
                g.drawLine(x0 - handleWidth, y0 + half - handleSize, x0 - 1, y0 + half - handleSize);
                g.drawLine(x0 + 1, y0 + half - handleSize, x0 + handleWidth, y0 + half - handleSize);
                if (-half1 + circleSize <= half) {
                    g.drawLine(x0, y0 - half1 + circleSize, x0, y0 + half);
                }
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    Markers.drawCircle(g, x0 + i, y0 + j - half1 + circleHalf1, size, circleSize, circleHalf1, y0 + j - half1, y0 + j - half1 + 2 * circleHalf1, x0 + i - circleHalf1, x0 + i + circleHalf1);
                }
            }
            g.fillRect(x0 - handleWidth, y0 + half - handleSize, 2 * handleWidth + 2, 2);
            g.fillRect(x0, y0 - half1 + circleSize, 2, size - circleSize);
        }
    }

    private static void drawMars(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int d;
        int half = size / 2;
        int circleSize = Markers.genderSize(size);
        int circleHalf = circleSize / 2;
        int circleHalf1 = (circleSize - 1) / 2;
        int circleSin = 1 + circleHalf1 * 71 / 100;
        int circleCos = circleSize % 2 == 0 ? circleSin + 1 : circleSin;
        int spearSize = circleSize / 2;
        if (circleSize <= 7) {
            spearSize = 2 * circleSize / 3;
        }
        int d1 = (d = (size - circleSize) / 4) > 0 ? d - 1 : 0;
        int x1 = x0 - half1 + circleHalf1 + d;
        int y1 = y0 + half - circleHalf - d;
        if (mode == 2) {
            Markers.drawCircleFilled(g, x1, y1, size, circleSize, circleHalf1, y1 - circleHalf1, y1 + circleHalf1, x1 - circleHalf1, x1 + circleHalf1);
        } else if (mode == 0) {
            Markers.drawCircle(g, x1, y1, size, circleSize, circleHalf1, y1 - circleHalf1, y1 + circleHalf1, x1 - circleHalf1, x1 + circleHalf1);
            g.drawLine(x1 + circleCos, y1 - circleSin, x0 + half - d1, top + d1);
            if (size > 3) {
                g.drawLine(x0 + half - d1 - spearSize, top + d1, x0 + half - d1 - 1, top + d1);
                g.drawLine(x0 + half - d1, top + d1 + 1, x0 + half - d1, top + d1 + spearSize);
            }
        } else {
            int i;
            if (size == 6) {
                --y1;
            }
            for (i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    Markers.drawCircle(g, x1 + i, y1 + j, size, circleSize, circleHalf1, y1 + j - circleHalf1, y1 + j + circleHalf1, x1 + i - circleHalf1, x1 + i + circleHalf1);
                }
            }
            g.drawLine(x1 + circleCos, y1 - circleCos, x0 + half - d, y0 - half1 + d);
            g.drawLine(x1 + circleCos - 1, y1 - circleCos, x0 + half - d - 1, top + d);
            g.drawLine(x1 + circleCos, y1 - circleCos + 1, x0 + half - d, top + d + 1);
            for (i = 0; i < 2; ++i) {
                g.drawLine(x0 + half - d1 - spearSize, top + d1 + i, x0 + half - d1, top + d1 + i);
                g.drawLine(x0 + half - d1 - i, top + d1, x0 + half - d1 - i, top + d1 + spearSize);
            }
        }
    }

    private static void drawEarth(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int half = size / 2;
        int circleSize = Markers.genderSize(size);
        int circleHalf = circleSize / 2;
        int circleHalf1 = (circleSize - 1) / 2;
        if (mode == 2) {
            Markers.drawCircleFilled(g, x0, y0, size, circleSize, circleHalf1, y0 - circleHalf1, y0 + circleHalf1, x0 - circleHalf1, x0 + circleHalf1);
        } else if (mode == 0) {
            Markers.drawCircle(g, x0, y0, size, circleSize, circleHalf1, y0 - circleHalf1, y0 + circleHalf1, x0 - circleHalf1, x0 + circleHalf1);
            if (size <= 6) {
                g.fillRect(x0, y0, size / 3, size / 3);
            } else {
                g.drawLine(x0 - circleHalf1 + 1, y0, x0 - 1, y0);
                g.drawLine(x0 + 1, y0, x0 + circleHalf1 - 1, y0);
                g.drawLine(x0, y0 - circleHalf1 + 1, x0, y0 + circleHalf1 - 1);
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    Markers.drawCircle(g, x0 + i, y0 + j, size, circleSize, circleHalf1, y0 + j - circleHalf1, y0 + j + circleHalf1, x0 + i - circleHalf1, x0 + i + circleHalf1);
                }
            }
            g.fillRect(x0 - circleHalf1, y0, circleSize, 2);
            g.fillRect(x0, y0 - circleHalf1, 2, circleSize);
        }
    }

    private static void drawArrowNarrow(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode, int dir) {
        if (size <= 4) {
            Markers.drawPlus(g, x0, y0, size, half1, top, bottom, left, right, mode);
            return;
        }
        top = y0 - half1;
        bottom = y0 + half1;
        left = x0 - half1;
        right = x0 + half1;
        int d1 = (half1 + 1) / 3;
        int d2 = half1 / 3;
        int x01 = right - d2;
        int y01 = y0 - d2;
        int x02 = x0 + 1;
        int y02 = top + 1;
        int x03 = x0;
        int y03 = top;
        int x04 = left + d2;
        int y04 = y0 - d2;
        int x05 = left + d2 + 1;
        int y05 = y0 - d2;
        int x06 = x0 - d1;
        int y06 = y0 - d2;
        int x07 = x0 - d1;
        int y07 = y0 - d2 + 1;
        int x08 = x0 - d1;
        int y08 = bottom;
        int x09 = x0 - d1 + 1;
        int y09 = bottom;
        int x10 = x0 + d1;
        int y10 = bottom;
        int x11 = x0 + d1;
        int y11 = bottom - 1;
        int x12 = x0 + d1;
        int y12 = y0 - d2 + 1;
        int x13 = x0 + d1;
        int y13 = y0 - d2;
        int x14 = right - d2 - 1;
        int y14 = y0 - d2;
        if (dir == 1) {
            x01 = left + d2;
            y01 = y0 + d2;
            x02 = x0 - 1;
            y02 = bottom - 1;
            x03 = x0;
            y03 = bottom;
            x04 = right - d2;
            y04 = y0 + d2;
            x05 = right - d2 - 1;
            y05 = y0 + d2;
            x06 = x0 + d1;
            y06 = y0 + d2;
            x07 = x0 + d1;
            y07 = y0 + d2 - 1;
            x08 = x0 + d1;
            y08 = top;
            x09 = x0 + d1 - 1;
            y09 = top;
            x10 = x0 - d1;
            y10 = top;
            x11 = x0 - d1;
            y11 = top + 1;
            x12 = x0 - d1;
            y12 = y0 + d2 - 1;
            x13 = x0 - d1;
            y13 = y0 + d2;
            x14 = left + d2 + 1;
            y14 = y0 + d2;
        } else if (dir == 2) {
            x01 = x0 - d2;
            y01 = top + d2;
            x02 = left + 1;
            y02 = y0 - 1;
            x03 = left;
            y03 = y0;
            x04 = x0 - d2;
            y04 = bottom - d2;
            x05 = x0 - d2;
            y05 = bottom - d2 - 1;
            x06 = x0 - d2;
            y06 = y0 + d1;
            x07 = x0 - d2 + 1;
            y07 = y0 + d1;
            x08 = right;
            y08 = y0 + d1;
            x09 = right;
            y09 = y0 + d1 - 1;
            x10 = right;
            y10 = y0 - d1;
            x11 = right - 1;
            y11 = y0 - d1;
            x12 = x0 - d2 + 1;
            y12 = y0 - d1;
            x13 = x0 - d2;
            y13 = y0 - d1;
            x14 = x0 - d2;
            y14 = top + d2 + 1;
        } else if (dir == 3) {
            x01 = x0 + d2;
            y01 = bottom - d2;
            x02 = right - 1;
            y02 = y0 + 1;
            x03 = right;
            y03 = y0;
            x04 = x0 + d2;
            y04 = top + d2;
            x05 = x0 + d2;
            y05 = top + d2 + 1;
            x06 = x0 + d2;
            y06 = y0 - d1;
            x07 = x0 + d2 - 1;
            y07 = y0 - d1;
            x08 = left;
            y08 = y0 - d1;
            x09 = left;
            y09 = y0 - d1 + 1;
            x10 = left;
            y10 = y0 + d1;
            x11 = left + 1;
            y11 = y0 + d1;
            x12 = x0 + d2 - 1;
            y12 = y0 + d1;
            x13 = x0 + d2;
            y13 = y0 + d1;
            x14 = x0 + d2;
            y14 = bottom - d2 - 1;
        }
        if (mode == 2) {
            int w = 2 * d1 - 1;
            int h = half1 + d2;
            if (dir == 0) {
                g.fillRect(x0 - d1 + 1, y0 - d2, w, h);
                for (int i = 1; i < half1 - d2; ++i) {
                    g.fillRect(x0 - i + 1, top + i, 2 * i - 1, 1);
                }
            } else if (dir == 1) {
                g.fillRect(x0 - d1 + 1, top + 1, w, h);
                for (int i = 1; i < half1 - d2; ++i) {
                    g.fillRect(x0 - i + 1, bottom - i, 2 * i - 1, 1);
                }
            } else if (dir == 2) {
                g.fillRect(x0 - d2, y0 - d1 + 1, h, w);
                for (int i = 1; i < half1 - d2; ++i) {
                    g.fillRect(left + i, y0 - i + 1, 1, 2 * i - 1);
                }
            } else {
                g.fillRect(left + 1, y0 - d1 + 1, h, w);
                for (int i = 1; i < half1 - d2; ++i) {
                    g.fillRect(right - i, y0 - i + 1, 1, 2 * i - 1);
                }
            }
        } else {
            g.drawLine(x01, y01, x02, y02);
            g.drawLine(x03, y03, x04, y04);
            g.drawLine(x05, y05, x06, y06);
            g.drawLine(x07, y07, x08, y08);
            g.drawLine(x09, y09, x10, y10);
            g.drawLine(x11, y11, x12, y12);
            g.drawLine(x13, y13, x14, y14);
        }
    }

    private static void drawArrowWide(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode, int dir) {
        int d1 = half1 / 2;
        top = y0 - half1;
        bottom = y0 + half1;
        left = x0 - half1;
        right = x0 + half1;
        if (mode == 2) {
            if (dir == 0) {
                g.fillRect(x0 - d1 + 1, y0, 2 * d1 - 1, half1);
                for (int i = 1; i < half1; ++i) {
                    g.fillRect(x0 - i + 1, top + i, 2 * i - 1, 1);
                }
            } else if (dir == 1) {
                g.fillRect(x0 - d1 + 1, top + 1, 2 * d1 - 1, half1);
                for (int i = 1; i < half1; ++i) {
                    g.fillRect(x0 - i + 1, bottom - i, 2 * i - 1, 1);
                }
            }
        } else if (dir == 0) {
            g.drawLine(x0, top, left, y0);
            g.drawLine(x0 + 1, top + 1, right, y0);
            if (x0 - d1 - 1 >= left + 1) {
                g.drawLine(x0 - d1 - 1, y0, left + 1, y0);
            }
            if (x0 + d1 + 1 <= right - 1) {
                g.drawLine(x0 + d1 + 1, y0, right - 1, y0);
            }
            g.drawLine(x0 - d1, y0, x0 - d1, bottom);
            g.drawLine(x0 + d1, y0, x0 + d1, bottom);
            g.drawLine(x0 - d1 + 1, bottom, x0 + d1 - 1, bottom);
        } else if (dir == 1) {
            g.drawLine(x0, bottom, left, y0);
            g.drawLine(x0 + 1, bottom - 1, right, y0);
            if (x0 - d1 - 1 >= left + 1) {
                g.drawLine(x0 - d1 - 1, y0, left + 1, y0);
            }
            if (x0 + d1 + 1 <= right - 1) {
                g.drawLine(x0 + d1 + 1, y0, right - 1, y0);
            }
            g.drawLine(x0 - d1, y0, x0 - d1, top);
            g.drawLine(x0 + d1, y0, x0 + d1, top);
            g.drawLine(x0 - d1 + 1, top, x0 + d1 - 1, top);
        }
    }

    private static void drawHourglass(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int d1 = half1 - 1;
        if (d1 % 2 == 1) {
            ++d1;
        }
        int d2 = d1 / 2;
        if (mode == 2) {
            for (int i = 1; i < d2; ++i) {
                g.fillRect(x0 - i + 1, y0 - 2 * i, 2 * i - 1, 2);
                g.fillRect(x0 - i + 1, y0 + 2 * i - 1, 2 * i - 1, 2);
            }
            g.fillRect(x0 - d2 + 1, y0 - 2 * d2 + 1 - half1 % 2, 2 * d2 - 1, 1 + half1 % 2);
            g.fillRect(x0 - d2 + 1, y0 + 2 * d2 - 1, 2 * d2 - 1, 1 + half1 % 2);
        } else {
            g.drawLine(x0 - 1, y0 - 1, x0 + 1, y0 + 1);
            g.drawLine(x0 - 1, y0 + 1, x0 + 1, y0 - 1);
            g.drawLine(x0 - 1, y0 - 1, x0 - d2, y0 - d1);
            g.drawLine(x0 - 1, y0 + 1, x0 - d2, y0 + d1);
            g.drawLine(x0 + 1, y0 - 1, x0 + d2, y0 - d1);
            g.drawLine(x0 + 1, y0 + 1, x0 + d2, y0 + d1);
            g.drawLine(x0 - d2 - 1, top, x0 + d2 + 1, top);
            g.drawLine(x0 - d2 - 1, bottom, x0 + d2 + 1, bottom);
        }
    }

    private static void drawStar(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode) {
        int d3;
        if (size <= 4) {
            g.drawLine(x0, y0 - 1, x0, y0 - 1);
            g.drawLine(x0 - 1, y0, x0 + 1, y0);
            g.drawLine(x0 - 1, y0 + 1, x0 - 1, y0 + 1);
            g.drawLine(x0 + 1, y0 + 1, x0 + 1, y0 + 1);
            return;
        }
        float r = (float)half1 * 0.30902f / 0.58779f;
        int hcos18 = 1;
        int hsin18 = 0;
        int hcos36 = 1;
        int hsin36 = 1;
        int rcos18 = 1;
        int rsin18 = 0;
        int rcos36 = 1;
        int rsin36 = 1;
        if (size == 5 && size == 6) {
            hcos18 = 2;
            hsin18 = 1;
            hcos36 = 1;
            hsin36 = 2;
            rcos18 = 1;
            rsin18 = 0;
            rcos36 = 0;
            rsin36 = 1;
        } else if (size == 7 && size == 8) {
            hcos18 = 3;
            hsin18 = 1;
            hcos36 = 2;
            hsin36 = 3;
            rcos18 = 2;
            rsin18 = 0;
            rcos36 = 2;
            rsin36 = 1;
        } else if (size == 9 && size == 10) {
            hcos18 = 4;
            hsin18 = 1;
            hcos36 = 3;
            hsin36 = 4;
            rcos18 = 2;
            rsin18 = 1;
            rcos36 = 1;
            rsin36 = 1;
        } else {
            hcos18 = Math.round((float)half1 * 0.95106f);
            hsin18 = Math.round((float)half1 * 0.30902f);
            hcos36 = Math.round((float)half1 * 0.58779f);
            hsin36 = Math.round((float)half1 * 0.80902f);
            if (size >= 14) {
                ++hsin36;
            }
            if (size >= 11) {
                ++hcos36;
            }
            rcos18 = Math.round(r * 0.95106f);
            rsin18 = Math.round(r * 0.30902f);
            rcos36 = Math.round(r * 0.58779f);
            rsin36 = Math.round(r * 0.80902f);
            if (size >= 17) {
                ++rsin18;
            }
        }
        int d1 = half1 - hsin18 - 1;
        if (d1 % 2 == 1) {
            ++d1;
        }
        if ((size == 9 || size == 10 || size == 15 || size == 16) && (d1 = half1 - hsin18 + 1) % 2 == 1) {
            --d1;
        }
        int d2 = d1 / 2;
        --d1;
        --d2;
        hsin36 = half1;
        int n = d3 = size > 10 ? 1 : 0;
        if (size == 7 || size == 8) {
            r = (int)r;
        }
        int[] x = new int[16];
        int[] y = new int[16];
        x[0] = x0 + hcos18;
        y[0] = y0 - hsin18;
        x[1] = x0 + rcos36;
        y[1] = y0 - hsin18;
        x[2] = x0 + rcos36 - d2;
        y[2] = y0 - hsin18 - d1;
        x[3] = x0;
        y[3] = top;
        x[4] = x0 - rcos36 + d2;
        y[4] = y0 - hsin18 - d1;
        x[5] = x0 - rcos36;
        y[5] = y0 - hsin18;
        x[6] = x0 - hcos18;
        y[6] = y0 - hsin18;
        x[7] = x0 - rcos18;
        y[7] = y0 + rsin18;
        x[8] = x0 - hcos36;
        y[8] = y0 + hsin36;
        x[9] = x[8];
        y[9] = y[8];
        x[10] = x[8] + d3;
        y[10] = y[8];
        x[11] = x0;
        y[11] = y0 + Math.round(r);
        x[12] = x0 + hcos36 - d3;
        y[12] = y0 + hsin36;
        x[13] = x[12] + d3;
        y[13] = y[12];
        x[14] = x[12] + d3;
        y[14] = y[12];
        x[15] = x0 + rcos18;
        y[15] = y0 + rsin18;
        if (mode == 2) {
            g.fillPolygon(x, y, 16);
        } else {
            g.drawPolygon(x, y, 16);
        }
    }

    private static void drawFigure(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode, boolean isMale) {
        int half = size / 2;
        int d1 = size / 10;
        int d2 = size / 5;
        if (6 * d1 + 3 * d2 >= size) {
            --d2;
        }
        if (6 * d1 + 3 * d2 >= size) {
            --d1;
        }
        if (size == 12) {
            d1 = 1;
            d2 = 2;
        } else if (size == 9) {
            d1 = 1;
            d2 = 1;
        }
        int[] x = new int[27];
        int[] y = new int[27];
        x[0] = x0 - d2 + d1;
        y[0] = top;
        x[1] = x0 - d2;
        y[1] = top + d1;
        x[2] = x0 - d2;
        y[2] = top + d1 + d2;
        x[3] = x0 - d2 + d1;
        y[3] = top + 2 * d1 + d2;
        x[4] = x0 - d1;
        y[4] = top + 2 * d1 + d2;
        x[5] = x0 - d1;
        y[5] = y0 - d1;
        x[6] = x0 - d1 - d2;
        y[6] = y0 - d1;
        x[7] = x0 - d1 - d2;
        y[7] = y0 + d1;
        x[8] = x0 - d1;
        y[8] = y0 + d1;
        if (isMale) {
            x[9] = x0 - d1;
            y[9] = y0 + d1;
            x[10] = x0 - d1;
            y[10] = y0 + half - 2 * (d1 + d2) + 1;
            x[11] = x0 - d1 - d2;
            y[11] = y0 + half;
            x[12] = x0 - d2 + 1;
            y[12] = y0 + half;
            x[13] = x0;
            y[13] = y0 + half - 2 * d2 + (d2 < 2 ? 0 : 3);
            x[14] = x0 + d2 - 1;
            y[14] = y0 + half;
            x[15] = x0 + d1 + d2;
            y[15] = y0 + half;
            x[16] = x0 + d1;
            y[16] = y0 + half - 2 * (d1 + d2) + 1;
            x[17] = x0 + d1;
            y[17] = y0 + d1;
        } else {
            x[9] = x0 - d1 - 1;
            y[9] = y0 + d1 + 1;
            x[10] = x0 - d1 - d2;
            y[10] = y0 + d1 + 2 * d2;
            x[11] = x0 - d1;
            y[11] = y0 + d1 + 2 * d2;
            x[12] = x0 - d1;
            y[12] = y0 + half;
            x[13] = x0;
            y[13] = y0 + half;
            x[14] = x0 + d1;
            y[14] = y0 + half;
            x[15] = x0 + d1;
            y[15] = y0 + d1 + 2 * d2;
            x[16] = x0 + d1 + d2;
            y[16] = y0 + d1 + 2 * d2;
            x[17] = x0 + d1 + 1;
            y[17] = y0 + d1 + 1;
        }
        x[18] = x0 + d1;
        y[18] = y0 + d1;
        x[19] = x0 + d1 + d2;
        y[19] = y0 + d1;
        x[20] = x0 + d1 + d2;
        y[20] = y0 - d1;
        x[21] = x0 + d1;
        y[21] = y0 - d1;
        x[22] = x0 + d1;
        y[22] = top + 2 * d1 + d2;
        x[23] = x0 + d2 - d1;
        y[23] = top + 2 * d1 + d2;
        x[24] = x0 + d2;
        y[24] = top + d1 + d2;
        x[25] = x0 + d2;
        y[25] = top + d1;
        x[26] = x0 + d2 - d1;
        y[26] = top;
        if (mode == 2) {
            g.fillPolygon(x, y, 27);
        } else {
            g.drawPolygon(x, y, 27);
        }
    }

    private static void drawCurve(Graphics g, int x0, int y0, int size, int half1, int top, int bottom, int left, int right, int mode, int dir) {
        int d0 = (size - 1) / 4;
        int d1 = (size + 1) / 4;
        int d2 = d1 / 2;
        boolean aa = false;
        if (g instanceof Graphics2D) {
            aa = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (size <= 6) {
            if (dir == 1) {
                g.drawLine(left, y0, left, y0 + d1);
                g.drawLine(x0 - d0, y0 - d0, x0 + d0, y0 + d0);
                g.drawLine(right, y0 - d1, right, y0);
            } else {
                g.drawLine(x0 - d1, top, x0, top);
                g.drawLine(x0 - d0, y0 + d0, x0 + d0, y0 - d0);
                g.drawLine(x0, bottom, x0 + d1, bottom);
            }
        } else if (size <= 12) {
            if (dir == 1) {
                g.drawLine(left, y0 - d2 - d0 + 1, left, y0 + d2 + d0 - 1);
                g.drawLine(x0, y0 - d2 - d0 + 1, x0, y0 + d2 + d0 - 1);
                g.drawLine(right, y0 - d2 - d0 + 1, right, y0 + d2 + d0 - 1);
                g.drawLine(left + 1, y0 - d2 - d0, x0 - 1, y0 - d2 - d0);
                g.drawLine(x0 + 1, y0 + d2 + d0, right - 1, y0 + d2 + d0);
                if (aa) {
                    g.drawLine(left, y0 - d2 - d0 + 1, left + 1, y0 - d2 - d0);
                    g.drawLine(x0, y0 - d2 - d0 + 1, x0 - 1, y0 - d2 - d0);
                    g.drawLine(x0, y0 + d2 + d0 - 1, x0 + 1, y0 + d2 + d0);
                    g.drawLine(right, y0 + d2 + d0 - 1, right - 1, y0 + d2 + d0);
                }
            } else {
                g.drawLine(x0 - d2 - d0 + 1, top, x0 + d2 + d0 - 1, top);
                g.drawLine(x0 - d2 - d0 + 1, y0, x0 + d2 + d0 - 1, y0);
                g.drawLine(x0 - d2 - d0 + 1, bottom, x0 + d2 + d0 - 1, bottom);
                g.drawLine(x0 + d2 + d0, top + 1, x0 + d2 + d0, y0 - 1);
                g.drawLine(x0 - d2 - d0, y0 + 1, x0 - d2 - d0, bottom - 1);
                if (aa) {
                    g.drawLine(x0 - d2 - d0 + 1, bottom, x0 - d2 - d0, bottom - 1);
                    g.drawLine(x0 - d2 - d0 + 1, y0, x0 - d2 - d0, y0 + 1);
                    g.drawLine(x0 + d2 + d0 - 1, y0, x0 + d2 + d0, y0 - 1);
                    g.drawLine(x0 + d2 + d0 - 1, top, x0 + d2 + d0, top + 1);
                }
            }
        } else if (dir == 1) {
            g.drawLine(left, y0 - d2 + 1, left, y0 + 2 * d2);
            g.drawLine(x0, y0 - d2 + 1, x0, y0 + d2 - 1);
            g.drawLine(right, y0 - 2 * d2, right, y0 + d2 - 1);
            Markers.drawEighth(g, true, true, x0 - d0, y0 - d2, d0, 0);
            Markers.drawEighth(g, true, true, x0 - d0, y0 - d2, d0, 1);
            Markers.drawEighth(g, true, true, x0 - d1, y0 - d2, d0, 2);
            Markers.drawEighth(g, true, true, x0 - d1, y0 - d2, d0, 3);
            Markers.drawEighth(g, true, true, x0 + d0, y0 + d2, d0, 4);
            Markers.drawEighth(g, true, true, x0 + d0, y0 + d2, d0, 5);
            Markers.drawEighth(g, true, true, x0 + d1, y0 + d2, d0, 6);
            Markers.drawEighth(g, true, true, x0 + d1, y0 + d2, d0, 7);
        } else {
            g.drawLine(x0 - 2 * d2, top, x0 + d2 - 1, top);
            g.drawLine(x0 - d2 + 1, y0, x0 + d2 - 1, y0);
            g.drawLine(x0 - d2 + 1, bottom, x0 + 2 * d2, bottom);
            Markers.drawEighth(g, true, true, x0 + d2, y0 - d1, d0, 1);
            Markers.drawEighth(g, true, true, x0 + d2, y0 - d1, d0, 0);
            Markers.drawEighth(g, true, true, x0 + d2, y0 - d0, d0, 7);
            Markers.drawEighth(g, true, true, x0 + d2, y0 - d0, d0, 6);
            Markers.drawEighth(g, true, true, x0 - d2, y0 + d0, d0, 2);
            Markers.drawEighth(g, true, true, x0 - d2, y0 + d0, d0, 3);
            Markers.drawEighth(g, true, true, x0 - d2, y0 + d1, d0, 4);
            Markers.drawEighth(g, true, true, x0 - d2, y0 + d1, d0, 5);
        }
    }

    private static void drawEighth(Graphics g, boolean first, boolean last, int x0, int y0, int r, int i) {
        int p = 0;
        int x = 0;
        int y = r;
        int d = 1 - r;
        while (y >= x) {
            int k;
            if (d <= 0) {
                d += 2 * x + 3;
                ++x;
                continue;
            }
            int j = p + (p > 0 ? 1 : (first ? 0 : 1));
            if (j <= (k = x - (y - 1 >= x + 1 ? 1 : (last ? 0 : 1)))) {
                switch (i) {
                    case 0: {
                        g.drawLine(x0 + y, y0 - j, x0 + y, y0 - k);
                        break;
                    }
                    case 1: {
                        g.drawLine(x0 + j, y0 - y, x0 + k, y0 - y);
                        break;
                    }
                    case 2: {
                        g.drawLine(x0 - j, y0 - y, x0 - k, y0 - y);
                        break;
                    }
                    case 3: {
                        g.drawLine(x0 - y, y0 - j, x0 - y, y0 - k);
                        break;
                    }
                    case 4: {
                        g.drawLine(x0 - y, y0 + j, x0 - y, y0 + k);
                        break;
                    }
                    case 5: {
                        g.drawLine(x0 - j, y0 + y, x0 - k, y0 + y);
                        break;
                    }
                    case 6: {
                        g.drawLine(x0 + j, y0 + y, x0 + k, y0 + y);
                        break;
                    }
                    case 7: {
                        g.drawLine(x0 + y, y0 + j, x0 + y, y0 + k);
                    }
                }
            }
            if (y - 1 >= x + 1) {
                j = y - 1 > x + 1 ? 1 : (last ? 1 : 0);
                switch (i) {
                    case 0: {
                        g.drawLine(x0 + y, y0 - x, x0 + y - j, y0 - x - j);
                        break;
                    }
                    case 1: {
                        g.drawLine(x0 + x, y0 - y, x0 + x + j, y0 - y + j);
                        break;
                    }
                    case 2: {
                        g.drawLine(x0 - x, y0 - y, x0 - x - j, y0 - y + j);
                        break;
                    }
                    case 3: {
                        g.drawLine(x0 - y, y0 - x, x0 - y + j, y0 - x - j);
                        break;
                    }
                    case 4: {
                        g.drawLine(x0 - y, y0 + x, x0 - y + j, y0 + x + j);
                        break;
                    }
                    case 5: {
                        g.drawLine(x0 - x, y0 + y, x0 - x - j, y0 + y - j);
                        break;
                    }
                    case 6: {
                        g.drawLine(x0 + x, y0 + y, x0 + x + j, y0 + y - j);
                        break;
                    }
                    case 7: {
                        g.drawLine(x0 + y, y0 + x, x0 + y - j, y0 + x + j);
                    }
                }
            }
            d += 2 * (x - y) + 5;
            p = ++x;
            --y;
        }
    }

    private static void drawSkin(Graphics g, int x, int y, int markerWidth, int markerHeight, Image skin) {
        if (skin == null) {
            return;
        }
        if (markerHeight < 1 || markerWidth < 1) {
            return;
        }
        BufferedImage image = null;
        image = new BufferedImage(markerWidth, markerHeight, 3);
        Graphics2D imageGraphics = image.createGraphics();
        imageGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        imageGraphics.drawImage(skin, 0, 0, markerWidth, markerHeight, null);
        g.drawImage(image, x, y, null);
    }

    public static void initUserDefinedMarkers() {
        udm.clear();
        udmName.clear();
    }

    public static int addUserDefinedMarker(String name, UserDefinedMarkerInterface marker) {
        udmName.add(name.toUpperCase());
        udm.add(marker);
        return 189 + udm.size();
    }

    public static boolean isUserDefinedMarker(String name) {
        return udmName.contains(name.toUpperCase());
    }

    public static boolean isUserDefinedMarker(int symbol) {
        if (symbol < 189) {
            return false;
        }
        return symbol - 189 <= udm.size();
    }

    public static int getUserDefinedMarker(String name) {
        return 189 + udmName.indexOf(name.toUpperCase()) + 1;
    }

    public static String getUserDefinedMarkerName(int symbol) {
        if (Markers.isUserDefinedMarker(symbol)) {
            return udmName.get(symbol - 1 - 189);
        }
        return null;
    }

    public static UserDefinedMarkerInterface getUserDefinedMarker(int shape) {
        return udm.get(shape - 1 - 189);
    }

    private static class ScalableMarkers {
        private static double NORMAL_PERCENT = 0.15;
        private static double SEMI_BOLD_PERCENT = 0.2;
        private static double BOLD_PERCENT = 0.3;
        private static int MAX_SIZE = 100000;
        private static final int UP = 0;
        private static final int DOWN = 1;
        private static final int LEFT = 2;
        private static final int RIGHT = 3;

        private ScalableMarkers() {
        }

        public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0, int thickness, boolean antialiasingIsOn) {
            ScalableMarkers.draw(g, color, edge, shape, maxSize, x0, y0, thickness, antialiasingIsOn, null);
        }

        public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0, int thickness, boolean antialiasingIsOn, Image skin) {
            int left;
            int top;
            int half;
            if (maxSize <= 0) {
                return;
            }
            if (shape == 63 || shape == 65) {
                maxSize = Math.min(maxSize, MAX_SIZE);
            }
            if (color != null) {
                g.setColor(color);
            } else {
                color = g.getColor();
            }
            boolean edgeOn = edge != null && !edge.equals(color) && edge.getAlpha() > 0;
            int size = ScalableMarkers.getAdjustedSize(shape, maxSize);
            if (thickness == 0) {
                edgeOn = false;
                thickness = 1;
            }
            if (edgeOn && thickness > 1 && ScalableMarkers.isFilled(shape)) {
                if (thickness > (size - 1) / 2) {
                    g.setColor(edge);
                    edgeOn = false;
                    thickness = 1;
                } else {
                    int adj = thickness % 2 == 0 ? thickness : thickness - 1;
                    size -= adj;
                }
            }
            if (size == 1) {
                g.drawLine(x0, y0, x0, y0);
                return;
            }
            if (size == 2) {
                if (edgeOn) {
                    g.setColor(edge);
                }
                g.drawRect(x0, y0, 1, 1);
                if (edgeOn) {
                    g.setColor(color);
                }
                return;
            }
            if (size % 2 == 0) {
                half = size / 2;
                top = y0 - (half - 1);
                left = x0 - (half - 1);
            } else {
                half = (size - 1) / 2;
                top = y0 - half;
                left = x0 - half;
            }
            int bottom = y0 + half;
            int right = x0 + half;
            Stroke oldStroke = null;
            if (!ScalableMarkers.isFilled(shape) && thickness > 1 && g instanceof Graphics2D) {
                oldStroke = ((Graphics2D)g).getStroke();
                if (ScalableMarkers.isRound(shape, size)) {
                    ((Graphics2D)g).setStroke(new BasicStroke(thickness, 0, 1));
                } else {
                    ((Graphics2D)g).setStroke(new BasicStroke(thickness));
                }
            }
            Color edgeColor = edgeOn ? edge : null;
            switch (shape) {
                default: {
                    if (!Markers.isUserDefinedMarker(shape)) break;
                    UserDefinedMarkerInterface udm = Markers.getUserDefinedMarker(shape);
                    udm.paint((Graphics2D)g, color, edgeColor, x0, y0, size, size);
                    break;
                }
                case 0: {
                    Markers.drawSkin(g, left, top, size, size, skin);
                    ScalableMarkers.drawCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, antialiasingIsOn);
                    break;
                }
                case 16: {
                    ScalableMarkers.drawFilledCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, edgeColor, antialiasingIsOn, skin);
                    break;
                }
                case 1: {
                    ScalableMarkers.drawPlus(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 4: {
                    ScalableMarkers.drawX(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 2: {
                    ScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 0);
                    break;
                }
                case 18: {
                    ScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 0);
                    break;
                }
                case 5: {
                    ScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 1);
                    break;
                }
                case 21: {
                    ScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 1);
                    break;
                }
                case 59: {
                    ScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 2);
                    break;
                }
                case 105: {
                    ScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 2);
                    break;
                }
                case 60: {
                    ScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 3);
                    break;
                }
                case 106: {
                    ScalableMarkers.drawTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 3);
                    break;
                }
                case 63: {
                    ScalableMarkers.drawTilde(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 66: {
                    ScalableMarkers.drawIBeam(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 3: {
                    ScalableMarkers.drawSquare(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, skin);
                    break;
                }
                case 19: {
                    ScalableMarkers.drawSquare(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, skin);
                    break;
                }
                case 58: {
                    ScalableMarkers.drawAsterisk(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 150: {
                    ScalableMarkers.drawY(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 6: {
                    ScalableMarkers.drawDiamond(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                    break;
                }
                case 22: {
                    ScalableMarkers.drawDiamond(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                    break;
                }
                case 151: {
                    ScalableMarkers.drawZ(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 65: {
                    ScalableMarkers.drawUnion(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 56: {
                    ScalableMarkers.drawHash(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 70: {
                    ScalableMarkers.drawTack(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 73: {
                    ScalableMarkers.drawHomeDown(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                    break;
                }
                case 108: {
                    ScalableMarkers.drawHomeDown(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                    break;
                }
                case 62: {
                    ScalableMarkers.drawGreaterThan(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 61: {
                    ScalableMarkers.drawLessThan(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 134: {
                    ScalableMarkers.drawArrowDown(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 54: {
                    ScalableMarkers.drawStar(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                    break;
                }
                case 23: {
                    ScalableMarkers.drawStar(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                    break;
                }
                case 146: {
                    ScalableMarkers.drawHexagon(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                    break;
                }
                case 148: {
                    ScalableMarkers.drawHexagon(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                    break;
                }
                case 52: {
                    ScalableMarkers.drawCross(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                    break;
                }
                case 17: {
                    ScalableMarkers.drawFilledCross(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                    break;
                }
                case 158: {
                    ScalableMarkers.drawOctagon(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                    break;
                }
                case 159: {
                    ScalableMarkers.drawOctagon(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                    break;
                }
                case 160: {
                    ScalableMarkers.drawOctagonRotated(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                    break;
                }
                case 161: {
                    ScalableMarkers.drawOctagonRotated(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                    break;
                }
                case 162: {
                    ScalableMarkers.drawPentagon(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                    break;
                }
                case 163: {
                    ScalableMarkers.drawPentagon(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                    break;
                }
                case 164: {
                    ScalableMarkers.drawCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, antialiasingIsOn);
                    if ((size /= 4) % 2 == 0) {
                        half = size / 2;
                        top = y0 - half;
                        left = x0 - half;
                    } else {
                        half = (size - 1) / 2;
                        top = y0 - half;
                        left = x0 - half;
                    }
                    bottom = y0 + half;
                    right = x0 + half;
                    ScalableMarkers.drawDiamond(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                    break;
                }
                case 165: {
                    ScalableMarkers.drawFilledCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, edgeColor, antialiasingIsOn, skin);
                    if ((size /= 4) % 2 == 0) {
                        half = size / 2;
                        top = y0 - half;
                        left = x0 - half;
                    } else {
                        half = (size - 1) / 2;
                        top = y0 - half;
                        left = x0 - half;
                    }
                    bottom = y0 + half;
                    right = x0 + half;
                    ScalableMarkers.drawDiamond(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                    break;
                }
                case 166: {
                    ScalableMarkers.drawCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, antialiasingIsOn);
                    if ((size /= 4) % 2 == 0) {
                        half = size / 2;
                        top = y0 - half;
                        left = x0 - half;
                    } else {
                        half = (size - 1) / 2;
                        top = y0 - half;
                        left = x0 - half;
                    }
                    bottom = y0 + half;
                    right = x0 + half;
                    ScalableMarkers.drawDiamond(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                    break;
                }
                case 167: {
                    ScalableMarkers.drawCheckmark(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 168: {
                    ScalableMarkers.drawCircumflex(g, x0, y0, size, half, top, bottom, left, right, thickness, false);
                    break;
                }
                case 169: {
                    ScalableMarkers.drawCircumflex(g, x0, y0, size, half, top, bottom, left, right, thickness, true);
                    break;
                }
                case 170: {
                    ScalableMarkers.drawDollarsign(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 171: {
                    ScalableMarkers.drawRegisteredTrademark(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 172: {
                    ScalableMarkers.drawCopywrite(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 173: {
                    ScalableMarkers.drawSVGCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, null, false);
                    break;
                }
                case 174: {
                    ScalableMarkers.drawSVGCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, edgeColor, true);
                    break;
                }
                case 176: {
                    ScalableMarkers.drawSVGUnion(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 175: {
                    ScalableMarkers.drawSVGTilde(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 178: {
                    ScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 0);
                    break;
                }
                case 179: {
                    ScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 0);
                    break;
                }
                case 180: {
                    ScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 1);
                    break;
                }
                case 181: {
                    ScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 1);
                    break;
                }
                case 182: {
                    ScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 2);
                    break;
                }
                case 183: {
                    ScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 2);
                    break;
                }
                case 184: {
                    ScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, 3);
                    break;
                }
                case 185: {
                    ScalableMarkers.drawSVGTriangle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, 3);
                    break;
                }
                case 177: {
                    ScalableMarkers.drawSVGSquare(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor, skin);
                    break;
                }
                case 186: {
                    ScalableMarkers.drawSVGY(g, x0, y0, size, half, top, bottom, left, right, thickness);
                    break;
                }
                case 187: {
                    ScalableMarkers.drawOutlinedCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, edgeColor);
                    break;
                }
                case 188: {
                    ScalableMarkers.drawOutlinedCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, true, edgeColor);
                }
            }
            if (edgeOn) {
                g.setColor(color);
            }
            if (oldStroke != null) {
                ((Graphics2D)g).setStroke(oldStroke);
            }
        }

        public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0, boolean bold, int weight) {
            ScalableMarkers.draw(g, color, edge, shape, maxSize, x0, y0, bold, weight, null);
        }

        public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0, boolean bold, int weight, Image skin) {
            if (maxSize <= 0) {
                return;
            }
            int thickness = 1;
            if (bold) {
                boolean edgeOn;
                if (color == null) {
                    color = g.getColor();
                }
                boolean bl = edgeOn = edge != null && !edge.equals(color);
                if (ScalableMarkers.isFilled(shape) && !edgeOn) {
                    maxSize = ScalableMarkers.getFilledMarkerSize(shape, maxSize, weight);
                } else {
                    thickness = ScalableMarkers.getOutlineThickness(shape, maxSize, weight);
                }
            }
            ScalableMarkers.draw(g, color, edge, shape, maxSize, x0, y0, thickness, false, skin);
        }

        public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0, boolean bold, int weight, boolean antialiasingOn) {
            ScalableMarkers.draw(g, color, edge, shape, maxSize, x0, y0, bold, weight, antialiasingOn, null);
        }

        public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0, boolean bold, int weight, boolean antialiasingOn, Image skin) {
            if (maxSize <= 0) {
                return;
            }
            int thickness = 1;
            if (bold) {
                boolean edgeOn;
                if (color == null) {
                    color = g.getColor();
                }
                boolean bl = edgeOn = edge != null && !edge.equals(color);
                if (ScalableMarkers.isFilled(shape) && !edgeOn) {
                    maxSize = ScalableMarkers.getFilledMarkerSize(shape, maxSize, weight);
                } else {
                    thickness = ScalableMarkers.getOutlineThickness(shape, maxSize, weight);
                }
            }
            ScalableMarkers.draw(g, color, edge, shape, maxSize, x0, y0, thickness, antialiasingOn, skin);
        }

        public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0) {
            ScalableMarkers.draw(g, color, edge, shape, maxSize, x0, y0, 1, false);
        }

        public static void draw(Graphics g, Color color, Color edge, int shape, int maxSize, int x0, int y0, Image skin) {
            ScalableMarkers.draw(g, color, edge, shape, maxSize, x0, y0, 1, false, skin);
        }

        private static void drawCircle(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor, boolean antialiasingOn) {
            if (size <= 3) {
                g.drawLine(left, y0, x0, bottom);
                g.drawLine(x0, top, right, y0);
            } else if (size <= 11) {
                int d = (size + 1) / 4;
                int[] px = new int[]{left, left + d, right - d, right, right, right - d, left + d, left};
                int[] py = new int[]{top + d, top, top, top + d, bottom - d, bottom, bottom, bottom - d};
                g.drawPolygon(px, py, 8);
            } else if (size > MAX_SIZE) {
                g.drawOval(left, top, size - 1, size - 1);
            } else {
                int i;
                int[] octX = new int[size * 2];
                int[] octY = new int[size * 2];
                int num = ScalableMarkers.getPointsInOctant(0, 0, half, octX, octY);
                Polygon P = new Polygon();
                for (i = 0; i < num - 1; ++i) {
                    P.addPoint(x0 + octX[i], y0 + octY[i]);
                }
                for (i = num - 1; i > 0; --i) {
                    P.addPoint(x0 + octY[i], y0 + octX[i]);
                }
                for (i = 0; i < num - 1; ++i) {
                    P.addPoint(x0 + octY[i], y0 - octX[i]);
                }
                for (i = num - 1; i > 0; --i) {
                    P.addPoint(x0 + octX[i], y0 - octY[i]);
                }
                for (i = 0; i < num - 1; ++i) {
                    P.addPoint(x0 - octX[i], y0 - octY[i]);
                }
                for (i = num - 1; i > 0; --i) {
                    P.addPoint(x0 - octY[i], y0 - octX[i]);
                }
                for (i = 0; i < num - 1; ++i) {
                    P.addPoint(x0 - octY[i], y0 + octX[i]);
                }
                for (i = num - 1; i > 0; --i) {
                    P.addPoint(x0 - octX[i], y0 + octY[i]);
                }
                g.drawPolygon(P);
            }
        }

        private static void drawFilledCircle(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, Color edgeColor, boolean antialiasingOn, Image skin) {
            if (edgeColor != null) {
                antialiasingOn = false;
            }
            if (size <= 3) {
                g.fillRect(left, top, size, size);
            } else if (antialiasingOn) {
                g.fillOval(left, top, size, size);
            } else if (size <= 11) {
                int d = (size + 1) / 4;
                g.fillRect(left + d, top, size - 2 * d, size);
                for (int i = 0; i < d; ++i) {
                    g.drawLine(left + d - 1 - i, top + 1 + i, left + d - 1 - i, bottom - 1 - i);
                    g.drawLine(right - d + 1 + i, top + 1 + i, right - d + 1 + i, bottom - 1 - i);
                }
            } else if (size > MAX_SIZE) {
                g.fillOval(left, top, size - 1, size - 1);
            } else {
                int[] X = new int[half];
                int[] Y = new int[half];
                int x = 0;
                int y = half;
                int d = 1 - half;
                int n = 0;
                boolean hasPoint = false;
                while (y >= x) {
                    if (d <= 0) {
                        d += 2 * x + 3;
                        ++x;
                        hasPoint = true;
                        continue;
                    }
                    X[n] = x;
                    Y[n] = y;
                    ++n;
                    hasPoint = false;
                    d += 2 * (x - y) + 5;
                    ++x;
                    --y;
                }
                if (hasPoint) {
                    X[n] = x;
                    Y[n] = y;
                    ++n;
                }
                x = X[0];
                y = Y[0];
                g.fillRect(x0 - x, top, 2 * x + 1, size);
                int prev_x = x;
                int prev_y = y;
                for (int i = 1; i < n; ++i) {
                    x = X[i];
                    y = Y[i];
                    if (x - prev_x == 1) {
                        g.drawLine(x0 + x, y0 - y, x0 + x, y0 + y);
                        g.drawLine(x0 - x, y0 - y, x0 - x, y0 + y);
                    } else {
                        g.fillRect(x0 + prev_x + 1, y0 - y, x - prev_x, 2 * y + 1);
                        g.fillRect(x0 - x, y0 - y, x - prev_x, 2 * y + 1);
                    }
                    prev_x = x;
                    prev_y = y;
                }
                int lastX = x0 + x;
                for (int i = 0; i < n; ++i) {
                    y = X[i];
                    x = Y[i];
                    if (x0 + x > lastX) {
                        g.drawLine(x0 + x, y0 - y, x0 + x, y0 + y);
                        g.drawLine(x0 - x, y0 - y, x0 - x, y0 + y);
                        continue;
                    }
                    break;
                }
            }
            Markers.drawSkin(g, left, top, size, size, skin);
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, true);
                ScalableMarkers.drawCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, antialiasingOn);
                if (oldStroke != null) {
                    ((Graphics2D)g).setStroke(oldStroke);
                }
            }
        }

        private static void drawOutlinedCircle(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor) {
            if (fillOn) {
                g.fillOval(left, top, size, size);
                if (edgeColor != null || thickness > 1) {
                    Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, true);
                    g.drawOval(left, top, size - 1, size - 1);
                    if (oldStroke != null) {
                        ((Graphics2D)g).setStroke(oldStroke);
                    }
                }
            } else {
                g.drawOval(left, top, size - 1, size - 1);
            }
        }

        private static void drawPlus(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            g.drawLine(left, y0, right, y0);
            g.drawLine(x0, top, x0, bottom);
        }

        private static void drawX(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            g.drawLine(left, top, right, bottom);
            g.drawLine(right, top, left, bottom);
        }

        private static void drawTriangle(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor, int dir) {
            int[] x = new int[4];
            int[] y = new int[4];
            int d = fillOn && edgeColor == null && thickness == 1 ? 1 : 0;
            switch (dir) {
                default: {
                    x[0] = x0;
                    y[0] = top - d;
                    x[1] = left - d;
                    y[1] = bottom + d;
                    x[2] = right + d;
                    y[2] = bottom + d;
                    x[3] = x[0] + 1;
                    y[3] = y[0] + 1;
                    break;
                }
                case 1: {
                    x[0] = x0;
                    y[0] = bottom + d;
                    x[1] = left;
                    y[1] = top;
                    x[2] = right + d;
                    y[2] = top;
                    x[3] = x[0] + 1;
                    y[3] = y[0] - 1;
                    break;
                }
                case 2: {
                    x[0] = left;
                    y[0] = y0;
                    x[1] = right + d;
                    y[1] = top - d;
                    x[2] = right + d;
                    y[2] = bottom + d;
                    x[3] = x[0] + 1;
                    y[3] = y[0] + 1;
                    break;
                }
                case 3: {
                    x[0] = right + d;
                    y[0] = y0;
                    x[1] = left;
                    y[1] = top - d;
                    x[2] = left;
                    y[2] = bottom + d;
                    x[3] = x[0] - 1;
                    y[3] = y[0] + 1;
                }
            }
            if (fillOn) {
                g.fillPolygon(x, y, 4);
                if (edgeColor != null || thickness > 1) {
                    Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, false);
                    if (thickness > 1) {
                        g.drawPolygon(x, y, 3);
                    } else {
                        g.drawPolygon(x, y, 4);
                    }
                    if (oldStroke != null) {
                        ((Graphics2D)g).setStroke(oldStroke);
                    }
                }
            } else if (thickness > 1) {
                g.drawPolygon(x, y, 3);
            } else {
                g.drawPolygon(x, y, 4);
            }
        }

        private static void drawCircumflex(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean down) {
            if (!down) {
                g.drawLine(left, bottom, x0, top);
                g.drawLine(x0, top, right, bottom);
            } else {
                g.drawLine(left, top, x0, bottom);
                g.drawLine(x0, bottom, right, top);
            }
        }

        private static void drawCheckmark(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            g.drawLine(left + half / 2 + 1, top + half / 2, x0, y0);
            g.drawLine(x0, y0, right, top - half / 4);
        }

        private static void drawDollarsign(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            int adj = half / 3;
            g.setFont(FontManager.getFont("Helvetica", 0, half + adj));
            g.drawString("$", x0, y0 + adj);
        }

        private static void drawRegisteredTrademark(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            g.setFont(FontManager.getFont("Helvetica", 1, half - 2));
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D r = fm.getStringBounds("R", g);
            int x = x0 - (int)r.getWidth() / 2;
            y0 -= half / 2;
            size = half;
            if (size % 2 == 0) {
                half = size / 2;
                top = y0 - half;
                left = x0 - half;
            } else {
                half = (size - 1) / 2;
                top = y0 - half;
                left = x0 - half;
            }
            bottom = y0 + half;
            right = x0 + half;
            g.drawString("R", x, y0 + fm.getAscent() - fm.getHeight() / 2);
            ScalableMarkers.drawCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, false);
        }

        private static void drawCopywrite(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            g.setFont(FontManager.getFont("Helvetica", 1, half - 2));
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D r = fm.getStringBounds("C", g);
            int x = x0 - (int)r.getWidth() / 2;
            y0 -= half / 2;
            size = half;
            if (size % 2 == 0) {
                half = size / 2;
                top = y0 - half;
                left = x0 - half;
            } else {
                half = (size - 1) / 2;
                top = y0 - half;
                left = x0 - half;
            }
            bottom = y0 + half;
            right = x0 + half;
            g.drawString("C", x, y0 + fm.getAscent() - fm.getHeight() / 2);
            ScalableMarkers.drawCircle(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null, false);
        }

        private static void drawTilde(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            int bottom_left = bottom - half / 2;
            int top_right = top + half / 2;
            int[] px = null;
            int[] py = null;
            if (size <= 6) {
                px = new int[]{left, x0 - half / 2, x0 + half / 2, right};
                py = new int[]{bottom_left, top, bottom, top_right};
            } else if (size <= 14) {
                int d = (half + 1) / 4;
                px = new int[]{left, left, left + d, x0 - d, x0, x0, x0 + d, right - d, right, right};
                py = new int[]{bottom_left, top + d, top, top, top + d, bottom - d, bottom, bottom, bottom - d, top_right};
            } else {
                int i;
                int r = half / 2;
                int d = half % 2;
                int[] octX = new int[r * 4];
                int[] octY = new int[r * 4];
                int num = ScalableMarkers.getPointsInOctant(0, 0, r, octX, octY);
                int n = 2 * (4 * num - 3);
                px = new int[n += 2];
                py = new int[n];
                n = 0;
                px[n] = left;
                py[n] = bottom_left;
                ++n;
                int x02 = x0 - r;
                int y02 = top + r;
                for (i = 0; i < num - 1; ++i) {
                    px[n] = x02 - octY[i] - d;
                    py[n] = y02 - octX[i];
                    ++n;
                }
                for (i = num - 1; i > 0; --i) {
                    px[n] = x02 - octX[i] - d;
                    py[n] = y02 - octY[i];
                    ++n;
                }
                for (i = 0; i < num - 1; ++i) {
                    px[n] = x02 + octX[i];
                    py[n] = y02 - octY[i];
                    ++n;
                }
                for (i = num - 1; i >= 0; --i) {
                    px[n] = x02 + octY[i];
                    py[n] = y02 - octX[i];
                    ++n;
                }
                x02 = x0 + r;
                y02 = bottom - r;
                for (i = 0; i < num - 1; ++i) {
                    px[n] = x02 - octY[i];
                    py[n] = y02 + octX[i];
                    ++n;
                }
                for (i = num - 1; i > 0; --i) {
                    px[n] = x02 - octX[i];
                    py[n] = y02 + octY[i];
                    ++n;
                }
                for (i = 0; i < num - 1; ++i) {
                    px[n] = x02 + octX[i] + d;
                    py[n] = y02 + octY[i];
                    ++n;
                }
                for (i = num - 1; i >= 0; --i) {
                    px[n] = x02 + octY[i] + d;
                    py[n] = y02 + octX[i];
                    ++n;
                }
                px[n] = right;
                py[n] = top_right;
            }
            g.drawPolyline(px, py, px.length);
        }

        private static void drawIBeam(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            int d = size / 3;
            g.drawLine(x0, top + 1, x0, bottom - 1);
            g.drawLine(x0 - d, top, x0 + d, top);
            g.drawLine(x0 - d, bottom, x0 + d, bottom);
        }

        private static void drawSquare(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor, Image skin) {
            if (fillOn) {
                g.fillRect(left, top, size, size);
                Markers.drawSkin(g, left, top, size, size, skin);
                if (edgeColor != null || thickness > 1) {
                    Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, false);
                    g.drawRect(left, top, size - 1, size - 1);
                    if (oldStroke != null) {
                        ((Graphics2D)g).setStroke(oldStroke);
                    }
                }
            } else {
                Markers.drawSkin(g, left, top, size, size, skin);
                g.drawRect(left, top, size - 1, size - 1);
            }
        }

        private static void drawAsterisk(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            int d = size / 3;
            g.drawLine(x0, top, x0, bottom);
            g.drawLine(left, y0 - d, x0 - 1, y0);
            g.drawLine(left, y0 + d, x0 - 1, y0);
            g.drawLine(right, y0 - d, x0 + 1, y0);
            g.drawLine(right, y0 + d, x0 + 1, y0);
        }

        private static void drawY(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            g.drawLine(x0, y0, x0, bottom);
            g.drawLine(left, top, x0 - 1, y0 - 1);
            g.drawLine(right, top, x0 + 1, y0 - 1);
        }

        private static void drawDiamond(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor) {
            int[] x = new int[4];
            int[] y = new int[4];
            int d = fillOn && edgeColor == null && thickness == 1 ? 1 : 0;
            x[0] = left - d;
            y[0] = y0;
            x[1] = x0;
            y[1] = top - d;
            x[2] = right + d;
            y[2] = y0;
            x[3] = x0;
            y[3] = bottom + d;
            if (fillOn) {
                g.fillPolygon(x, y, 4);
                if (edgeColor != null || thickness > 1) {
                    Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, false);
                    g.drawPolygon(x, y, 4);
                    if (oldStroke != null) {
                        ((Graphics2D)g).setStroke(oldStroke);
                    }
                }
            } else {
                g.drawPolygon(x, y, 4);
            }
        }

        private static void drawZ(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            int[] x = new int[6];
            int[] y = new int[6];
            x[0] = left;
            y[0] = top;
            x[1] = right;
            y[1] = top;
            x[2] = right;
            y[2] = top + 1;
            x[3] = left;
            y[3] = bottom - 1;
            x[4] = left;
            y[4] = bottom;
            x[5] = right;
            y[5] = bottom;
            g.drawPolyline(x, y, 6);
        }

        private static void drawUnion(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            if (size <= 3) {
                g.drawLine(left, top, left, bottom - 1);
                g.drawLine(right, top, right, bottom - 1);
                g.drawLine(x0, bottom, x0, bottom);
                return;
            }
            int r = size / 3;
            int x0_l = left + r;
            int x0_r = right - r;
            int y02 = bottom - r;
            int[] px = null;
            int[] py = null;
            if (size <= 6) {
                px = new int[]{left, left, left + 1, right - 1, right, right};
                py = new int[]{top, bottom - 1, bottom, bottom, bottom - 1, top};
            } else if (size <= 14) {
                int d = (2 * r + 1) / 4;
                px = new int[]{left, left, x0_l - d, x0_l, x0_r, x0_r + d, right, right};
                py = new int[]{top, bottom - r, bottom - d, bottom, bottom, bottom - d, bottom - r, top};
            } else {
                int i;
                int[] octX = new int[r * 4];
                int[] octY = new int[r * 4];
                int num = ScalableMarkers.getPointsInOctant(0, 0, r, octX, octY);
                int n = 2 * (2 * num - 1);
                px = new int[n += 2];
                py = new int[n];
                n = 0;
                px[n] = left;
                py[n] = top;
                ++n;
                for (i = 0; i < num - 1; ++i) {
                    px[n] = x0_l - octY[i];
                    py[n] = y02 + octX[i];
                    ++n;
                }
                for (i = num - 1; i >= 0; --i) {
                    px[n] = x0_l - octX[i];
                    py[n] = y02 + octY[i];
                    ++n;
                }
                for (i = 0; i < num - 1; ++i) {
                    px[n] = x0_r + octX[i];
                    py[n] = y02 + octY[i];
                    ++n;
                }
                for (i = num - 1; i >= 0; --i) {
                    px[n] = x0_r + octY[i];
                    py[n] = y02 + octX[i];
                    ++n;
                }
                px[n] = right;
                py[n] = top;
            }
            g.drawPolyline(px, py, px.length);
        }

        private static void drawHash(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            if (size <= 4) {
                g.drawLine(left, y0, right, y0);
                g.drawLine(x0, top, x0, bottom);
            } else {
                int d = size / 4;
                d = Math.max(d, thickness);
                g.drawLine(left, y0 - d, right, y0 - d);
                g.drawLine(left, y0 + d, right, y0 + d);
                g.drawLine(x0 - d, top, x0 - d, bottom);
                g.drawLine(x0 + d, top, x0 + d, bottom);
            }
        }

        private static void drawTack(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            g.drawLine(left, top, right, top);
            g.drawLine(x0, top + 1, x0, bottom);
        }

        private static void drawHomeDown(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor) {
            if (size > 6) {
                ++bottom;
                ++y0;
            }
            int[] x = new int[5];
            int[] y = new int[5];
            int d = fillOn && edgeColor == null && thickness == 1 ? 1 : 0;
            x[0] = left;
            y[0] = y0;
            x[1] = left;
            y[1] = top;
            x[2] = right + d;
            y[2] = top;
            x[3] = right + d;
            y[3] = y0;
            x[4] = x0;
            y[4] = bottom + d;
            if (fillOn) {
                g.fillPolygon(x, y, 5);
                if (edgeColor != null || thickness > 1) {
                    Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, false);
                    g.drawPolygon(x, y, 5);
                    if (oldStroke != null) {
                        ((Graphics2D)g).setStroke(oldStroke);
                    }
                }
            } else {
                g.drawPolygon(x, y, 5);
            }
        }

        private static void drawGreaterThan(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            int[] x = new int[3];
            int[] y = new int[3];
            x[0] = left;
            y[0] = top;
            x[1] = right;
            y[1] = y0;
            x[2] = left;
            y[2] = bottom;
            g.drawPolyline(x, y, 3);
        }

        private static void drawLessThan(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            int[] x = new int[3];
            int[] y = new int[3];
            x[0] = right;
            y[0] = top;
            x[1] = left;
            y[1] = y0;
            x[2] = right;
            y[2] = bottom;
            g.drawPolyline(x, y, 3);
        }

        private static void drawArrowDown(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            g.drawLine(x0, top, x0, ++bottom - thickness / 2);
            int[] px = new int[]{left, x0, right};
            int[] py = new int[]{++y0, bottom, y0};
            g.drawPolyline(px, py, 3);
        }

        private static void drawStar(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor) {
            boolean aa = false;
            if (g instanceof Graphics2D && ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING) != null) {
                aa = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (size <= 4) {
                g.drawLine(x0, y0 - 1, x0, y0 - 1);
                g.drawLine(x0 - 1, y0, x0 + 1, y0);
                g.drawLine(x0 - 1, y0 + 1, x0 - 1, y0 + 1);
                g.drawLine(x0 + 1, y0 + 1, x0 + 1, y0 + 1);
                return;
            }
            int[] x = new int[10];
            int[] y = new int[10];
            if (size <= 5) {
                x[0] = x0;
                y[0] = top;
                x[1] = x0 + 1;
                y[1] = top + 1;
                x[2] = right;
                y[2] = top + 1;
                x[3] = x0 + 1;
                y[3] = y0 + 1;
                x[4] = x0 + 1;
                y[4] = bottom;
                x[5] = x0;
                y[5] = y0 + 1;
                x[6] = x0 - 1;
                y[6] = bottom;
                x[7] = x0 - 1;
                y[7] = aa ? y0 + 1 : top + 1;
                x[8] = left;
                y[8] = top + 1;
                x[9] = x0 - 1;
                y[9] = top + 1;
            } else {
                double r = half / 2;
                if (size <= 8) {
                    r = 2.0;
                }
                int d = size <= 10 ? 1 : 0;
                int e = size <= 8 ? 1 : 0;
                double sin54 = Math.sin(0.9424777960769379);
                double cos54 = Math.cos(0.9424777960769379);
                double sin18 = Math.sin(0.3141592653589793);
                double cos18 = Math.cos(0.3141592653589793);
                int hsin54 = (int)Math.ceil((double)half * sin54);
                int hcos54 = (int)Math.ceil((double)half * cos54);
                int rsin54 = (int)Math.ceil(r * sin54);
                int rcos54 = (int)Math.ceil(r * cos54);
                int hsin18 = (int)Math.ceil((double)half * sin18);
                int hcos18 = (int)Math.ceil((double)half * cos18);
                int rsin18 = (int)Math.ceil(r * sin18);
                int rcos18 = (int)Math.ceil(r * cos18);
                x[0] = x0;
                y[0] = top - d + e;
                x[1] = x0 + rcos54 - d;
                y[1] = y0 - rsin54 + e;
                x[2] = x0 + hcos18;
                y[2] = y0 - hsin18;
                x[3] = x0 + rcos18 - e;
                y[3] = y0 + rsin18 - d + e;
                x[4] = x0 + hcos54;
                y[4] = y0 + hsin54;
                x[5] = x0;
                y[5] = (int)((double)y0 + r - (double)d);
                x[6] = x0 - hcos54;
                y[6] = y0 + hsin54;
                x[7] = x0 - rcos18 + e;
                y[7] = y0 + rsin18 - d + e;
                x[8] = x0 - hcos18;
                y[8] = y0 - hsin18;
                x[9] = x0 - rcos54 + d;
                y[9] = y0 - rsin54 + e;
            }
            Stroke oldStroke = null;
            if (fillOn) {
                g.fillPolygon(x, y, 10);
                if (edgeColor != null || thickness > 1) {
                    oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, ScalableMarkers.isRound(54, size));
                }
            }
            g.drawPolygon(x, y, 10);
            if (oldStroke != null) {
                ((Graphics2D)g).setStroke(oldStroke);
            }
        }

        private static void drawHexagon(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor) {
            if (size <= 3) {
                g.drawLine(left, y0, x0, bottom);
                g.drawLine(x0, top, right, y0);
                if (fillOn) {
                    g.drawLine(x0, y0, x0, y0);
                }
                return;
            }
            int d = (half + 1) / 2;
            int[] x = new int[6];
            int[] y = new int[6];
            x[0] = left;
            y[0] = y0;
            x[1] = left + d;
            y[1] = top;
            x[2] = right - d;
            y[2] = top;
            x[3] = right;
            y[3] = y0;
            x[4] = right - d;
            y[4] = bottom;
            x[5] = left + d;
            y[5] = bottom;
            if (fillOn) {
                g.fillRect(left + d, top, size - 2 * d, size);
                for (int i = 0; i < d; ++i) {
                    if (y0 - i * 2 > top) {
                        g.drawLine(left + i, y0 - i * 2, left + i, y0 + i * 2);
                        g.drawLine(right - i, y0 - i * 2, right - i, y0 + i * 2);
                        continue;
                    }
                    g.drawLine(left + i, y0 - i * 2 + 1, left + i, y0 + i * 2 - 1);
                    g.drawLine(right - i, y0 - i * 2 + 1, right - i, y0 + i * 2 - 1);
                }
                if (edgeColor != null || thickness > 1) {
                    Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, false);
                    g.drawPolygon(x, y, 6);
                    if (oldStroke != null) {
                        ((Graphics2D)g).setStroke(oldStroke);
                    }
                }
            } else {
                g.drawPolygon(x, y, 6);
            }
        }

        private static void drawOctagon(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor) {
            if (size <= 3) {
                g.drawLine(left, y0, x0, bottom);
                g.drawLine(x0, top, right, y0);
                if (fillOn) {
                    g.drawLine(x0, y0, x0, y0);
                }
                return;
            }
            int d = half / 2;
            int[] x = new int[8];
            int[] y = new int[8];
            x[0] = left;
            y[0] = y0 - d;
            x[1] = x0 - d;
            y[1] = top;
            x[2] = x0 + d;
            y[2] = top;
            x[3] = right;
            y[3] = y0 - d;
            x[4] = right;
            y[4] = y0 + d;
            x[5] = x0 + d;
            y[5] = bottom;
            x[6] = x0 - d;
            y[6] = bottom;
            x[7] = left;
            y[7] = y0 + d;
            if (fillOn) {
                g.fillPolygon(x, y, 8);
                if (edgeColor != null || thickness > 1) {
                    Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, false);
                    g.drawPolygon(x, y, 8);
                    if (oldStroke != null) {
                        ((Graphics2D)g).setStroke(oldStroke);
                    }
                }
            } else {
                g.drawPolygon(x, y, 8);
            }
        }

        private static void drawOctagonRotated(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor) {
            if (size <= 3) {
                g.drawLine(left, y0, x0, bottom);
                g.drawLine(x0, top, right, y0);
                if (fillOn) {
                    g.drawLine(x0, y0, x0, y0);
                }
                return;
            }
            int d = half / 3;
            int[] x = new int[8];
            int[] y = new int[8];
            x[0] = left;
            y[0] = y0;
            x[1] = left + d;
            y[1] = top + d;
            x[2] = x0;
            y[2] = top;
            x[3] = right - d;
            y[3] = top + d;
            x[4] = right;
            y[4] = y0;
            x[5] = right - d;
            y[5] = bottom - d;
            x[6] = x0;
            y[6] = bottom;
            x[7] = left + d;
            y[7] = bottom - d;
            if (fillOn) {
                g.fillPolygon(x, y, 8);
                if (edgeColor != null || thickness > 1) {
                    Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, false);
                    g.drawPolygon(x, y, 8);
                    if (oldStroke != null) {
                        ((Graphics2D)g).setStroke(oldStroke);
                    }
                }
            } else {
                g.drawPolygon(x, y, 8);
            }
        }

        private static void drawPentagon(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor) {
            if (size <= 3) {
                g.drawLine(left, y0, x0, bottom);
                g.drawLine(x0, top, right, y0);
                if (fillOn) {
                    g.drawLine(x0, y0, x0, y0);
                }
                return;
            }
            int d = half / 4;
            int[] x = new int[5];
            int[] y = new int[5];
            x[0] = left;
            y[0] = y0 - d;
            x[1] = x0;
            y[1] = top;
            x[2] = right;
            y[2] = y0 - d;
            x[3] = x0 + (int)(2.5 * (double)d);
            y[3] = bottom;
            x[4] = x0 - (int)(2.5 * (double)d);
            y[4] = bottom;
            if (fillOn) {
                g.fillPolygon(x, y, 5);
                if (edgeColor != null || thickness > 1) {
                    Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, false);
                    g.drawPolygon(x, y, 5);
                    if (oldStroke != null) {
                        ((Graphics2D)g).setStroke(oldStroke);
                    }
                }
            } else {
                g.drawPolygon(x, y, 5);
            }
        }

        private static void drawCross(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor) {
            if (size <= 3) {
                g.drawLine(left, y0, right, y0);
                g.drawLine(x0, top, x0, bottom);
                return;
            }
            int d = (size + 1) / 6;
            int e = (d = Math.max(d, thickness - 1)) == 1 && thickness > 1 ? 1 : 0;
            int[] x = new int[]{left, left, x0 - d, x0 - d, x0 + d + e, x0 + d + e, right + e, right + e, x0 + d + e, x0 + d + e, x0 - d, x0 - d};
            int[] y = new int[]{y0 + d + e, y0 - d, y0 - d, top, top, y0 - d, y0 - d, y0 + d + e, y0 + d + e, bottom + e, bottom + e, y0 + d + e};
            g.drawPolygon(x, y, 12);
        }

        private static void drawFilledCross(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor) {
            if (size <= 3) {
                g.drawLine(left, y0, right, y0);
                g.drawLine(x0, top, x0, bottom);
                return;
            }
            int d = (size + 1) / 6;
            d = Math.max(d, thickness - 1);
            g.fillRect(left, y0 - d, size, 2 * d + 1);
            int size2 = (size - (2 * d + 1)) / 2;
            g.fillRect(x0 - d, top, 2 * d + 1, size2);
            g.fillRect(x0 - d, y0 + d + 1, 2 * d + 1, size2);
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, false);
                ScalableMarkers.drawCross(g, x0, y0, size, half, top, bottom, left, right, thickness, false, null);
                if (oldStroke != null) {
                    ((Graphics2D)g).setStroke(oldStroke);
                }
            }
        }

        private static void drawSVGUnion(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            int r = size / 3;
            g.drawArc(left, bottom - 2 * r, size, r * 2, 180, 180);
            g.drawLine(left, top, left, bottom - r);
            g.drawLine(right, top, right, bottom - r);
        }

        private static void drawSVGCircle(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, Color edgeColor, boolean fill) {
            if (fill) {
                g.fillOval(left, top, size - 1, size - 1);
            } else {
                g.drawOval(left, top, size - 1, size - 1);
            }
            if (edgeColor != null || thickness > 1) {
                Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, true);
                g.drawOval(left, top, size - 1, size - 1);
                if (oldStroke != null) {
                    ((Graphics2D)g).setStroke(oldStroke);
                }
            }
        }

        private static void drawSVGTilde(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            if (size < 5) {
                int bottom_left = bottom - half / 2;
                int top_right = top + half / 2;
                int[] px = new int[]{left, x0 - half / 2, x0 + half / 2, right};
                int[] py = new int[]{bottom_left, top, bottom, top_right};
                g.drawPolyline(px, py, px.length);
            } else {
                int r = half / 2;
                g.drawArc(left, top, half, half, 0, 180);
                g.drawArc(x0, y0, half, half, 180, 180);
                g.drawLine(left, top + r, left, bottom - r);
                g.drawLine(right, top + r, right, bottom - r);
                g.drawLine(x0, top + r, x0, bottom - r);
            }
        }

        private static void drawSVGY(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness) {
            g.drawLine(x0, y0, x0, bottom);
            g.drawLine(left, top, x0, y0);
            g.drawLine(right, top, x0, y0);
        }

        private static void drawSVGSquare(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor, Image skin) {
            if (fillOn) {
                g.fillRect(left, top, size - 1, size - 1);
                Markers.drawSkin(g, left, top, size, size, skin);
                if (edgeColor != null || thickness > 1) {
                    Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, false);
                    g.drawRect(left, top, size - 1, size - 1);
                    if (oldStroke != null) {
                        ((Graphics2D)g).setStroke(oldStroke);
                    }
                }
            } else {
                Markers.drawSkin(g, left, top, size, size, skin);
                g.drawRect(left, top, size - 1, size - 1);
            }
        }

        private static void drawSVGTriangle(Graphics g, int x0, int y0, int size, int half, int top, int bottom, int left, int right, int thickness, boolean fillOn, Color edgeColor, int dir) {
            int[] x = new int[3];
            int[] y = new int[3];
            switch (dir) {
                default: {
                    x[0] = x0;
                    y[0] = top;
                    x[1] = left;
                    y[1] = bottom;
                    x[2] = right;
                    y[2] = bottom;
                    break;
                }
                case 1: {
                    x[0] = x0;
                    y[0] = bottom;
                    x[1] = left;
                    y[1] = top;
                    x[2] = right;
                    y[2] = top;
                    break;
                }
                case 2: {
                    x[0] = left;
                    y[0] = y0;
                    x[1] = right;
                    y[1] = top;
                    x[2] = right;
                    y[2] = bottom;
                    break;
                }
                case 3: {
                    x[0] = right;
                    y[0] = y0;
                    x[1] = left;
                    y[1] = top;
                    x[2] = left;
                    y[2] = bottom;
                }
            }
            if (fillOn) {
                g.fillPolygon(x, y, 3);
                if (edgeColor != null || thickness > 1) {
                    Stroke oldStroke = ScalableMarkers.setOutlineDrawingProperties((Graphics2D)g, edgeColor, thickness, false);
                    g.drawPolygon(x, y, 3);
                    if (oldStroke != null) {
                        ((Graphics2D)g).setStroke(oldStroke);
                    }
                }
            } else {
                g.drawPolygon(x, y, 3);
            }
        }

        private static boolean isFilled(int shape) {
            switch (shape) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 105: 
                case 106: 
                case 108: 
                case 148: 
                case 174: 
                case 177: 
                case 179: 
                case 181: 
                case 183: 
                case 185: 
                case 188: {
                    return true;
                }
            }
            return false;
        }

        private static boolean isRound(int shape, int size) {
            switch (shape) {
                default: {
                    return false;
                }
                case 0: 
                case 16: 
                case 63: 
                case 65: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 187: 
                case 188: {
                    return true;
                }
                case 23: 
                case 54: 
            }
            return size <= 9;
        }

        private static int getAdjustedSize(int shape, int maxSize) {
            int size = maxSize % 2 == 0 ? maxSize - 1 : maxSize;
            int half = size / 2;
            switch (shape) {
                case 23: 
                case 54: {
                    double adj = (double)half * 0.1;
                    size = (int)Math.ceil((double)half / Math.cos(0.3141592653589793) + adj) * 2 + 1;
                    break;
                }
                case 6: 
                case 22: {
                    size = (int)((1.414 * (double)half + (double)half) / 2.0 + 0.5) * 2 + 1;
                    break;
                }
            }
            return size;
        }

        private static int getOutlineThickness(int shape, int maxSize, int weight) {
            double wt;
            switch (shape) {
                case 0: {
                    break;
                }
                case 16: {
                    break;
                }
                case 1: {
                    break;
                }
                case 4: {
                    break;
                }
                case 2: 
                case 5: 
                case 59: 
                case 60: {
                    break;
                }
                case 18: 
                case 21: 
                case 105: 
                case 106: {
                    break;
                }
                case 63: {
                    break;
                }
                case 66: {
                    break;
                }
                case 3: {
                    break;
                }
                case 19: {
                    break;
                }
                case 58: {
                    break;
                }
                case 150: {
                    break;
                }
                case 6: {
                    break;
                }
                case 22: {
                    break;
                }
                case 151: {
                    break;
                }
                case 65: {
                    break;
                }
                case 56: {
                    break;
                }
                case 70: {
                    break;
                }
                case 73: {
                    break;
                }
                case 108: {
                    break;
                }
                case 62: {
                    break;
                }
                case 134: {
                    break;
                }
            }
            switch (weight) {
                default: {
                    wt = (double)maxSize * NORMAL_PERCENT;
                    break;
                }
                case 1: {
                    wt = (double)maxSize * SEMI_BOLD_PERCENT;
                    break;
                }
                case 2: {
                    wt = (double)maxSize * BOLD_PERCENT;
                }
            }
            return Math.max(1, (int)wt);
        }

        private static int getFilledMarkerSize(int shape, int maxSize, int weight) {
            if (ScalableMarkers.isFilled(shape)) {
                int d = maxSize % 2 == 0 ? 0 : 1;
                int wt = ScalableMarkers.getOutlineThickness(shape, maxSize, weight);
                maxSize = shape == 23 ? (maxSize += (int)Math.ceil((double)(wt - 1) / Math.sin(0.6283185307179586))) : (maxSize += wt - 1);
                maxSize = maxSize / 2 * 2 + d;
            }
            return maxSize;
        }

        private static void getPointsInOctant(int x0, int y0, int r, ArrayList X, ArrayList Y) {
            int x = 0;
            int y = r;
            int d = 1 - r;
            X.add(new Integer(x0 + x));
            Y.add(new Integer(y0 + y));
            boolean hasPoint = false;
            while (y > x) {
                if (d <= 0) {
                    d += 2 * x + 3;
                    ++x;
                    hasPoint = true;
                    continue;
                }
                if (hasPoint) {
                    X.add(new Integer(x0 + x));
                    Y.add(new Integer(y0 + y));
                    hasPoint = false;
                }
                d += 2 * (x - y) + 5;
                X.add(new Integer(x0 + ++x));
                Y.add(new Integer(y0 + --y));
            }
            if (hasPoint) {
                X.add(new Integer(x0 + x));
                Y.add(new Integer(y0 + y));
            }
        }

        private static int getPointsInOctant(int x0, int y0, int r, int[] X, int[] Y) {
            int comparator;
            int x = 0;
            int y = r;
            int d = 1 - r;
            int n = 0;
            X[n] = x0 + x;
            Y[n] = y0 + y;
            ++n;
            boolean hasPoint = false;
            int n2 = comparator = r == 16 ? -1 : 0;
            while (y > x) {
                if (d <= comparator) {
                    d += 2 * x + 3;
                    ++x;
                    hasPoint = true;
                    continue;
                }
                if (hasPoint) {
                    X[n] = x0 + x;
                    Y[n] = y0 + y;
                    ++n;
                    hasPoint = false;
                }
                d += 2 * (x - y) + 5;
                X[n] = x0 + ++x;
                Y[n] = y0 + --y;
                ++n;
            }
            if (hasPoint) {
                X[n] = x0 + x;
                Y[n] = y0 + y;
                ++n;
            }
            return n;
        }

        private static Stroke setOutlineDrawingProperties(Graphics2D g, Color color, int thickness, boolean round) {
            if (color != null) {
                g.setColor(color);
            }
            if (thickness <= 1) {
                return null;
            }
            Stroke oldStroke = g.getStroke();
            if (round) {
                g.setStroke(new BasicStroke(thickness, 0, 1));
            } else {
                g.setStroke(new BasicStroke(thickness));
            }
            return oldStroke;
        }

        public static int getMaximumMarkerSize(int markerSize, boolean bold, int weight) {
            int maxSize = markerSize;
            for (int i = 0; i < scalableMarkers.length; ++i) {
                maxSize = Math.max(maxSize, ScalableMarkers.getAdjustedSize(i, markerSize));
            }
            if (!bold) {
                return maxSize;
            }
            int wt = ScalableMarkers.getOutlineThickness(0, markerSize, weight);
            if ((maxSize += wt) % 2 == 0) {
                ++maxSize;
            }
            return maxSize;
        }
    }
}

