/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.nls.l10n.font.TTFontInfo;
import com.sas.nls.l10n.font.TTFontLanguageMapping;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class FontManager {
    private static final String defaultName = "SansSerif";
    private static final int defaultStyle = 0;
    private static final int defaultSize = 12;
    private static Font defaultFont = null;
    private static boolean remapWindowsFonts = false;
    private static Hashtable windowsFontMap = null;
    private static Map localeToAvailableFonts = Collections.synchronizedMap(new HashMap());

    public static synchronized Font getDefaultFont() {
        if (defaultFont == null) {
            defaultFont = FontManager.getFont(defaultName, 0, 12);
        }
        return defaultFont;
    }

    public static Font getFont(Map attributes) {
        Font rc = TTFontLanguageMapping.loadFont((Map)attributes);
        if (rc == null) {
            rc = FontManager.getDefaultFont().deriveFont(attributes);
        }
        return rc;
    }

    public static Font getFont(String name, int style, int size) {
        return FontManager.getFont(new String[]{name}, style, size);
    }

    public static Font getFont(String[] fontNames, int style, int size) {
        return FontManager.getFont(fontNames, style, size, Locale.getDefault());
    }

    public static Font getFont(String[] fontNames, int style, int size, Locale locale) {
        return FontManager.getFont(fontNames, style, size, locale, null);
    }

    public static Font getFont(String[] fontNames, int style, int size, Locale locale, Hashtable lookupTable) {
        if (fontNames == null || fontNames.length == 0) {
            return FontManager.getDefaultFont();
        }
        if (size < 0) {
            size = 12;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ArrayList allFontNames = FontManager.getAvailableFontNames(locale);
        for (int j = 0; j < fontNames.length; ++j) {
            String adjustedFontName = FontManager.adjustFontFamilyName(fontNames[j], locale, lookupTable);
            for (int i = 0; i < allFontNames.size(); ++i) {
                String f = (String)allFontNames.get(i);
                if (!f.equalsIgnoreCase(adjustedFontName)) continue;
                return TTFontLanguageMapping.loadFont((String)f, (int)style, (int)size);
            }
        }
        return FontManager.getDefaultFont().deriveFont(style, size);
    }

    private static ArrayList getAvailableFontNames(Locale locale) {
        ArrayList<String> allFontNames = (ArrayList<String>)localeToAvailableFonts.get(locale);
        if (allFontNames == null) {
            allFontNames = new ArrayList<String>();
            TTFontInfo[] ttinfo = TTFontLanguageMapping.getFontsForLocale((Locale)locale);
            for (int i = 0; i < ttinfo.length; ++i) {
                allFontNames.add(ttinfo[i].getFontName());
            }
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] availableFonts = ge.getAvailableFontFamilyNames(locale);
            for (int i = 0; i < availableFonts.length; ++i) {
                allFontNames.add(availableFonts[i]);
            }
            localeToAvailableFonts.put(locale, allFontNames);
        }
        return allFontNames;
    }

    public static boolean isValidFontFamily(String familyName) {
        return FontManager.isValidFontFamily(familyName, Locale.getDefault());
    }

    public static boolean isValidFontFamily(String familyName, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (FontManager.isFamilyNameDirective(familyName)) {
            return true;
        }
        ArrayList allFontNames = FontManager.getAvailableFontNames(locale);
        for (int i = 0; i < allFontNames.size(); ++i) {
            String f = (String)allFontNames.get(i);
            if (!f.equalsIgnoreCase(familyName)) continue;
            return true;
        }
        return false;
    }

    protected static String adjustFontFamilyName(String name, Locale locale, Hashtable lookupTable) {
        if (FontManager.isFamilyNameDirective(name)) {
            String fontName = name.substring(1, name.length() - 1);
            if (lookupTable != null && lookupTable.containsKey(fontName)) {
                return FontManager.remapWindowsFontName(lookupTable.get(fontName).toString());
            }
            ResourceBundle rb = ResourceBundle.getBundle("com.sas.graphics.util.Resources", locale);
            String familyName = null;
            try {
                familyName = rb.getString(fontName + ".fnt");
            }
            catch (MissingResourceException mre) {
                return FontManager.remapWindowsFontName(fontName);
            }
            if (familyName == null) {
                return FontManager.remapWindowsFontName(fontName);
            }
            return FontManager.remapWindowsFontName(familyName);
        }
        return FontManager.remapWindowsFontName(name);
    }

    public static int adjustFontSize(double pointSize) {
        double factor = 1.3888888888888888;
        if (!GraphicsEnvironment.isHeadless()) {
            factor = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0;
        }
        double adjustedSize = factor * pointSize + 0.5;
        return (int)adjustedSize;
    }

    public static void setRemapWindowsFonts(boolean remap) {
        remapWindowsFonts = remap;
    }

    public static boolean isRemapWindowsFonts() {
        return remapWindowsFonts;
    }

    public static String remapWindowsFontName(String fontName) {
        if (!remapWindowsFonts) {
            return fontName;
        }
        if (windowsFontMap == null) {
            windowsFontMap = new Hashtable();
            windowsFontMap.put("ARIAL", "Albany AMT");
            windowsFontMap.put("TIMES", "Thorndale AMT");
            windowsFontMap.put("TIMES ROMAN", "Thorndale AMT");
            windowsFontMap.put("TIMES NEW ROMAN", "Thorndale AMT");
        }
        if (windowsFontMap.containsKey(fontName.toUpperCase())) {
            return windowsFontMap.get(fontName.toUpperCase()).toString();
        }
        return fontName;
    }

    public static boolean isFamilyNameDirective(String familyName) {
        if (familyName == null) {
            return false;
        }
        String str = familyName.trim();
        return str.startsWith("[") && str.endsWith("]");
    }
}

