/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

public class DateFormatNameConversion {
    private static FormatPair[] nlDate;
    private static FormatPair[] eurDate;
    private static String[] formats;
    private String format;

    private DateFormatNameConversion(String f) {
        this.format = f;
    }

    public static DateFormatNameConversion newDataFormatNameConversion(String format) throws IllegalArgumentException {
        DateFormatNameConversion.initFormatLists();
        String f = DateFormatNameConversion.extractFormatName(format);
        DateFormatNameConversion.validate(f);
        return new DateFormatNameConversion(f);
    }

    public String getFormatName() {
        return this.format;
    }

    public String convertEnglishFormatName(String englishName) throws IllegalArgumentException {
        String f = DateFormatNameConversion.extractFormatName(englishName);
        DateFormatNameConversion.validate(f);
        if (this.format.startsWith("NL")) {
            for (int i = 0; i < nlDate.length; ++i) {
                if (!nlDate[i].getSASFormat().equals(f)) continue;
                return nlDate[i].getI18nFormat();
            }
            throw new IllegalArgumentException();
        }
        if (this.format.startsWith("EUR")) {
            for (int i = 0; i < eurDate.length; ++i) {
                if (!eurDate[i].getSASFormat().equals(f)) continue;
                return eurDate[i].getI18nFormat();
            }
            throw new IllegalArgumentException();
        }
        return englishName;
    }

    public String getEnglishFormatName() {
        block3: {
            block2: {
                if (!this.format.startsWith("NL")) break block2;
                for (int i = 0; i < nlDate.length; ++i) {
                    if (!nlDate[i].getI18nFormat().equals(this.format)) continue;
                    return nlDate[i].getSASFormat();
                }
                break block3;
            }
            if (!this.format.startsWith("EUR")) break block3;
            for (int i = 0; i < eurDate.length; ++i) {
                if (!eurDate[i].getI18nFormat().equals(this.format)) continue;
                return eurDate[i].getSASFormat();
            }
        }
        return this.format;
    }

    private static void validate(String format) throws IllegalArgumentException {
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i].equals(format.trim())) continue;
            return;
        }
        throw new IllegalArgumentException();
    }

    private static void initFormatLists() {
        if (nlDate != null) {
            return;
        }
        nlDate = new FormatPair[]{new FormatPair("NLDATE", "DATE"), new FormatPair("NLDATEMN", "MONNAME"), new FormatPair("NLDATEW", "WEEKDATE"), new FormatPair("NLDATEWN", "DOWNAME"), new FormatPair("NLDATM", "DATETIME"), new FormatPair("NLDATMAP", "DATEAMPM"), new FormatPair("NLDATMTM", "TOD"), new FormatPair("NLDATMW", "DATETIME"), new FormatPair("NLTIMAP", "TIMEAMPM"), new FormatPair("NLTIME", "TIME"), new FormatPair("NLDATEMD", "DATE"), new FormatPair("NLDATMMD", "DTDATE"), new FormatPair("NLDATEYM", "MONYY"), new FormatPair("NLDATMYM", "DTMONYY"), new FormatPair("YEAR", "YEAR"), new FormatPair("DTYEAR", "DTYEAR"), new FormatPair("YYQC", "YYQC"), new FormatPair("DTYYQC", "DTYYQC"), new FormatPair("NLDATMDT", "DTDATE"), new FormatPair("NLDATE", "WEEKDATX"), new FormatPair("NLDATMW", "DTWKDATX")};
        eurDate = new FormatPair[]{new FormatPair("EURDFDD", "DDMMYY"), new FormatPair("EURDFDE", "DATE"), new FormatPair("EURDFDN", "WEEKDAY"), new FormatPair("EURDFDT", "DATETIME"), new FormatPair("EURDFDWN", "DOWNAME"), new FormatPair("EURDFMN", "MONNAME"), new FormatPair("EURDFMY", "MONYY"), new FormatPair("EURDFWDX", "WORDDATX"), new FormatPair("EURDFWKX", "WEEKDATX"), new FormatPair("EURDFDT", "DTMONYY"), new FormatPair("YEAR", "YEAR"), new FormatPair("DTYEAR", "DTYEAR"), new FormatPair("YYQC", "YYQC"), new FormatPair("DTYYQC", "DTYYQC"), new FormatPair("EURDFDT", "DTDATE"), new FormatPair("EURDFDT", "DTWKDATX"), new FormatPair("TIME", "TIME")};
    }

    private static String extractFormatName(String fmtname) {
        if (fmtname == null) {
            return null;
        }
        for (int c = 0; c < fmtname.length(); ++c) {
            if (Character.isLetter(fmtname.charAt(c))) continue;
            return fmtname.substring(0, c).toUpperCase();
        }
        return fmtname.toUpperCase();
    }

    static {
        formats = new String[]{"DATE", "DATETIME", "DAY", "DDMMYY", "DOWNAME", "DTDATE", "DTMONYY", "DTSEMIYEAR", "DTWKDATX", "DTYEAR", "DTYYQC", "HHMM", "HOUR", "JULDAY", "JULIAN", "MMDDYY", "MMDDYYS", "MMSS", "MMYY", "MMYYC", "MMYYD", "MMYYN", "MMYYP", "MMYYS", "MONNAME", "MONTH", "MONYY", "NENGO", "QTR", "QTRR", "TIME", "TIMEAMPM", "TOD", "WEEKDATE", "WEEKDATX", "WEEKDAY", "WORDDATE", "WORDDATX", "YEAR", "YYMM", "YYMMC", "YYMMD", "YYMMDD", "YYMMN", "YYMMP", "YYMMS", "YYMON", "YYQ", "YYQC", "YYQD", "YYQN", "YYQP", "YYQR", "YYQRC", "YYQRD", "YYQRN", "YYQRP", "YYQRS", "YYQS", "EURDFDD", "EURDFDE", "EURDFDN", "EURDFDN", "EURFDT", "EURDFDWN", "EURDFMN", "EURDFMY", "EURDFWDX", "EURDFWKX", "NLDATE", "NLDATEMN", "NLDATEW", "NLDATEW", "NLDATEWN", "NLDATM", "NLDATMAP", "NLDATMTM", "NLDATMW", "NLTIME", "NLTIMAP", "NLDATMDT", "NLDATMYM", "NLDATEYM", "NLDATEMD", "NLDATMMD"};
    }

    private static class FormatPair {
        String sasFormat;
        String i18nFormat;

        public FormatPair(String i18nF, String sasF) {
            this.sasFormat = sasF;
            this.i18nFormat = i18nF;
        }

        public String getSASFormat() {
            return this.sasFormat;
        }

        public String getI18nFormat() {
            return this.i18nFormat;
        }
    }
}

