/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.ColorEditDialog;
import com.sas.graphics.util.ColorPanel;
import com.sas.graphics.util.ColorVertex;
import com.sas.graphics.util.DoublePoint;
import com.sas.graphics.util.ISASPaletteEditorListener;
import com.sas.graphics.util.Palette;
import com.sas.graphics.util.RepresentationPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ColorRampDialog
extends Dialog
implements ActionListener {
    ISASPaletteEditorListener paletteListener = null;
    double min = 0.0;
    double max = 1.0;
    protected Palette palette = null;
    protected Palette oldPalette = null;
    RepresentationPanel repPanel = null;
    protected int selectedPoint = -1;
    protected ColorPanel redPanel;
    protected ColorPanel greenPanel;
    protected ColorPanel bluePanel = null;
    protected ColorEditDialog colorEditDialog = null;
    protected ResourceBundle rb = null;
    protected boolean holdResponse = false;
    protected boolean holdColor = false;
    protected boolean allowAdd = true;
    protected boolean useRBSizing = true;
    boolean fComponentsAdjusted = false;
    Panel rgbPanel;
    Panel layoutRepPanel;
    Label labelMax;
    Label labelMin;
    Label label3;
    Label label4;
    Label label5;
    Checkbox radioButton1;
    CheckboxGroup Group1;
    Checkbox radioButton2;
    Checkbox checkboxLockResponse;
    Checkbox checkboxLockColor;
    Button buttonOK;
    Button buttonCancel;
    Button buttonApply;

    public ColorRampDialog(ResourceBundle rbIn, Frame parent, boolean modal, boolean useSizing) {
        super(parent, modal);
        this.rb = rbIn;
        this.useRBSizing = useSizing;
        this.setLayout(null);
        this.setVisible(false);
        this.setSize(this.getRBSize(this.rb, "ColorRampDialog.size", 480, 270));
        this.setForeground(new Color(0));
        this.setBackground(new Color(0xC0C0C0));
        this.rgbPanel = new Panel();
        this.rgbPanel.setLayout(new BorderLayout(0, 0));
        this.rgbPanel.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.rgbPanel", 101, 36, 210, 160));
        this.rgbPanel.setForeground(new Color(0x808080));
        this.rgbPanel.setBackground(new Color(0x808080));
        this.add(this.rgbPanel);
        this.layoutRepPanel = new Panel();
        this.layoutRepPanel.setLayout(null);
        this.layoutRepPanel.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.layoutRepPanel", 60, 36, 40, 160));
        this.layoutRepPanel.setBackground(new Color(0xFFFFFF));
        this.add(this.layoutRepPanel);
        this.labelMax = new Label(this.GRS(this.rb, "ColorRampDialog.labelMax", "1.0"), 1);
        this.labelMax.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.labelMax", 60, 20, 40, 12));
        this.add(this.labelMax);
        this.labelMin = new Label(this.GRS(this.rb, "ColorRampDialog.labelMin", "0.0"), 1);
        this.labelMin.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.labelMin", 60, 201, 40, 12));
        this.add(this.labelMin);
        this.label3 = new Label(this.GRS(this.rb, "ColorRampDialog.Red", "Red"), 1);
        this.label3.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.Red", 101, 199, 70, 22));
        this.label3.setForeground(new Color(0xFF0000));
        this.add(this.label3);
        this.label4 = new Label(this.GRS(this.rb, "ColorRampDialog.Green", "Green"), 1);
        this.label4.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.Green", 171, 199, 70, 22));
        this.label4.setForeground(new Color(-16744384));
        this.add(this.label4);
        this.label5 = new Label(this.GRS(this.rb, "ColorRampDialog.Blue", "Blue"), 1);
        this.label5.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.Blue", 241, 199, 70, 22));
        this.label5.setForeground(new Color(255));
        this.add(this.label5);
        this.Group1 = new CheckboxGroup();
        this.radioButton1 = new Checkbox(this.GRS(this.rb, "ColorRampDialog.Continuous", "Continuous"), this.Group1, true);
        this.radioButton1.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.radioButtonContinuous", 325, 101, 100, 24));
        this.add(this.radioButton1);
        this.radioButton2 = new Checkbox(this.GRS(this.rb, "ColorRampDialog.Discrete", "Discrete"), this.Group1, false);
        this.radioButton2.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.radioButtonDiscrete", 325, 125, 100, 24));
        this.add(this.radioButton2);
        this.checkboxLockResponse = new Checkbox(this.GRS(this.rb, "ColorRampDialog.Lock_Response", "Lock Response"));
        this.checkboxLockResponse.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.checkboxLockResponse", 325, 156, 140, 18));
        this.add(this.checkboxLockResponse);
        this.checkboxLockColor = new Checkbox(this.GRS(this.rb, "ColorRampDialog.Lock_Color", "Lock Color"));
        this.checkboxLockColor.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.checkboxLockColor", 325, 179, 140, 18));
        this.add(this.checkboxLockColor);
        this.buttonOK = new Button();
        this.buttonOK.setLabel(this.GRS(this.rb, "ColorRampDialog.OK", "OK"));
        this.buttonOK.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.buttonOK", 325, 3, 75, 31));
        this.buttonOK.setBackground(new Color(0xC0C0C0));
        this.add(this.buttonOK);
        this.buttonCancel = new Button();
        this.buttonCancel.setLabel(this.GRS(this.rb, "ColorRampDialog.Cancel", "Cancel"));
        this.buttonCancel.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.buttonCancel", 325, 67, 75, 31));
        this.buttonCancel.setBackground(new Color(0xC0C0C0));
        this.add(this.buttonCancel);
        this.buttonApply = new Button();
        this.buttonApply.setLabel(this.GRS(this.rb, "ColorRampDialog.Apply", "Apply"));
        this.buttonApply.setBounds(this.getRBBounds(this.rb, "ColorRampDialog.buttonApply", 325, 35, 75, 31));
        this.buttonApply.setBackground(new Color(0xC0C0C0));
        this.add(this.buttonApply);
        this.setTitle("");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymItem lSymItem = new SymItem();
        this.radioButton1.addItemListener(lSymItem);
        this.radioButton2.addItemListener(lSymItem);
        this.buttonOK.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.buttonApply.addActionListener(this);
        PanelKeyAdapter panelKeyAdapter = new PanelKeyAdapter();
        this.radioButton1.addKeyListener(panelKeyAdapter);
        this.radioButton2.addKeyListener(panelKeyAdapter);
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
        this.checkboxLockResponse.addItemListener(lSymItem);
        this.checkboxLockColor.addItemListener(lSymItem);
        this.redPanel = new ColorPanel(this, 1);
        this.greenPanel = new ColorPanel(this, 2);
        this.bluePanel = new ColorPanel(this, 4);
        this.resetPanelBounds();
        this.rgbPanel.add((Component)this.redPanel, "West");
        this.rgbPanel.add((Component)this.greenPanel, "Center");
        this.rgbPanel.add((Component)this.bluePanel, "East");
        this.repPanel = new RepresentationPanel(this);
        this.repPanel.setLayout(null);
        this.repPanel.setSize(this.layoutRepPanel.getSize());
        this.repPanel.setBackground(new Color(0));
        this.layoutRepPanel.add(this.repPanel);
        this.palette = new Palette();
        this.oldPalette = new Palette();
        this.repPanel.setPalette(this.palette);
        this.redPanel.setPalette(this.palette);
        this.greenPanel.setPalette(this.palette);
        this.bluePanel.setPalette(this.palette);
        this.syncPanels();
        Container foo = this.getParent();
        while (!(foo instanceof Frame)) {
            foo = foo.getParent();
        }
        Frame frame = (Frame)foo;
        frame.setLocation(400, 400);
        this.colorEditDialog = new ColorEditDialog(this.rb, frame, true);
        this.colorEditDialog.setLocation(400, 400);
    }

    public Palette getPalette() {
        Palette tempPalette = new Palette();
        this.palette.copyInto(tempPalette);
        return tempPalette;
    }

    public void setPalette(Palette newPalette) {
        newPalette.copyInto(this.oldPalette);
        newPalette.copyInto(this.palette);
        this.repPanel.setPalette(this.palette);
        this.redPanel.setPalette(this.palette);
        this.greenPanel.setPalette(this.palette);
        this.bluePanel.setPalette(this.palette);
        this.repPanel.setContinuous(this.palette.getContinuous());
        this.redPanel.setContinuous(this.palette.getContinuous());
        this.greenPanel.setContinuous(this.palette.getContinuous());
        this.bluePanel.setContinuous(this.palette.getContinuous());
        this.syncPanels();
        this.radioButton1.setState(this.palette.getContinuous());
        this.radioButton2.setState(!this.palette.getContinuous());
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public ColorRampDialog(ResourceBundle rbIn, Frame parent, String title, boolean modal) {
        this(rbIn, parent, modal, true);
        this.setTitle(title);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
        } else if (this.colorEditDialog != null) {
            this.colorEditDialog.setVisible(false);
        }
        super.setVisible(b);
    }

    void ColorRampDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    public void resetPanelBounds() {
        this.redPanel.setSize((int)((double)this.rgbPanel.getSize().width / 3.0), this.rgbPanel.getSize().height);
        this.greenPanel.setSize((int)((double)this.rgbPanel.getSize().width / 3.0), this.rgbPanel.getSize().height);
        this.bluePanel.setSize((int)((double)this.rgbPanel.getSize().width / 3.0), this.rgbPanel.getSize().height);
    }

    public void addPoint(DoublePoint point, int mask) {
        if (!this.allowAdd) {
            return;
        }
        int index = -1;
        if (point.y == 0.0 || point.y == 1.0) {
            return;
        }
        Color newColor = this.palette.getValue(point.y);
        switch (mask) {
            case 1: {
                newColor = new Color((float)point.x, (float)newColor.getGreen() / 255.0f, (float)newColor.getBlue() / 255.0f);
                break;
            }
            case 2: {
                newColor = new Color((float)newColor.getRed() / 255.0f, (float)point.x, (float)newColor.getBlue() / 255.0f);
                break;
            }
            case 4: {
                newColor = new Color((float)newColor.getRed() / 255.0f, (float)newColor.getGreen() / 255.0f, (float)point.x);
            }
        }
        this.palette.addEntry(point.y, newColor);
        this.deselectPoint(this.selectedPoint);
    }

    public int selectPoint(int point, int mask) {
        this.selectedPoint = point;
        this.syncPanels();
        return this.selectedPoint;
    }

    public void editPoint(int selected, int mask) {
        if (selected < 0) {
            return;
        }
        ColorVertex tempEntry = this.palette.getEntry(selected);
        this.colorEditDialog.setColor(tempEntry.color);
        this.colorEditDialog.show();
        tempEntry.color = this.colorEditDialog.getColor();
        this.palette.setEntry(selected, tempEntry);
        this.syncPanels();
    }

    public void movePoint(int selected, DoublePoint point, int mask) {
        if (selected < 0) {
            return;
        }
        ColorVertex tempEntry = this.palette.getEntry(selected);
        if (!this.holdResponse) {
            tempEntry.value = point.y;
        }
        if (point.x < 0.0) {
            point.x = 0.0;
        }
        if (point.x > 1.0) {
            point.x = 1.0;
        }
        Color tempColor = tempEntry.color;
        if (!this.holdColor) {
            if (mask == 1) {
                tempEntry.color = new Color((float)point.x, (float)((double)tempColor.getGreen() / 255.0), (float)((double)tempColor.getBlue() / 255.0));
            } else if (mask == 2) {
                tempEntry.color = new Color((float)((double)tempColor.getRed() / 255.0), (float)point.x, (float)((double)tempColor.getBlue() / 255.0));
            } else if (mask == 4) {
                tempEntry.color = new Color((float)((double)tempColor.getRed() / 255.0), (float)((double)tempColor.getGreen() / 255.0), (float)point.x);
            }
        }
        this.palette.setEntry(selected, tempEntry);
        this.syncPanels();
    }

    public void deselectPoint(int selected) {
        this.selectedPoint = -1;
        this.syncPanels();
    }

    public void deleteSelectedPoint(int selected) {
        if (!this.allowAdd) {
            return;
        }
        this.palette.removeEntryAt(selected);
        this.selectedPoint = -1;
        this.syncPanels();
    }

    protected void syncPanels() {
        this.redPanel.setSelectedPoint(this.selectedPoint);
        this.greenPanel.setSelectedPoint(this.selectedPoint);
        this.bluePanel.setSelectedPoint(this.selectedPoint);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.repaintPanels();
    }

    public void drawBorders(Graphics g) {
    }

    protected void drawLeader(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, 61, this.getSize().height);
        if (this.selectedPoint != -1) {
            int y = (int)((1.0 - this.palette.getEntry((int)this.selectedPoint).value) * (double)this.repPanel.getSize().height);
            DecimalFormat decimalFormat = new DecimalFormat("0.000");
            double val = this.palette.getEntry((int)this.selectedPoint).value;
            val = val * (this.max - this.min) + this.min;
            String string = decimalFormat.format(val).toString();
            int height = g.getFontMetrics(g.getFont()).getAscent();
            int width = g.getFontMetrics(g.getFont()).stringWidth(string);
            g.setColor(Color.black);
            g.drawString(string, 5, y + this.layoutRepPanel.getBounds().y + height / 2);
            g.drawLine(50, y + this.layoutRepPanel.getBounds().y, 60, y + this.layoutRepPanel.getBounds().y);
            g.drawLine(57, y + this.layoutRepPanel.getBounds().y - 3, 60, y + this.layoutRepPanel.getBounds().y);
            g.drawLine(57, y + this.layoutRepPanel.getBounds().y + 3, 60, y + this.layoutRepPanel.getBounds().y);
        }
    }

    protected void repaintPanels() {
        this.drawLeader(this.getGraphics());
        this.redPanel.paint(this.redPanel.getGraphics());
        this.greenPanel.paint(this.greenPanel.getGraphics());
        this.bluePanel.paint(this.bluePanel.getGraphics());
        this.repPanel.paint(this.repPanel.getGraphics());
    }

    void radioButton1_ItemStateChanged(ItemEvent event) {
        this.repPanel.setContinuous(this.radioButton1.getState());
        this.redPanel.setContinuous(this.radioButton1.getState());
        this.greenPanel.setContinuous(this.radioButton1.getState());
        this.bluePanel.setContinuous(this.radioButton1.getState());
        this.palette.setContinuous(this.radioButton1.getState());
        this.paint(this.getGraphics());
    }

    void radioButton2_ItemStateChanged(ItemEvent event) {
        this.repPanel.setContinuous(!this.radioButton2.getState());
        this.redPanel.setContinuous(!this.radioButton2.getState());
        this.greenPanel.setContinuous(!this.radioButton2.getState());
        this.bluePanel.setContinuous(!this.radioButton2.getState());
        this.palette.setContinuous(!this.radioButton2.getState());
        this.paint(this.getGraphics());
    }

    void KeyPressed(KeyEvent event) {
        if (event.getKeyCode() == 127) {
            this.deleteSelectedPoint(this.selectedPoint);
            this.repaintPanels();
            this.deselectPoint(this.selectedPoint);
        }
    }

    void missingPanel_MousePressed(MouseEvent event) {
        this.colorEditDialog.setColor(this.palette.getMissingColor());
        this.colorEditDialog.show();
        this.palette.missingColor = this.colorEditDialog.getColor();
        this.repaint();
    }

    void overflowPanel_MousePressed(MouseEvent event) {
        this.colorEditDialog.setColor(this.palette.getOverflowColor());
        this.colorEditDialog.show();
        this.palette.overflowColor = this.colorEditDialog.getColor();
        this.repaint();
    }

    void underflowPanel_MousePressed(MouseEvent event) {
        this.colorEditDialog.setColor(this.palette.getUnderflowColor());
        this.colorEditDialog.show();
        this.palette.underflowColor = this.colorEditDialog.getColor();
        this.repaint();
    }

    void checkboxLockResponse_ItemStateChanged(ItemEvent event) {
        this.holdResponse = this.checkboxLockResponse.getState();
    }

    void checkboxLockColor_ItemStateChanged(ItemEvent event) {
        this.holdColor = this.checkboxLockColor.getState();
    }

    protected void syncComponents() {
        this.radioButton1.setState(this.palette.getContinuous());
        this.radioButton2.setState(!this.palette.getContinuous());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object == this.buttonOK) {
            this.setVisible(false);
        } else if (object == this.buttonCancel) {
            this.oldPalette.copyInto(this.palette);
            this.syncComponents();
            this.syncPanels();
            this.repPanel.setContinuous(this.radioButton1.getState());
            this.redPanel.setContinuous(this.radioButton1.getState());
            this.greenPanel.setContinuous(this.radioButton1.getState());
            this.bluePanel.setContinuous(this.radioButton1.getState());
            this.palette.setContinuous(this.radioButton1.getState());
            this.setVisible(false);
        } else if (object == this.buttonApply && this.paletteListener != null) {
            Palette tempPalette = new Palette();
            this.palette.copyInto(tempPalette);
            this.paletteListener.setPalette(tempPalette);
        }
    }

    public void setPaletteListener(ISASPaletteEditorListener p) {
        this.paletteListener = p;
    }

    public void setMinMax(double minVal, double maxVal) {
        if (this.min < this.max) {
            this.min = minVal;
            this.max = maxVal;
            this.labelMin.setText(new Double(this.min).toString());
            this.labelMax.setText(new Double(this.max).toString());
        }
    }

    protected Color EditColor(Color oldColor) {
        this.colorEditDialog.setColor(oldColor);
        this.colorEditDialog.show();
        return this.colorEditDialog.getColor();
    }

    protected Color EditButtonColor(Button button, Color oldColor) {
        Color newColor = this.EditColor(oldColor);
        button.setBackground(newColor);
        return newColor;
    }

    public void setDiscreteCategorization(boolean val) {
        if (val) {
            this.allowAdd = false;
            this.checkboxLockResponse.setState(true);
            this.holdResponse = true;
            this.checkboxLockResponse.setEnabled(false);
            this.radioButton1.setEnabled(false);
            this.radioButton2.setEnabled(false);
        } else {
            this.allowAdd = true;
            this.checkboxLockResponse.setEnabled(true);
            this.radioButton1.setEnabled(true);
            this.radioButton2.setEnabled(true);
        }
    }

    protected String GRS(ResourceBundle rb, String name, String defStrg) {
        String s = null;
        if (name == null) {
            return defStrg;
        }
        try {
            if (rb != null) {
                s = rb.getString(name);
            }
        }
        catch (MissingResourceException e) {
            s = null;
        }
        if (s == null) {
            s = defStrg;
        }
        return s;
    }

    protected Rectangle getRBBounds(ResourceBundle rb, String name, int x, int y, int width, int height) {
        String s = this.GRS(rb, name + ".bounds", "Empty");
        if (s.equals("Empty") || !this.useRBSizing) {
            return new Rectangle(x, y, width, height);
        }
        try {
            Rectangle rect = new Rectangle();
            int i = s.indexOf(",");
            rect.x = Integer.valueOf(s.substring(0, i));
            if (rect.x == -1) {
                rect.x = x;
            }
            s = s.substring(i + 1);
            i = s.indexOf(",");
            rect.y = Integer.valueOf(s.substring(0, i));
            if (rect.y == -1) {
                rect.y = y;
            }
            s = s.substring(i + 1);
            i = s.indexOf(",");
            rect.width = Integer.valueOf(s.substring(0, i));
            if (rect.width == -1) {
                rect.width = width;
            }
            s = s.substring(i + 1);
            rect.height = Integer.valueOf(s);
            if (rect.height == -1) {
                rect.height = height;
            }
            return rect;
        }
        catch (NumberFormatException e) {
            return new Rectangle(x, y, width, height);
        }
    }

    protected Dimension getRBSize(ResourceBundle rb, String name, int width, int height) {
        String s = this.GRS(rb, name, "Empty");
        if (s.equals("Empty") || !this.useRBSizing) {
            return new Dimension(width, height);
        }
        try {
            Dimension dim = new Dimension();
            int i = s.indexOf(",");
            dim.width = Integer.valueOf(s.substring(0, i));
            if (dim.width == -1) {
                dim.width = width;
            }
            s = s.substring(i + 1);
            dim.height = Integer.valueOf(s);
            if (dim.height == -1) {
                dim.height = height;
            }
            return dim;
        }
        catch (NumberFormatException e) {
            return new Dimension(width, height);
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == ColorRampDialog.this) {
                ColorRampDialog.this.ColorRampDialog_WindowClosing(event);
            }
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == ColorRampDialog.this.radioButton1) {
                ColorRampDialog.this.radioButton1_ItemStateChanged(event);
            } else if (object == ColorRampDialog.this.radioButton2) {
                ColorRampDialog.this.radioButton2_ItemStateChanged(event);
            } else if (object == ColorRampDialog.this.checkboxLockResponse) {
                ColorRampDialog.this.checkboxLockResponse_ItemStateChanged(event);
            } else if (object == ColorRampDialog.this.checkboxLockColor) {
                ColorRampDialog.this.checkboxLockColor_ItemStateChanged(event);
            }
        }
    }

    class PanelKeyAdapter
    extends KeyAdapter {
        PanelKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            Object object = event.getSource();
            ColorRampDialog.this.KeyPressed(event);
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            ColorRampDialog.this.selectedPoint = -1;
            ColorRampDialog.this.redPanel.setSelectedPoint(-1);
            ColorRampDialog.this.bluePanel.setSelectedPoint(-1);
            ColorRampDialog.this.greenPanel.setSelectedPoint(-1);
            ColorRampDialog.this.paint(ColorRampDialog.this.getGraphics());
        }
    }
}

