/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import java.awt.AWTEvent;
import java.awt.Color;

public class ColorEvent
extends AWTEvent {
    public static final int UPDATED = 0;
    Color color;
    float h;
    float s;
    float b;
    boolean hsb = false;

    public ColorEvent(Object source, int id, Color color) {
        super(source, id);
        this.color = color;
    }

    public ColorEvent(Object source, Color color) {
        this(source, 0, color);
    }

    public ColorEvent(Object source, int id, float hue, float sat, float bright) {
        super(source, id);
        this.h = Math.max(0.0f, Math.min(1.0f, hue));
        this.s = Math.max(0.0f, Math.min(1.0f, sat));
        this.b = Math.max(0.0f, Math.min(1.0f, bright));
        this.hsb = true;
    }

    public ColorEvent(Object source, float hue, float sat, float bright) {
        this(source, 0, hue, sat, bright);
    }

    public Color getColor() {
        return this.hsb ? Color.getHSBColor(this.h, this.s, this.b) : this.color;
    }

    public float[] getHSB() {
        float[] fArray;
        if (this.hsb) {
            float[] fArray2 = new float[3];
            fArray2[0] = this.h;
            fArray2[1] = this.s;
            fArray = fArray2;
            fArray2[2] = this.b;
        } else {
            fArray = this.color == null ? null : Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
        }
        return fArray;
    }
}

