/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

public class Barnes74 {
    protected static double square(double x) {
        return x * x;
    }

    protected static boolean zmissn(double[] array, int n) {
        for (int i = 0; i < n; ++i) {
            if (!Double.isNaN(array[i])) continue;
            return true;
        }
        return false;
    }

    protected static int binsrch(double[] list, int size, double val) {
        int h = size - 1;
        int l = 0;
        do {
            int m;
            if (val < list[m = (l + h) / 2]) {
                h = m - 1;
                continue;
            }
            if (val > list[m]) {
                l = m + 1;
                continue;
            }
            return Math.min(m, size - 1);
        } while (h > l);
        if (list[l] >= val && l > 0) {
            --l;
        }
        return l;
    }

    public static int grid(double[] x, double[] y, double[] data, int n, double[] grid, double[] gx, int igx, double[] gy, int igy, int xextra, int yextra, double gamma, double d, double radius, boolean uniform) {
        return Barnes74.grid(x, y, null, data, n, grid, gx, igx, gy, igy, null, 0, xextra, yextra, 0, gamma, d, radius, uniform);
    }

    public static int grid(double[] x, double[] y, double[] z, double[] data, int n, double[] grid, double[] gx, int igx, double[] gy, int igy, double[] gz, int igz, int xextra, int yextra, int zextra, double gamma, double d, double radius, boolean uniform) {
        double dum;
        double weight;
        double w;
        double wgtfun;
        double sumwgt;
        int ix;
        int iy;
        int iz;
        double dist;
        int k;
        int len = 4;
        int xStride = 0;
        int yStride = 0;
        int zStride = 0;
        double avespa = 0.0;
        double zdelta = 0.0;
        double[] q = new double[8];
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        double zzl = 0.0;
        double zzu = 0.0;
        int nobs = 0;
        int count = 0;
        if (n <= 0 || igx <= 0 || igy <= 0 || xextra < 0 || yextra < 0 || gx == null || gy == null || x == null || y == null || data == null || grid == null) {
            return -1;
        }
        if (z == null) {
            igz = 1;
        } else if (igz <= 0 || zextra < 0 || gz == null) {
            return -1;
        }
        int sgx = igx + 2 * xextra;
        int sgy = igy + 2 * yextra;
        int sgz = igz + 2 * zextra;
        double[] grdat1 = new double[sgx * sgy * sgz];
        if (grdat1 == null) {
            return -1;
        }
        if (uniform) {
            dx = gx[xextra + 1] - gx[xextra];
            dy = gy[yextra + 1] - gy[yextra];
            if (z != null && gz != null) {
                dz = gz[zextra + 1] - gz[zextra];
            }
        }
        double xxl = gx[0];
        double xxu = gx[sgx - 1];
        double yyl = gy[0];
        double yyu = gy[sgy - 1];
        if (z != null) {
            zzl = gz[0];
            zzu = gz[sgz - 1];
        }
        xStride = 1;
        yStride = sgx;
        zStride = z == null ? 0 : sgx * sgy;
        double radius_sq = !Double.isNaN(radius) ? (z != null ? radius * (Barnes74.square((xxu - xxl) / 2.0) + Barnes74.square((yyu - yyl) / 2.0) + Barnes74.square((zzu - zzl) / 2.0)) : radius * (Barnes74.square((xxu - xxl) / 2.0) + Barnes74.square((yyu - yyl) / 2.0))) : radius;
        for (k = 0; k < n; ++k) {
            if (Double.isNaN(x[k]) || Double.isNaN(y[k]) || z != null && Double.isNaN(z[k]) || x[k] < xxl || x[k] > xxu || y[k] < yyl || y[k] > yyu || z != null && (z[k] < zzl || z[k] > zzu)) continue;
            ++count;
            for (int l = 0; l < n; ++l) {
                if (Double.isNaN(x[l]) || Double.isNaN(y[l]) || z != null && Double.isNaN(z[l]) || x[l] < xxl || x[l] > xxu || y[l] < yyl || y[l] > yyu || z != null && z[l] < zzl && z[l] > zzu) continue;
                dist = Barnes74.square(x[l] - x[k]) + Barnes74.square(y[l] - y[k]);
                if (z != null) {
                    dist += Barnes74.square(z[l] - z[k]);
                }
                avespa += dist;
                ++nobs;
            }
        }
        if (nobs <= 0) {
            return -1;
        }
        if (avespa == 0.0) {
            return -1;
        }
        avespa = 4.0 * avespa / (double)nobs;
        double cccc = Math.log(d) * avespa / -39.47841760435743;
        double cc4inv = -1.0 / (4.0 * cccc);
        for (iz = 0; iz < sgz; ++iz) {
            for (iy = 0; iy < sgy; ++iy) {
                for (ix = 0; ix < sgx; ++ix) {
                    sumwgt = 0.0;
                    wgtfun = 0.0;
                    for (k = 0; k < n; ++k) {
                        if (Double.isNaN(x[k]) || Double.isNaN(y[k]) || Double.isNaN(data[k]) || z != null && Double.isNaN(z[k]) || x[k] < xxl || x[k] > xxu || y[k] < yyl && y[k] > yyu || z != null && (z[k] < zzl || z[k] > zzu)) continue;
                        dist = Barnes74.square(gx[ix] - x[k]) + Barnes74.square(gy[iy] - y[k]);
                        if (z != null && gz != null) {
                            dist += Barnes74.square(gz[iz] - z[k]);
                        }
                        if (!Double.isNaN(radius_sq) && !(dist <= radius_sq)) continue;
                        w = dist * cc4inv;
                        weight = Math.exp(w);
                        dum = weight * data[k];
                        wgtfun += dum;
                        sumwgt += weight;
                    }
                    grdat1[ix * xStride + iy * yStride + iz * zStride] = sumwgt == 0.0 ? Double.NaN : wgtfun / sumwgt;
                }
            }
        }
        cc4inv = -1.0 / (gamma * 4.0 * cccc);
        for (iz = 0; iz < sgz; ++iz) {
            for (iy = 0; iy < sgy; ++iy) {
                for (ix = 0; ix < sgx; ++ix) {
                    wgtfun = 0.0;
                    sumwgt = 0.0;
                    for (k = 0; k < n; ++k) {
                        int izb;
                        int izf;
                        int iyu;
                        int ixu;
                        int iyl;
                        int ixl;
                        if (Double.isNaN(x[k]) || Double.isNaN(y[k]) || Double.isNaN(data[k]) || z != null && Double.isNaN(z[k]) || x[k] < xxl || x[k] > xxu || y[k] < yyl || y[k] > yyu || z != null && (z[k] < zzl || z[k] > zzu)) continue;
                        dist = Barnes74.square(gx[ix] - x[k]) + Barnes74.square(gy[iy] - y[k]);
                        if (z != null && gz != null) {
                            dist += Barnes74.square(gz[iz] - z[k]);
                        }
                        if (!Double.isNaN(radius_sq) && !(dist <= radius_sq)) continue;
                        w = dist * cc4inv;
                        weight = Math.exp(w);
                        if (uniform) {
                            ixl = (int)((x[k] - gx[0]) / dx);
                            iyl = (int)((y[k] - gy[0]) / dy);
                            ixu = Math.min(ixl + 1, sgx - 1);
                            iyu = Math.min(iyl + 1, sgy - 1);
                            if (z != null) {
                                izf = (int)((z[k] - gz[0]) / dz);
                                izb = Math.min(izf + 1, sgz - 1);
                            } else {
                                izb = 0;
                                izf = 0;
                            }
                        } else {
                            ixl = Barnes74.binsrch(gx, sgx, x[k]);
                            iyl = Barnes74.binsrch(gy, sgy, y[k]);
                            ixu = ixl + 1;
                            iyu = iyl + 1;
                            dx = gx[ixu] - gx[ixl];
                            dy = gy[iyu] - gy[iyl];
                            if (z != null) {
                                izf = Barnes74.binsrch(gz, sgz, z[k]);
                                izb = izf + 1;
                                dz = gz[izb] - gz[izf];
                            } else {
                                izb = 0;
                                izf = 0;
                            }
                        }
                        double xdelta = (x[k] - gx[ixl]) / dx;
                        double ydelta = (y[k] - gy[iyl]) / dy;
                        if (z != null && gz != null) {
                            zdelta = (z[k] - gz[izf]) / dz;
                        }
                        q[0] = grdat1[ixl * xStride + iyl * yStride + izf * zStride];
                        q[1] = grdat1[ixl * xStride + iyu * yStride + izf * zStride];
                        q[2] = grdat1[ixu * xStride + iyu * yStride + izf * zStride];
                        q[3] = grdat1[ixu * xStride + iyl * yStride + izf * zStride];
                        if (z != null) {
                            q[4] = grdat1[ixl * xStride + iyl * yStride + izb * zStride];
                            q[5] = grdat1[ixl * xStride + iyu * yStride + izb * zStride];
                            q[6] = grdat1[ixu * xStride + iyu * yStride + izb * zStride];
                            q[7] = grdat1[ixu * xStride + iyl * yStride + izb * zStride];
                        }
                        if (Barnes74.zmissn(q, len)) continue;
                        double interp = z != null ? q[0] + xdelta * (q[3] - q[0]) + ydelta * (q[1] - q[0]) + zdelta * (q[4] - q[0]) + ydelta * zdelta * (q[5] - q[4] - q[1] + q[0]) + xdelta * ydelta * (q[2] - q[3] - q[1] + q[0]) + xdelta * zdelta * (q[7] - q[4] - q[3] + q[0]) + xdelta * ydelta * zdelta * (q[6] - q[7] - q[2] + q[3] - q[5] + q[4] + q[1] - q[0]) : xdelta * (ydelta * (q[2] - q[3]) - q[3] - (ydelta * (q[1] - q[0]) - q[0])) - (ydelta * (q[1] - q[0]) - q[0]);
                        double err = data[k] - interp;
                        dum = weight * err;
                        wgtfun += dum;
                        sumwgt += weight;
                    }
                    if (z != null) {
                        if (ix < xextra || ix >= igx + xextra || iy < yextra || iy >= igy + yextra || iz < zextra || iz >= igz + zextra) continue;
                        if (Double.isNaN(grdat1[ix * xStride + iy * yStride + iz * zStride]) || sumwgt == 0.0) {
                            grid[(ix - xextra) * xStride + (iy - yextra) * yStride + (iz - zextra) * zStride] = Double.NaN;
                            continue;
                        }
                        grid[(ix - xextra) * xStride + (iy - yextra) * yStride + (iz - zextra) * zStride] = grdat1[ix * xStride + iy * yStride + iz * zStride] + wgtfun / sumwgt;
                        continue;
                    }
                    if (ix < xextra || ix >= igx + xextra || iy < yextra || iy >= igy + yextra) continue;
                    grid[(ix - xextra) * xStride + (iy - yextra) * yStride] = Double.isNaN(grdat1[ix * xStride + iy * yStride]) || sumwgt == 0.0 ? Double.NaN : grdat1[ix * xStride + iy * yStride] + wgtfun / sumwgt;
                }
            }
        }
        grdat1 = null;
        return count;
    }
}

