/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.BasicRangeSliderUI;
import com.sas.graphics.util.RangeSlider;
import com.sas.graphics.util.WindowsRangeSliderUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;

public class AlternateRangeSliderUI
extends BasicRangeSliderUI {
    private Polygon _thumb = new Polygon();

    public AlternateRangeSliderUI(JSlider slider) {
        super(slider);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WindowsRangeSliderUI((RangeSlider)c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this._thumbLarge = 12;
        this._thumbSmall = 9;
    }

    @Override
    public void setThumbSize(int size) {
        this._thumbLarge = size;
        this._thumbLarge = 4 * (this._thumbLarge / 4);
        this._thumbSmall = 3 * this._thumbLarge / 4;
        if (this._thumbSmall % 2 == 0) {
            ++this._thumbSmall;
        }
        this.calculateThumbLocation();
    }

    @Override
    protected boolean onThumb(int x, int y, int i) {
        Rectangle r = (Rectangle)this._thumbRects.get(i);
        int d = Math.max(r.width, r.height) / 4;
        int x0 = r.x;
        int y0 = r.y;
        int x1 = r.x + d;
        int y1 = r.y + d;
        int x2 = r.x + r.width / 2;
        int y2 = r.y + r.height / 2;
        int x3 = r.x + r.width - 1 - d;
        int y3 = r.y + r.height - 1 - d;
        int x4 = r.x + r.width - 1;
        int y4 = r.y + r.height - 1;
        boolean isRange = this.getSlider().getExtent(i / 2) >= 0;
        boolean isHorizontal = this.slider.getOrientation() == 0;
        boolean isInverted = this.drawInverted();
        boolean isValueInclusive = this.getSlider().getValueInclusive(i / 2);
        boolean isExtentInclusive = this.getSlider().getExtentInclusive(i / 2);
        boolean isLeftToRight = this.slider.getComponentOrientation().isLeftToRight();
        this._thumb.reset();
        if (i % 2 == 0) {
            if (isRange) {
                if (isHorizontal) {
                    this._thumb.addPoint(isInverted ? x4 : x0, y4);
                    this._thumb.addPoint(isInverted ? x4 : x0, y3);
                    this._thumb.addPoint(isValueInclusive ? (isInverted ? x4 : x0) : (isInverted ? x3 : x1), y2);
                    this._thumb.addPoint(isInverted ? x4 : x0, y1);
                    this._thumb.addPoint(isInverted ? x4 : x0, y0);
                    this._thumb.addPoint(isInverted ? x3 : x1, y0);
                    this._thumb.addPoint(isInverted ? x0 : x4, y2);
                    this._thumb.addPoint(isInverted ? x3 : x1, y4);
                } else {
                    this._thumb.addPoint(x4, isInverted ? y0 : y4);
                    this._thumb.addPoint(x3, isInverted ? y0 : y4);
                    this._thumb.addPoint(x2, isValueInclusive ? (isInverted ? y0 : y4) : (isInverted ? y1 : y3));
                    this._thumb.addPoint(x1, isInverted ? y0 : y4);
                    this._thumb.addPoint(x0, isInverted ? y0 : y4);
                    this._thumb.addPoint(x0, isInverted ? y1 : y3);
                    this._thumb.addPoint(x2, isInverted ? y4 : y0);
                    this._thumb.addPoint(x4, isInverted ? y1 : y3);
                }
            } else if (isHorizontal) {
                this._thumb.addPoint(x0, y4 - r.width / 2);
                this._thumb.addPoint(x0, y0);
                this._thumb.addPoint(x2, y0);
                this._thumb.addPoint(x4, y0);
                this._thumb.addPoint(x4, y4 - r.width / 2);
                this._thumb.addPoint(x2, y4);
            } else {
                this._thumb.addPoint(isLeftToRight ? x0 : x4, y0);
                this._thumb.addPoint(isLeftToRight ? x4 - r.height / 2 : x0 + r.height / 2, y0);
                this._thumb.addPoint(isLeftToRight ? x4 : x0, y2);
                this._thumb.addPoint(isLeftToRight ? x4 - r.height / 2 : x0 + r.height / 2, y4);
                this._thumb.addPoint(isLeftToRight ? x0 : x4, y4);
                this._thumb.addPoint(isLeftToRight ? x0 : x4, y2);
            }
        } else if (isRange) {
            if (isHorizontal) {
                this._thumb.addPoint(isInverted ? x0 : x4, y4);
                this._thumb.addPoint(isInverted ? x0 : x4, y3);
                this._thumb.addPoint(isExtentInclusive ? (isInverted ? x0 : x4) : (isInverted ? x1 : x3), y2);
                this._thumb.addPoint(isInverted ? x0 : x4, y1);
                this._thumb.addPoint(isInverted ? x0 : x4, y0);
                this._thumb.addPoint(isInverted ? x1 : x3, y0);
                this._thumb.addPoint(isInverted ? x4 : x0, y2);
                this._thumb.addPoint(isInverted ? x1 : x3, y4);
            } else {
                this._thumb.addPoint(x4, isInverted ? y4 : y0);
                this._thumb.addPoint(x3, isInverted ? y4 : y0);
                this._thumb.addPoint(x2, isExtentInclusive ? (isInverted ? y4 : y0) : (isInverted ? y3 : y1));
                this._thumb.addPoint(x1, isInverted ? y4 : y0);
                this._thumb.addPoint(x0, isInverted ? y4 : y0);
                this._thumb.addPoint(x0, isInverted ? y3 : y1);
                this._thumb.addPoint(x2, isInverted ? y0 : y4);
                this._thumb.addPoint(x4, isInverted ? y3 : y1);
            }
        }
        return this._thumb.contains(x, y);
    }

    @Override
    public void paintRange(Graphics g, int i) {
        if (((RangeSlider)this.slider).getExtent(i) < 0) {
            return;
        }
        Rectangle r = this.getRangeRectangle(i);
        int x = r.x;
        int y = r.y;
        int w = r.width;
        int h = r.height;
        boolean focused = 2 * i == this.getValueFocus() && 2 * i + 1 == this.getExtentFocus();
        g.translate(x, y);
        g.setColor(Color.black);
        g.fillRect(0, 0, w, h);
        g.setColor(this.getHighlightColor());
        g.fillRect(1, 1, w - 2, h - 2);
        if (!focused) {
            g.setColor(this.slider.isEnabled() ? this.getThumbColor() : this.getThumbColor().darker());
            g.fillRect(2, 2, w - 3, h - 3);
        }
        g.translate(-x, -y);
    }

    @Override
    public void paintThumbValue(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        int cw = w / 2;
        int ch = h / 2;
        g.setColor(this.slider.isEnabled() ? this.getThumbColor() : this.getThumbColor().darker());
        if (this.slider.getOrientation() == 0) {
            if (focused) {
                g.setColor(this.getHighlightColor());
            }
            g.fillRect(1, 1, w - 2, h - 1 - cw);
            Polygon p = new Polygon();
            p.addPoint(0, h - 1 - cw);
            p.addPoint(w - 1 - cw, h - 1);
            p.addPoint(w - 1, h - 1 - cw);
            g.fillPolygon(p);
            g.setColor(this.getHighlightColor());
            g.drawLine(1, 1, w - 2, 1);
            g.drawLine(1, 1, 1, h - 1 - cw);
            g.setColor(Color.black);
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 0, 0, h - 1 - cw);
            g.drawLine(w - 1, 0, w - 1, h - 1 - cw);
            g.drawLine(w - 1, h - 1 - cw, w - 1 - cw, h - 1);
            g.drawLine(0, h - 1 - cw, w - 1 - cw, h - 1);
        } else if (this.slider.getComponentOrientation().isLeftToRight()) {
            if (focused) {
                g.setColor(this.getHighlightColor());
            }
            g.fillRect(1, 1, w - 1 - ch, h - 2);
            Polygon p = new Polygon();
            p.addPoint(w - 1 - ch, 0);
            p.addPoint(w - 1, h - 1 - ch);
            p.addPoint(w - 1 - ch, h - 1);
            g.fillPolygon(p);
            g.setColor(this.getHighlightColor());
            g.drawLine(1, 1, 1, h - 2);
            g.drawLine(1, 1, w - 1 - ch, 1);
            g.setColor(Color.black);
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(0, 0, w - 1 - ch, 0);
            g.drawLine(0, h - 1, w - 1 - ch, h - 1);
            g.drawLine(w - 1 - ch, 0, w - 1, h - 1 - ch);
            g.drawLine(w - 1 - ch, h - 1, w - 1, h - 1 - ch);
        } else {
            if (focused) {
                g.setColor(this.getHighlightColor());
            }
            g.fillRect(ch, 1, w - 1 - ch, h - 2);
            Polygon p = new Polygon();
            p.addPoint(ch, 0);
            p.addPoint(0, h - 1 - ch);
            p.addPoint(ch, h - 1);
            g.fillPolygon(p);
            g.setColor(this.getHighlightColor());
            g.drawLine(ch, 1, w - 2, 1);
            g.drawLine(1, ch, ch, 1);
            g.setColor(Color.black);
            g.drawLine(ch, 0, w - 1, 0);
            g.drawLine(0, ch, ch, 0);
            g.drawLine(0, ch, ch, h - 1);
            g.drawLine(ch, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 0, w - 1, h - 1);
        }
    }

    @Override
    public void paintThumbValueInclusive(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        int cw = w / 2;
        int ch = h / 2;
        g.setColor(this.slider.isEnabled() ? this.getThumbColor() : this.getThumbColor().darker());
        if (this.slider.getOrientation() == 0) {
            if (inverted) {
                this.paintThumbExtentInclusive(g, i, w, h, focused, false);
            } else {
                if (focused) {
                    g.setColor(this.getHighlightColor());
                }
                for (int j = 1; j < h; ++j) {
                    g.drawLine(1, j, w - 1 - Math.abs(ch - j), j);
                }
                g.setColor(this.getHighlightColor());
                g.drawLine(1, 1, 1, h - 2);
                g.drawLine(1, 1, w - ch, 1);
                g.setColor(Color.black);
                g.drawLine(0, 0, 0, h - 1);
                g.drawLine(0, 0, w - ch, 0);
                g.drawLine(0, h - 1, w - ch, h - 1);
                g.drawLine(w - ch, 0, w - 1, ch - 1);
                g.drawLine(w - ch, h - 1, w - 1, ch);
            }
        } else if (inverted) {
            this.paintThumbExtentInclusive(g, i, w, h, focused, false);
        } else {
            if (focused) {
                g.setColor(this.getHighlightColor());
            }
            for (int j = 1; j < w; ++j) {
                g.drawLine(j, Math.abs(cw - j), j, h - 1);
            }
            g.setColor(this.getHighlightColor());
            g.drawLine(1, h - 2, 1, cw - 1);
            g.drawLine(1, cw - 1, cw - 1, 1);
            g.setColor(Color.black);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(0, h - 1, 0, cw - 1);
            g.drawLine(w - 1, h - 1, w - 1, cw - 1);
            g.drawLine(0, cw - 1, cw - 1, 0);
            g.drawLine(w - 1, cw - 1, cw, 0);
        }
    }

    @Override
    public void paintThumbValueExclusive(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        int cw = w / 2;
        int ch = h / 2;
        int d = Math.max(w, h) / 4;
        g.setColor(this.slider.isEnabled() ? this.getThumbColor() : this.getThumbColor().darker());
        if (this.slider.getOrientation() == 0) {
            if (inverted) {
                this.paintThumbExtentExclusive(g, i, w, h, focused, false);
            } else {
                if (focused) {
                    g.setColor(this.getHighlightColor());
                }
                for (int j = 1; j < h; ++j) {
                    int wj = Math.max(ch - 1 - j, j - ch);
                    g.drawLine(Math.max(1, d - wj), j, w - 1 - wj, j);
                }
                g.setColor(this.getHighlightColor());
                g.drawLine(1, 1, 1, d);
                g.drawLine(1, h - d - 1, 1, h - 2);
                g.drawLine(1, 1, w - ch, 1);
                g.setColor(Color.black);
                g.drawLine(0, 0, 0, d);
                g.drawLine(0, d, d - 1, 2 * d - 1);
                g.drawLine(0, h - d - 1, d - 1, h - 2 * d);
                g.drawLine(0, h - d, 0, h - 1);
                g.drawLine(0, 0, w - ch, 0);
                g.drawLine(0, h - 1, w - ch, h - 1);
                g.drawLine(w - ch, 0, w - 1, ch - 1);
                g.drawLine(w - ch, h - 1, w - 1, ch);
            }
        } else if (inverted) {
            this.paintThumbExtentExclusive(g, i, w, h, focused, false);
        } else {
            if (focused) {
                g.setColor(this.getHighlightColor());
            }
            for (int j = 1; j < w; ++j) {
                int hj = Math.max(cw - 1 - j, j - cw);
                g.drawLine(j, hj, j, Math.min(h - 1, hj + cw));
            }
            g.setColor(this.getHighlightColor());
            g.drawLine(1, h - 2, 1, cw - 1);
            g.drawLine(1, cw - 1, cw - 1, 1);
            g.setColor(Color.black);
            g.drawLine(0, h - 1, d, h - 1);
            g.drawLine(d, h - 1, 2 * d - 1, h - d);
            g.drawLine(w - d - 1, h - 1, w - 2 * d, h - d);
            g.drawLine(w - d, h - 1, w - 1, h - 1);
            g.drawLine(0, h - 1, 0, cw - 1);
            g.drawLine(w - 1, h - 1, w - 1, cw - 1);
            g.drawLine(0, cw - 1, cw - 1, 0);
            g.drawLine(w - 1, cw - 1, cw, 0);
        }
    }

    @Override
    public void paintThumbExtentInclusive(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        int cw = w / 2;
        int ch = h / 2;
        g.setColor(this.slider.isEnabled() ? this.getThumbColor() : this.getThumbColor().darker());
        if (this.slider.getOrientation() == 0) {
            if (inverted) {
                this.paintThumbValueInclusive(g, i, w, h, focused, false);
            } else {
                if (focused) {
                    g.setColor(this.getHighlightColor());
                }
                for (int j = 1; j < h; ++j) {
                    g.drawLine(Math.abs(ch - j), j, w - 1, j);
                }
                g.setColor(this.getHighlightColor());
                g.drawLine(ch, 1, w - 1, 1);
                g.drawLine(1, ch - 1, ch - 1, 1);
                g.setColor(Color.black);
                g.drawLine(w - 1, 0, w - 1, h - 1);
                g.drawLine(ch, 0, w - 1, 0);
                g.drawLine(ch, h - 1, w - 1, h - 1);
                g.drawLine(0, ch - 1, ch - 1, 0);
                g.drawLine(0, ch, ch - 1, h - 1);
            }
        } else if (inverted) {
            this.paintThumbValueInclusive(g, i, w, h, focused, false);
        } else {
            if (focused) {
                g.setColor(this.getHighlightColor());
            }
            for (int j = 1; j < w; ++j) {
                g.drawLine(j, 1, j, h - 1 - Math.abs(cw - j));
            }
            g.setColor(this.getHighlightColor());
            g.drawLine(1, 1, w - 2, 1);
            g.drawLine(1, 1, 1, h - cw);
            g.setColor(Color.black);
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 0, 0, h - cw);
            g.drawLine(w - 1, 0, w - 1, h - cw);
            g.drawLine(0, h - cw, cw - 1, h - 1);
            g.drawLine(w - 1, h - cw, cw, h - 1);
        }
    }

    @Override
    public void paintThumbExtentExclusive(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        int cw = w / 2;
        int ch = h / 2;
        int d = Math.max(w, h) / 4;
        g.setColor(this.slider.isEnabled() ? this.getThumbColor() : this.getThumbColor().darker());
        if (this.slider.getOrientation() == 0) {
            if (inverted) {
                this.paintThumbValueExclusive(g, i, w, h, focused, false);
            } else {
                if (focused) {
                    g.setColor(this.getHighlightColor());
                }
                for (int j = 1; j < h; ++j) {
                    int wj = Math.max(ch - 1 - j, j - ch);
                    g.drawLine(wj, j, Math.min(w - 1, wj + ch), j);
                }
                g.setColor(this.getHighlightColor());
                g.drawLine(w - d - 1, 1, 1, ch - 1);
                g.drawLine(w - d - 1, 1, w - 2, 1);
                g.setColor(Color.black);
                g.drawLine(w - 1, 0, w - 1, d);
                g.drawLine(w - 1, d, w - d, 2 * d - 1);
                g.drawLine(w - 1, h - d - 1, w - d, 2 * d);
                g.drawLine(w - 1, h - d - 1, w - 1, h - 1);
                g.drawLine(w - 1, 0, w - d - 1, 0);
                g.drawLine(w - 1, h - 1, w - d - 1, h - 1);
                g.drawLine(w - d - 1, 0, 0, ch - 1);
                g.drawLine(w - d - 1, h - 1, 0, ch);
            }
        } else if (inverted) {
            this.paintThumbValueExclusive(g, i, w, h, focused, false);
        } else {
            if (focused) {
                g.setColor(this.getHighlightColor());
            }
            for (int j = 1; j < w; ++j) {
                int hj = Math.max(cw - 1 - j, j - cw);
                g.drawLine(j, Math.max(1, d - hj), j, h - 1 - hj);
            }
            g.setColor(this.getHighlightColor());
            g.drawLine(1, 1, 1, d);
            g.drawLine(1, 1, d, 1);
            g.drawLine(w - d - 1, 1, w - 1, 1);
            g.setColor(Color.black);
            g.drawLine(0, 0, d, 0);
            g.drawLine(d, 0, 2 * d - 1, d - 1);
            g.drawLine(w - d - 1, 0, w - 2 * d, d - 1);
            g.drawLine(w - d - 1, 0, w - 1, 0);
            g.drawLine(0, 0, 0, d);
            g.drawLine(w - 1, 0, w - 1, d);
            g.drawLine(0, d, cw - 1, h - 1);
            g.drawLine(w - 1, d, cw, h - 1);
        }
    }
}

