/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.graphics.styles.PredefinedStyles;
import com.sas.graphics.styles.Style;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class StyleCollection {
    private Vector styles = new Vector();
    private Style currentStyle = null;
    private EventListenerList propertyListeners = null;
    public static final String STYLE_ADDED = "styleAdded";
    public static final String STYLE_REMOVED = "styleRemoved";
    public static final String CURRENT_STYLE_CHANGED = "currentStyleChanged";
    public static final String CURRENT_STYLE_CONTENTS_CHANGED = "currentStyleContentsChanged";
    private StyleChangeListener styleChangeListener = null;

    public StyleCollection() {
    }

    public StyleCollection(boolean loadPredefined) {
        if (loadPredefined) {
            this.loadPredefinedStyles(PredefinedStyles.predefinedStyles);
        }
    }

    public StyleCollection(String[] predefinedList) {
        this.loadPredefinedStyles(predefinedList);
    }

    private void loadPredefinedStyles(String[] list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            this.addStyle(PredefinedStyles.getPredefinedStyle(list[i]), null);
        }
    }

    public boolean addStyle(Style s) {
        return this.addStyle(s, null);
    }

    public boolean addStyle(Style s, Object source) {
        if (s == null) {
            return false;
        }
        StyleEntry entry = new StyleEntry();
        entry.style = s;
        entry.source = source;
        for (int i = 0; i < this.styles.size(); ++i) {
            StyleEntry se = (StyleEntry)this.styles.elementAt(i);
            String styleName = se.style.getStyleName();
            String schemeName = se.style.getSchemeName();
            if (styleName == null || !styleName.equals(s.getStyleName()) || schemeName == null || !schemeName.equalsIgnoreCase(s.getSchemeName())) continue;
            this.styles.remove(i);
        }
        this.styles.addElement(entry);
        this.firePropertyChangeEvent(STYLE_ADDED);
        if (this.styles.size() == 1) {
            this.currentStyle = s;
            this.firePropertyChangeEvent(CURRENT_STYLE_CHANGED);
        }
        return true;
    }

    public void removeStyle(String name) {
        for (int i = 0; i < this.styles.size(); ++i) {
            StyleEntry style = (StyleEntry)this.styles.elementAt(i);
            if (!style.style.getDisplayName().equalsIgnoreCase(name) && !style.style.getSchemeName().equalsIgnoreCase(name)) continue;
            this.styles.remove(style);
        }
    }

    public int getNumberStyles() {
        return this.styles.size();
    }

    public Style getStyle(String name) {
        for (int i = 0; i < this.styles.size(); ++i) {
            StyleEntry style = (StyleEntry)this.styles.elementAt(i);
            String displayName = style.style.getDisplayName();
            String schemeName = style.style.getSchemeName();
            String styleName = style.style.getStyleName();
            if (!(displayName != null && displayName.equalsIgnoreCase(name) || schemeName != null && schemeName.equalsIgnoreCase(name)) && (styleName == null || !styleName.equalsIgnoreCase(name))) continue;
            return style.style;
        }
        return null;
    }

    public Style getStyleAt(int i) {
        return ((StyleEntry)this.styles.elementAt((int)i)).style;
    }

    public Object getStyleSource(int i) {
        return ((StyleEntry)this.styles.elementAt((int)i)).source;
    }

    public Style getStyleForSource(Object source) {
        if (source == null) {
            return null;
        }
        for (int i = 0; i < this.styles.size(); ++i) {
            if (!source.equals(this.getStyleSource(i))) continue;
            return this.getStyleAt(i);
        }
        return null;
    }

    public Enumeration styles() {
        Vector<Style> v = new Vector<Style>();
        for (int i = 0; i < this.styles.size(); ++i) {
            v.addElement(((StyleEntry)this.styles.elementAt((int)i)).style);
        }
        return v.elements();
    }

    public Style[] getStyles() {
        Vector<Style> v = new Vector<Style>();
        for (int i = 0; i < this.styles.size(); ++i) {
            v.addElement(((StyleEntry)this.styles.elementAt((int)i)).style);
        }
        Object[] rc = new Style[v.size()];
        v.copyInto(rc);
        return rc;
    }

    public Style getCurrentStyle() {
        return this.currentStyle;
    }

    public boolean contains(Style s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < this.getNumberStyles(); ++i) {
            if (!this.getStyleAt(i).equals(s)) continue;
            return true;
        }
        return false;
    }

    public boolean setCurrentStyle(Style currentStyle) {
        if (!this.contains(currentStyle)) {
            return false;
        }
        if (this.styleChangeListener == null) {
            this.styleChangeListener = new StyleChangeListener();
        } else if (this.currentStyle != null) {
            this.currentStyle.removeStyleChangeListener(this.styleChangeListener);
        }
        this.currentStyle = currentStyle;
        this.currentStyle.addStyleChangeListener(this.styleChangeListener);
        this.firePropertyChangeEvent(CURRENT_STYLE_CHANGED);
        return true;
    }

    public void addChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.propertyListeners == null) {
            this.propertyListeners = new EventListenerList();
        }
        this.propertyListeners.add(PropertyChangeListener.class, listener);
    }

    public void removeChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.propertyListeners == null) {
            return;
        }
        this.propertyListeners.remove(PropertyChangeListener.class, listener);
    }

    private void firePropertyChangeEvent(String event) {
        if (this.propertyListeners == null || this.propertyListeners.getListenerCount() == 0) {
            return;
        }
        PropertyChangeEvent pce = new PropertyChangeEvent(this, event, null, null);
        EventListener[] arr = this.propertyListeners.getListeners(PropertyChangeListener.class);
        for (int i = 0; i < arr.length; ++i) {
            ((PropertyChangeListener)arr[i]).propertyChange(pce);
        }
    }

    class StyleChangeListener
    implements PropertyChangeListener {
        StyleChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            StyleCollection.this.firePropertyChangeEvent(StyleCollection.CURRENT_STYLE_CONTENTS_CHANGED);
        }
    }

    private class StyleEntry {
        Object source = null;
        Style style = null;

        private StyleEntry() {
        }
    }
}

