/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.graphics.styles.AttributeNames;
import com.sas.graphics.styles.Size;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.HTMLColors;
import java.awt.Color;
import org.w3c.dom.Element;

public class ShadowStyleElement
extends StyleElement
implements AttributeNames {
    public ShadowStyleElement(Element styleElement) {
        super(styleElement);
    }

    public Color getShadowColor() {
        return this.getColorAttribute("shadowColor", null);
    }

    public boolean setShadowColor(Color c) {
        String s = HTMLColors.getColorString(c);
        if (s == null) {
            return false;
        }
        return this.setAttribute("shadowColor", s);
    }

    public Size getXOffset() {
        return this.getSizeAttribute("xOffset", null);
    }

    public boolean setXOffset(Size offset) {
        if (offset == null) {
            return false;
        }
        return this.setAttribute("xOffset", offset.toString());
    }

    public Size getYOffset() {
        return this.getSizeAttribute("yOffset", null);
    }

    public boolean setYOffset(Size offset) {
        if (offset == null) {
            return false;
        }
        return this.setAttribute("yOffset", offset.toString());
    }

    @Override
    public Color getDefaultColor() {
        return this.getShadowColor();
    }
}

