/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.graphics.styles.AttributeNames;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.HTMLColors;
import java.awt.Color;
import java.util.Vector;
import org.w3c.dom.Element;

public class RampStyleElement
extends StyleElement
implements AttributeNames {
    public static final Color defaultStartColor = new Color(221, 96, 96);
    public static final Color defaultNeutralColor = new Color(255, 255, 255);
    public static final Color defaultEndColor = new Color(100, 151, 235);

    public RampStyleElement(Element styleElement) {
        super(styleElement);
    }

    public Color getStartColor() {
        return this.getColorAttribute("fillGradientStartColor", defaultStartColor);
    }

    public boolean setStartColor(Color c) {
        String s = HTMLColors.getColorString(c);
        if (s == null) {
            return false;
        }
        return this.setAttribute("fillGradientStartColor", s);
    }

    public Color getNeutralColor() {
        return this.getColorAttribute("fillGradientNeutralColor", defaultNeutralColor);
    }

    public boolean setNeutralColor(Color c) {
        String s = HTMLColors.getColorString(c);
        if (s == null) {
            return false;
        }
        return this.setAttribute("fillGradientNeutralColor", s);
    }

    public Color getEndColor() {
        return this.getColorAttribute("fillGradientEndColor", defaultEndColor);
    }

    public boolean setEndColor(Color c) {
        String s = HTMLColors.getColorString(c);
        if (s == null) {
            return false;
        }
        return this.setAttribute("fillGradientEndColor", s);
    }

    public Color[] getColors() {
        Vector<Color> v = new Vector<Color>();
        if (this.getStartColor() != null) {
            v.addElement(this.getStartColor());
        }
        if (this.getColorAttribute("fillGradientNeutralColor", null) != null) {
            v.addElement(this.getNeutralColor());
        }
        if (this.getEndColor() != null) {
            v.addElement(this.getEndColor());
        }
        Object[] rc = new Color[v.size()];
        v.copyInto(rc);
        return rc;
    }

    public Color[] getThreeColors() {
        Color[] rc = new Color[3];
        rc[0] = this.getStartColor();
        rc[2] = this.getEndColor();
        rc[1] = this.getColorAttribute("fillGradientNeutralColor", null);
        if (rc[1] == null) {
            rc[1] = RampStyleElement.interpolateColor(rc[0], rc[2]);
        }
        return rc;
    }

    public static Color interpolateColor(Color c1, Color c2) {
        if (c1 == null && c2 == null) {
            return Color.black;
        }
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        int r1 = c1.getRed();
        int r2 = c2.getRed();
        int g1 = c1.getGreen();
        int g2 = c2.getGreen();
        int b1 = c1.getBlue();
        int b2 = c2.getBlue();
        int r = RampStyleElement.interploateInt(r1, r2, 0, 255);
        int g = RampStyleElement.interploateInt(g1, g2, 0, 255);
        int b = RampStyleElement.interploateInt(b1, b2, 0, 255);
        return new Color(r, g, b);
    }

    private static int interploateInt(int i1, int i2, int minClamp, int maxClamp) {
        if (i1 > i2) {
            int temp = i2;
            i2 = i1;
            i1 = temp;
        }
        int r = i1 + (i2 - i1) / 2;
        return Math.max(Math.min(maxClamp, r), minClamp);
    }

    @Override
    public Color getDefaultColor() {
        return this.getStartColor();
    }
}

