/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.graphics.styles.AttributeNames;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.Size;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.HTMLColors;
import com.sas.graphics.util.Markers;
import java.awt.Color;
import org.w3c.dom.Element;

public class DataStyleElement
extends StyleElement
implements AttributeNames {
    public static final Color defaultFillColor = new Color(210, 210, 210);
    public static final String defaultFillPattern = "E";
    public static final Color defaultContrastColor = new Color(0, 0, 0);
    public static final int defaultMarkerSymbol = 0;
    public static final int defaultFillType = 0;
    public static final int defaultLineStyle = 1;
    public static final double defaultTransparency = 0.0;
    public static final Size defaultLineThickness = new Size(1, 1);
    public static final Size defaultMarkerSize = new Size(7, 1);
    public static final Color defaultLineColor = Color.BLACK;

    public DataStyleElement(Element styleElement) {
        super(styleElement);
    }

    public Color getFillColor() {
        return this.getColorAttribute("fillColor", this.getColorAttribute("color", defaultFillColor));
    }

    public boolean setFillColor(Color c) {
        if (c == null) {
            return false;
        }
        return this.setAttribute("color", HTMLColors.getColorString(c));
    }

    public Color getContrastColor() {
        return this.getColorAttribute("altColor", defaultContrastColor);
    }

    public boolean setContrastColor(Color c) {
        if (c == null) {
            return false;
        }
        return this.setAttribute("altColor", HTMLColors.getColorString(c));
    }

    public Color getLineColor() {
        return this.getColorAttribute("lineColor", this.getColorAttribute("altColor", defaultLineColor));
    }

    public boolean setLineColor(Color c) {
        String s = HTMLColors.getColorString(c);
        if (s == null) {
            return false;
        }
        return this.setAttribute("lineColor", s);
    }

    public int getMarkerSymbol() {
        if (!this.hasAttribute("markerSymbol")) {
            return 0;
        }
        return Markers.getShape(this.getAttribute("markerSymbol"));
    }

    public boolean setMarkerSymbol(int symbol) {
        return this.setAttribute("markerSymbol", Markers.getShapeName(symbol));
    }

    public int getFillType() {
        if (!this.hasAttribute("fillType")) {
            return 0;
        }
        return FillStyleElement.fillTypeForString(this.getAttribute("fillType"));
    }

    public boolean setFillType(int fillType) {
        String s = FillStyleElement.fillTypeAsString(fillType);
        if (s == null) {
            return false;
        }
        return this.setAttribute("fillType", s);
    }

    public int getLineStyle() {
        return this.getIntegerAttribute("lineStyle", 1);
    }

    public boolean setLineStyle(int style) {
        return this.setAttribute("lineStyle", style + "");
    }

    public double getTransparency() {
        return this.getDoubleAttribute("transparency", 0.0);
    }

    public boolean setTransparency(double trans) {
        return this.setAttribute("transparency", trans + "");
    }

    public Size getLineThickness() {
        return this.getSizeAttribute("lineThickness", defaultLineThickness);
    }

    public boolean setLineThickness(Size thickness) {
        return this.setAttribute("lineThickness", thickness.toString());
    }

    public Size getMarkerSize() {
        return this.getSizeAttribute("markerSize", defaultMarkerSize);
    }

    public boolean setMarkerSize(Size markerSize) {
        return this.setAttribute("markerSize", markerSize.toString());
    }

    @Override
    public Color getDefaultColor() {
        return this.getFillColor();
    }

    public String getFillPattern() {
        return this.getAttribute("fillPattern", defaultFillPattern);
    }

    public boolean setFillPattern(String fillPattern) {
        return this.setAttribute("fillPattern", fillPattern);
    }
}

