/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.image;

import com.sas.graphics.image.Filter;
import java.awt.image.BufferedImage;
import java.awt.image.Kernel;

public class GaussianFilter
extends Filter {
    public static int ZERO_EDGES = 0;
    public static int CLAMP_EDGES = 1;
    public static int WRAP_EDGES = 2;
    protected boolean alpha = true;
    protected boolean premultiplyAlpha = true;
    protected float radiusX;
    protected float radiusY;
    protected Kernel kernelX;
    protected Kernel kernelY;

    public GaussianFilter() {
        this(2.0f, 2.0f);
    }

    public GaussianFilter(float radiusX, float radiusY) {
        this.setRadius(radiusX, radiusY);
    }

    public void setRadius(float radiusX, float radiusY) {
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.kernelX = GaussianFilter.makeKernel(radiusX);
        this.kernelY = radiusY == radiusX ? this.kernelX : GaussianFilter.makeKernel(radiusY);
    }

    public float getRadiusX() {
        return this.radiusX;
    }

    public float getRadiusY() {
        return this.radiusY;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = new BufferedImage(width, height, 2);
        }
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        src.getRGB(0, 0, width, height, inPixels, 0, width);
        if (this.radiusX > 0.0f || this.radiusY > 0.0f) {
            if (this.radiusX > 0.0f) {
                GaussianFilter.convolveAndTranspose(this.kernelX, inPixels, outPixels, width, height, this.alpha, this.alpha && this.premultiplyAlpha, false, CLAMP_EDGES);
            } else {
                GaussianFilter.transpose(inPixels, outPixels, width, height, this.alpha && this.premultiplyAlpha, false);
            }
            if (this.radiusY > 0.0f) {
                GaussianFilter.convolveAndTranspose(this.kernelY, outPixels, inPixels, height, width, this.alpha, false, this.alpha && this.premultiplyAlpha, CLAMP_EDGES);
            } else {
                GaussianFilter.transpose(outPixels, inPixels, height, width, false, this.alpha && this.premultiplyAlpha);
            }
        }
        dst.setRGB(0, 0, width, height, inPixels, 0, width);
        return dst;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst, int xOffset, int yOffset) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = new BufferedImage(width, height, 2);
        }
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        src.getRGB(0, 0, width, height, inPixels, 0, width);
        if (this.radiusX > 0.0f || this.radiusY > 0.0f) {
            if (this.radiusX > 0.0f) {
                GaussianFilter.convolveAndTranspose(this.kernelX, inPixels, outPixels, width, height, this.alpha, this.alpha && this.premultiplyAlpha, false, CLAMP_EDGES, xOffset);
            } else {
                GaussianFilter.transpose(inPixels, outPixels, width, height, this.alpha && this.premultiplyAlpha, false);
            }
            if (this.radiusY > 0.0f) {
                GaussianFilter.convolveAndTranspose(this.kernelY, outPixels, inPixels, height, width, this.alpha, false, this.alpha && this.premultiplyAlpha, CLAMP_EDGES, yOffset);
            } else {
                GaussianFilter.transpose(outPixels, inPixels, height, width, false, this.alpha && this.premultiplyAlpha);
            }
        }
        dst.setRGB(0, 0, width, height, inPixels, 0, width);
        return dst;
    }

    public static void transpose(int[] inPixels, int[] outPixels, int width, int height, boolean premultiply, boolean unpremultiply) {
        for (int y = 0; y < height; ++y) {
            int index = y;
            int ioffset = y * width;
            for (int x = 0; x < width; ++x) {
                if (!premultiply && !unpremultiply) {
                    outPixels[index] = inPixels[ioffset + x];
                } else {
                    int rgb = inPixels[ioffset + x];
                    int a = rgb >> 24 & 0xFF;
                    int r = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int b = rgb & 0xFF;
                    if (premultiply) {
                        float a255 = (float)a * 0.003921569f;
                        r = (int)((float)r * a255);
                        g = (int)((float)g * a255);
                        b = (int)((float)b * a255);
                    }
                    if (unpremultiply) {
                        float f = 255.0f / (float)a;
                        r = (int)((float)r * f);
                        g = (int)((float)g * f);
                        b = (int)((float)b * f);
                    }
                    int ia = GaussianFilter.clamp((int)((double)a + 0.5));
                    int ir = GaussianFilter.clamp((int)((double)r + 0.5));
                    int ig = GaussianFilter.clamp((int)((double)g + 0.5));
                    int ib = GaussianFilter.clamp((int)((double)b + 0.5));
                    outPixels[index] = ia << 24 | ir << 16 | ig << 8 | ib;
                }
                index += height;
            }
        }
    }

    public static void convolveAndTranspose(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha, boolean premultiply, boolean unpremultiply, int edgeAction) {
        float[] matrix = kernel.getKernelData(null);
        int cols = kernel.getWidth();
        int cols2 = cols / 2;
        for (int y = 0; y < height; ++y) {
            int index = y;
            int ioffset = y * width;
            for (int x = 0; x < width; ++x) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                float a = 0.0f;
                int moffset = cols2;
                for (int col = -cols2; col <= cols2; ++col) {
                    float f = matrix[moffset + col];
                    if (f == 0.0f) continue;
                    int ix = x + col;
                    if (ix < 0) {
                        if (edgeAction == CLAMP_EDGES) {
                            ix = 0;
                        } else if (edgeAction == WRAP_EDGES) {
                            ix = (x + width) % width;
                        }
                    } else if (ix >= width) {
                        if (edgeAction == CLAMP_EDGES) {
                            ix = width - 1;
                        } else if (edgeAction == WRAP_EDGES) {
                            ix = (x + width) % width;
                        }
                    }
                    int rgb = inPixels[ioffset + ix];
                    int pa = rgb >> 24 & 0xFF;
                    int pr = rgb >> 16 & 0xFF;
                    int pg = rgb >> 8 & 0xFF;
                    int pb = rgb & 0xFF;
                    if (premultiply) {
                        float a255 = (float)pa * 0.003921569f;
                        pr = (int)((float)pr * a255);
                        pg = (int)((float)pg * a255);
                        pb = (int)((float)pb * a255);
                    }
                    a += f * (float)pa;
                    r += f * (float)pr;
                    g += f * (float)pg;
                    b += f * (float)pb;
                }
                if (unpremultiply && a != 0.0f && a != 255.0f) {
                    float f = 255.0f / a;
                    r *= f;
                    g *= f;
                    b *= f;
                }
                int ia = alpha ? GaussianFilter.clamp((int)((double)a + 0.5)) : 255;
                int ir = GaussianFilter.clamp((int)((double)r + 0.5));
                int ig = GaussianFilter.clamp((int)((double)g + 0.5));
                int ib = GaussianFilter.clamp((int)((double)b + 0.5));
                outPixels[index] = ia << 24 | ir << 16 | ig << 8 | ib;
                index += height;
            }
        }
    }

    public static void convolveAndTranspose(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, boolean alpha, boolean premultiply, boolean unpremultiply, int edgeAction, int direction) {
        float[] matrix = kernel.getKernelData(null);
        int cols = kernel.getWidth();
        int cols2 = cols / 2;
        for (int y = 0; y < height; ++y) {
            int a;
            int rgb;
            int x;
            int index = y;
            int ioffset = y * width;
            int edge1 = width - 1;
            int edge2 = 0;
            if (direction == 0) {
                edge1 = 0;
                edge2 = width - 1;
            } else if (direction > 0) {
                for (x = 0; x < width; ++x) {
                    rgb = inPixels[ioffset + x];
                    a = rgb >> 24 & 0xFF;
                    if (a == 0) continue;
                    edge1 = x;
                    break;
                }
                edge2 = width - 1;
            } else {
                for (x = width - 1; x >= 0; --x) {
                    rgb = inPixels[ioffset + x];
                    a = rgb >> 24 & 0xFF;
                    if (a == 0) continue;
                    edge2 = x;
                    break;
                }
                edge1 = 0;
            }
            index += edge1 * height;
            for (x = edge1; x <= edge2; ++x) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                float a2 = 0.0f;
                int moffset = cols2;
                for (int col = -cols2; col <= cols2; ++col) {
                    float f = matrix[moffset + col];
                    if (f == 0.0f) continue;
                    int ix = x + col;
                    if (ix < edge1) {
                        if (edgeAction == CLAMP_EDGES) {
                            ix = edge1;
                        } else if (edgeAction == WRAP_EDGES) {
                            ix = (x + width) % width;
                        }
                    } else if (ix > edge2) {
                        if (edgeAction == CLAMP_EDGES) {
                            ix = edge2;
                        } else if (edgeAction == WRAP_EDGES) {
                            ix = (x + width) % width;
                        }
                    }
                    int rgb2 = inPixels[ioffset + ix];
                    int pa = rgb2 >> 24 & 0xFF;
                    int pr = rgb2 >> 16 & 0xFF;
                    int pg = rgb2 >> 8 & 0xFF;
                    int pb = rgb2 & 0xFF;
                    if (premultiply) {
                        float a255 = (float)pa * 0.003921569f;
                        pr = (int)((float)pr * a255);
                        pg = (int)((float)pg * a255);
                        pb = (int)((float)pb * a255);
                    }
                    a2 += f * (float)pa;
                    r += f * (float)pr;
                    g += f * (float)pg;
                    b += f * (float)pb;
                }
                if (unpremultiply && a2 != 0.0f && a2 != 255.0f) {
                    float f = 255.0f / a2;
                    r *= f;
                    g *= f;
                    b *= f;
                }
                int ia = alpha ? GaussianFilter.clamp((int)((double)a2 + 0.5)) : 255;
                int ir = GaussianFilter.clamp((int)((double)r + 0.5));
                int ig = GaussianFilter.clamp((int)((double)g + 0.5));
                int ib = GaussianFilter.clamp((int)((double)b + 0.5));
                outPixels[index] = ia << 24 | ir << 16 | ig << 8 | ib;
                index += height;
            }
        }
    }

    public static void convolveAndTranspose(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height, int edgeAction) {
        float[] matrix = kernel.getKernelData(null);
        int cols = kernel.getWidth();
        int cols2 = cols / 2;
        for (int y = 0; y < height; ++y) {
            int index = y;
            int ioffset = y * width;
            for (int x = 0; x < width; ++x) {
                float a = 0.0f;
                int moffset = cols2;
                for (int col = -cols2; col <= cols2; ++col) {
                    float f = matrix[moffset + col];
                    if (f == 0.0f) continue;
                    int ix = x + col;
                    if (ix < 0) {
                        if (edgeAction == CLAMP_EDGES) {
                            ix = 0;
                        } else if (edgeAction == WRAP_EDGES) {
                            ix = (x + width) % width;
                        }
                    } else if (ix >= width) {
                        if (edgeAction == CLAMP_EDGES) {
                            ix = width - 1;
                        } else if (edgeAction == WRAP_EDGES) {
                            ix = (x + width) % width;
                        }
                    }
                    int rgb = inPixels[ioffset + ix];
                    int pa = rgb >> 24 & 0xFF;
                    a += f * (float)pa;
                }
                int ia = GaussianFilter.clamp((int)((double)a + 0.5));
                int rgb = inPixels[ioffset + x];
                int ir = rgb >> 16 & 0xFF;
                int ig = rgb >> 8 & 0xFF;
                int ib = rgb & 0xFF;
                outPixels[index] = ia << 24 | ir << 16 | ig << 8 | ib;
                index += height;
            }
        }
    }

    public static Kernel makeKernel(float radius) {
        int x;
        int width = (int)Math.ceil(radius);
        int rows = width * 2 + 1;
        float[] matrix = new float[rows];
        float sigma = radius / 3.0f;
        float coeff = 2.0f * sigma * sigma;
        float total = 0.0f;
        int idx = 0;
        for (x = -width; x <= width; ++x) {
            matrix[idx] = (float)(Math.exp((float)(-x * x) / coeff) / Math.sqrt(Math.PI * (double)coeff));
            total += matrix[idx];
            ++idx;
        }
        for (x = 0; x <= 2 * width; ++x) {
            matrix[x] = matrix[x] / total;
        }
        return new Kernel(rows, 1, matrix);
    }

    public static int clamp(int c) {
        if (c < 0) {
            return 0;
        }
        if (c > 255) {
            return 255;
        }
        return c;
    }

    public String toString() {
        return "Blur/Gaussian Blur...";
    }
}

