/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webapp;

import com.sas.services.ServiceException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.security.CredentialLoginServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import java.rmi.RemoteException;
import java.util.List;

public class SessionHelper {
    private UserIdentityInterface _successfulCredential = null;
    private SessionContextInterface _sessionContext = null;

    public UserIdentityInterface getSuccessfulCredential() {
        return this._successfulCredential;
    }

    public SessionContextInterface getSessionContext() {
        return this._sessionContext;
    }

    void setSessionContext(SessionContextInterface session) {
        this._sessionContext = session;
    }

    private SessionContextInterface newSession(String userid, String password, String domain, UserServiceInterface userService, SessionServiceInterface sessionService) throws ServiceException, RemoteException {
        SessionContextInterface sessionContext;
        UserContextInterface userContext = null;
        try {
            userContext = userService.newUser(userid, password, domain);
        }
        catch (UserInitializationException uie) {
            userContext = uie.getUser();
        }
        this._sessionContext = sessionContext = sessionService.newSessionContext(userContext);
        return sessionContext;
    }

    public SessionContextInterface newSession(SessionContextInterface sourceSession, UserServiceInterface userService, SessionServiceInterface sessionService, InformationServiceInterface infoService) throws ServiceException, RemoteException {
        if (infoService != null) {
            // empty if block
        }
        return this.newSession(sourceSession, userService, sessionService);
    }

    public SessionContextInterface newSession(SessionContextInterface sourceSession, UserServiceInterface userService, SessionServiceInterface sessionService) throws ServiceException, RemoteException {
        SessionContextInterface rval = null;
        UserContextInterface sourceUser = sourceSession.getUserContext();
        List identities = sourceUser.getIdentities();
        if (identities == null || identities.isEmpty()) {
            throw new IllegalArgumentException("Source session to 'copy' is invalid, it has no 'identities'");
        }
        UserIdentityInterface identity = (UserIdentityInterface)identities.get(0);
        String domain = identity.getDomain();
        UserIdentityInterface identityByDomain = sourceUser.getIdentityByDomain(domain);
        String userId = (String)identityByDomain.getPrincipal();
        String password = (String)identityByDomain.getCredential();
        ServiceException cachedException = null;
        try {
            rval = this.newSession(userId, password, domain, userService, sessionService);
            this._successfulCredential = identity;
        }
        catch (ServiceException e) {
            cachedException = e;
        }
        if (rval == null) {
            if (cachedException == null) {
                cachedException = new CredentialLoginServiceException("Inter-application transfer could not locate a logon credential");
            }
            throw cachedException;
        }
        return rval;
    }
}

