/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webapp;

import com.sas.services.webapp.res.RB;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertyReader {
    private static final String RB_MISSING_SYSTEM_PROPERTY_FILE = "missing_system_property_file.fmt.txt";
    private static final String RB_PROPERTY_ALREADY_SET = "property_already_set.fmt.txt";
    private static final String RB_PROPERTY_SET_VALUE = "property_set_value.fmt.txt";
    private static final String RB_PROPERTY_IGNORED_VALUE = "property_ignored_value.fmt.txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean setSystemProps(String propsFile) {
        boolean retval = false;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(propsFile));
            String s = "";
            while ((s = in.readLine()) != null) {
                if (s.trim().startsWith("#") || s.trim().equals("")) continue;
                String name = null;
                String value = "";
                try {
                    StringTokenizer st = new StringTokenizer(s, "=");
                    name = st.nextToken();
                    value = PropertyReader.formatPath(st.nextToken());
                    if (PropertyReader.isPropertySet(name, value)) continue;
                    System.setProperty(name, value);
                }
                catch (NoSuchElementException ne) {
                    if (name == null) continue;
                    System.setProperty(name, value);
                }
            }
            retval = true;
        }
        catch (IOException ioe) {
            try {
                System.err.println(MessageFormat.format(RB.getStringResource(RB_MISSING_SYSTEM_PROPERTY_FILE), propsFile));
            }
            catch (MissingResourceException mre) {
                System.err.println(mre.getMessage());
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
            }
        }
        return retval;
    }

    public static void listSystemProperties() {
        Properties sProps = System.getProperties();
        Enumeration<?> i = sProps.propertyNames();
        while (i.hasMoreElements()) {
            String name = (String)i.nextElement();
            String value = sProps.getProperty(name);
            System.out.println(name + ":" + value);
        }
    }

    public static String formatPath(String value) {
        value = value.replaceAll("\\\\", "~~");
        value = value.replaceAll("~~~~", "/");
        value = value.replaceAll("~~", "/");
        if ((value = value.replaceFirst("file:////", "file:///")).startsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    private static boolean isPropertySet(String name, String value) {
        String setValue = System.getProperty(name);
        if (setValue != null) {
            setValue = PropertyReader.formatPath(setValue);
        }
        if (setValue != null && !setValue.equals(value)) {
            try {
                System.out.println("\n" + MessageFormat.format(RB.getStringResource(RB_PROPERTY_ALREADY_SET), name));
                System.out.println(MessageFormat.format(RB.getStringResource(RB_PROPERTY_SET_VALUE), setValue));
                System.out.println(MessageFormat.format(RB.getStringResource(RB_PROPERTY_IGNORED_VALUE), value));
            }
            catch (MissingResourceException mre) {
                System.err.println(mre.getMessage());
            }
        }
        return setValue != null;
    }
}

