/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractToolImpl;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.metadata.mgmt.MetadataManager;
import com.sas.metadata.mgmt.MetadataManagerFactory;
import com.sas.metadata.remote.MdFactory;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.session.SessionContextInterface;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifyMetadataFiles
extends AbstractToolImpl {
    private static final WAdminResource bundle = new WAdminResource(VerifyMetadataFiles.class);
    private static final String TOOLNAME = bundle.getString("VerifyMetadataFiles.tool.name");
    private static final String TOOLDESCRIPTION = bundle.getString("VerifyMetadataFiles.tool.desc");
    private static final String TOOLMNEMONIC = "Files";
    static AnalyzeTool _factoryInstance;
    private String _datasetErrors = null;
    private String _datasetRepairs = null;
    private String _datasetWarnings = null;

    public static AnalyzeTool getInstance() {
        if (_factoryInstance == null) {
            _factoryInstance = new VerifyMetadataFiles(null, null);
        }
        return _factoryInstance;
    }

    private VerifyMetadataFiles(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalyzeTool newInstance(OMIRepositoryInterface repository, Logger log) {
        VerifyMetadataFiles newObject = new VerifyMetadataFiles(repository, log);
        return newObject;
    }

    @Override
    public String getDescription() {
        return TOOLDESCRIPTION;
    }

    @Override
    public String getMnemonic() {
        return TOOLMNEMONIC;
    }

    @Override
    public String getName() {
        return TOOLNAME;
    }

    @Override
    public String getGroup() {
        return "Physical";
    }

    @Override
    public boolean isRepairSupported() {
        return true;
    }

    @Override
    public void analyze() throws ServiceException {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        try {
            StringBuffer inXMLBuffer = new StringBuffer();
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.Analyze.Open.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.Metadata.Analyze.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.ReposId.Open.notrans"));
            inXMLBuffer.append(this._repository.getDefaultRepositoryId());
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.ReposId.Close.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.Flags.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.Namespace.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.Options.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.Analyze.Close.notrans"));
            String inXML = inXMLBuffer.toString();
            this._log.debug(inXML);
            MdFactory factory = ((OMIServer)this._repository.getServer()).getMdFactory();
            SessionContextInterface session = ((OMIServer)this._repository.getServer()).getUserContext().getSessionContext();
            MetadataManager m_metadataManager = session != null ? MetadataManagerFactory.getMetadataManager((SessionContextInterface)session) : MetadataManagerFactory.getMetadataManager((MdFactory)factory);
            Document mainDoc = m_metadataManager.doRequestWithExclusiveServerLock(inXML);
            if (mainDoc != null) {
                Node attrNode;
                NamedNodeMap attrNodeMap;
                String childName;
                Node childNode;
                int j;
                NodeList nodeList = mainDoc.getElementsByTagName("Metadata");
                Node node = nodeList.item(0);
                NodeList childList = node.getChildNodes();
                for (j = 0; j < childList.getLength(); ++j) {
                    childNode = childList.item(j);
                    childName = childNode.getNodeName();
                    if (!childName.equalsIgnoreCase("Statistics")) continue;
                    attrNodeMap = childNode.getAttributes();
                    attrNode = attrNodeMap.getNamedItem("Errors");
                    this._datasetErrors = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Warnings");
                    this._datasetWarnings = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Repairs");
                    this._datasetRepairs = attrNode.getNodeValue();
                }
                nodeList = mainDoc.getElementsByTagName("OmiWarnings");
                if (nodeList != null && nodeList.getLength() > 0) {
                    node = nodeList.item(0);
                    childList = node.getChildNodes();
                    for (j = 0; j < childList.getLength(); ++j) {
                        childNode = childList.item(j);
                        childName = childNode.getNodeName();
                        if (!childName.equalsIgnoreCase("Warning")) continue;
                        attrNodeMap = childNode.getAttributes();
                        attrNode = attrNodeMap.getNamedItem("Name");
                        String severity = attrNode.getNodeValue();
                        attrNode = attrNodeMap.getNamedItem("Desc");
                        String text = attrNode.getNodeValue();
                        if (severity.equals("ERROR")) {
                            this._log.error(text);
                            continue;
                        }
                        if (severity.equals("WARN")) {
                            this._log.warn(text);
                            continue;
                        }
                        if (!severity.equals("INFO") || text.indexOf("OpenRepository") >= 0 || text.indexOf("CloseRepository") >= 0) continue;
                        this._log.info(text);
                    }
                }
            }
            if (this._datasetErrors.equalsIgnoreCase("0") && this._datasetWarnings.equalsIgnoreCase("0")) {
                this._log.info(bundle.formatString("VerifyMetadataFiles.Analyze.NoCandidates.txt", (Object)this._repository.getDefaultRepositoryName()));
                this._rc = 0;
                this._isRepairNeeded = false;
            } else {
                if (this._datasetErrors.equalsIgnoreCase("0")) {
                    this._log.warn(bundle.formatString("VerifyMetadataFiles.Analyze.CandidatesFound.txt", (Object)this._datasetErrors, (Object)this._datasetWarnings, (Object)this._datasetRepairs, (Object)this._repository.getDefaultRepositoryName()));
                    this._rc = 2;
                } else {
                    this._log.error(bundle.formatString("VerifyMetadataFiles.Analyze.CandidatesFound.txt", (Object)this._datasetErrors, (Object)this._datasetWarnings, (Object)this._datasetRepairs, (Object)this._repository.getDefaultRepositoryName()));
                    this._log.error(bundle.formatString("VerifyMetadataFiles.Analyze.FatalErrorsFound.txt", (Object)this._repository.getDefaultRepositoryName()));
                    this._rc = 16;
                }
                this._isRepairNeeded = true;
            }
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (DOMException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void repair() throws ServiceException {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        if (this._rc == -1) {
            this.analyze();
        }
        try {
            Node attrNode;
            NamedNodeMap attrNodeMap;
            String childName;
            Node childNode;
            int j;
            NodeList childList;
            Node node;
            NodeList nodeList;
            if (!this._isRepairNeeded) {
                this._log.info(bundle.formatString("VerifyMetadataFiles.Repair.NoRepairRequired.txt", (Object)this._datasetErrors, (Object)this._datasetWarnings, (Object)this._repository.getDefaultRepositoryName()));
                return;
            }
            StringBuffer inXMLBuffer = new StringBuffer();
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.Repair.Open.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.Metadata.Repair.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.ReposId.Open.notrans"));
            inXMLBuffer.append(this._repository.getDefaultRepositoryId());
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.ReposId.Close.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.Flags.Trusted.Client.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.Namespace.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.Options.notrans"));
            inXMLBuffer.append(bundle.getString("VerifyMetadataFiles.Request.Repair.Close.notrans"));
            String inXML = inXMLBuffer.toString();
            this._log.debug(inXML);
            MdFactory factory = ((OMIServer)this._repository.getServer()).getMdFactory();
            SessionContextInterface session = ((OMIServer)this._repository.getServer()).getUserContext().getSessionContext();
            MetadataManager m_metadataManager = session != null ? MetadataManagerFactory.getMetadataManager((SessionContextInterface)session) : MetadataManagerFactory.getMetadataManager((MdFactory)factory);
            Document mainDoc = m_metadataManager.doRequestWithExclusiveServerLock(inXML);
            if (mainDoc != null) {
                nodeList = mainDoc.getElementsByTagName("Metadata");
                node = nodeList.item(0);
                childList = node.getChildNodes();
                for (j = 0; j < childList.getLength(); ++j) {
                    childNode = childList.item(j);
                    childName = childNode.getNodeName();
                    if (!childName.equalsIgnoreCase("Statistics")) continue;
                    attrNodeMap = childNode.getAttributes();
                    attrNode = attrNodeMap.getNamedItem("Errors");
                    this._datasetErrors = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Warnings");
                    this._datasetWarnings = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Repairs");
                    this._datasetRepairs = attrNode.getNodeValue();
                }
            }
            if ((nodeList = mainDoc.getElementsByTagName("OmiWarnings")) != null && nodeList.getLength() > 0) {
                node = nodeList.item(0);
                childList = node.getChildNodes();
                for (j = 0; j < childList.getLength(); ++j) {
                    childNode = childList.item(j);
                    childName = childNode.getNodeName();
                    if (!childName.equalsIgnoreCase("Warning")) continue;
                    attrNodeMap = childNode.getAttributes();
                    attrNode = attrNodeMap.getNamedItem("Name");
                    String severity = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Desc");
                    String text = attrNode.getNodeValue();
                    if (severity.equals("ERROR")) {
                        this._log.error(text);
                        continue;
                    }
                    if (severity.equals("WARN")) {
                        this._log.warn(text);
                        continue;
                    }
                    if (!severity.equals("INFO") || text.indexOf("OpenRepository") >= 0 || text.indexOf("CloseRepository") >= 0) continue;
                    this._log.info(text);
                }
            }
            if (this._datasetRepairs.equalsIgnoreCase("0")) {
                this._log.info(bundle.formatString("VerifyMetadataFiles.Repair.NoRepairRequired.txt", (Object)this._datasetErrors, (Object)this._datasetWarnings, (Object)this._repository.getDefaultRepositoryName()));
            } else {
                this._log.info(bundle.formatString("VerifyMetadataFiles.Repair.Results.txt", (Object)this._datasetRepairs, (Object)this._datasetErrors, (Object)this._datasetWarnings, (Object)this._repository.getDefaultRepositoryName()));
            }
            if (!this._datasetErrors.equalsIgnoreCase("0")) {
                this._log.error(bundle.formatString("VerifyMetadataFiles.Repair.FatalErrorsFound.txt", (Object)this._repository.getDefaultRepositoryName()));
                this._rc = 16;
            } else {
                this._rc = !this._datasetWarnings.equalsIgnoreCase("0") ? 2 : 0;
            }
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (DOMException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

