/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractToolImpl;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Repository;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class VerifyAuthenticationDomains
extends AbstractToolImpl {
    private static final WAdminResource bundle = new WAdminResource(VerifyAuthenticationDomains.class);
    private static final String TOOLNAME = bundle.getString("VerifyAuthenticationDomains.tool.name");
    private static final String TOOLDESCRIPTION = bundle.getString("VerifyAuthenticationDomains.tool.desc");
    private static final String TOOLMNEMONIC = "AuthDomains";
    static AnalyzeTool _factoryInstance;
    private Set _authDomainNamesSet = new HashSet();

    public static AnalyzeTool getInstance() {
        if (_factoryInstance == null) {
            _factoryInstance = new VerifyAuthenticationDomains(null, null);
        }
        return _factoryInstance;
    }

    private VerifyAuthenticationDomains(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalyzeTool newInstance(OMIRepositoryInterface repository, Logger log) {
        VerifyAuthenticationDomains newObject = new VerifyAuthenticationDomains(repository, log);
        return newObject;
    }

    @Override
    public String getDescription() {
        return TOOLDESCRIPTION;
    }

    @Override
    public String getMnemonic() {
        return TOOLMNEMONIC;
    }

    @Override
    public String getName() {
        return TOOLNAME;
    }

    @Override
    public String getGroup() {
        return "Security";
    }

    @Override
    public boolean isRepairSupported() {
        return true;
    }

    @Override
    public void analyze() throws ServiceException {
        block12: {
            this._authDomainNamesSet.clear();
            if (this._repository == null) {
                throw new IllegalStateException("This method cannot be called on a factory instance.");
            }
            List authDomains = null;
            try {
                this.createObjectStore();
                int flags = 2304;
                authDomains = this._OMIUtil.getMetadataObjectsSubset((MdStore)this._store, this._repository.getDefaultRepositoryId(), "AuthenticationDomain", flags, "", false);
                if (authDomains.size() == 0) {
                    this._log.info(bundle.getString("VerifyAuthenticationDomains.Analyze.NotFound.txt"));
                    this._rc = 0;
                    this.release();
                    return;
                }
                if (this._repository.getRepositoryType() != null && this._repository.getRepositoryType().equalsIgnoreCase("Foundation")) {
                    int numOfDuplicates = 0;
                    for (int i = 0; i < authDomains.size(); ++i) {
                        AuthenticationDomain domain = (AuthenticationDomain)authDomains.get(i);
                        if (domain != null && !this._authDomainNamesSet.contains(domain.getName())) {
                            this._authDomainNamesSet.add(domain.getName());
                            continue;
                        }
                        ++numOfDuplicates;
                        this._log.warn(bundle.formatString("VerifyAuthenticationDomains.Analyze.DuplicatedDomainFound.txt", (Object)domain.getName(), (Object)this._repository.getDefaultRepositoryName()));
                    }
                    if (numOfDuplicates > 1) {
                        this._log.warn(bundle.formatString("VerifyAuthenticationDomains.Analyze.DuplicatedDomainsFound.txt", (Object)new Integer(numOfDuplicates), (Object)this._repository.getDefaultRepositoryName()));
                        this._rc = 2;
                        this._isRepairNeeded = true;
                    } else {
                        this._log.info(bundle.formatString("VerifyAuthenticationDomains.Analyze.NoDuplicatedDomainFound.txt", (Object)this._repository.getDefaultRepositoryName()));
                        this._rc = 0;
                        this.release();
                    }
                    break block12;
                }
                for (int i = 0; i < authDomains.size(); ++i) {
                    AuthenticationDomain domain = (AuthenticationDomain)authDomains.get(i);
                    this._log.warn(bundle.formatString("VerifyAuthenticationDomains.Analyze.DomainFoundInNonFoundation.txt", (Object)domain.getName(), (Object)this._repository.getDefaultRepositoryName()));
                }
                this._log.warn(bundle.formatString("VerifyAuthenticationDomains.Analyze.DomainsFoundInNonFoundation.txt", (Object)new Integer(authDomains.size()), (Object)this._repository.getDefaultRepositoryName()));
                this._rc = 2;
                this._isRepairNeeded = true;
                return;
            }
            catch (MdException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (OutOfMemoryError e) {
                this._log.error(bundle.getString("VerifyAuthenticationDomains.Analyze.Error.txt"));
                this._rc = 8;
            }
            catch (RemoteException e) {
                throw new ServiceException((Throwable)e);
            }
        }
    }

    @Override
    public void repair() throws ServiceException {
        this._authDomainNamesSet.clear();
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        if (this._rc == -1) {
            this.analyze();
        }
        try {
            if (!this._isRepairNeeded) {
                this._log.info(bundle.formatString("VerifyAuthenticationDomains.Repair.NoRepairRequired.txt", (Object)this._repository.getDefaultRepositoryName()));
                return;
            }
            List repositories = this._repository.getRepositories();
            String foundationRepositoryID = this.getFoundationRepositoryFQID();
            if (foundationRepositoryID == null || foundationRepositoryID.length() == 0) {
                this._log.error(bundle.getString("VerifyAuthenticationDomains.Repair.NoFoundationRepository.error.txt"));
                this._rc = 8;
                throw new ServiceException(bundle.getString("VerifyAuthenticationDomains.Repair.NoFoundationRepository.error.txt"));
            }
            List authDomainsInFoundation = null;
            int flags = 2304;
            authDomainsInFoundation = this._OMIUtil.getMetadataObjectsSubset((MdStore)this._store, foundationRepositoryID, "AuthenticationDomain", flags, "", false);
            if (this._repository.getRepositoryType() != null && this._repository.getRepositoryType().equalsIgnoreCase("Foundation")) {
                int numOfDuplicates = 0;
                for (int i = 0; i < authDomainsInFoundation.size(); ++i) {
                    AuthenticationDomain domain = (AuthenticationDomain)authDomainsInFoundation.get(i);
                    if (domain != null && !this._authDomainNamesSet.contains(domain.getName())) {
                        this._authDomainNamesSet.add(domain.getName());
                        continue;
                    }
                    String oldName = domain.getName();
                    String newName = domain.getName() + "_Foundatition";
                    int j = 0;
                    while (this._authDomainNamesSet.contains(newName)) {
                        newName = newName + j++;
                    }
                    domain.setName(newName);
                    domain.setPublicType("AuthenticationDomain");
                    domain.setUsageVersion(1000000.0);
                    try {
                        domain.updateMetadataAll();
                    }
                    catch (MdException e1) {
                        domain.setName(domain.getName() + "_" + System.currentTimeMillis());
                        domain.updateMetadataAll();
                    }
                    this._log.info(bundle.formatString("VerifyAuthenticationDomains.Repair.Rename_Foundation.txt", (Object)oldName, (Object)domain.getName(), (Object)this._repository.getDefaultRepositoryName()));
                    this._authDomainNamesSet.add(domain.getName());
                }
                this._log.info(bundle.formatString("VerifyAuthenticationDomains.Repair.Results_Foundation.txt", (Object)new Integer(numOfDuplicates), (Object)this._repository.getDefaultRepositoryName()));
                this._rc = 0;
                this.release();
                return;
            }
            for (int i = 0; i < authDomainsInFoundation.size(); ++i) {
                AuthenticationDomain domain = (AuthenticationDomain)authDomainsInFoundation.get(i);
                this._authDomainNamesSet.add(domain.getName());
            }
            List authDomainsList = null;
            authDomainsList = this._OMIUtil.getMetadataObjectsSubset((MdStore)this._store, this._repository.getDefaultRepositoryId(), "AuthenticationDomain", flags, "", false);
            int numberOfMoved = 0;
            int numberOfMovedAndRenamed = 0;
            for (int i = 0; i < authDomainsList.size(); ++i) {
                AuthenticationDomain newDomain;
                AuthenticationDomain domain = (AuthenticationDomain)authDomainsList.get(i);
                String oldDomainName = domain.getName();
                if (domain != null && !this._authDomainNamesSet.contains(domain.getName())) {
                    newDomain = this.createDomain(domain, foundationRepositoryID);
                    this._OMIUtil.deleteMetadataObject("AuthenticationDomain", domain.getId());
                    try {
                        newDomain.updateMetadataAll();
                        ++numberOfMoved;
                        this._log.info(bundle.formatString("VerifyAuthenticationDomains.Repair.MoveTo_Foundation.txt", (Object)oldDomainName));
                    }
                    catch (MdException e1) {
                        if (this.renameAndSave(newDomain)) {
                            // empty if block
                        }
                        this._log.info(bundle.formatString("VerifyAuthenticationDomains.Repair.RenamedAndMovedTo_Foundation.txt", (Object)oldDomainName, (Object)newDomain.getName()));
                        ++numberOfMovedAndRenamed;
                    }
                    this._authDomainNamesSet.add(newDomain.getName());
                    continue;
                }
                newDomain = this.createDomain(domain, foundationRepositoryID);
                this._OMIUtil.deleteMetadataObject("AuthenticationDomain", domain.getId());
                if (this.renameAndSave(newDomain)) {
                    // empty if block
                }
                ++numberOfMovedAndRenamed;
                this._authDomainNamesSet.add(newDomain.getName());
                this._log.info(bundle.formatString("VerifyAuthenticationDomains.Repair.RenamedAndMovedTo_Foundation.txt", (Object)oldDomainName, (Object)newDomain.getName()));
            }
            this._log.info(bundle.formatString("VerifyAuthenticationDomains.Repair.Results_NonFoundation.txt", (Object)new Integer(numberOfMoved + numberOfMovedAndRenamed), (Object)this._repository.getDefaultRepositoryName(), (Object)new Integer(numberOfMovedAndRenamed)));
            this._rc = 0;
            this.release();
            return;
        }
        catch (OutOfMemoryError e) {
            this._log.error(bundle.formatString("VerifyAuthenticationDomains.Repair.Failure.txt", (Object)e.getMessage()));
            this._rc = 8;
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        this._rc = 0;
    }

    private AuthenticationDomain createDomain(AuthenticationDomain domain, String reposID) throws RemoteException, MdException {
        AuthenticationDomain newDomain = (AuthenticationDomain)this._factory.createComplexMetadataObject(this._store, null, domain.getName(), "AuthenticationDomain", reposID.substring(9));
        newDomain.setDesc(domain.getDesc());
        newDomain.setPublicType("AuthenticationDomain");
        newDomain.setUsageVersion(1000000.0);
        newDomain.getLogins().addAll((Collection)domain.getLogins());
        newDomain.getConnections().addAll((Collection)domain.getConnections());
        return newDomain;
    }

    private boolean renameAndSave(AuthenticationDomain domain) {
        try {
            domain.setName(domain.getName() + "_" + this._repository.getDefaultRepositoryName());
            domain.updateMetadataAll();
            return true;
        }
        catch (MdException e) {
            try {
                domain.setName(domain.getName() + "_" + System.currentTimeMillis());
                domain.updateMetadataAll();
                return true;
            }
            catch (RemoteException e2) {
                e2.printStackTrace();
            }
            catch (MdException e1) {
                e1.printStackTrace();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return false;
    }

    private String getFoundationRepositoryFQID() {
        try {
            Repository[] reposArray = Repository.getRepositories((MdFactory)this._factory);
            for (int i = 0; i < reposArray.length; ++i) {
                if (!reposArray[i].getType().equalsIgnoreCase("Foundation")) continue;
                return reposArray[i].getFQID();
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getMessage());
            return "";
        }
        return "";
    }
}

