/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractToolImpl;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.Permission;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Repository;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class VerifyAndRepairPermissions
extends AbstractToolImpl {
    private static final WAdminResource bundle = new WAdminResource(VerifyAndRepairPermissions.class);
    private static final String TOOLNAME = bundle.getString("VerifyAndRepairPermissions.tool.name");
    private static final String TOOLDESCRIPTION = bundle.getString("VerifyAndRepairPermissions.tool.desc");
    private static final String TOOLMNEMONIC = "Permissions";
    static AnalyzeTool _factoryInstance;
    private Set _authDomainNamesSet = new HashSet();

    public static AnalyzeTool getInstance() {
        if (_factoryInstance == null) {
            _factoryInstance = new VerifyAndRepairPermissions(null, null);
        }
        return _factoryInstance;
    }

    private VerifyAndRepairPermissions(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalyzeTool newInstance(OMIRepositoryInterface repository, Logger log) {
        VerifyAndRepairPermissions newObject = new VerifyAndRepairPermissions(repository, log);
        return newObject;
    }

    @Override
    public String getDescription() {
        return TOOLDESCRIPTION;
    }

    @Override
    public String getMnemonic() {
        return TOOLMNEMONIC;
    }

    @Override
    public String getName() {
        return TOOLNAME;
    }

    @Override
    public String getGroup() {
        return "Security";
    }

    @Override
    public boolean isRepairSupported() {
        return true;
    }

    @Override
    public void analyze() throws ServiceException {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        List permissionsList = null;
        try {
            if (this._repository.getRepositoryType().equals("FOUNDATION")) {
                this._log.info(bundle.formatString("VerifyAndRepairPermissions.Analyze.Foundation.txt", (Object)this._repository.getDefaultRepositoryName()));
                this._rc = 0;
                return;
            }
            this.createObjectStore();
            permissionsList = this.getPermissionsListInRepository(this._repository.getDefaultRepositoryId());
            if (permissionsList.size() == 0) {
                this._log.info(bundle.formatString("VerifyAndRepairPermissions.Analyze.NotFound.txt", (Object)this._repository.getDefaultRepositoryName()));
                this._rc = 0;
                this.release();
                return;
            }
            List grantDenypairsList = VerifyAndRepairPermissions.getGrantDenyPairsList(VerifyAndRepairPermissions.buildPermissionsMap(permissionsList));
            for (int i = 0; i < grantDenypairsList.size(); ++i) {
                GrantDenyPair permPair = (GrantDenyPair)grantDenypairsList.get(i);
                Permission grant = permPair.getGrantPerm();
                Permission deny = permPair.getDenyPerm();
                int numAces = grant.getAccessControlEntries().size() + deny.getAccessControlEntries().size();
                this._log.warn(bundle.formatString("VerifyAndRepairPermissions.Analyze.PermissionFoundInNonFoundation.txt", (Object)permPair.getGrantPerm().getName(), (Object)this._repository.getDefaultRepositoryName(), (Object)new Integer(numAces)));
            }
            this._log.warn(bundle.formatString("VerifyAndRepairPermissions.Analyze.permissionsFoundInNonFoundation.txt", (Object)new Integer(grantDenypairsList.size()), (Object)this._repository.getDefaultRepositoryName()));
            this._rc = 2;
            this._isRepairNeeded = true;
            return;
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this._log.error(bundle.getString("VerifyAndRepairPermissions.Analyze.Error.txt"));
            this._rc = 8;
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void repair() throws ServiceException {
        this._authDomainNamesSet.clear();
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        if (this._rc == -1) {
            this.analyze();
        }
        try {
            if (!this._isRepairNeeded) {
                this._log.info(bundle.formatString("VerifyAndRepairPermissions.Repair.NoRepairRequired.txt", (Object)this._repository.getDefaultRepositoryName()));
                return;
            }
            List repositories = this._repository.getRepositories();
            String foundationRepositoryID = this.getFoundationRepositoryFQID();
            if (foundationRepositoryID == null || foundationRepositoryID.length() == 0) {
                this._log.error(bundle.getString("VerifyAndRepairPermissions.Repair.NoFoundationRepository.error.txt"));
                this._rc = 8;
                throw new ServiceException(bundle.getString("VerifyAndRepairPermissions.Repair.NoFoundationRepository.error.txt"));
            }
            Hashtable permissionsInFoundationTable = VerifyAndRepairPermissions.buildPermissionsMap(this.getPermissionsListInRepository(foundationRepositoryID));
            if (this._repository.getRepositoryType() == null || !this._repository.getRepositoryType().equalsIgnoreCase("Foundation")) {
                List permissionsList = this.getPermissionsListInRepository(this._repository.getDefaultRepositoryId());
                List permissionPairsList = VerifyAndRepairPermissions.getGrantDenyPairsList(VerifyAndRepairPermissions.buildPermissionsMap(permissionsList));
                int numberOfMoved = 0;
                int numberOfDeleted = 0;
                for (int i = 0; i < permissionPairsList.size(); ++i) {
                    GrantDenyPair grantDenyPair = (GrantDenyPair)permissionPairsList.get(i);
                    Permission grant = grantDenyPair.getGrantPerm();
                    Permission deny = grantDenyPair.getDenyPerm();
                    String permName = grant.getName();
                    if (grant.getAccessControlEntries().size() == 0 && deny.getAccessControlEntries().size() == 0) {
                        this._OMIUtil.deleteMetadataObject("Permission", grant.getId());
                        this._OMIUtil.deleteMetadataObject("Permission", deny.getId());
                        ++numberOfDeleted;
                        this._log.info(bundle.formatString("VerifyAndRepairPermissions.Repair.Permission.Deleted.txt", (Object)permName, (Object)this._repository.getDefaultRepositoryName()));
                        continue;
                    }
                    if (permissionsInFoundationTable.containsKey(grant.getName())) {
                        GrantDenyPair foundationPair = (GrantDenyPair)permissionsInFoundationTable.get(grant.getName());
                        Permission foundationGrant = foundationPair.getGrantPerm();
                        Permission foundationDeny = foundationPair.getDenyPerm();
                        foundationGrant.getAccessControlEntries().addAll((Collection)grant.getAccessControlEntries());
                        foundationDeny.getAccessControlEntries().addAll((Collection)deny.getAccessControlEntries());
                        this._OMIUtil.deleteMetadataObject("Permission", grant.getId());
                        this._OMIUtil.deleteMetadataObject("Permission", deny.getId());
                        this._store.updatedMetadataAll();
                        ++numberOfDeleted;
                        this._log.info(bundle.formatString("VerifyAndRepairPermissions.Repair.Permission.MovedAndDeleted.txt", (Object)permName, (Object)this._repository.getDefaultRepositoryName()));
                        continue;
                    }
                    this.createPermission(grant, foundationRepositoryID);
                    this.createPermission(deny, foundationRepositoryID);
                    this._OMIUtil.deleteMetadataObject("Permission", grant.getId());
                    this._OMIUtil.deleteMetadataObject("Permission", deny.getId());
                    this._store.updatedMetadataAll();
                    ++numberOfMoved;
                    this._log.info(bundle.formatString("VerifyAndRepairPermissions.Repair.Permission.MovedAndDeleted1.txt", (Object)permName, (Object)this._repository.getDefaultRepositoryName()));
                }
                this._log.info(bundle.formatString("VerifyAndRepairPermissions.Repair.Results_NonFoundation.txt", (Object)new Integer(numberOfMoved), (Object)new Integer(numberOfDeleted), (Object)this._repository.getDefaultRepositoryName()));
                this._rc = 0;
                this.release();
                return;
            }
        }
        catch (OutOfMemoryError e) {
            this._log.error(bundle.formatString("VerifyAndRepairPermissions.Repair.Failure.txt", (Object)e.getMessage()));
            this._rc = 8;
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        this._rc = 0;
    }

    private Permission createPermission(Permission permission, String reposID) throws RemoteException, MdException {
        Permission newPermission = (Permission)this._factory.createComplexMetadataObject(this._store, null, permission.getName(), "Permission", reposID.substring(9));
        newPermission.setType(permission.getType());
        newPermission.setDesc(permission.getDesc());
        newPermission.getAccessControlEntries().addAll((Collection)permission.getAccessControlEntries());
        return newPermission;
    }

    private String getFoundationRepositoryFQID() {
        try {
            Repository[] reposArray = Repository.getRepositories((MdFactory)this._factory);
            for (int i = 0; i < reposArray.length; ++i) {
                if (!reposArray[i].getType().equalsIgnoreCase("Foundation")) continue;
                return reposArray[i].getFQID();
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getMessage());
            return "";
        }
        return "";
    }

    public static List getGrantDenyPairsList(Hashtable permissionTable) {
        if (permissionTable == null || permissionTable.size() < 1) {
            return new ArrayList(0);
        }
        Enumeration gdps = permissionTable.elements();
        ArrayList<GrantDenyPair> retList = new ArrayList<GrantDenyPair>(permissionTable.size());
        while (gdps.hasMoreElements()) {
            GrantDenyPair gdPair = (GrantDenyPair)gdps.nextElement();
            retList.add(gdPair);
        }
        return retList;
    }

    public static Hashtable buildPermissionsMap(List permissions) {
        if (permissions == null || permissions.size() < 1) {
            return new Hashtable(0);
        }
        Iterator permIter = permissions.iterator();
        Hashtable<String, GrantDenyPair> gdp_tbl = new Hashtable<String, GrantDenyPair>(permissions.size() / 2);
        while (permIter.hasNext()) {
            Permission perm = (Permission)permIter.next();
            try {
                GrantDenyPair gdp;
                if (!gdp_tbl.containsKey(perm.getName())) {
                    gdp = new GrantDenyPair();
                    if (perm.getType().toUpperCase().compareTo("GRANT") == 0) {
                        gdp.setGrantPerm(perm);
                    } else {
                        gdp.setDenyPerm(perm);
                    }
                    gdp_tbl.put(perm.getName(), gdp);
                    continue;
                }
                gdp = (GrantDenyPair)gdp_tbl.get(perm.getName());
                MdStore gdpStore = gdp.getDenyPerm() != null ? gdp.getDenyPerm().getObjectStore() : gdp.getGrantPerm().getObjectStore();
                MdStoreUtil.refreshMetaObject((MdStore)perm.getObjectStore(), (MdStore)gdpStore, (String)perm.getFQID());
                Permission scndPairObj = (Permission)gdpStore.getObject(perm.getFQID());
                if (scndPairObj != null && scndPairObj.getType().toUpperCase().compareTo("GRANT") == 0) {
                    gdp.setGrantPerm(scndPairObj);
                    continue;
                }
                gdp.setDenyPerm(scndPairObj);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        Enumeration gdps = gdp_tbl.elements();
        Hashtable<String, GrantDenyPair> returnTable = new Hashtable<String, GrantDenyPair>(gdp_tbl.size());
        while (gdps.hasMoreElements()) {
            GrantDenyPair gdPair = (GrantDenyPair)gdps.nextElement();
            if (gdPair.getDenyPerm() == null || gdPair.getGrantPerm() == null) continue;
            try {
                returnTable.put(gdPair.getDenyPerm().getName(), gdPair);
            }
            catch (RemoteException remoteException) {}
        }
        return returnTable;
    }

    private List getPermissionsListInRepository(String reposID) throws RemoteException, MdException {
        String strTemplate = "<TEMPLATES><Permission Name=\"\" Type=\"\"><AcccessControlEntries/></Permission></TEMPLATES>";
        int flags = 2304;
        return this.retrieve((MdStore)this._store, "Permission", "<TEMPLATES><Permission Name=\"\" Type=\"\"><AcccessControlEntries/></Permission></TEMPLATES>", "", reposID, false, false);
    }

    public List retrieve(MdStore mdStore, String strMetaType, String strTemplate, String strSelect, String strReposid, boolean bIncSubtypes, boolean bParentRepos) {
        ArrayList<CMetadata> retList;
        boolean bMultipeOptions = false;
        if (strTemplate != null && strTemplate.length() > 0 && strSelect != null && strSelect.length() > 0) {
            bMultipeOptions = true;
        }
        String strOptions = "";
        int flags = 256;
        if (strTemplate != null && strTemplate.length() > 0) {
            strOptions = strOptions + strTemplate;
            flags |= 4;
        }
        if (strSelect != null && strSelect.length() > 0) {
            strOptions = strOptions + strSelect;
            flags |= 0x80;
        }
        if (bIncSubtypes) {
            flags |= 0x10;
        }
        if (bParentRepos) {
            flags |= 0x4000;
        }
        if (bMultipeOptions) {
            strOptions = "<Options>" + strOptions + "</Options>";
        }
        try {
            List metaList = this._store.getFactory().getOMIUtil().getMetadataObjectsSubset(mdStore, strReposid, strMetaType, flags, strOptions);
            retList = new ArrayList(metaList.size());
            for (int i = 0; i < metaList.size(); ++i) {
                CMetadata rtrvdObj = (CMetadata)metaList.get(i);
                if (mdStore.getObject(rtrvdObj.getFQID()) == null) {
                    MdStoreUtil.refreshMetaObject((MdStore)rtrvdObj.getObjectStore(), (MdStore)mdStore, (String)rtrvdObj.getFQID());
                }
                retList.add(mdStore.getObject(rtrvdObj.getFQID()));
            }
        }
        catch (MdException e) {
            e.printStackTrace();
            retList = new ArrayList();
        }
        catch (RemoteException re) {
            retList = new ArrayList<CMetadata>();
        }
        return retList;
    }

    static class GrantDenyPair {
        protected Permission m_gp = null;
        protected Permission m_dp = null;

        public GrantDenyPair() {
        }

        public GrantDenyPair(Permission grant, Permission deny) {
            this.setDenyPerm(deny);
            this.setGrantPerm(grant);
        }

        public boolean setGrantPerm(Permission grant) {
            try {
                if (grant.getType().compareTo("GRANT") != 0) {
                    return false;
                }
                if (this.m_dp != null) {
                    if (this.m_dp.getName().compareTo(grant.getName()) != 0) {
                        return false;
                    }
                    if (this.m_dp.getObjectStore() != grant.getObjectStore()) {
                        return false;
                    }
                }
                this.m_gp = grant;
                return true;
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return false;
            }
        }

        public boolean setDenyPerm(Permission deny) {
            try {
                if (deny.getType().compareTo("DENY") != 0) {
                    return false;
                }
                if (this.m_gp != null) {
                    if (this.m_gp.getName().compareTo(deny.getName()) != 0) {
                        return false;
                    }
                    if (this.m_gp.getObjectStore() != deny.getObjectStore()) {
                        return false;
                    }
                }
                this.m_dp = deny;
                return true;
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return false;
            }
        }

        public Permission getGrantPerm() {
            return this.m_gp;
        }

        public Permission getDenyPerm() {
            return this.m_dp;
        }
    }
}

