/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractOrphanObjectTool;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.management.metadata.tools.OrphanObjectComponentInterface;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class OrphanedTextStores
extends AbstractOrphanObjectTool
implements OrphanObjectComponentInterface {
    private static final WAdminResource bundle = new WAdminResource(OrphanedTextStores.class);
    private static final String TOOLNAME = bundle.getString("OrphanedTextStores.tool.name");
    private String ANALYZE_TEMPLATE = null;
    private boolean _templateSet = false;
    private static final String SELECT = "<XMLSelect search=\"*[@PublicType='' and @ChangeState='']\"/>";
    static AnalyzeTool _factoryInstance;

    public static AnalyzeTool getInstance() {
        if (_factoryInstance == null) {
            _factoryInstance = new OrphanedTextStores(null, null);
        }
        return _factoryInstance;
    }

    private OrphanedTextStores(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
        this.setProcessCount(1000);
    }

    @Override
    public AnalyzeTool newInstance(OMIRepositoryInterface repository, Logger log) {
        OrphanedTextStores newObject = new OrphanedTextStores(repository, log);
        return newObject;
    }

    @Override
    public String getDescription() {
        return bundle.getString("OrphanedTextStores.tool.desc");
    }

    @Override
    public String getMnemonic() {
        return "OrphTxtStr";
    }

    @Override
    public String getName() {
        return TOOLNAME;
    }

    @Override
    public String getLabel() {
        return bundle.getString("OrphanedTextStores.tool.label");
    }

    @Override
    public String getAnalyzeTemplate() {
        return this.ANALYZE_TEMPLATE;
    }

    @Override
    public String getXMLSelectString() {
        return SELECT;
    }

    @Override
    public String getMetadataType() {
        return "TextStore";
    }

    @Override
    public String getRepairTemplate() {
        return null;
    }

    @Override
    public boolean isOrphan(Map objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        String publicType = (String)objectMap.get("PublicType");
        if (publicType != null && publicType.length() > 0) {
            return false;
        }
        String changeState = (String)objectMap.get("ChangeState");
        if (changeState != null && changeState.length() > 0) {
            return false;
        }
        return !this.containsAssociations(objectMap);
    }

    @Override
    public AnalyzeTool getParentAnalyzeTool() {
        return this;
    }

    @Override
    public void analysisSetup() {
        super.analysisSetup();
        if (!this._templateSet) {
            Set<String> assocs = this.getAssociationNames();
            if (assocs != null && assocs.size() > 0) {
                StringBuilder sb = new StringBuilder(850);
                sb.append("<Templates><TextStore Name=\"\" PublicType=\"\" ChangeState=\"\">");
                for (String assocName : assocs) {
                    sb.append("<").append(assocName).append("/>");
                }
                sb.append("</TextStore></Templates>");
                this.ANALYZE_TEMPLATE = sb.toString();
            } else {
                this.ANALYZE_TEMPLATE = null;
            }
            this._templateSet = true;
        }
    }

    private Set<String> getAssociationNames() {
        try {
            HashMap attrs = new HashMap();
            HashMap assocs = new HashMap();
            this._factory.getOMIUtil().getTypeProperties("TextStore", attrs, assocs);
            return assocs.keySet();
        }
        catch (Exception e) {
            this._log.debug("Unable to retrieve the list of associations for a TextStore");
            return null;
        }
    }
}

