/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractToolImpl;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class OrphanedPropertyGroups
extends AbstractToolImpl {
    private static final WAdminResource bundle = new WAdminResource(OrphanedPropertyGroups.class);
    private static final String TOOLNAME = bundle.getString("OrphanedPropertyGroups.tool.name");
    private static final String TOOLDESCRIPTION = bundle.getString("OrphanedPropertyGroups.tool.desc");
    private static final String TOOLMNEMONIC = "OrphPropGrp";
    static AnalyzeTool _factoryInstance;
    private List _orphansList = null;
    private int _propGrpCount = 0;

    public static AnalyzeTool getInstance() {
        if (_factoryInstance == null) {
            _factoryInstance = new OrphanedPropertyGroups(null, null);
        }
        return _factoryInstance;
    }

    private OrphanedPropertyGroups(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalyzeTool newInstance(OMIRepositoryInterface repository, Logger log) {
        OrphanedPropertyGroups newObject = new OrphanedPropertyGroups(repository, log);
        return newObject;
    }

    @Override
    public String getDescription() {
        return TOOLDESCRIPTION;
    }

    @Override
    public String getMnemonic() {
        return TOOLMNEMONIC;
    }

    @Override
    public String getName() {
        return TOOLNAME;
    }

    @Override
    public String getGroup() {
        return "Usage";
    }

    @Override
    public boolean isRepairSupported() {
        return true;
    }

    @Override
    public void analyze() throws ServiceException {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        List propGrpsList = null;
        this._propGrpCount = 0;
        this._orphansList = null;
        try {
            this.createObjectStore();
            String strTemplate = "<TEMPLATES><PropertyGroup Name=\"\"><AssociatedObject/><ParentGroup/><GroupedProperties/><SubpropertyGroups/><Properties/></PropertyGroup></TEMPLATES>";
            int flags = 2308;
            propGrpsList = this._OMIUtil.getMetadataObjectsSubset((MdStore)this._store, this._repository.getDefaultRepositoryId(), "PropertyGroup", flags, strTemplate, false);
            if (propGrpsList == null || propGrpsList.size() == 0) {
                this._log.info(bundle.getString("OrphanedPropertyGroups.Analyze.NotFound.txt"));
                this._rc = 0;
                this.release();
                return;
            }
            int objectCount = propGrpsList.size();
            if (this._log.isDebugEnabled()) {
                this._log.debug("Found " + objectCount + " total PropertyGroup objects.  Searching for orphans.");
            }
            for (int i = 0; i < objectCount; ++i) {
                PropertyGroup pGrp = (PropertyGroup)propGrpsList.get(i);
                AssociationList groupsAssocList = pGrp.getParentGroups(false);
                AssociationList assocObjectsList = pGrp.getAssociatedObjects(false);
                if (groupsAssocList != null && groupsAssocList.size() != 0 || assocObjectsList != null && assocObjectsList.size() != 0) continue;
                ++this._propGrpCount;
                if (this._orphansList == null) {
                    this._orphansList = new ArrayList();
                }
                this._orphansList.add(pGrp.getFQID());
                if (this._propGrpCount > 100 || !this._log.isDebugEnabled()) continue;
                this._log.debug("Found orphaned PropertyGroup: " + pGrp.getName() + " (" + pGrp.getId() + ")");
            }
            if (this._orphansList == null) {
                this._log.info(bundle.formatString("OrphanedPropertyGroups.Analyze.NoOrphans.txt", (Object)this._repository.getDefaultRepositoryName()));
                this._rc = 0;
            } else {
                Integer total = new Integer(this._propGrpCount);
                this._log.warn(bundle.formatString("OrphanedPropertyGroups.Analyze.OrphansFound.txt", (Object)total, (Object)this._repository.getDefaultRepositoryName()));
                this._rc = 2;
                this._isRepairNeeded = true;
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this._log.error("Orphaned Property Groups analysis aborted due to out of memory error.");
            this._rc = 8;
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            this.releaseObjectStore();
        }
    }

    @Override
    public void repair() throws ServiceException {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        List deletedList = null;
        int deletedCount = 0;
        boolean error = false;
        if (this._rc == -1) {
            this.analyze();
        }
        try {
            if (!this._isRepairNeeded) {
                this._log.info(bundle.formatString("OrphanedPropertyGroups.Repair.NoRepairRequired.txt", (Object)this._repository.getDefaultRepositoryName()));
                return;
            }
            String strDeleteTemplate = "<Template TemplateName=\"PropertyCleanup\"><Property><OwningType><PropertyType match=\"*[@Name='GenericString'][Groups/Group[@Name='Entity Property Types']]\" TemplateExpand=\"no\"/><PropertyType TemplateExpand=\"yes\"/></OwningType><ExternalIdentities/><PrimaryPropertyGroup/><SpecTargetTransformations/><Properties/><StoredConfiguration/></Property><PropertySet><SetProperties/><Properties/></PropertySet><PropertyGroup><Properties/><GroupedProperties/><SubPropertyGroups/><PropertySets/></PropertyGroup><PropertyType><StoredConfiguration/></PropertyType></Template>";
            for (String orphanID : this._orphansList) {
                if (orphanID == null || (deletedList = this._OMIUtil.deleteMetadataObject("PropertyGroup", orphanID, strDeleteTemplate)) == null || deletedList.size() <= 0) continue;
                ++deletedCount;
                deletedList = null;
            }
            Integer deleted = new Integer(deletedCount);
            Integer total = new Integer(this._orphansList.size());
            this._log.info(bundle.formatString("OrphanedPropertyGroups.Repair.Results.txt", (Object)deleted, (Object)total));
            if (this._orphansList != null) {
                this._orphansList.clear();
                this._orphansList = null;
            }
        }
        catch (MdException e) {
            this._log.error(bundle.formatString("OrphanedPropertyGroups.Repair.DeleteFailure.txt", (Object)e.getMessage()));
            this._rc = 8;
            throw new ServiceException((Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this._log.error(bundle.formatString("OrphanedPropertyGroups.Repair.DeleteFailure.txt", (Object)e.getMessage()));
            this._rc = 8;
        }
        catch (RemoteException e) {
            throw new ServiceException((Throwable)e);
        }
        this._rc = error ? 8 : 0;
    }
}

