/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractPropertyObjectComponent;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

class OrphanedPropertyGroupComponent
extends AbstractPropertyObjectComponent {
    private static final WAdminResource bundle = new WAdminResource(OrphanedPropertyGroupComponent.class);
    private static final String ANALYZE_TEMPLATE = "<TEMPLATES><PropertyGroup Name=\"\"><Customizers/><Editors/><Validators/><Implementors/><AssociatedObject/><ParentGroup/><GroupedProperties/><SubpropertyGroups/><Properties/></PropertyGroup></TEMPLATES>";

    public OrphanedPropertyGroupComponent(AnalyzeTool parentAnalyzeTool) {
        super(parentAnalyzeTool);
    }

    @Override
    public String getLabel() {
        return bundle.getString("OrphanedPropertyGroupComponent.tool.label");
    }

    @Override
    public String getAnalyzeTemplate() {
        return ANALYZE_TEMPLATE;
    }

    @Override
    public String getMetadataType() {
        return "PropertyGroup";
    }

    @Override
    public boolean isOrphan(Map objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        if (this.containsCommonAssociations(objectMap)) {
            return false;
        }
        List groupsAssocList = (List)objectMap.get("ParentGroup");
        if (groupsAssocList != null && groupsAssocList.size() > 0) {
            return false;
        }
        List assocObjectsList = (List)objectMap.get("AssociatedObject");
        return assocObjectsList == null || assocObjectsList.size() <= 0;
    }
}

