/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.metadata.tools;

import com.sas.management.metadata.tools.AbstractPropertyObjectComponent;
import com.sas.management.metadata.tools.AnalyzeTool;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class OrphanedPropertyComponent
extends AbstractPropertyObjectComponent {
    private static final WAdminResource bundle = new WAdminResource(OrphanedPropertyComponent.class);
    private static final String ANALYZE_TEMPLATE = "<TEMPLATES><Property Name=\"\"><Customizers/><Editors/><Validators/><Implementors/><AssociatedLocalizedObject/><AssociatedObject/><AssociatedPropertySet/><AssociatedPropertyGroup/><StoredConfiguration/></Property></TEMPLATES>";

    public OrphanedPropertyComponent(AnalyzeTool parentAnalyzeTool) {
        super(parentAnalyzeTool);
    }

    @Override
    public String getLabel() {
        return bundle.getString("OrphanedPropertyComponent.tool.label");
    }

    @Override
    public String getAnalyzeTemplate() {
        return ANALYZE_TEMPLATE;
    }

    @Override
    public String getMetadataType() {
        return "Property";
    }

    @Override
    public boolean isOrphan(Map objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        if (this.containsCommonAssociations(objectMap)) {
            return false;
        }
        List propSetsList = (List)objectMap.get("AssociatedPropertySet");
        if (propSetsList != null && propSetsList.size() > 0) {
            return false;
        }
        List assocObjectsList = (List)objectMap.get("AssociatedObject");
        if (assocObjectsList != null && assocObjectsList.size() > 0) {
            return false;
        }
        List propGroupsList = (List)objectMap.get("AssociatedPropertyGroup");
        if (propGroupsList != null && propGroupsList.size() > 0) {
            return false;
        }
        List localizedObjectsList = (List)objectMap.get("AssociatedLocalizedObject");
        return localizedObjectsList == null || localizedObjectsList.size() <= 0;
    }
}

